/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.finance.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.customer.dto.request.DgEnterpriseQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgEnterpriseQueryApiProxy;
import com.yunxi.dg.base.center.finance.dto.entity.KeepRelatedShopDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepRelatedTradeConfigDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepRelatedTradeConfigPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepRelatedTradeDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepRelatedTradeShopConfigDto;
import com.yunxi.dg.base.center.finance.dto.entity.RelatedTradeShopMatchDto;
import com.yunxi.dg.base.center.finance.dto.entity.RelatedTradeShopMatchQueryDto;
import com.yunxi.dg.base.center.finance.proxy.entity.IKeepRelatedTradeConfigApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ChannelQueryReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgCsChannelRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgShopRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgCsChannelQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.mgmt.service.finance.FinancialManagementKeepRelatedTradeConfigService;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.KeepRelatedShopBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.KeepRelatedTradeBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.financial.request.KeepRelatedTradeShopConfigBody;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ExportKeepRelatedTradeConfigDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.KeepRelatedTradeConfigImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="AbstractBaseFileOperationCommonService_FINANCE_RELATED_TRADE_CONFIG_IMPORT")
public class FinancialManagementKeepRelatedTradeConfigServiceServiceImpl
extends AbstractBaseFileOperationCommonService
implements FinancialManagementKeepRelatedTradeConfigService {
    private static final Logger logger = LoggerFactory.getLogger(FinancialManagementKeepRelatedTradeConfigServiceServiceImpl.class);
    @Resource
    private IKeepRelatedTradeConfigApiProxy proxy;
    @Resource
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Resource
    private IDgCsChannelQueryApiProxy channelQueryApiProxy;
    @Resource
    private IDgEnterpriseQueryApiProxy enterpriseQueryApiProxy;

    @Override
    public RestResponse<Long> saveOrUpdate(@ApiParam(value="") @Valid @RequestBody(required=false) KeepRelatedTradeShopConfigBody keepRelatedTradeShopConfigBody) {
        KeepRelatedTradeShopConfigDto tradeShopConfigDto = new KeepRelatedTradeShopConfigDto();
        tradeShopConfigDto.setId(keepRelatedTradeShopConfigBody.getId());
        tradeShopConfigDto.setRuleName(keepRelatedTradeShopConfigBody.getRuleName());
        tradeShopConfigDto.setRuleCode(keepRelatedTradeShopConfigBody.getRuleCode());
        tradeShopConfigDto.setSiteCode(keepRelatedTradeShopConfigBody.getSiteCode());
        tradeShopConfigDto.setSiteName(keepRelatedTradeShopConfigBody.getSiteName());
        tradeShopConfigDto.setRemark(keepRelatedTradeShopConfigBody.getRemark());
        tradeShopConfigDto.setEnable(keepRelatedTradeShopConfigBody.getEnable());
        tradeShopConfigDto.setEffectBeginTime(keepRelatedTradeShopConfigBody.getEffectBeginTime());
        tradeShopConfigDto.setEffectEndTime(keepRelatedTradeShopConfigBody.getEffectEndTime());
        if (CollectionUtils.isNotEmpty((Collection)keepRelatedTradeShopConfigBody.getRelatedTradeBodyList())) {
            List relatedTradeDtos = keepRelatedTradeShopConfigBody.getRelatedTradeBodyList().stream().map(v -> {
                KeepRelatedTradeDto tradeDto = new KeepRelatedTradeDto();
                tradeDto.setPlatformSellerEntityNumber(v.getPlatformSellerEntityNumber());
                tradeDto.setRelatedEntityId(v.getRelatedEntityId());
                tradeDto.setRelatedEntityNumber(v.getRelatedEntityNumber());
                tradeDto.setRelatedEntityName(v.getRelatedEntityName());
                tradeDto.setOwnEntity(v.getOwnEntity());
                tradeDto.setCustomerId(v.getCustomerId());
                tradeDto.setCustomerCode(v.getCustomerCode());
                tradeDto.setCustomerName(v.getCustomerName());
                tradeDto.setCommission(v.getCommission());
                return tradeDto;
            }).collect(Collectors.toList());
            tradeShopConfigDto.setRelatedTradeDtos(relatedTradeDtos);
        }
        if (CollectionUtils.isNotEmpty((Collection)keepRelatedTradeShopConfigBody.getRelatedShopBodyList())) {
            List relatedShopDtos = keepRelatedTradeShopConfigBody.getRelatedShopBodyList().stream().map(v -> {
                KeepRelatedShopDto shopDto = new KeepRelatedShopDto();
                shopDto.setShopId(v.getShopId());
                shopDto.setShopCode(v.getShopCode());
                shopDto.setShopName(v.getShopName());
                return shopDto;
            }).collect(Collectors.toList());
            tradeShopConfigDto.setRelatedShopDtos(relatedShopDtos);
        }
        logger.info("\u65b0\u589e\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u7ba1\u7406\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)tradeShopConfigDto));
        return this.proxy.saveOrUpdate(tradeShopConfigDto);
    }

    @Override
    public RestResponse<KeepRelatedTradeShopConfigBody> detail(Long id) {
        KeepRelatedTradeShopConfigBody keepRelatedTradeShopConfigBody = new KeepRelatedTradeShopConfigBody();
        KeepRelatedTradeShopConfigDto tradeShopConfigDto = (KeepRelatedTradeShopConfigDto)RestResponseHelper.extractData((RestResponse)this.proxy.detail(id));
        logger.info("KeepRelatedTradeShopConfigDto:{}", (Object)JSONObject.toJSONString((Object)tradeShopConfigDto));
        if (Objects.nonNull(tradeShopConfigDto)) {
            keepRelatedTradeShopConfigBody.setId(tradeShopConfigDto.getId());
            keepRelatedTradeShopConfigBody.setRuleCode(tradeShopConfigDto.getRuleCode());
            keepRelatedTradeShopConfigBody.setRuleName(tradeShopConfigDto.getRuleName());
            keepRelatedTradeShopConfigBody.setSiteCode(tradeShopConfigDto.getSiteCode());
            keepRelatedTradeShopConfigBody.setSiteName(tradeShopConfigDto.getSiteName());
            keepRelatedTradeShopConfigBody.setEnable(tradeShopConfigDto.getEnable());
            keepRelatedTradeShopConfigBody.setRemark(tradeShopConfigDto.getRemark());
            keepRelatedTradeShopConfigBody.setEffectBeginTime(tradeShopConfigDto.getEffectBeginTime());
            keepRelatedTradeShopConfigBody.setEffectEndTime(tradeShopConfigDto.getEffectEndTime());
            if (CollectionUtils.isNotEmpty((Collection)tradeShopConfigDto.getRelatedTradeDtos())) {
                keepRelatedTradeShopConfigBody.setRelatedTradeBodyList(tradeShopConfigDto.getRelatedTradeDtos().stream().map(v -> {
                    KeepRelatedTradeBody relatedTradeBody = new KeepRelatedTradeBody();
                    relatedTradeBody.setId(v.getId());
                    relatedTradeBody.setPlatformSellerEntityNumber(v.getPlatformSellerEntityNumber());
                    relatedTradeBody.setRelatedEntityId(v.getRelatedEntityId());
                    relatedTradeBody.setRelatedEntityNumber(v.getRelatedEntityNumber());
                    relatedTradeBody.setRelatedEntityName(v.getRelatedEntityName());
                    relatedTradeBody.setRuleCode(v.getRuleCode());
                    relatedTradeBody.setCustomerId(v.getCustomerId());
                    relatedTradeBody.setCustomerCode(v.getCustomerCode());
                    relatedTradeBody.setCustomerName(v.getCustomerName());
                    relatedTradeBody.setOwnEntity(v.getOwnEntity());
                    relatedTradeBody.setCommission(v.getCommission());
                    return relatedTradeBody;
                }).collect(Collectors.toList()));
                if (CollectionUtils.isNotEmpty((Collection)tradeShopConfigDto.getRelatedShopDtos())) {
                    keepRelatedTradeShopConfigBody.setRelatedShopBodyList(tradeShopConfigDto.getRelatedShopDtos().stream().map(v -> {
                        KeepRelatedShopBody relatedShopBody = new KeepRelatedShopBody();
                        relatedShopBody.setId(v.getId());
                        relatedShopBody.setRuleCode(v.getRuleCode());
                        relatedShopBody.setShopId(v.getShopId());
                        relatedShopBody.setShopCode(v.getShopCode());
                        relatedShopBody.setShopName(v.getShopName());
                        return relatedShopBody;
                    }).collect(Collectors.toList()));
                }
            }
        }
        return new RestResponse((Object)keepRelatedTradeShopConfigBody);
    }

    @Override
    public RestResponse<Void> delete(Long id) {
        return this.proxy.delete(id);
    }

    @Override
    public RestResponse<Void> enable(KeepRelatedTradeConfigDto dto) {
        return this.proxy.enable(dto);
    }

    @Override
    public RestResponse<PageInfo<KeepRelatedTradeShopConfigDto>> queryPage(KeepRelatedTradeConfigPageReqDto dto) {
        return this.proxy.queryPage(dto);
    }

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        if (StringUtils.isBlank((CharSequence)ServiceContext.getContext().getRequestId())) {
            String requestId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)requestId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        }
        logger.info("\u5bfc\u5165\u5173\u8054\u4ea4\u6613\u4fe1\u606flist\uff1a{}", (Object)JSONObject.toJSONString(result));
        List resultList = BeanUtil.copyToList((Collection)result.getList(), KeepRelatedTradeConfigImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            respDto.setErrorMsg("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5Excel\uff01");
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        if (resultList.size() > 2000) {
            respDto.setErrorMsg("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc72000\u884c");
            respDto.setStatus(com.yunxi.dg.base.poi.enums.FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return new ArrayList();
        }
        resultList.forEach(v -> this.importApplySpaceHandle((KeepRelatedTradeConfigImportDto)v));
        Map<String, List<KeepRelatedTradeConfigImportDto>> platformSaleSubjectMap = resultList.stream().collect(Collectors.groupingBy(x -> {
            StringBuffer buffer = new StringBuffer();
            buffer.append(x.getRuleName()).append(";");
            buffer.append(x.getPlatformSellerEntityNumber());
            return buffer.toString();
        }));
        logger.info("\u5224\u65ad\u662f\u5426\u5b58\u5728\u540c\u4e00\u89c4\u5219\u76f8\u540c\u7684\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u7f16\u53f7\u60c5\u51b5platformSaleSubjectMap:{}", (Object)JSONObject.toJSONString(platformSaleSubjectMap));
        ArrayList shopCodes = Lists.newArrayList();
        resultList.forEach(v -> {
            if (StringUtils.isNotBlank((CharSequence)v.getShopCode())) {
                List<String> codes = Arrays.asList(v.getShopCode().split(","));
                shopCodes.addAll(codes);
            }
        });
        Map<String, DgShopRespDto> shopRespDtoMap = this.getDgShopRespDto(shopCodes);
        List<String> ruleNames = resultList.stream().filter(x -> Objects.nonNull(x.getRuleName())).map(KeepRelatedTradeConfigImportDto::getRuleName).distinct().collect(Collectors.toList());
        List<String> siteCodes = resultList.stream().filter(x -> Objects.nonNull(x.getSiteCode())).map(KeepRelatedTradeConfigImportDto::getSiteCode).distinct().collect(Collectors.toList());
        Map<String, List<KeepRelatedTradeShopConfigDto>> shopConfigDtoMap = this.getKeepRelatedTradeShopConfigDtoMap(ruleNames, siteCodes);
        List channelCodes = resultList.stream().filter(x -> Objects.nonNull(x.getSiteCode())).map(KeepRelatedTradeConfigImportDto::getSiteCode).distinct().collect(Collectors.toList());
        ChannelQueryReqDto queryReqDto = new ChannelQueryReqDto();
        queryReqDto.setCodes(channelCodes);
        List listChannelByCodes = (List)RestResponseHelper.extractData((RestResponse)this.channelQueryApiProxy.queryListChannelByCodes(queryReqDto));
        Map channelRespDtoMap = listChannelByCodes.stream().collect(Collectors.toMap(DgCsChannelRespDto::getChannelCode, Function.identity(), (a, b) -> a));
        List<String> enterpriseCodes = resultList.stream().filter(x -> Objects.nonNull(x.getRelatedEntityNumber())).map(KeepRelatedTradeConfigImportDto::getRelatedEntityNumber).distinct().collect(Collectors.toList());
        Map<String, DgEnterpriseRespDto> enterpriseRespDtoMap = this.getDgEnterpriseRespDto(enterpriseCodes);
        ArrayList relatedSiteCodes = Lists.newArrayList();
        ArrayList platformSellerEntityNumbers = Lists.newArrayList();
        ArrayList relatedShopCodes = Lists.newArrayList();
        ArrayList relatedEntityNumbers = Lists.newArrayList();
        resultList.forEach(v -> {
            if (StringUtils.isNotBlank((CharSequence)v.getSiteCode())) {
                relatedSiteCodes.add(v.getSiteCode());
            }
            if (StringUtils.isNotBlank((CharSequence)v.getPlatformSellerEntityNumber())) {
                platformSellerEntityNumbers.add(v.getPlatformSellerEntityNumber());
            }
            if (StringUtils.isNotBlank((CharSequence)v.getRelatedEntityNumber())) {
                relatedEntityNumbers.add(v.getRelatedEntityNumber());
            }
            if (StringUtils.isNotBlank((CharSequence)v.getShopCode())) {
                List<String> codes = Arrays.asList(v.getShopCode().split(","));
                relatedShopCodes.addAll(codes);
            }
        });
        RelatedTradeShopMatchQueryDto queryDto = new RelatedTradeShopMatchQueryDto();
        queryDto.setSiteCodes((List)relatedSiteCodes);
        queryDto.setPlatformSellerEntityNumbers((List)platformSellerEntityNumbers);
        queryDto.setRelatedEntityNumbers((List)relatedEntityNumbers);
        queryDto.setShopCodes((List)relatedShopCodes);
        queryDto.setEnable(Integer.valueOf(0));
        List tradeShopMatchDtos = (List)RestResponseHelper.extractData((RestResponse)this.proxy.queryListBySiteShopSellerRelated(queryDto));
        ArrayList passList = new ArrayList();
        resultList.forEach(v -> {
            List tradeConfigImportDtos;
            ExportKeepRelatedTradeConfigDto msgDto = new ExportKeepRelatedTradeConfigDto();
            KeepRelatedTradeConfigImportDto successDto = new KeepRelatedTradeConfigImportDto();
            ArrayList<String> errorList = new ArrayList<String>();
            this.importCheckParams((KeepRelatedTradeConfigImportDto)v, (List<String>)errorList, channelRespDtoMap, shopRespDtoMap, tradeShopMatchDtos, enterpriseRespDtoMap);
            String key = v.getRuleName() + ";" + v.getSiteCode();
            logger.info("\u6821\u9a8c\u6570\u636e\u5e93\u662f\u5426\u5df2\u5b58\u5728\u89c4\u5219shopConfigDtoMap:{},{}", (Object)v.getRuleName(), (Object)key);
            if (shopConfigDtoMap.containsKey(key) && ((List)shopConfigDtoMap.get(key)).size() > 0) {
                errorList.add("\u89c4\u5219\u540d\u79f0:" + v.getRuleName() + "\u6e20\u9053\u7f16\u53f7:" + v.getSiteCode() + "\u6570\u636e\u5df2\u5b58\u5728");
            }
            String platformKey = v.getRuleName() + ";" + v.getPlatformSellerEntityNumber();
            logger.info("\u6821\u9a8c\u5bfc\u5165\u6570\u636e\u662f\u5426\u91cd\u590d\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u7f16\u53f7platformSaleSubjectMap:{},{}", (Object)v.getRuleName(), (Object)JSONObject.toJSONString(platformSaleSubjectMap.get(platformKey)));
            if (platformSaleSubjectMap.containsKey(platformKey) && (tradeConfigImportDtos = (List)platformSaleSubjectMap.get(platformKey)).size() > 1) {
                errorList.add("\u89c4\u5219\u540d\u79f0:" + v.getRuleName() + "\u6e20\u9053\u7f16\u53f7:" + v.getPlatformSellerEntityNumber() + "\u5b58\u5728\u91cd\u590d\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u7f16\u53f7");
            }
            if (StringUtils.isNotBlank((CharSequence)v.getShopCode())) {
                List<String> codes = Arrays.asList(v.getShopCode().split(","));
                codes.forEach(i -> {
                    if (shopRespDtoMap.containsKey(i)) {
                        DgShopRespDto shopRespDto = (DgShopRespDto)shopRespDtoMap.get(i);
                        if (!v.getSiteCode().equals(shopRespDto.getChannelCode())) {
                            errorList.add("\u5e97\u94fa\u7f16\u53f7: " + i + "\u7684\u6e20\u9053\uff1a " + shopRespDto.getChannelCode() + "\u4e0e\u5bfc\u5165\u7684\u6587\u4ef6\u5bf9\u5e94\u7684\u6e20\u9053\u4e0d\u4e00\u81f4\uff01");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(errorList)) {
                BeanUtils.copyProperties((Object)v, (Object)msgDto);
                msgDto.setErrorMsg(String.join((CharSequence)",", errorList));
                respDto.getErrorDetails().add(msgDto);
            } else {
                CubeBeanUtils.copyProperties((Object)successDto, (Object)v, (String[])new String[0]);
                if ("\u662f".equals(v.getOwnEntity())) {
                    successDto.setOwnEntity("yes");
                } else if ("\u5426".equals(v.getOwnEntity())) {
                    successDto.setOwnEntity("no");
                }
                DgCsChannelRespDto dgCsChannelRespDto = (DgCsChannelRespDto)channelRespDtoMap.get(v.getSiteCode());
                successDto.setSiteName(Objects.nonNull(dgCsChannelRespDto) ? dgCsChannelRespDto.getChannelName() : null);
                if (StringUtils.isNotBlank((CharSequence)v.getRelatedEntityNumber())) {
                    DgEnterpriseRespDto dgEnterpriseRespDto = (DgEnterpriseRespDto)enterpriseRespDtoMap.get(v.getRelatedEntityNumber());
                    successDto.setRelatedEntityName(Objects.nonNull(dgEnterpriseRespDto) ? dgEnterpriseRespDto.getName() : null);
                }
                passList.add(successDto);
            }
        });
        logger.info("\u5bfc\u5165\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u6821\u9a8c\u901a\u8fc7\u6570\u91cf====>>>{}", (Object)passList.size());
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List successList = (List)object;
        if (CollectionUtil.isEmpty((Collection)successList)) {
            respDto.setStatus(com.yunxi.dg.base.poi.enums.FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)successList) && CollectionUtils.isNotEmpty((Collection)respDto.getErrorDetails())) {
            respDto.setStatus(com.yunxi.dg.base.poi.enums.FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        } else {
            respDto.setStatus(com.yunxi.dg.base.poi.enums.FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        }
        logger.info("\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u5bfc\u5165:{}", (Object)JSON.toJSONString((Object)successList));
        Map<String, List<KeepRelatedTradeConfigImportDto>> collect = successList.stream().collect(Collectors.groupingBy(x -> {
            StringBuffer buffer = new StringBuffer();
            buffer.append(x.getRuleName()).append(";");
            buffer.append(x.getSiteCode());
            return buffer.toString();
        }));
        logger.info("\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u5bfc\u5165\u5206\u7ec4\uff1a{}", (Object)JSONObject.toJSONString(collect));
        ArrayList shopCodes = Lists.newArrayList();
        successList.forEach(v -> {
            if (StringUtils.isNotBlank((CharSequence)v.getShopCode())) {
                shopCodes.addAll(Arrays.asList(v.getShopCode().split(",")));
            }
        });
        Map<String, DgShopRespDto> shopRespDtoMap = this.getDgShopRespDto(shopCodes);
        ArrayList tradeShopConfigDtos = Lists.newArrayList();
        collect.forEach((k, v) -> {
            KeepRelatedTradeShopConfigDto configDto = new KeepRelatedTradeShopConfigDto();
            List<String> key = Arrays.asList(k.split(";"));
            List tradeConfigImportDtos = v;
            configDto.setRuleName(key.get(0));
            configDto.setEffectBeginTime(((KeepRelatedTradeConfigImportDto)tradeConfigImportDtos.get(0)).getEffectBeginTime());
            configDto.setEffectEndTime(((KeepRelatedTradeConfigImportDto)tradeConfigImportDtos.get(0)).getEffectEndTime());
            configDto.setSiteCode(key.get(0));
            configDto.setSiteName(((KeepRelatedTradeConfigImportDto)tradeConfigImportDtos.get(0)).getSiteName());
            configDto.setEnable(Integer.valueOf(0));
            ArrayList relatedTradeDtos = Lists.newArrayList();
            tradeConfigImportDtos.forEach(i -> {
                KeepRelatedTradeDto relatedTradeDto = new KeepRelatedTradeDto();
                relatedTradeDto.setPlatformSellerEntityNumber(i.getPlatformSellerEntityNumber());
                relatedTradeDto.setRelatedEntityNumber(i.getRelatedEntityNumber());
                relatedTradeDto.setRelatedEntityName(i.getRelatedEntityName());
                relatedTradeDto.setCustomerCode(i.getCustomerCode());
                relatedTradeDto.setCustomerName(i.getCustomerName());
                relatedTradeDto.setCommission(i.getCommission());
                relatedTradeDto.setOwnEntity(i.getOwnEntity());
                relatedTradeDtos.add(relatedTradeDto);
            });
            configDto.setRelatedTradeDtos((List)relatedTradeDtos);
            ArrayList relatedShopDtos = Lists.newArrayList();
            HashSet tradeShops = new HashSet();
            tradeConfigImportDtos.forEach(i -> {
                if (StringUtils.isNotBlank((CharSequence)i.getShopCode())) {
                    List<String> codes = Arrays.asList(i.getShopCode().split(","));
                    tradeShops.addAll(codes);
                }
            });
            if (CollectionUtils.isNotEmpty(tradeShops)) {
                ArrayList codes = new ArrayList(tradeShops);
                codes.forEach(j -> {
                    KeepRelatedShopDto relatedShopDto = new KeepRelatedShopDto();
                    relatedShopDto.setShopCode(j);
                    if (shopRespDtoMap.containsKey(j)) {
                        DgShopRespDto dgShopRespDto = (DgShopRespDto)shopRespDtoMap.get(j);
                        relatedShopDto.setShopId(dgShopRespDto.getId());
                        relatedShopDto.setShopName(dgShopRespDto.getStoreName());
                    }
                    relatedShopDtos.add(relatedShopDto);
                });
            }
            configDto.setRelatedShopDtos((List)relatedShopDtos);
            tradeShopConfigDtos.add(configDto);
        });
        try {
            logger.info("\u5173\u8054\u4ea4\u6613\u5173\u7cfb\u5bfc\u5165\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)tradeShopConfigDtos));
            RestResponse restResponse = this.proxy.batchSave((List)tradeShopConfigDtos);
            if (!restResponse.isSuccess()) {
                respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
                respDto.setErrorMsg(restResponse.getResultMsg());
            } else {
                respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
            }
        }
        catch (Exception e) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void importCheckParams(KeepRelatedTradeConfigImportDto importDto, List<String> errorList, Map<String, DgCsChannelRespDto> channelRespDtoMap, Map<String, DgShopRespDto> shopRespDtoMap, List<RelatedTradeShopMatchDto> tradeShopMatchDtos, Map<String, DgEnterpriseRespDto> enterpriseRespDtoMap) {
        if (StringUtils.isBlank((CharSequence)importDto.getRuleName())) {
            errorList.add("\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)importDto.getPlatformSellerEntityNumber())) {
            errorList.add("\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)importDto.getRelatedEntityNumber())) {
            errorList.add("\u5173\u8054\u4e3b\u4f53\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getRelatedEntityNumber()) && !enterpriseRespDtoMap.containsKey(importDto.getRelatedEntityNumber())) {
            errorList.add("\u5173\u8054\u4e3b\u4f53\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)importDto.getOwnEntity())) {
            errorList.add("\u662f\u5426\u81ea\u6709\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"\u662f".equals(importDto.getOwnEntity()) && !"\u5426".equals(importDto.getOwnEntity())) {
            errorList.add("\u662f\u5426\u81ea\u6709\u4e3b\u4f53\u53ea\u80fd'\u662f'\u6216\u8005'\u5426'");
        }
        if (StringUtils.isBlank((CharSequence)importDto.getCommission())) {
            errorList.add("\u4f63\u91d1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)importDto.getEffectBeginTime())) {
            errorList.add("\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)importDto.getEffectEndTime())) {
            errorList.add("\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)importDto.getSiteCode())) {
            errorList.add("\u6e20\u9053\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getSiteCode()) && !channelRespDtoMap.containsKey(importDto.getSiteCode())) {
            errorList.add("\u6e20\u9053\u7f16\u53f7\u4e0d\u5b58\u5728!");
        }
        if (StringUtils.isBlank((CharSequence)importDto.getShopCode())) {
            errorList.add("\u5e97\u94fa\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getShopCode())) {
            List<String> shopCodes = Arrays.asList(importDto.getShopCode().split(","));
            logger.info("\u5e97\u94fa\u7f16\u53f7\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(shopCodes));
            shopCodes.forEach(x -> {
                if (!shopRespDtoMap.containsKey(x)) {
                    errorList.add("\u5e97\u94fa\u7f16\u53f7" + x + "\u4e0d\u5b58\u5728!");
                }
            });
        }
        if (!FinancialManagementKeepRelatedTradeConfigServiceServiceImpl.isNumeric(importDto.getCommission()) && new BigDecimal(importDto.getCommission()).compareTo(BigDecimal.ZERO) >= 0 && new BigDecimal(importDto.getCommission()).intValue() <= 100) {
            errorList.add("\u4f63\u91d1\u53ea\u80fd\u586b\u6570\u5b57\u4e14\u5927\u4e8e0\u5c0f\u4e8e\u7b49\u4e8e100");
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getEffectBeginTime()) && !FinancialManagementKeepRelatedTradeConfigServiceServiceImpl.isValidDate(importDto.getEffectBeginTime(), "yyyy-MM-dd")) {
            errorList.add("\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u987b\u4e3a:yyyy-MM-dd");
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getEffectEndTime()) && !FinancialManagementKeepRelatedTradeConfigServiceServiceImpl.isValidDate(importDto.getEffectEndTime(), "yyyy-MM-dd")) {
            errorList.add("\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u987b\u4e3a:yyyy-MM-dd");
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getEffectBeginTime()) && StringUtils.isNotBlank((CharSequence)importDto.getEffectEndTime())) {
            try {
                Date startTime = DateUtil.parse((String)(importDto.getEffectBeginTime() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
                Date endTime = DateUtil.parse((String)(importDto.getEffectEndTime() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
                if (startTime.after(endTime)) {
                    errorList.add("\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4");
                }
            }
            catch (Exception e) {
                errorList.add("\u6709\u6548\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u987b\u4e3a:yyyy-MM-dd");
            }
        }
        if (CollectionUtils.isNotEmpty(tradeShopMatchDtos)) {
            AtomicReference<Boolean> isTradeShopMatch = new AtomicReference<Boolean>(Boolean.FALSE);
            Map tradeShopMatchDtoMap = tradeShopMatchDtos.stream().collect(Collectors.toMap(x -> x.getSiteCode() + ";" + x.getShopCode() + ";" + x.getPlatformSellerEntityNumber() + ";" + x.getRelatedEntityNumber(), Function.identity(), (k1, k2) -> k1));
            tradeShopMatchDtoMap.forEach((k, v) -> {
                RelatedTradeShopMatchDto tradeShopMatchDto = v;
                if (importDto.getSiteCode().equals(tradeShopMatchDto.getSiteCode())) {
                    String tradeKey = importDto.getPlatformSellerEntityNumber() + ";" + importDto.getRelatedEntityNumber();
                    if (StringUtils.isNotBlank((CharSequence)importDto.getShopCode())) {
                        List<String> shopCodes = Arrays.asList(importDto.getShopCode().split(","));
                        shopCodes.forEach(x -> {
                            if (tradeKey.equals(tradeShopMatchDto.getPlatformSellerEntityNumber() + ";" + tradeShopMatchDto.getRelatedEntityNumber()) && x.equals(tradeShopMatchDto.getShopCode())) {
                                isTradeShopMatch.set(Boolean.TRUE);
                                return;
                            }
                        });
                    }
                }
            });
            if (isTradeShopMatch.get().booleanValue()) {
                errorList.add("\u6e20\u9053\uff1a" + importDto.getSiteCode() + "\u5b58\u5728\u5176\u4ed6\u540c\u4e00\u6e20\u9053\u540c\u4e00\u5e97\u94fa\uff0c\u540c\u4e00\u5173\u8054\u4e3b\u4f53\uff0c\u540c\u4e00\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u5b58\u5728\u542f\u7528\u6570\u636e\uff0c\u8bf7\u5148\u7981\u7528!");
            }
        }
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidDate(String dateStr, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        try {
            LocalDate.parse(dateStr, formatter);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    public void importApplySpaceHandle(KeepRelatedTradeConfigImportDto importDto) {
        if (StringUtils.isNotBlank((CharSequence)importDto.getRuleName())) {
            importDto.setRuleName(importDto.getRuleName().trim().replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getPlatformSellerEntityNumber())) {
            importDto.setPlatformSellerEntityNumber(importDto.getPlatformSellerEntityNumber().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getRelatedEntityNumber())) {
            importDto.setRelatedEntityNumber(importDto.getRelatedEntityNumber().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getRelatedEntityName())) {
            importDto.setRelatedEntityName(importDto.getRelatedEntityName().trim().replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getCustomerCode())) {
            importDto.setCustomerCode(importDto.getCustomerCode().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getCustomerName())) {
            importDto.setCustomerName(importDto.getCustomerName().trim().replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getCommission())) {
            importDto.setCommission(importDto.getCommission().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getEffectBeginTime())) {
            importDto.setEffectBeginTime(importDto.getEffectBeginTime().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getEffectEndTime())) {
            importDto.setEffectEndTime(importDto.getEffectEndTime().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getSiteCode())) {
            importDto.setSiteCode(importDto.getSiteCode().replace(" ", "").replace("\n", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getShopCode())) {
            importDto.setShopCode(importDto.getShopCode().replace(" ", "").replace("\n", ""));
        }
    }

    private Map<String, List<KeepRelatedTradeShopConfigDto>> getKeepRelatedTradeShopConfigDtoMap(List<String> ruleNames, List<String> siteCodes) {
        HashMap<String, List<KeepRelatedTradeShopConfigDto>> resultMap = new HashMap<String, List<KeepRelatedTradeShopConfigDto>>();
        if (CollectionUtils.isEmpty(ruleNames) || CollectionUtils.isEmpty(siteCodes)) {
            return resultMap;
        }
        KeepRelatedTradeConfigPageReqDto pageReqDto = new KeepRelatedTradeConfigPageReqDto();
        pageReqDto.setRuleNames(ruleNames);
        pageReqDto.setSiteCodes(siteCodes);
        List shopConfigDtos = (List)RestResponseHelper.extractData((RestResponse)this.proxy.queryList(pageReqDto));
        if (CollectionUtils.isEmpty((Collection)shopConfigDtos)) {
            return resultMap;
        }
        Map<String, List<KeepRelatedTradeShopConfigDto>> collect = shopConfigDtos.stream().collect(Collectors.groupingBy(x -> {
            StringBuffer buffer = new StringBuffer();
            buffer.append(x.getRuleName()).append(";");
            buffer.append(x.getSiteCode());
            return buffer.toString();
        }));
        return collect;
    }

    private Map<String, DgShopRespDto> getDgShopRespDto(List<String> shopCodes) {
        if (CollectionUtils.isEmpty(shopCodes)) {
            return Maps.newHashMap();
        }
        List shopRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.queryByCodes(shopCodes));
        logger.info("\u5e97\u94fa\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)shopRespDtos));
        return shopRespDtos.stream().collect(Collectors.toMap(DgShopRespDto::getStoreCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, DgEnterpriseRespDto> getDgEnterpriseRespDto(List<String> enterpriseCodes) {
        HashMap enterpriseRespDtoMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(enterpriseCodes)) {
            return enterpriseRespDtoMap;
        }
        DgEnterpriseQueryReqDto queryReqDto = new DgEnterpriseQueryReqDto();
        queryReqDto.setCodeList(enterpriseCodes);
        List enterpriseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.enterpriseQueryApiProxy.queryList(queryReqDto));
        if (CollectionUtils.isEmpty((Collection)enterpriseRespDtoList)) {
            return enterpriseRespDtoMap;
        }
        return enterpriseRespDtoList.stream().collect(Collectors.toMap(DgEnterpriseRespDto::getCode, Function.identity(), (k1, k2) -> k1));
    }
}

