/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.dto.dto.DictValueDto;
import com.yundt.boot.center.data.dto.request.AreaQueryNameReqDto;
import com.yundt.boot.center.data.dto.response.AreaExtRespDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchListReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerSearchListRespDto;
import com.yunxi.dg.base.center.inventory.proxy.other.IInOtherStorageOrderApiProxy;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageBusinessTypeDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageBusinessTypePageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageOrderDetailDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageOrderDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.UnitDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.IDgLogicInventoryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.order.IInOtherStorageBusinessTypeApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IAreaExtQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.unit.IUnitDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.config.InventoryConfig;
import com.yunxi.dg.base.mgmt.service.context.OcsConfig;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportOutOtherOrderModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_out_other_storage")
public class OutOtherStorageOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(OutOtherStorageOrderCommonServiceImpl.class);
    @Resource
    private IDgLogicInventoryApiProxy dgLogicInventoryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IUnitDgQueryApiProxy unitDgQueryApiProxy;
    @Resource
    private IInOtherStorageBusinessTypeApiProxy iInOtherStorageBusinessTypeApiProxy;
    @Value(value="${project.item.unit.conversion}")
    private String UNIT_CONVERSION;
    @Resource
    private IInOtherStorageOrderApiProxy inOtherStorageOrderApiProxy;
    @Resource
    private IUnitDgQueryApiProxy iUnitDgQueryApiProxy;
    @Resource
    private IDgCustomerQueryApiProxy dgCustomerQueryApiProxy;
    @Resource
    private IAreaExtQueryApiProxy areaExtQueryApiProxy;
    @Resource
    private IDictQueryApiProxy iDictQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u5176\u4ed6\u51fa\u5e93\u5355");
        ArrayList<ImportOutOtherOrderModeDto> passList = new ArrayList<ImportOutOtherOrderModeDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportOutOtherOrderModeDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u5176\u4ed6\u51fa\u5e93\u5355,\u5bfc\u5165\u5176\u4ed6\u51fa\u5e93\u5355\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        UnitDgReqDto unitDgReqDto = new UnitDgReqDto();
        List unitDgRespDtos = Optional.ofNullable(this.iUnitDgQueryApiProxy.queryList(unitDgReqDto).getData()).orElse(new ArrayList());
        Map<String, String> unitNameMap = unitDgRespDtos.stream().collect(Collectors.toMap(UnitDgRespDto::getName, UnitDgRespDto::getCode, (o, o1) -> o));
        for (ImportOutOtherOrderModeDto importOutOtherOrderModeDto : resultList) {
            if (!unitNameMap.containsKey(importOutOtherOrderModeDto.getUnit())) continue;
            importOutOtherOrderModeDto.setUnit(unitNameMap.get(importOutOtherOrderModeDto.getUnit()));
        }
        List skuCodes = resultList.stream().map(ImportOutOtherOrderModeDto::getSkuCode).collect(Collectors.toList());
        List warehouseCodes = resultList.stream().map(ImportOutOtherOrderModeDto::getDeliveryLogicWarehouseCode).collect(Collectors.toList());
        List customerCodeList = resultList.stream().map(ImportOutOtherOrderModeDto::getReceiveCustomerCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        ArrayList reqList = new ArrayList();
        resultList.forEach(o -> {
            AreaQueryNameReqDto reqDto = new AreaQueryNameReqDto();
            reqDto.setProvinceName(o.getProvince());
            reqDto.setCityName(o.getCity());
            reqDto.setAreaName(o.getArea());
            reqList.add(reqDto);
        });
        List areaRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.areaExtQueryApiProxy.queryByAreaName(reqList));
        DgLogicInventoryListReqDto reqDto = new DgLogicInventoryListReqDto();
        reqDto.setLogicWarehouseCodeList(warehouseCodes);
        reqDto.setSkuCodeList(skuCodes);
        List dgLogicInventoryDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgLogicInventoryApiProxy.queryList(reqDto))).orElse(new ArrayList());
        List dgItemSkuDetailRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryBySkuCode(skuCodes))).orElse(new ArrayList());
        List unitRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.unitDgQueryApiProxy.queryList(new UnitDgReqDto()))).orElse(new ArrayList());
        DgCustomerSearchListReqDto customerSearchListReqDto = new DgCustomerSearchListReqDto();
        customerSearchListReqDto.setCustomerCodeList(customerCodeList);
        List customerList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgCustomerQueryApiProxy.queryList(customerSearchListReqDto))).orElse(new ArrayList());
        InOtherStorageBusinessTypePageReqDto inOtherStorageBusinessTypePageReqDto = new InOtherStorageBusinessTypePageReqDto();
        inOtherStorageBusinessTypePageReqDto.setStatus(YesNoEnum.YES.getValue());
        inOtherStorageBusinessTypePageReqDto.setType("other_out");
        inOtherStorageBusinessTypePageReqDto.setPageNum(Integer.valueOf(1));
        inOtherStorageBusinessTypePageReqDto.setPageSize(Integer.valueOf(1000));
        List inOtherStorageBusinessTypeDtoList = Optional.ofNullable(((PageInfo)this.iInOtherStorageBusinessTypeApiProxy.page(inOtherStorageBusinessTypePageReqDto).getData()).getList()).orElse(new ArrayList());
        Map<String, InOtherStorageBusinessTypeDto> businessGroupMap = inOtherStorageBusinessTypeDtoList.stream().filter(r -> r.getParentCode().equals("0")).collect(Collectors.toMap(InOtherStorageBusinessTypeDto::getBusinessTypeName, Function.identity(), (o, o1) -> o));
        Map<String, InOtherStorageBusinessTypeDto> businessTypeMap = inOtherStorageBusinessTypeDtoList.stream().filter(r -> !r.getParentCode().equals("0")).collect(Collectors.toMap(InOtherStorageBusinessTypeDto::getBusinessTypeName, Function.identity(), (o, o1) -> o));
        Map<String, List<DgLogicInventoryDto>> warehouseCodeMap = dgLogicInventoryDtos.stream().collect(Collectors.groupingBy(DgLogicInventoryDto::getWarehouseCode));
        Map<String, DgLogicInventoryDto> skuCodeMap = dgLogicInventoryDtos.stream().collect(Collectors.toMap(DgLogicInventoryDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        Map<String, DgLogicInventoryDto> batchMap = dgLogicInventoryDtos.stream().collect(Collectors.toMap(DgLogicInventoryDto::getBatch, Function.identity(), (k1, k2) -> k1));
        Map<String, ItemSkuDgRespDto> itemUnitMap = dgItemSkuDetailRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        Map<String, UnitDgRespDto> unitMap = unitRespDtos.stream().collect(Collectors.toMap(UnitDgRespDto::getName, Function.identity(), (k1, k2) -> k1));
        Map<String, DgLogicInventoryDto> skuCodeBatchMap = dgLogicInventoryDtos.stream().collect(Collectors.toMap(o -> InventoryConfig.isNoneBatch() ? o.getSkuCode() : o.getSkuCode() + o.getBatch(), Function.identity(), (k1, k2) -> k1));
        Map<String, String> customerCodeNameMap = customerList.stream().collect(Collectors.toMap(DgCustomerSearchListRespDto::getCode, DgCustomerSearchListRespDto::getName, (k1, k2) -> k1));
        Map<String, AreaExtRespDto> areaMap = ((List)Optional.ofNullable(areaRespDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(o -> o.getProvinceName() + o.getCityName() + o.getAreaName(), Function.identity(), (k1, k2) -> k1));
        log.info("unitMap\u5355\u4f4d\u4fe1\u606f\u5206\u7ec4:{}", (Object)JSON.toJSONString(unitMap));
        log.info("\u67e5\u8be2\u903b\u8f91\u4ed3\u4fe1\u606f\u6570\u636edgLogicInventoryDtos:{}", (Object)JSON.toJSONString((Object)dgLogicInventoryDtos));
        log.info("\u67e5\u8be2\u4e1a\u52a1\u4fe1\u606finOtherStorageBusinessTypeDtoList\u6570\u636e:{}", (Object)JSON.toJSONString((Object)inOtherStorageBusinessTypeDtoList));
        log.info("\u4e1a\u52a1\u5206\u7ec4businessGroupMap\u6570\u636e:{}", (Object)JSON.toJSONString(businessGroupMap));
        log.info("\u4e1a\u52a1\u7c7b\u578b\u5206\u7ec4\u6570\u636ebusinessTypeMap:{}", (Object)JSON.toJSONString(businessTypeMap));
        for (ImportOutOtherOrderModeDto dto : resultList) {
            boolean businessTypePass = this.businessTypeVerify(businessGroupMap, businessTypeMap, dto);
            boolean isPass = this.paramVerify(dto, warehouseCodeMap, skuCodeMap, batchMap, itemUnitMap, unitMap, skuCodeBatchMap, customerCodeNameMap, areaMap);
            if (isPass || businessTypePass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        try {
            ArrayList<InOtherStorageOrderDto> orderDtoList = new ArrayList<InOtherStorageOrderDto>();
            this.assembleDtos(orderDtoList, passList, respDto, commonReqDto);
            for (InOtherStorageOrderDto inOtherStorageOrderDto : orderDtoList) {
                this.inOtherStorageOrderApiProxy.addOtherStorageOrder(inOtherStorageOrderDto);
            }
        }
        catch (Exception e) {
            log.info("\u5bfc\u5165\u5176\u4ed6\u51fa\u5e93\u5355\u5931\u8d25", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
        }
    }

    private void assembleDtos(List<InOtherStorageOrderDto> orderDtoList, List<ImportOutOtherOrderModeDto> passList, ImportFileOperationCommonRespDto respDto, ImportFileOperationCommonReqDto commonReqDto) {
        Map<String, List<ImportOutOtherOrderModeDto>> passMap = passList.stream().collect(Collectors.groupingBy(this::getGroupKey));
        log.info("\u5bfc\u5165\u5176\u4ed6\u51fa\u5e93\u5355\u5206\u7ec4\u540epassMap:{}", (Object)JSON.toJSONString(passMap));
        passMap.forEach((key, importDtos) -> {
            try {
                InOtherStorageOrderDto inOtherStorageOrderDto = new InOtherStorageOrderDto();
                ArrayList inOtherStorageOrderDetailDtos = new ArrayList();
                ImportOutOtherOrderModeDto importDto = (ImportOutOtherOrderModeDto)importDtos.get(0);
                BeanUtil.copyProperties((Object)importDto, (Object)inOtherStorageOrderDto, (String[])new String[0]);
                inOtherStorageOrderDto.setType("other_out");
                inOtherStorageOrderDto.setWarehouseCode(importDto.getDeliveryLogicWarehouseCode());
                inOtherStorageOrderDto.setWarehouseName(importDto.getDeliveryLogicWarehouseName());
                inOtherStorageOrderDto.setBusinessTypeGroup(importDto.getBusinessTypeGroup());
                inOtherStorageOrderDto.setBusinessTypeGroupName(importDto.getBusinessGroup());
                inOtherStorageOrderDto.setBusinessTypeName(importDto.getBusinessType());
                inOtherStorageOrderDto.setBusinessType(importDto.getType());
                inOtherStorageOrderDto.setPhysicsWarehouseCode(importDto.getPhysicsWarehouseCode());
                inOtherStorageOrderDto.setPhysicsWarehouseName(importDto.getPhysicsWarehouseName());
                inOtherStorageOrderDto.setCargoOrganizationCode(importDto.getCargoOrganizationCode());
                inOtherStorageOrderDto.setCargoOrganizationName(importDto.getCargoOrganizationName());
                inOtherStorageOrderDto.setCommitType("SAVE");
                inOtherStorageOrderDto.setRemark(importDto.getMessage());
                inOtherStorageOrderDto.setBizDate((Date)DateUtil.parse((CharSequence)(importDto.getBizDate() + " 00:00:00"), (String)"yyyy/MM/dd HH:mm:ss"));
                inOtherStorageOrderDto.setCustomerCode(importDto.getReceiveCustomerCode());
                inOtherStorageOrderDto.setCustomerName(importDto.getReceiveCustomerName());
                inOtherStorageOrderDto.setConsignee(importDto.getContact());
                inOtherStorageOrderDto.setPhone(importDto.getContactPhone());
                inOtherStorageOrderDto.setProvinceName(importDto.getProvince());
                inOtherStorageOrderDto.setProvinceCode(importDto.getProvinceCode());
                inOtherStorageOrderDto.setCityName(importDto.getCity());
                inOtherStorageOrderDto.setCityCode(importDto.getCityCode());
                inOtherStorageOrderDto.setAreaName(importDto.getArea());
                inOtherStorageOrderDto.setAreaCode(importDto.getAreaCode());
                inOtherStorageOrderDto.setAddress(importDto.getDetailAddress());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("platformName", (Object)importDto.getPlatformName());
                String whDepartmentCode = importDto.getWhDepartmentCode();
                jsonObject.put("whDepartmentCode", (Object)whDepartmentCode);
                String whDepartmentName = importDto.getWhDepartmentName();
                if (StringUtils.isEmpty((CharSequence)whDepartmentName)) {
                    List dictDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iDictQueryApiProxy.queryByPage(Integer.valueOf(1), Integer.valueOf(1), "{'code':'U9_DEPARTMENT_MISCSHIPMENT'}"))).getList();
                    if (CollectionUtils.isNotEmpty((Collection)dictDtoList)) {
                        DictValueDto dictValueDto = Optional.ofNullable(((DictDto)dictDtoList.get(0)).getDictValueList()).orElse(Lists.newArrayList()).stream().filter(d -> d.getValue() != null && d.getValue().equals(whDepartmentCode)).findFirst().orElse(null);
                        jsonObject.put("whDepartmentName", (Object)(dictValueDto != null ? dictValueDto.getLabel() : ""));
                    }
                } else {
                    jsonObject.put("whDepartmentName", (Object)whDepartmentName);
                }
                inOtherStorageOrderDto.setExtension(jsonObject.toJSONString());
                Map<String, List<ImportOutOtherOrderModeDto>> detailMap = importDtos.stream().collect(Collectors.groupingBy(this::getGroupDetailKey));
                log.info("\u5bfc\u5165\u5176\u4ed6\u5165\u5e93\u5355\u660e\u7ec6\u5206\u7ec4detailMap:{}", (Object)JSON.toJSONString(detailMap));
                List itemSkuDgRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryBySkuCode((List)Lists.newArrayList(detailMap.keySet())));
                Map skuMap = Optional.of(itemSkuDgRespDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (a, b) -> b));
                detailMap.forEach((detailKey, detailDtoList) -> {
                    ImportOutOtherOrderModeDto detailDto = Optional.ofNullable(detailDtoList.get(0)).orElse(new ImportOutOtherOrderModeDto());
                    InOtherStorageOrderDetailDto orderDetailDto = (InOtherStorageOrderDetailDto)Optional.ofNullable(BeanUtil.toBean((Object)detailDto, InOtherStorageOrderDetailDto.class)).orElse(new InOtherStorageOrderDetailDto());
                    orderDetailDto.setSkuCode(detailDto.getSkuCode());
                    orderDetailDto.setUnit(detailDto.getUnit());
                    ItemSkuDgRespDto itemSkuDgRespDto = (ItemSkuDgRespDto)skuMap.get(detailDto.getSkuCode());
                    if (itemSkuDgRespDto != null) {
                        orderDetailDto.setUnit(itemSkuDgRespDto.getUnit());
                        orderDetailDto.setVolume(itemSkuDgRespDto.getVolume() != null ? itemSkuDgRespDto.getVolume().multiply(new BigDecimal(detailDto.getPlanQuantity())) : BigDecimal.ZERO);
                        orderDetailDto.setWeight(itemSkuDgRespDto.getGrossWeight() != null ? itemSkuDgRespDto.getGrossWeight().multiply(new BigDecimal(detailDto.getPlanQuantity())) : BigDecimal.ZERO);
                    }
                    orderDetailDto.setSkuName(detailDto.getSkuName());
                    BigDecimal planQuantity = detailDtoList.stream().map(o -> new BigDecimal(o.getPlanQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
                    orderDetailDto.setQuantity(planQuantity);
                    orderDetailDto.setVolume(detailDto.getVolume());
                    orderDetailDto.setWeight(detailDto.getWeight());
                    inOtherStorageOrderDetailDtos.add(orderDetailDto);
                });
                inOtherStorageOrderDto.setInOtherStorageOrderDetailDtos(inOtherStorageOrderDetailDtos);
                orderDtoList.add(inOtherStorageOrderDto);
            }
            catch (Exception e) {
                ImportOutOtherOrderModeDto importDto = (ImportOutOtherOrderModeDto)importDtos.get(0);
                this.setErrorMsg(importDto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
            }
        });
    }

    @Nullable
    private boolean businessTypeVerify(Map<String, InOtherStorageBusinessTypeDto> businessGroupMap, Map<String, InOtherStorageBusinessTypeDto> businessTypeMap, ImportOutOtherOrderModeDto dto) {
        Boolean flag = false;
        InOtherStorageBusinessTypeDto typeDto = businessTypeMap.get(dto.getBusinessType());
        if (ObjectUtil.isEmpty((Object)typeDto)) {
            this.setErrorMsg(dto, "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
            return true;
        }
        dto.setType(typeDto.getBusinessTypeCode());
        dto.setBusinessGroup(typeDto.getParentName());
        dto.setBusinessTypeGroup(typeDto.getParentCode());
        return flag;
    }

    private boolean paramVerify(ImportOutOtherOrderModeDto dto, Map<String, List<DgLogicInventoryDto>> warehouseCodeMap, Map<String, DgLogicInventoryDto> skuCodeMap, Map<String, DgLogicInventoryDto> batchMap, Map<String, ItemSkuDgRespDto> itemUnitMap, Map<String, UnitDgRespDto> unitMap, Map<String, DgLogicInventoryDto> skuCodeBatchMap, Map<String, String> customerCodeNameMap, Map<String, AreaExtRespDto> areaMap) {
        List<DgLogicInventoryDto> inventoryDto = warehouseCodeMap.get(dto.getDeliveryLogicWarehouseCode());
        if (CollectionUtil.isEmpty(inventoryDto)) {
            this.setErrorMsg(dto, "\u53d1\u8d27\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
            return true;
        }
        dto.setPhysicsWarehouseCode(inventoryDto.get(0).getPhysicsWarehouseCode());
        dto.setPhysicsWarehouseName(inventoryDto.get(0).getPhysicsWarehouseName());
        dto.setCargoOrganizationCode(inventoryDto.get(0).getOrganizationCode());
        dto.setCargoOrganizationName(inventoryDto.get(0).getOrganizationName());
        if (StringUtils.isBlank((CharSequence)dto.getPlanQuantity())) {
            this.setErrorMsg(dto, "\u8ba1\u5212\u51fa\u5e93\u6570\u91cf\u672a\u586b\u5199");
            return true;
        }
        if (OcsConfig.isUnitConversion() && StringUtils.isBlank((CharSequence)dto.getUnit())) {
            this.setErrorMsg(dto, "\u5355\u4f4d\u672a\u586b\u5199");
            return true;
        }
        boolean skuFlag = false;
        boolean batchFlag = false;
        boolean unitFlag = false;
        for (DgLogicInventoryDto o : inventoryDto) {
            if (!dto.getSkuCode().equals(o.getSkuCode())) continue;
            skuFlag = true;
            dto.setProduceTime(o.getProduceTime());
            dto.setExpireTime(o.getExpireTime());
            dto.setSkuName(o.getSkuName());
            if (!"on".equals(this.UNIT_CONVERSION) || !dto.getUnit().equals(o.getUnit())) continue;
            unitFlag = true;
        }
        if (!skuFlag) {
            this.setErrorMsg(dto, "SKU\u7f16\u7801\u4e0d\u5b58\u5728");
            return true;
        }
        if (OcsConfig.isUnitConversion()) {
            if (!unitFlag) {
                dto.setErrorMsg(dto.getSkuCode() + "\u4e0d\u5b58\u5728\u8be5\u5355\u4f4d\uff1a" + dto.getUnit());
                return true;
            }
            ItemSkuDgRespDto itemSkuDgRespDto = itemUnitMap.get(dto.getSkuCode());
            dto.setVolume(itemSkuDgRespDto.getVolume());
            dto.setWeight(itemSkuDgRespDto.getGrossWeight());
            UnitDgRespDto unitDgRespDto = unitMap.get(dto.getUnit());
            log.info("\u884c\u6821\u9a8c\u5355\u4f4d\u4fe1\u606funit:{}", (Object)dto.getUnit());
            log.info("\u884c\u6821\u9a8c\u5355\u4f4d\u4fe1\u606funitDgRespDto:{}", (Object)JSON.toJSONString((Object)unitDgRespDto));
            if (unitDgRespDto.getDecimalLimit() == 0 && !dto.getPlanQuantity().matches("\\d+")) {
                dto.setErrorMsg("SKU\u7f16\u7801" + dto.getSkuCode() + "\u7684\u8ba1\u5212\u51fa\u5e93\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
                return true;
            }
            if (unitDgRespDto.getDecimalLimit() != 0 && !dto.getPlanQuantity().matches("^\\d+(\\.\\d{1," + unitDgRespDto.getDecimalLimit() + "})?$")) {
                dto.setErrorMsg("SKU\u7f16\u7801" + dto.getSkuCode() + "\u7684\u8ba1\u5212\u51fa\u5e93\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6570\uff0c\u4e14\u5c0f\u6570\u4f4d\u6570\u4e0d\u80fd\u8d85\u8fc7" + unitDgRespDto.getDecimalLimit() + "\u4f4d");
                return true;
            }
        } else if (!dto.getPlanQuantity().matches("\\d+")) {
            this.setErrorMsg(dto, "SKU\u7f16\u7801" + dto.getSkuCode() + "\u7684\u8ba1\u5212\u51fa\u5e93\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)dto.getBizDate())) {
            dto.setBizDate(DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd"));
        } else if (!dto.getBizDate().matches("^\\d{4}(\\-|\\/|\\.)\\d{1,2}\\1\\d{1,2}$")) {
            this.setErrorMsg(dto, "\u4e1a\u52a1\u65e5\u671f\u4e0d\u7b26\u5408\u201cYYYY/MM/DD\u201d\u7684\u683c\u5f0f\uff0c\u8bf7\u8c03\u6574");
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getReceiveCustomerCode())) {
            String cs = customerCodeNameMap.get(dto.getReceiveCustomerCode());
            if (StringUtils.isBlank((CharSequence)cs)) {
                this.setErrorMsg(dto, "\u6536\u8d27\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
                return true;
            }
            dto.setReceiveCustomerName(cs);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProvince()) || StringUtils.isNotBlank((CharSequence)dto.getCity()) || StringUtils.isNotBlank((CharSequence)dto.getArea())) {
            String key = dto.getProvince() + dto.getCity() + dto.getArea();
            AreaExtRespDto areaExtRespDto = areaMap.get(key);
            if (ObjectUtil.isEmpty((Object)areaExtRespDto)) {
                this.setErrorMsg(dto, "\u7701\u5e02\u533a\u7f16\u7801\u4e0d\u5b58\u5728");
                return true;
            }
            dto.setProvinceCode(areaExtRespDto.getProvinceCode());
            dto.setCityCode(areaExtRespDto.getCityCode());
            dto.setAreaCode(areaExtRespDto.getAreaCode());
        }
        return false;
    }

    private String getGroupKey(ImportOutOtherOrderModeDto o) {
        return o.getBusinessType() + o.getDeliveryLogicWarehouseCode() + o.getReceiveCustomerCode();
    }

    private String getGroupDetailKey(ImportOutOtherOrderModeDto o) {
        return o.getSkuCode();
    }

    private String setErrorMsg(ImportOutOtherOrderModeDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }
}

