/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.dto.dto.DictValueDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.req.DgEsPerformOrderReqDto;
import com.yunxi.dg.base.center.openapi.dto.resp.DgEsPerformOrderRespDto;
import com.yunxi.dg.base.center.openapi.dto.resp.DgPerformOrderItemLineRespDto;
import com.yunxi.dg.base.center.openapi.proxy.trade.IDgPerformOrderApiProxy;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterTypeRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterTypeRecordPageReqDto;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterSaleOrderApiProxy;
import com.yunxi.dg.base.center.trade.proxy.aftersale.IDgAfterTypeRecordApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.LitterAmountRefundOrderImportDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_after_litter_amount_refund_order_import")
public class LitterAmountRefundOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(LitterAmountRefundOrderCommonServiceImpl.class);
    @Resource
    private IDgAfterTypeRecordApiProxy dgAfterTypeRecordApiProxy;
    @Resource
    private IDgPerformOrderApiProxy dgPerformOrderApiProxy;
    @Resource
    private IDgAfterSaleOrderApiProxy dgAfterSaleOrderApiProxy;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    public static final String BIZ_MODEL = "FHHTK";

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u552e\u540e\u5c0f\u989d\u9000\u6b3e\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(result));
        List resultList = BeanUtil.copyToList((Collection)result.getList(), LitterAmountRefundOrderImportDto.class);
        if (CollectionUtil.isEmpty((Collection)resultList)) {
            throw new BizException("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (resultList.size() > 1000) {
            throw new BizException("\u6279\u91cf\u5bfc\u5165\u4e0d\u652f\u6301\u8d85\u8fc71000\u884c");
        }
        if (resultList.stream().map(LitterAmountRefundOrderImportDto::getSaleOrderNo).count() > 400L) {
            throw new BizException("\u6279\u91cf\u5bfc\u5165\u5c0f\u989d\u9000\u6b3e\u5355\u4e0d\u652f\u6301\u8d85\u8fc7400\u4e2a");
        }
        ArrayList<LitterAmountRefundOrderImportDto> passList = Lists.newArrayList();
        Map<String, DgAfterTypeRecordDto> afterTypeMap = this.getAfterTypeMap();
        Map<String, String> paymentMethodMap = this.getDict("yunxi-dg-base-center-trade", "after_payment_method_enum");
        Map<String, Map<String, List<DgPerformOrderItemLineRespDto>>> orderInfoMap = this.getOrderInfoMap(resultList);
        log.info("\u5c0f\u989d\u9000\u6b3e\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(orderInfoMap));
        for (LitterAmountRefundOrderImportDto importDto : resultList) {
            boolean isUnPass = this.checkAndInitParam(importDto, afterTypeMap, orderInfoMap, paymentMethodMap);
            if (isUnPass) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
                continue;
            }
            passList.add(importDto);
        }
        Map<String, Map<String, List<LitterAmountRefundOrderImportDto>>> orderMap = passList.stream().collect(Collectors.groupingBy(LitterAmountRefundOrderImportDto::getOrderUniqueKey, Collectors.groupingBy(LitterAmountRefundOrderImportDto::getSkuCode)));
        log.info("\u5c0f\u989d\u9000\u6b3e\u67e5\u8be2\u8ba2\u5355\u4fe1\u606forderMap\uff1a{}", (Object)JSONObject.toJSONString(orderMap));
        passList = new ArrayList<LitterAmountRefundOrderImportDto>();
        for (String orderNos : orderMap.keySet()) {
            Map<String, List<LitterAmountRefundOrderImportDto>> skuCodeMap = orderMap.get(orderNos);
            for (String skuCode : skuCodeMap.keySet()) {
                BigDecimal refundAmount;
                List<LitterAmountRefundOrderImportDto> importDtos = skuCodeMap.get(skuCode);
                BigDecimal surplusCanRefundPayAmount = orderInfoMap.get(importDtos.get(0).getSaleOrderNo()).get(skuCode).stream().map(DgPerformOrderItemLineRespDto::getSurplusCanRefundPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (surplusCanRefundPayAmount.compareTo(refundAmount = importDtos.stream().map(LitterAmountRefundOrderImportDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add)) < 0) {
                    this.setErrorMsg(importDtos.get(0), "\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u53ef\u9000\u91d1\u989d;");
                    respDto.getErrorDetails().add(importDtos.get(0));
                    importDtos.forEach(giftDto -> giftDto.setErrorMsg(((LitterAmountRefundOrderImportDto)importDtos.get(0)).getErrorMsg()));
                    continue;
                }
                passList.addAll(importDtos);
            }
        }
        log.info("\u6253\u5370\u5c0f\u989d\u9000\u6b3e\u67e5\u8be2\u8ba2\u5355\u4fe1\u606fpassList\uff1a{}", (Object)JSONObject.toJSONString(passList));
        respDto.setDetails(passList);
        Collections.sort(respDto.getErrorDetails(), Comparator.comparingInt(ImportBaseModeDto::getRowNum));
        return passList;
    }

    public boolean checkAndInitParam(LitterAmountRefundOrderImportDto importDto, Map<String, DgAfterTypeRecordDto> afterTypeMap, Map<String, Map<String, List<DgPerformOrderItemLineRespDto>>> orderInfoMap, Map<String, String> paymentMethodMap) {
        Map<String, List<DgPerformOrderItemLineRespDto>> sku2DetailListMap;
        StringBuffer errorMsg = new StringBuffer();
        DgAfterTypeRecordDto afterTypeRecordDto = afterTypeMap.get(importDto.getAfterBusinessTypeName());
        if (afterTypeRecordDto == null) {
            errorMsg.append("\u552e\u540e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728\uff1b");
        } else {
            importDto.setIfInvoice(afterTypeRecordDto.getIfInvoice());
            importDto.setIfRecord(afterTypeRecordDto.getIfRecord());
            importDto.setAfterBusinessTypeCode(afterTypeRecordDto.getAfterBusinessTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)importDto.getPaymentMethodStr())) {
            if (paymentMethodMap.containsKey(importDto.getPaymentMethodStr())) {
                importDto.setPaymentMethod(paymentMethodMap.get(importDto.getPaymentMethodStr()));
            } else {
                errorMsg.append("\u552e\u540e\u6536\u6b3e\u65b9\u5f0f\u4e0d\u5b58\u5728\uff1b");
            }
        }
        if (CollUtil.isEmpty(sku2DetailListMap = orderInfoMap.get(importDto.getSaleOrderNo()))) {
            errorMsg.append("\u5185\u90e8\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\uff1b");
        } else if (CollUtil.isEmpty((Collection)sku2DetailListMap.get(importDto.getSkuCode()))) {
            errorMsg.append("\u5185\u90e8\u9500\u552e\u8ba2\u5355sku\u7f16\u7801\u4e0d\u5b58\u5728\uff1b");
        } else {
            List<DgPerformOrderItemLineRespDto> dgPerformOrderItemLineRespDtos = sku2DetailListMap.get(importDto.getSkuCode());
            DgPerformOrderItemLineRespDto respDto = dgPerformOrderItemLineRespDtos.get(0);
            importDto.setSaleOrderId(respDto.getSaleOrderId());
            importDto.setShopCode(respDto.getShopCode());
            importDto.setShopName(respDto.getShopName());
            importDto.setShopId(Long.valueOf(respDto.getShopId()));
            importDto.setHsCustomerCode(respDto.getHsCustomerCode());
            importDto.setHsCustomerName(respDto.getHsCustomerName());
            importDto.setSkuName(respDto.getSkuName());
            importDto.setItemCode(respDto.getItemCode());
            importDto.setItemName(respDto.getItemName());
            importDto.setSaleOrderItemId(respDto.getLineId());
            importDto.setCalcItemNum(respDto.getItemNum());
            importDto.setItemNum(respDto.getItemNum());
            importDto.setOrigItemNum(Integer.valueOf(respDto.getItemNum().intValue()));
            importDto.setRealPayAmount(respDto.getRealPayAmount());
        }
        importDto.setErrorMsg(errorMsg.toString());
        log.info("\u5c0f\u989d\u9000\u6b3e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)errorMsg));
        return errorMsg.length() > 0;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        log.info("\u5c0f\u989d\u9000\u6b3e/\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e-callBackImportFileOperationCommonAsync-->result:{}", (Object)JSON.toJSONString(result));
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        if (!respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        Map<String, List<LitterAmountRefundOrderImportDto>> orderMap = passList.stream().collect(Collectors.groupingBy(LitterAmountRefundOrderImportDto::getOrderUniqueKey));
        for (String orderKey : orderMap.keySet()) {
            List<LitterAmountRefundOrderImportDto> importDtos = this.processSameSkuCode(orderMap.get(orderKey));
            LitterAmountRefundOrderImportDto dto = importDtos.get(0);
            DgBizAfterSaleOrderReqDto reqDto = this.buildDgBizAfterSaleOrderReqDto(importDtos);
            this.saveOrder(respDto, reqDto, dto);
            importDtos.forEach(giftDto -> giftDto.setErrorMsg(dto.getErrorMsg()));
        }
        Collections.sort(respDto.getErrorDetails(), Comparator.comparingInt(ImportBaseModeDto::getRowNum));
        log.info("\u9519\u8bef\u65e5\u5fd7\u6253\u53702\uff1a{}", (Object)JSONObject.toJSONString((Object)respDto.getErrorDetails()));
    }

    private void saveOrder(ImportFileOperationCommonRespDto respDto, DgBizAfterSaleOrderReqDto reqDto, LitterAmountRefundOrderImportDto dto) {
        try {
            log.info("createAfterSale\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            RestResponseHelper.extractData((RestResponse)this.dgAfterSaleOrderApiProxy.createAfterSale(BIZ_MODEL, reqDto));
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u5c0f\u989d\u9000\u6b3e/\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\uff0c\u4fdd\u5b58\u5931\u8d25 {}", (Object)reqDto.getPlatformOrderNo(), (Object)e);
            this.setErrorMsg(dto, "\u5bfc\u5165\u5c0f\u989d\u9000\u6b3e/\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u5355\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            respDto.getErrorDetails().add(dto);
        }
    }

    public DgBizAfterSaleOrderReqDto buildDgBizAfterSaleOrderReqDto(List<LitterAmountRefundOrderImportDto> litterAmountRefundOrderImportDtos) {
        LitterAmountRefundOrderImportDto litterAmountRefundOrderImportDto = litterAmountRefundOrderImportDtos.get(0);
        DgBizAfterSaleOrderReqDto reqDto = new DgBizAfterSaleOrderReqDto();
        BeanUtil.copyProperties((Object)litterAmountRefundOrderImportDto, (Object)reqDto, (String[])new String[0]);
        reqDto.setBizDate(new Date());
        reqDto.setBizType(BIZ_MODEL);
        reqDto.setChannelCode("INNER");
        reqDto.setAfterSaleOrderType(BIZ_MODEL);
        reqDto.setPlatformApplyRefundType("REFUND_RETURN");
        reqDto.setStatus("WAIT_AUDIT");
        reqDto.setRelateToPlatformOrder(Integer.valueOf(1));
        reqDto.setOrderSource(Integer.valueOf(0));
        reqDto.setRefundStatus("1");
        BigDecimal refundFee = BigDecimal.ZERO;
        ArrayList<DgAfterSaleOrderItemModifyReqDto> afterSaleOrderItemReqDtoList = new ArrayList<DgAfterSaleOrderItemModifyReqDto>();
        for (LitterAmountRefundOrderImportDto detail : litterAmountRefundOrderImportDtos) {
            DgAfterSaleOrderItemModifyReqDto modifyReqDto = new DgAfterSaleOrderItemModifyReqDto();
            BeanUtil.copyProperties((Object)detail, (Object)modifyReqDto, (String[])new String[0]);
            modifyReqDto.setAfterSaleOrderItemType(Integer.valueOf(0));
            modifyReqDto.setIsGift(Integer.valueOf(0));
            modifyReqDto.setSaleOrderId(detail.getSaleOrderId());
            refundFee = refundFee.add(detail.getRefundAmount());
            afterSaleOrderItemReqDtoList.add(modifyReqDto);
        }
        reqDto.setRefundFee(refundFee);
        reqDto.setAfterSaleOrderItemReqDtoList(afterSaleOrderItemReqDtoList);
        return reqDto;
    }

    private void setErrorMsg(LitterAmountRefundOrderImportDto dto, String msg) {
        dto.setErrorMsg(StringUtils.isBlank((CharSequence)dto.getErrorMsg()) ? String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef\uff0c%s", dto.getRowNum() + 1, msg) : dto.getErrorMsg() + ";" + msg);
    }

    public List<LitterAmountRefundOrderImportDto> processSameSkuCode(List<LitterAmountRefundOrderImportDto> list) {
        return list.stream().collect(Collectors.toMap(LitterAmountRefundOrderImportDto::getSkuCode, Function.identity(), (o1, o2) -> {
            o1.setRefundAmount(o1.getRefundAmount().add(o2.getRefundAmount()));
            return o1;
        })).values().stream().collect(Collectors.toList());
    }

    private Map<String, String> getDict(String groupCode, String code) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode(groupCode, code));
        if (Objects.isNull(dictDto) || CollectionUtil.isEmpty((Collection)dictDto.getDictValueList())) {
            return MapUtil.empty();
        }
        return dictDto.getDictValueList().stream().collect(Collectors.toMap(DictValueDto::getLabel, DictValueDto::getValue, (v1, v2) -> v2));
    }

    public Map<String, Map<String, List<DgPerformOrderItemLineRespDto>>> getOrderInfoMap(List<LitterAmountRefundOrderImportDto> resultList) {
        int size = 20;
        Set saleOrderNos = resultList.stream().map(LitterAmountRefundOrderImportDto::getSaleOrderNo).collect(Collectors.toSet());
        List orderNoList = CollUtil.split(saleOrderNos, (int)size);
        HashMap<String, Map<String, List<DgPerformOrderItemLineRespDto>>> orderMap = new HashMap<String, Map<String, List<DgPerformOrderItemLineRespDto>>>();
        for (List orders : orderNoList) {
            DgEsPerformOrderReqDto reqDto = new DgEsPerformOrderReqDto();
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(size));
            reqDto.setOrderNos(orders);
            log.info("getOrderInfoMap\u67e5\u8be2\u5355\u636e-\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)orders));
            List list = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.dgPerformOrderApiProxy.queryByDetailPage(reqDto))).getList();
            log.info("getOrderInfoMap\u67e5\u8be2\u5355\u636e-\u6570\u91cf:{}", (Object)(CollectionUtil.isEmpty((Collection)list) ? 0 : list.size()));
            log.info("getOrderInfoMap\u67e5\u8be2\u5355\u636e-\u54cd\u5e94:{}", (Object)JSONObject.toJSONString((Object)list));
            if (CollectionUtil.isEmpty((Collection)list)) {
                return new HashMap<String, Map<String, List<DgPerformOrderItemLineRespDto>>>();
            }
            Map<String, Map<String, List<DgPerformOrderItemLineRespDto>>> groupedByOrderNoAndSkuCode = list.stream().collect(Collectors.groupingBy(DgEsPerformOrderRespDto::getSaleOrderNo, Collectors.groupingBy(DgPerformOrderItemLineRespDto::getSkuCode)));
            orderMap.putAll(groupedByOrderNoAndSkuCode);
        }
        return orderMap;
    }

    private Map<String, DgAfterTypeRecordDto> getAfterTypeMap() {
        DgAfterTypeRecordPageReqDto reqDto = new DgAfterTypeRecordPageReqDto();
        reqDto.setPageSize(Integer.valueOf(1000));
        reqDto.setAfterTypeCode(BIZ_MODEL);
        reqDto.setTypeStatus(Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgAfterTypeRecordApiProxy.page(reqDto));
        if (Objects.isNull(pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return MapUtil.empty();
        }
        return pageInfo.getList().stream().collect(Collectors.toMap(DgAfterTypeRecordDto::getAfterBusinessTypeName, Function.identity(), (v1, v2) -> v2));
    }
}

