/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.enums;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.util.DateConverter;
import java.math.BigDecimal;
import java.util.Date;

public enum BasicDataTypeEnum {
    STRING("String", "java.lang.String"),
    INTEGER("Integer", "java.lang.Integer"),
    BIGDECIMAL("BigDecimal", "java.math.BigDecimal"),
    DATE("Date", "java.util.Date");

    private String type;
    private String className;

    private BasicDataTypeEnum(String type, String className) {
        this.type = type;
        this.className = className;
    }

    public static BasicDataTypeEnum getInstance(String type) {
        for (BasicDataTypeEnum value : BasicDataTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        throw new BizException("\u6570\u636e\u7c7b\u578b\u4e0d\u5b58\u5728");
    }

    public static BasicDataTypeEnum getInstanceOfClassName(String className) {
        for (BasicDataTypeEnum value : BasicDataTypeEnum.values()) {
            if (!value.getClassName().equals(className)) continue;
            return value;
        }
        throw new BizException("\u6570\u636e\u7c7b\u578b\u4e0d\u5b58\u5728");
    }

    public Object getConvertVal(Object value) {
        if (this.equals((Object)STRING)) {
            return this.getConvertValStr(value);
        }
        if (this.equals((Object)DATE)) {
            return this.getConvertValDate(value);
        }
        if (this.equals((Object)BIGDECIMAL)) {
            return this.getConvertValBigDecimal(value);
        }
        if (this.equals((Object)INTEGER)) {
            return this.getConvertValInt(value);
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    private String getConvertValStr(Object value) {
        return value.toString();
    }

    private BigDecimal getConvertValBigDecimal(Object value) {
        return new BigDecimal(value.toString());
    }

    private Date getConvertValDate(Object value) {
        Date convert = new DateConverter().convert(value.toString());
        return convert;
    }

    private Integer getConvertValInt(Object value) {
        return Integer.valueOf(value.toString());
    }
}

