/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.transform.api.query.ITrLogisticsMappingManageQueryApi;
import com.yunxi.dg.base.center.transform.api.query.ITrLogisticsMappingRelationQueryApi;
import com.yunxi.dg.base.center.transform.constants.LogisticsMappingType;
import com.yunxi.dg.base.center.transform.constants.RelevanceOrderTypeEnum;
import com.yunxi.dg.base.center.transform.dto.request.ExportRelationReqDto;
import com.yunxi.dg.base.center.transform.dto.request.TrLogisticsMappingManageReqDto;
import com.yunxi.dg.base.center.transform.dto.response.TrLogisticsMappingRelationRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ExportLogisticsMappingVO;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_logistics_mapping")
public class LogisticsMappingCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsMappingCommonServiceImpl.class);
    @Resource
    protected ITrLogisticsMappingManageQueryApi logisticsMappingManageQueryApi;
    @Resource
    private ITrLogisticsMappingRelationQueryApi logisticsMappingRelationQueryApi;

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        TrLogisticsMappingManageReqDto reqDto = null;
        if (StrUtil.isNotBlank((CharSequence)filter)) {
            reqDto = (TrLogisticsMappingManageReqDto)JSON.parseObject((String)filter, TrLogisticsMappingManageReqDto.class);
        }
        log.info("\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        if (FileModeTypeEnum.LOGISTICS_MAPPING.getKey().equals(key)) {
            List ids = (List)RestResponseHelper.extractData((RestResponse)this.logisticsMappingManageQueryApi.queryByIds(reqDto));
            ExportRelationReqDto relationReqDto = new ExportRelationReqDto();
            relationReqDto.setManageIds(ids);
            Long endId = null;
            ArrayList relationList = Lists.newArrayList();
            while (true) {
                relationReqDto.setEndId(endId);
                List relationRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logisticsMappingRelationQueryApi.exportQuery(relationReqDto));
                if (CollUtil.isEmpty((Collection)relationRespDtos)) break;
                relationList.addAll(relationRespDtos);
                endId = ((TrLogisticsMappingRelationRespDto)relationRespDtos.get(relationRespDtos.size() - 1)).getId();
                log.info("\u5bfc\u51fa\u67e5\u8be2\u5faa\u73af\uff0cendId\uff1a{}", (Object)endId);
            }
            log.info("\u5bfc\u51fa\u67e5\u8be2\u7ed3\u675f\uff0cendId\uff1a{}", endId);
            log.info("\u8df3\u51fa\u5bfc\u51fa\u67e5\u8be2\u5faa\u73af");
            if (CollUtil.isEmpty((Collection)relationList)) {
                return Lists.newArrayList();
            }
            List mappingVOList = relationList.stream().sorted(Comparator.comparing(TrLogisticsMappingRelationRespDto::getManageId).reversed()).map(relationDto -> {
                ExportLogisticsMappingVO mappingVO = new ExportLogisticsMappingVO();
                BeanUtil.copyProperties((Object)relationDto, (Object)mappingVO, (String[])new String[0]);
                String mappingType = relationDto.getMappingType();
                LogisticsMappingType mappingTypeEnum = LogisticsMappingType.getByCode((String)mappingType);
                mappingVO.setMappingType("");
                if (Objects.nonNull(mappingTypeEnum)) {
                    mappingVO.setMappingType(mappingTypeEnum.getName());
                }
                if (LogisticsMappingType.SITE.equalsByCode(mappingType)) {
                    mappingVO.setSiteCode(relationDto.getSystematicCode());
                    mappingVO.setSiteName(relationDto.getSystematicName());
                    mappingVO.setSystematicCode("");
                    mappingVO.setSystematicName("");
                }
                mappingVO.setOrderTypeName(RelevanceOrderTypeEnum.getNameByCode((String)relationDto.getOrderType()));
                return mappingVO;
            }).collect(Collectors.toList());
            for (int i = 0; i < mappingVOList.size(); ++i) {
                ExportLogisticsMappingVO relationRespDto = (ExportLogisticsMappingVO)mappingVOList.get(i);
                relationRespDto.setNumber(Integer.valueOf(i + 1));
            }
            return mappingVOList;
        }
        return Collections.EMPTY_LIST;
    }
}

