/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.dto.entity.CsOrganizationPageQueryDto;
import com.yunxi.dg.base.center.report.dto.entity.CsOrganizationPageRespDto;
import com.yunxi.dg.base.center.report.proxy.customer.IDgOrganizationQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.api.userbiz.IDgOrganizationApi;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.AreaQueryExtReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ChannelQueryReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.DgShopReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgCsChannelRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.api.IDgShopApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IAreaExtQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgCsChannelQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.query.IDgCustomerQueryApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ImportShopTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ShopStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.user.OrganizationDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.AreaDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportOfflineShopDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_offline_shop_import")
public class OfflineShopCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(OfflineShopCommonServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(OfflineShopCommonServiceImpl.class);
    @Resource
    private IDgOrganizationApi dgOrganizationApi;
    @Resource
    private IDgCustomerQueryApiProxy dgCustomerQueryApiProxy;
    @Resource
    private IDgCsChannelQueryApiProxy dgCsChannelQueryApiProxy;
    @Resource
    private IDgOrganizationQueryApiProxy dgOrganizationQueryApiProxy;
    @Resource
    private IDgShopApiProxy dgShopApiProxy;
    @Resource
    private IAreaExtQueryApiProxy areaQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        Map<Object, Object> enterpriseMap;
        Map<Object, Object> channelMap;
        Map<Object, Object> customerMap;
        ArrayList importList = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        this.logger.info("\u8bfb\u53d6\u6570\u91cf===============>{}", (Object)result.getList().size());
        CubeBeanUtils.copyCollection(importList, (Collection)result.getList(), ImportOfflineShopDto.class);
        this.logger.info("\u5bfc\u5165\u6570\u91cf===============>{}", (Object)importList.size());
        ArrayList<ImportOfflineShopDto> passList = new ArrayList<ImportOfflineShopDto>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        List orgList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgOrganizationApi.queryOrgListByCode(importList.stream().map(ImportOfflineShopDto::getSaleOrganizationCode).filter(Objects::nonNull).collect(Collectors.toList())))).orElse(new ArrayList());
        Map<String, OrganizationDto> orgMap = orgList.stream().collect(Collectors.toMap(OrganizationDto::getCode, Function.identity(), (a, b) -> a));
        List customerCode = importList.stream().map(ImportOfflineShopDto::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customerCode)) {
            JSONObject jo = new JSONObject();
            jo.put("codeInList", customerCode);
            List customerList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgCustomerQueryApiProxy.queryByList(JSON.toJSONString((Object)jo)))).orElse(new ArrayList());
            customerMap = customerList.stream().collect(Collectors.toMap(DgCustomerRespDto::getCode, Function.identity(), (a, b) -> a));
        } else {
            customerMap = Maps.newHashMap();
        }
        List channelCodes = importList.stream().map(ImportOfflineShopDto::getChannelCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(channelCodes)) {
            ChannelQueryReqDto channelQueryReqDto = new ChannelQueryReqDto();
            channelQueryReqDto.setCodes(channelCodes);
            List channelList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgCsChannelQueryApiProxy.queryListChannelByCodes(channelQueryReqDto))).orElse(new ArrayList());
            channelMap = channelList.stream().collect(Collectors.toMap(DgCsChannelRespDto::getChannelCode, Function.identity(), (a, b) -> a));
        } else {
            channelMap = Maps.newHashMap();
        }
        List orgIds = orgList.stream().map(OrganizationDto::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgIds)) {
            CsOrganizationPageQueryDto organizationPageQueryDto = new CsOrganizationPageQueryDto();
            organizationPageQueryDto.setIdList(orgIds);
            List channelList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.dgOrganizationQueryApiProxy.querySaleOrgByList(organizationPageQueryDto))).orElse(new ArrayList());
            enterpriseMap = channelList.stream().collect(Collectors.toMap(CsOrganizationPageRespDto::getCode, Function.identity(), (a, b) -> a));
        } else {
            enterpriseMap = Maps.newHashMap();
        }
        Map<Object, Object> areaNameMap = Maps.newHashMap();
        ArrayList areaNameList = Lists.newArrayList();
        for (ImportOfflineShopDto importDto : importList) {
            if (StringUtils.isNotBlank((CharSequence)importDto.getProvinceName())) {
                areaNameList.add(importDto.getProvinceName());
            }
            if (StringUtils.isNotBlank((CharSequence)importDto.getCityName())) {
                areaNameList.add(importDto.getCityName());
            }
            if (!StringUtils.isNotBlank((CharSequence)importDto.getCountyName())) continue;
            areaNameList.add(importDto.getCountyName());
        }
        if (CollectionUtils.isNotEmpty((Collection)areaNameList)) {
            AreaQueryExtReqDto areaQueryExtReqDto = new AreaQueryExtReqDto();
            areaQueryExtReqDto.setNameList((List)areaNameList);
            List areaDtos = (List)RestResponseHelper.extractData((RestResponse)this.areaQueryApiProxy.queryList(areaQueryExtReqDto));
            if (CollectionUtils.isNotEmpty((Collection)areaDtos)) {
                areaNameMap = areaDtos.stream().collect(Collectors.toMap(dto -> dto.getName() + "-" + dto.getParentCode(), Function.identity(), (a, b) -> a));
            }
        }
        for (ImportOfflineShopDto importDto : importList) {
            Boolean verify = this.onlineShopVerify(importDto, orgMap, customerMap, channelMap, enterpriseMap, areaNameMap);
            if (!verify.booleanValue()) {
                importDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
                continue;
            }
            passList.add(importDto);
        }
        respDto.setDetails(passList);
        dataMap.put("passList", passList);
        dataMap.put("orgMap", orgMap);
        dataMap.put("enterpriseMap", enterpriseMap);
        dataMap.put("customerMap", customerMap);
        dataMap.put("channelMap", channelMap);
        dataMap.put("areaNameMap", areaNameMap);
        return dataMap;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        Map dataMap = (Map)object;
        List passList = (List)dataMap.get("passList");
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        Map orgMap = (Map)dataMap.get("orgMap");
        Map enterpriseMap = (Map)dataMap.get("enterpriseMap");
        Map customerMap = (Map)dataMap.get("customerMap");
        Map channelMap = (Map)dataMap.get("channelMap");
        Map areaNameMap = (Map)dataMap.get("areaNameMap");
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList reqDtoList = new ArrayList();
        try {
            passList.forEach(dto -> {
                DgShopReqDto shopReqDto = new DgShopReqDto();
                reqDtoList.add(shopReqDto);
                shopReqDto.setStoreName(dto.getStoreName());
                shopReqDto.setCustomerCode(dto.getCustomerCode());
                shopReqDto.setCustomerName(((DgCustomerRespDto)customerMap.get(dto.getCustomerCode())).getName());
                ImportShopTypeEnum storeTypeEnum = ImportShopTypeEnum.enumOf((String)dto.getStoreType());
                if (storeTypeEnum != null) {
                    shopReqDto.setStoreType(storeTypeEnum.getType());
                }
                shopReqDto.setSaleOrganizationCode(dto.getSaleOrganizationCode());
                shopReqDto.setSaleOrganizationId(((OrganizationDto)orgMap.get(dto.getSaleOrganizationCode())).getId());
                shopReqDto.setSaleOrganizationName(((OrganizationDto)orgMap.get(dto.getSaleOrganizationCode())).getName());
                CsOrganizationPageRespDto csOrganizationPageRespDto = (CsOrganizationPageRespDto)enterpriseMap.get(dto.getSaleOrganizationCode());
                if (csOrganizationPageRespDto != null) {
                    shopReqDto.setSaleCompanyCode(csOrganizationPageRespDto.getEnterpriseCode());
                    shopReqDto.setSaleCompanyId(csOrganizationPageRespDto.getEnterpriseId());
                    shopReqDto.setSaleCompanyName(csOrganizationPageRespDto.getEnterpriseName());
                }
                shopReqDto.setChannelCode(dto.getChannelCode());
                shopReqDto.setChannelId(((DgCsChannelRespDto)channelMap.get(dto.getChannelCode())).getId());
                shopReqDto.setChannelName(((DgCsChannelRespDto)channelMap.get(dto.getChannelCode())).getChannelName());
                if (StringUtils.isNotBlank((CharSequence)dto.getStatus())) {
                    ShopStatusEnum statusEnum = ShopStatusEnum.enumOf((String)dto.getStatus());
                    if (statusEnum != null) {
                        shopReqDto.setStatus(statusEnum.getType());
                    } else {
                        shopReqDto.setStatus(Integer.valueOf(1));
                    }
                } else {
                    shopReqDto.setStatus(Integer.valueOf(1));
                }
                shopReqDto.setLineType(Integer.valueOf(2));
                shopReqDto.setProvinceName(dto.getProvinceName());
                shopReqDto.setCityName(dto.getCityName());
                shopReqDto.setCountyName(dto.getCountyName());
                AreaDto province = (AreaDto)areaNameMap.get(dto.getProvinceName() + "-0");
                AreaDto city = (AreaDto)areaNameMap.get(dto.getCityName() + "-" + province.getCode());
                AreaDto county = (AreaDto)areaNameMap.get(dto.getCountyName() + "-" + city.getCode());
                shopReqDto.setProvinceCode(province.getCode());
                shopReqDto.setCityCode(city.getCode());
                shopReqDto.setCountyCode(county.getCode());
                shopReqDto.setGeo(dto.getLongitude() + "," + dto.getLatitude());
                shopReqDto.setAddress(dto.getAddress());
                shopReqDto.setContactPerson(dto.getContactPerson());
                shopReqDto.setContactEmail(dto.getContactEmail());
                shopReqDto.setContactMobile(dto.getContactMobile());
                shopReqDto.setContactPhone(dto.getContactPhone());
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u7ebf\u4e0b\u95e8\u5e97,\u6570\u91cf\u4e3a:{}", (Object)reqDtoList.size());
        RestResponseHelper.checkOrThrow((RestResponse)this.dgShopApiProxy.addShopBatch(reqDtoList));
    }

    private Boolean onlineShopVerify(ImportOfflineShopDto dto, Map<String, OrganizationDto> orgMap, Map<String, DgCustomerRespDto> customerMap, Map<String, DgCsChannelRespDto> channelMap, Map<String, CsOrganizationPageRespDto> enterpriseMap, Map<String, AreaDto> areaNameMap) {
        if (StringUtils.isBlank((CharSequence)dto.getStoreName())) {
            dto.setErrorMsg("\u95e8\u5e97\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getStoreType())) {
            dto.setErrorMsg("\u95e8\u5e97\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getSaleOrganizationCode())) {
            dto.setErrorMsg("\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getChannelCode())) {
            dto.setErrorMsg("\u6240\u5c5e\u6e20\u9053\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getCustomerCode())) {
            dto.setErrorMsg("\u6240\u5c5e\u5ba2\u6237\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getProvinceName())) {
            dto.setErrorMsg("\u5730\u5740\uff08\u7701\uff09\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getCityName())) {
            dto.setErrorMsg("\u5730\u5740\uff08\u5e02\uff09\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getCountyName())) {
            dto.setErrorMsg("\u5730\u5740\uff08\u533a\uff09\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getAddress())) {
            dto.setErrorMsg("\u8be6\u7ec6\u5730\u5740\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (!orgMap.containsKey(dto.getSaleOrganizationCode())) {
            dto.setErrorMsg("\u672a\u627e\u5230\u9500\u552e\u7ec4\u7ec7\uff1a" + dto.getSaleOrganizationCode());
            return false;
        }
        if (!customerMap.containsKey(dto.getCustomerCode())) {
            dto.setErrorMsg("\u672a\u627e\u5230\u6240\u5c5e\u5ba2\u6237\uff1a" + dto.getCustomerCode());
            return false;
        }
        if (!channelMap.containsKey(dto.getChannelCode())) {
            dto.setErrorMsg("\u672a\u627e\u5230\u6240\u5c5e\u6e20\u9053\uff1a" + dto.getChannelCode());
            return false;
        }
        if (!areaNameMap.containsKey(dto.getProvinceName() + "-0")) {
            dto.setErrorMsg("\u672a\u627e\u5230\u5730\u5740\uff08\u7701\uff09\uff1a" + dto.getProvinceName());
            return false;
        }
        AreaDto province = areaNameMap.get(dto.getProvinceName() + "-0");
        if (!areaNameMap.containsKey(dto.getCityName() + "-" + province.getCode())) {
            dto.setErrorMsg("\u672a\u627e\u5230\u5730\u5740\uff08\u5e02\uff09\uff1a" + dto.getCityName());
            return false;
        }
        AreaDto city = areaNameMap.get(dto.getCityName() + "-" + province.getCode());
        if (!areaNameMap.containsKey(dto.getCountyName() + "-" + city.getCode())) {
            dto.setErrorMsg("\u672a\u627e\u5230\u5730\u5740\uff08\u533a\uff09\uff1a" + dto.getCountyName());
            return false;
        }
        if (ImportShopTypeEnum.enumOf((String)dto.getStoreType()) == null) {
            dto.setErrorMsg("\u95e8\u5e97\u7c7b\u578b\u8bbe\u7f6e\u9519\u8bef\uff1a" + dto.getStoreType());
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getStatus()) && ShopStatusEnum.enumOf((String)dto.getStatus()) == null) {
            dto.setErrorMsg("\u72b6\u6001\u8bbe\u7f6e\u9519\u8bef\uff1a" + dto.getStatus());
            return false;
        }
        return true;
    }
}

