/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.IUnitDgApi;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.unit.IUnitDgQueryApi;
import com.yunxi.dg.base.mgmt.service.utils.IsNumberUtils;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.UnitDgReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.UnitImportDgReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportUnitModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_unit_import")
public class UnitCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(UnitCommonServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(UnitCommonServiceImpl.class);
    @Resource
    private IUnitDgApi unitDgApi;
    @Resource
    private IUnitDgQueryApi unitDgQueryApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        this.logger.info("\u8bfb\u53d6\u6570\u91cf===============>{}", (Object)result.getList().size());
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportUnitModeDto.class);
        this.logger.info("\u5bfc\u5165\u6570\u91cf===============>{}", (Object)list.size());
        ArrayList<ImportUnitModeDto> passList = new ArrayList<ImportUnitModeDto>();
        for (ImportUnitModeDto dto : list) {
            Boolean verify = this.unitVerify(dto, passList);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        log.info("\u4e0a\u4e0b\u6587userCode:{}", (Object)commonReqDto.getCreatePerson());
        ArrayList unitDgReqDtos = Lists.newArrayList();
        try {
            for (ImportUnitModeDto unitModeDto : passList) {
                UnitDgReqDto dto = new UnitDgReqDto();
                dto.setCode(unitModeDto.getUnitCode());
                dto.setRemark(unitModeDto.getRemark());
                if (Objects.nonNull(unitModeDto.getDecimalLimit())) {
                    dto.setDecimalLimit(Integer.valueOf(unitModeDto.getDecimalLimit()));
                }
                dto.setName(unitModeDto.getUnitName());
                dto.setCreatePerson(commonReqDto.getCreatePerson());
                dto.setUpdatePerson(commonReqDto.getCreatePerson());
                unitDgReqDtos.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u5355\u4f4d,\u6570\u91cf\u4e3a:{}", (Object)unitDgReqDtos.size());
        UnitImportDgReqDto unitImportDgReqDto = new UnitImportDgReqDto();
        unitImportDgReqDto.setUnitDgReqDtos((List)unitDgReqDtos);
        this.unitDgApi.importInsertBatch(unitImportDgReqDto);
    }

    private Boolean unitVerify(ImportUnitModeDto dto, List<ImportUnitModeDto> passList) {
        List codes = passList.stream().map(ImportUnitModeDto::getUnitCode).collect(Collectors.toList());
        if (StringUtils.isBlank((CharSequence)dto.getUnitCode())) {
            dto.setErrorMsg("\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (dto.getUnitCode().length() > 50) {
            dto.setErrorMsg("\u7f16\u7801\u4e0d\u53ef\u8d85\u8fc750\u4e2a\u5b57");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dto.getUnitName())) {
            dto.setErrorMsg("\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (dto.getUnitName().length() > 50) {
            dto.setErrorMsg("\u540d\u79f0\u4e0d\u53ef\u8d85\u8fc750\u4e2a\u5b57");
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDecimalLimit()) && Integer.valueOf(dto.getDecimalLimit()) > 10) {
            dto.setErrorMsg("\u5c0f\u6570\u70b9\u4f4d\u6570\u9650\u5236\u4e0d\u53ef\u8d85\u8fc710\u4f4d");
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRemark()) && dto.getRemark().length() > 100) {
            dto.setErrorMsg("\u5907\u6ce8\u4e0d\u53ef\u8d85\u8fc7100\u4e2a\u5b57");
            return false;
        }
        if (codes.contains(dto.getUnitCode())) {
            dto.setErrorMsg("\u7f16\u7801\u5df2\u6dfb\u52a0\u81f3\u5217\u8868");
            return false;
        }
        if (Objects.nonNull(dto.getDecimalLimit()) && !IsNumberUtils.isNumber(dto.getDecimalLimit())) {
            dto.setErrorMsg("\u5c0f\u6570\u70b9\u4f4d\u9650\u5236\u4e0d\u662f\u6570\u5b57");
            return false;
        }
        return true;
    }
}

