/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.util.DateUtil;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.reconciliationbiz.IChannelBillApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.ChannelEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportDyBillDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ChannelBillDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_dy_bill_import")
public class DouyinBillCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(DouyinBillCommonServiceImpl.class);
    private static final BigDecimal a = new BigDecimal("100");
    @Resource
    protected IChannelBillApiProxy channelBillApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportDyBillDto.class);
        ArrayList<ImportDyBillDto> passList = new ArrayList<ImportDyBillDto>();
        for (ImportDyBillDto dto : list) {
            Boolean billVerify;
            if (StringUtils.isNotBlank((CharSequence)dto.getSubOrderNo())) {
                dto.setSubOrderNo(StringUtils.replace((String)dto.getSubOrderNo(), (String)"`", (String)""));
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getOrderNo())) {
                dto.setOrderNo(StringUtils.replace((String)dto.getOrderNo(), (String)"`", (String)""));
            }
            if (!(billVerify = this.jdBillVerify(dto)).booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        ArrayList channelBillDtos = Lists.newArrayList();
        try {
            for (ImportDyBillDto douyinBillDto : passList) {
                if (null != douyinBillDto.getExcelOrderTime()) {
                    douyinBillDto.setOrderTime(DateUtil.format((Date)douyinBillDto.getExcelOrderTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                douyinBillDto.setBillingTime(DateUtil.format((Date)douyinBillDto.getExcelBillingTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                ChannelBillDto dto = new ChannelBillDto();
                dto.setChannelCode(ChannelEnum.DY.getCode());
                dto.setChannelName(ChannelEnum.DY.getName());
                dto.setSerialNo(douyinBillDto.getOrderNo());
                dto.setPlatformSerialNo(douyinBillDto.getSerialNumber());
                dto.setUniqueSerialNo(douyinBillDto.getSerialNumber());
                dto.setProduceDate(douyinBillDto.getExcelBillingTime());
                dto.setData(JSON.toJSONString((Object)douyinBillDto));
                this.setCreatePerson(commonReqDto, dto);
                channelBillDtos.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6279\u91cf\u4fdd\u5b58\u6296\u97f3\u539f\u59cb\u8d26\u5355,\u6570\u91cf\u4e3a:{}", (Object)channelBillDtos.size());
        this.channelBillApi.importInsertBatch((List)channelBillDtos);
    }

    private BigDecimal amountTransfor(String amount) {
        BigDecimal resultAmount = BigDecimal.ZERO;
        resultAmount = new BigDecimal(amount).divide(a, 2, 1);
        return resultAmount;
    }

    private Boolean jdBillVerify(ImportDyBillDto dto) {
        return true;
    }

    protected void setCreatePerson(ImportFileOperationCommonReqDto commonReqDto, ChannelBillDto dto) {
        dto.setCreatePerson(commonReqDto.getCreatePerson());
        dto.setUpdatePerson(commonReqDto.getCreatePerson());
    }
}

