/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryPageReqDto;
import com.yunxi.dg.base.center.inventory.proxy.entity.IInLogicInventoryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.request.WmsInventoryQueryDto;
import com.yunxi.dg.base.center.openapi.dto.request.WmsInventoryQueryReqDto;
import com.yunxi.dg.base.center.openapi.dto.response.ClientDto;
import com.yunxi.dg.base.center.openapi.dto.response.Item;
import com.yunxi.dg.base.center.openapi.dto.response.WmsInventoryQueryRespDto;
import com.yunxi.dg.base.center.openapi.proxy.wms.IExternalWmsApiProxy;
import com.yunxi.dg.base.center.report.dto.entity.WmsBalanceReportDto;
import com.yunxi.dg.base.center.report.dto.entity.WmsBalanceReportPageReqDto;
import com.yunxi.dg.base.center.report.proxy.entity.IWmsBalanceReportApiProxy;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.mgmt.service.IOcsWmsBalanceReportService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IOcsWmsBalanceReportServiceImpl
implements IOcsWmsBalanceReportService {
    private static final Logger log = LoggerFactory.getLogger(IOcsWmsBalanceReportServiceImpl.class);
    @Autowired
    private IInLogicInventoryApiProxy iInLogicInventoryApiProxy;
    @Autowired
    private IExternalWmsApiProxy iExternalWmsApiProxy;
    @Autowired
    private IWmsBalanceReportApiProxy iWmsBalanceReportApiProxy;

    @Override
    public void generateTask(String time) {
        log.info("\u62c9\u53d6wms\u5e93\u5b58\u4efb\u52a1\u5f00\u59cb");
        if (StringUtils.isEmpty((String)time)) {
            time = DateUtil.formatDate((Date)new Date());
        }
        String statisticsTime = time;
        List logicInventoryDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iInLogicInventoryApiProxy.queryThirdWarehouse(new LogicInventoryPageReqDto()));
        if (CollectionUtil.isEmpty((Collection)logicInventoryDtoList)) {
            return;
        }
        Map<String, List<LogicInventoryDto>> customerIdMap = logicInventoryDtoList.stream().collect(Collectors.groupingBy(LogicInventoryDto::getCustomerId));
        ArrayList reportDtoList = Lists.newArrayList();
        for (String key : customerIdMap.keySet()) {
            List<LogicInventoryDto> logicInventoryDtos = customerIdMap.get(key);
            WmsInventoryQueryReqDto wmsInventoryQueryReqDto = new WmsInventoryQueryReqDto();
            wmsInventoryQueryReqDto.setCustomerId(key);
            ArrayList wmsInventoryQueryDtoList = Lists.newArrayList();
            for (LogicInventoryDto logicInventoryDto : logicInventoryDtos) {
                WmsInventoryQueryDto wmsInventoryQueryDto = new WmsInventoryQueryDto();
                wmsInventoryQueryDto.setItemCode(logicInventoryDto.getSkuCode());
                wmsInventoryQueryDto.setWarehouseCode(logicInventoryDto.getPhysicsWarehouseCode());
                wmsInventoryQueryDtoList.add(wmsInventoryQueryDto);
            }
            wmsInventoryQueryReqDto.setWmsInventoryQueryDtoList((List)wmsInventoryQueryDtoList);
            ClientDto respDtoClientDto = (ClientDto)RestResponseHelper.extractData((RestResponse)this.iExternalWmsApiProxy.inventoryQuery(wmsInventoryQueryReqDto));
            log.info("\u67e5\u8be2\u5230wms\u5e93\u5b58\u6570\u636e:{}", (Object)LogUtils.buildLogContent((Object)respDtoClientDto.getClientResp()));
            WmsInventoryQueryRespDto respDto = (WmsInventoryQueryRespDto)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)respDtoClientDto.getClientResp()), WmsInventoryQueryRespDto.class);
            if (CollectionUtil.isEmpty((Collection)respDto.getItems())) continue;
            log.info("\u67e5\u8be2\u5230wms\u5e93\u5b58\u8fd4\u56de\u591a\u5c11\u6761\u6570\u636e:{}", (Object)respDto.getItems().size());
            List respDtoItems = respDto.getItems();
            for (Item dtoItem : respDtoItems) {
                WmsBalanceReportDto wmsBalanceReportDto = new WmsBalanceReportDto();
                wmsBalanceReportDto.setBatch(dtoItem.getBatchCode());
                wmsBalanceReportDto.setSkuCode(dtoItem.getItemCode());
                wmsBalanceReportDto.setPhysicsWarehouseCode(dtoItem.getWarehouseCode());
                wmsBalanceReportDto.setQuantity(BigDecimalUtils.parse((String)String.valueOf(dtoItem.getQuantity())));
                if (StringUtils.isNotBlank((String)dtoItem.getExpireDate())) {
                    wmsBalanceReportDto.setExpireDate((Date)DateUtil.parseDate((CharSequence)dtoItem.getExpireDate()));
                }
                if (StringUtils.isNotBlank((String)dtoItem.getProductDate())) {
                    wmsBalanceReportDto.setProductDate((Date)DateUtil.parseDate((CharSequence)dtoItem.getProductDate()));
                }
                wmsBalanceReportDto.setStatisticsTime(statisticsTime);
                reportDtoList.add(wmsBalanceReportDto);
            }
        }
        this.iWmsBalanceReportApiProxy.batchAdd((List)reportDtoList);
    }

    @Override
    public PageInfo<WmsBalanceReportDto> queryByPage(WmsBalanceReportPageReqDto dto) {
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.iWmsBalanceReportApiProxy.queryByPage(dto));
    }
}

