/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yundt.boot.center.data.dto.dto.DictDto;
import com.yundt.boot.center.data.dto.dto.DictValueDto;
import com.yundt.boot.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.other.IInOtherStorageOrderApiProxy;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageBusinessTypeDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageBusinessTypePageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageOrderDetailDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.InOtherStorageOrderDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.request.UnitDgReqDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.inventory.IDgLogicInventoryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.order.IInOtherStorageBusinessTypeApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.unit.IUnitDgQueryApiProxy;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.mgmt.service.context.OcsConfig;
import com.yunxi.dg.base.ocs.mgmt.application.dto.entity.ItemUnitConversionDgDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportInOtherOrderModeDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_in_other_storage")
public class InOtherStorageOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(InOtherStorageOrderCommonServiceImpl.class);
    @Resource
    private IDgLogicInventoryApiProxy dgLogicInventoryApiProxy;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IUnitDgQueryApiProxy unitDgQueryApiProxy;
    @Resource
    private IInOtherStorageBusinessTypeApiProxy iInOtherStorageBusinessTypeApiProxy;
    @Resource
    private ILogicWarehouseApiProxy iLogicWarehouseApiProxy;
    @Resource
    private IInOtherStorageOrderApiProxy inOtherStorageOrderApiProxy;
    @Resource
    private IUnitDgQueryApiProxy iUnitDgQueryApiProxy;
    @Resource
    private IDictQueryApiProxy iDictQueryApiProxy;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        log.info("\u5f00\u59cb\u5bfc\u5165\u5176\u4ed6\u5165\u5e93\u5355");
        ArrayList<ImportInOtherOrderModeDto> passList = new ArrayList<ImportInOtherOrderModeDto>();
        List resultList = BeanUtil.copyToList((Collection)result.getList(), ImportInOtherOrderModeDto.class);
        log.info("\u5f00\u59cb\u5bfc\u5165\u5176\u4ed6\u5165\u5e93\u5355\uff0c\u5176\u4ed6\u5165\u5e93\u5355\u6570\u636e:{}", (Object)JSON.toJSONString((Object)resultList));
        UnitDgReqDto unitDgReqDto = new UnitDgReqDto();
        List unitDgRespDtos = Optional.ofNullable(this.iUnitDgQueryApiProxy.queryList(unitDgReqDto).getData()).orElse(new ArrayList());
        Map<String, String> unitNameMap = unitDgRespDtos.stream().collect(Collectors.toMap(UnitDgRespDto::getName, UnitDgRespDto::getCode, (o, o1) -> o));
        for (ImportInOtherOrderModeDto importInOtherOrderModeDto : resultList) {
            if (!unitNameMap.containsKey(importInOtherOrderModeDto.getUnit())) continue;
            importInOtherOrderModeDto.setUnit(unitNameMap.get(importInOtherOrderModeDto.getUnit()));
        }
        List skuCodes = resultList.stream().map(ImportInOtherOrderModeDto::getSkuCode).collect(Collectors.toList());
        List warehouseCodes = resultList.stream().map(ImportInOtherOrderModeDto::getReceiveLogicWarehouseCode).collect(Collectors.toList());
        LogicWarehousePageReqDto reqDto = new LogicWarehousePageReqDto();
        reqDto.setWarehouseCodeList(warehouseCodes);
        List dgLogicInventoryDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iLogicWarehouseApiProxy.queryList(reqDto))).orElse(new ArrayList());
        ItemQueryDgReqDto itemReqDto = new ItemQueryDgReqDto();
        itemReqDto.setSkuCodes(skuCodes);
        List dgItemSkuDetailRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.querySkuList(itemReqDto))).orElse(new ArrayList());
        List unitRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.unitDgQueryApiProxy.queryList(new UnitDgReqDto()))).orElse(new ArrayList());
        InOtherStorageBusinessTypePageReqDto inOtherStorageBusinessTypePageReqDto = new InOtherStorageBusinessTypePageReqDto();
        inOtherStorageBusinessTypePageReqDto.setStatus(YesNoEnum.YES.getValue());
        inOtherStorageBusinessTypePageReqDto.setType("other_in");
        inOtherStorageBusinessTypePageReqDto.setPageNum(Integer.valueOf(1));
        inOtherStorageBusinessTypePageReqDto.setPageSize(Integer.valueOf(1000));
        List inOtherStorageBusinessTypeDtoList = Optional.ofNullable(((PageInfo)this.iInOtherStorageBusinessTypeApiProxy.page(inOtherStorageBusinessTypePageReqDto).getData()).getList()).orElse(new ArrayList());
        Map<String, InOtherStorageBusinessTypeDto> businessGroupMap = inOtherStorageBusinessTypeDtoList.stream().filter(r -> r.getParentCode().equals("0")).collect(Collectors.toMap(InOtherStorageBusinessTypeDto::getBusinessTypeName, Function.identity(), (o, o1) -> o));
        Map<String, InOtherStorageBusinessTypeDto> businessTypeMap = inOtherStorageBusinessTypeDtoList.stream().filter(r -> !r.getParentCode().equals("0")).collect(Collectors.toMap(InOtherStorageBusinessTypeDto::getBusinessTypeName, Function.identity(), (o, o1) -> o));
        Map<String, LogicWarehouseRespDto> warehouseCodeMap = dgLogicInventoryDtos.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        Map<String, DgItemSkuDetailRespDto> skuCodeMap = dgItemSkuDetailRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        Map<String, DgItemSkuDetailRespDto> itemUnitMap = dgItemSkuDetailRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        Map<String, UnitDgRespDto> unitMap = unitRespDtos.stream().collect(Collectors.toMap(UnitDgRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        log.info("unitMap\u5355\u4f4d\u4fe1\u606f\u5206\u7ec4:{}", (Object)JSON.toJSONString(unitMap));
        log.info("skuCodeMap\u5546\u54c1\u4fe1\u606f\u5206\u7ec4:{}", (Object)JSON.toJSONString(skuCodeMap));
        log.info("itemUnitMap\u5546\u54c1\u5355\u4f4d\u4fe1\u606f\u5206\u7ec4:{}", (Object)JSON.toJSONString(itemUnitMap));
        log.info("inOtherStorageBusinessTypeDtoList\u5176\u4ed6\u51fa\u5165\u5355\u4e1a\u52a1\u7c7b\u578b\u8868\u6570\u636e:{}", (Object)JSON.toJSONString((Object)inOtherStorageBusinessTypeDtoList));
        log.info("\u4e1a\u52a1\u5206\u7ec4businessGroupMap\u6570\u636e:{}", (Object)JSON.toJSONString(businessGroupMap));
        log.info("\u4e1a\u52a1\u7c7b\u578b\u5206\u7ec4\u6570\u636ebusinessTypeMap:{}", (Object)JSON.toJSONString(businessTypeMap));
        for (ImportInOtherOrderModeDto dto : resultList) {
            boolean businessTypePass = this.businessTypeVerify(businessGroupMap, businessTypeMap, dto);
            boolean isPass = this.paramVerify(dto, warehouseCodeMap, skuCodeMap, itemUnitMap, unitMap);
            if (isPass || businessTypePass) {
                this.setErrorMsg(dto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    @Nullable
    private boolean businessTypeVerify(Map<String, InOtherStorageBusinessTypeDto> businessGroupMap, Map<String, InOtherStorageBusinessTypeDto> businessTypeMap, ImportInOtherOrderModeDto dto) {
        Boolean flag = false;
        InOtherStorageBusinessTypeDto typeDto = businessTypeMap.get(dto.getBusinessType());
        if (ObjectUtil.isEmpty((Object)typeDto)) {
            this.setErrorMsg(dto, "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
            flag = true;
        } else {
            dto.setType(typeDto.getBusinessTypeCode());
            dto.setBusinessGroup(typeDto.getParentName());
            dto.setBusinessTypeGroup(typeDto.getParentCode());
        }
        return flag;
    }

    public void callBackImportFileOperationCommonAsync(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object object) {
        List passList = (List)object;
        if (CollectionUtil.isEmpty((Collection)passList)) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            return;
        }
        respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
        if (CollectionUtil.isNotEmpty((Collection)passList) && !respDto.getErrorDetails().isEmpty()) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_PARTIAL_SUCCESS.getCode());
        }
        try {
            ArrayList<InOtherStorageOrderDto> orderDtoList = new ArrayList<InOtherStorageOrderDto>();
            this.assembleDtos(orderDtoList, passList, respDto, commonReqDto);
            for (InOtherStorageOrderDto inOtherStorageOrderDto : orderDtoList) {
                this.inOtherStorageOrderApiProxy.addOtherStorageOrder(inOtherStorageOrderDto);
            }
        }
        catch (Exception e) {
            log.info("\u5bfc\u5165\u5176\u4ed6\u51fa\u5e93\u5355\u5931\u8d25", (Throwable)e);
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            respDto.setErrorMsg(e.getMessage());
        }
    }

    private void assembleDtos(List<InOtherStorageOrderDto> orderDtoList, List<ImportInOtherOrderModeDto> passList, ImportFileOperationCommonRespDto respDto, ImportFileOperationCommonReqDto commonReqDto) {
        Map<String, List<ImportInOtherOrderModeDto>> passMap = passList.stream().collect(Collectors.groupingBy(r -> this.getGroupKey((ImportInOtherOrderModeDto)r)));
        log.info("\u5bfc\u5165\u5176\u4ed6\u5165\u5e93\u5355\u5206\u7ec4\u540epassMap:{}", (Object)JSON.toJSONString(passMap));
        passMap.forEach((key, importDtos) -> {
            try {
                InOtherStorageOrderDto inOtherStorageOrderDto = new InOtherStorageOrderDto();
                ArrayList inOtherStorageOrderDetailDtos = new ArrayList();
                ImportInOtherOrderModeDto importDto = (ImportInOtherOrderModeDto)importDtos.get(0);
                BeanUtil.copyProperties((Object)importDto, (Object)inOtherStorageOrderDto, (String[])new String[0]);
                inOtherStorageOrderDto.setType("other_in");
                inOtherStorageOrderDto.setWarehouseCode(importDto.getReceiveLogicWarehouseCode());
                inOtherStorageOrderDto.setWarehouseName(importDto.getReceiveLogicWarehouseName());
                inOtherStorageOrderDto.setBusinessTypeGroup(importDto.getBusinessTypeGroup());
                inOtherStorageOrderDto.setBusinessTypeGroupName(importDto.getBusinessGroup());
                inOtherStorageOrderDto.setBusinessTypeName(importDto.getBusinessType());
                inOtherStorageOrderDto.setBusinessType(importDto.getType());
                inOtherStorageOrderDto.setPhysicsWarehouseCode(importDto.getPhysicsWarehouseCode());
                inOtherStorageOrderDto.setPhysicsWarehouseName(importDto.getPhysicsWarehouseName());
                inOtherStorageOrderDto.setCargoOrganizationCode(importDto.getCargoOrganizationCode());
                inOtherStorageOrderDto.setCargoOrganizationName(importDto.getCargoOrganizationName());
                inOtherStorageOrderDto.setCommitType("SAVE");
                inOtherStorageOrderDto.setRemark(importDto.getRemark());
                inOtherStorageOrderDto.setBizDate((Date)DateUtil.parse((CharSequence)(importDto.getBizDate() + " 00:00:00"), (String)"yyyy/MM/dd HH:mm:ss"));
                JSONObject extensionJson = new JSONObject();
                String whDepartmentCode = importDto.getWhDepartmentCode();
                extensionJson.put("whDepartmentCode", (Object)whDepartmentCode);
                String whDepartmentName = importDto.getWhDepartmentName();
                if (StringUtils.isEmpty((CharSequence)whDepartmentName)) {
                    List dictDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iDictQueryApiProxy.queryByPage(Integer.valueOf(1), Integer.valueOf(1), "{'code':'U9_DEPARTMENT_MISCRCVTRANS'}"))).getList();
                    if (CollectionUtil.isEmpty((Collection)dictDtoList)) {
                        throw new BizException(String.format("\u6240\u5c5e\u90e8\u95e8\u7f16\u7801\u3010%s\u3011\u4e0d\u5b58\u5728", whDepartmentCode));
                    }
                    DictValueDto dictValueDto = Optional.ofNullable(((DictDto)dictDtoList.get(0)).getDictValueList()).orElse(Lists.newArrayList()).stream().filter(d -> d.getValue() != null && d.getValue().equals(whDepartmentCode)).findFirst().orElse(null);
                    extensionJson.put("whDepartmentName", (Object)(dictValueDto != null ? dictValueDto.getLabel() : ""));
                } else {
                    extensionJson.put("whDepartmentName", (Object)whDepartmentName);
                }
                inOtherStorageOrderDto.setExtension(JSONObject.toJSONString((Object)extensionJson));
                Map<String, List<ImportInOtherOrderModeDto>> detailMap = importDtos.stream().collect(Collectors.groupingBy(ImportInOtherOrderModeDto::getSkuCode));
                log.info("\u5bfc\u5165\u5176\u4ed6\u5165\u5e93\u5355\u660e\u7ec6\u5206\u7ec4detailMap:{}", (Object)JSON.toJSONString(detailMap));
                List itemSkuDgRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryBySkuCode((List)Lists.newArrayList(detailMap.keySet())));
                Map skuMap = Optional.of(itemSkuDgRespDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (a, b) -> b));
                detailMap.forEach((detailKey, detailDtoList) -> {
                    InOtherStorageOrderDetailDto orderDetailDto = new InOtherStorageOrderDetailDto();
                    ImportInOtherOrderModeDto detailDto = (ImportInOtherOrderModeDto)detailDtoList.get(0);
                    orderDetailDto.setSkuCode(detailDto.getSkuCode());
                    orderDetailDto.setUnit(detailDto.getUnit());
                    ItemSkuDgRespDto itemSkuDgRespDto = (ItemSkuDgRespDto)skuMap.get(detailDto.getSkuCode());
                    if (itemSkuDgRespDto != null) {
                        orderDetailDto.setUnit(itemSkuDgRespDto.getUnit());
                        orderDetailDto.setVolume(itemSkuDgRespDto.getVolume() != null ? itemSkuDgRespDto.getVolume().multiply(new BigDecimal(detailDto.getPlanQuantity())) : BigDecimal.ZERO);
                        orderDetailDto.setWeight(itemSkuDgRespDto.getGrossWeight() != null ? itemSkuDgRespDto.getGrossWeight().multiply(new BigDecimal(detailDto.getPlanQuantity())) : BigDecimal.ZERO);
                    }
                    orderDetailDto.setSkuName(detailDto.getSkuName());
                    BigDecimal planQuantity = detailDtoList.stream().map(o -> new BigDecimal(o.getPlanQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
                    orderDetailDto.setQuantity(planQuantity);
                    inOtherStorageOrderDetailDtos.add(orderDetailDto);
                });
                inOtherStorageOrderDto.setInOtherStorageOrderDetailDtos(inOtherStorageOrderDetailDtos);
                orderDtoList.add(inOtherStorageOrderDto);
            }
            catch (Exception e) {
                ImportInOtherOrderModeDto importDto = (ImportInOtherOrderModeDto)importDtos.get(0);
                this.setErrorMsg(importDto, String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", importDto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), importDto.getErrorMsg()));
                respDto.getErrorDetails().add(importDto);
            }
        });
    }

    private boolean paramVerify(ImportInOtherOrderModeDto dto, Map<String, LogicWarehouseRespDto> warehouseCodeMap, Map<String, DgItemSkuDetailRespDto> skuCodeMap, Map<String, DgItemSkuDetailRespDto> itemUnitMap, Map<String, UnitDgRespDto> unitMap) {
        DgItemSkuDetailRespDto itemSkuRespDto;
        boolean flag = false;
        DgItemSkuDetailRespDto dgItemSkuDetailRespDto = skuCodeMap.get(dto.getSkuCode());
        if (ObjectUtil.isEmpty((Object)dgItemSkuDetailRespDto)) {
            this.setErrorMsg(dto, "SKU\u7f16\u7801\u4e0d\u5b58\u5728");
            flag = true;
        } else {
            dto.setSkuName(dgItemSkuDetailRespDto.getSkuName());
        }
        LogicWarehouseRespDto inventoryDto = warehouseCodeMap.get(dto.getReceiveLogicWarehouseCode());
        if (ObjectUtil.isEmpty((Object)inventoryDto)) {
            this.setErrorMsg(dto, "\u903b\u8f91\u4ed3\u5e93\u4e0d\u5b58\u5728");
            flag = true;
        } else {
            dto.setPhysicsWarehouseCode(inventoryDto.getPhysicsWarehouseCode());
            dto.setPhysicsWarehouseName(inventoryDto.getPhysicsWarehouseName());
            dto.setCargoOrganizationCode(inventoryDto.getOrganizationCode());
            dto.setCargoOrganizationName(inventoryDto.getOrganizationName());
        }
        if (!dto.getPlanQuantity().matches("^(([0-9]+\\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\\.[0-9]+)|([0-9]*[1-9][0-9]*))$")) {
            this.setErrorMsg(dto, "\u8c03\u6574\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6570");
            flag = true;
        }
        if (StringUtils.isBlank((CharSequence)dto.getUnit())) {
            itemSkuRespDto = Optional.ofNullable(itemUnitMap.get(dto.getSkuCode())).orElse(new DgItemSkuDetailRespDto());
            dto.setUnit(itemSkuRespDto.getUnit());
        }
        if (OcsConfig.isUnitConversion()) {
            if (StringUtils.isBlank((CharSequence)dto.getUnit())) {
                itemSkuRespDto = Optional.ofNullable(itemUnitMap.get(dto.getSkuCode())).orElse(new DgItemSkuDetailRespDto());
                dto.setUnit(itemSkuRespDto.getUnit());
            } else {
                DgItemSkuDetailRespDto itemSkuDetailRespDto = itemUnitMap.get(dto.getSkuCode());
                boolean unitFlag = false;
                for (ItemUnitConversionDgDto unitConversionDgDto : (List)Optional.ofNullable(itemSkuDetailRespDto.getUnitConvertList()).orElse(new ArrayList())) {
                    if (!Objects.equals(unitConversionDgDto.getConversionUnit(), dto.getUnit())) continue;
                    unitFlag = true;
                    log.info("\u5355\u4f4d\u4fe1\u606f:{}", (Object)dto.getUnit());
                    log.info("\u6821\u9a8c\u5355\u4f4d\u4fe1\u606f:{}", (Object)unitConversionDgDto.getConversionUnit());
                    break;
                }
                log.info("unitFlag:{}", (Object)unitFlag);
                if (!unitFlag) {
                    dto.setErrorMsg(dto.getSkuCode() + "\u4e0d\u5b58\u5728\u8be5\u5355\u4f4d\uff1a" + dto.getUnit());
                    return true;
                }
                UnitDgRespDto unitDgRespDto = unitMap.get(dto.getUnit());
                if (unitDgRespDto.getDecimalLimit() == 0 && !dto.getPlanQuantity().matches("\\d+")) {
                    dto.setErrorMsg("SKU\u7f16\u7801" + dto.getSkuCode() + "\u7684\u8ba1\u5212\u5165\u5e93\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
                    return true;
                }
                if (unitDgRespDto.getDecimalLimit() != 0 && !dto.getPlanQuantity().matches("^\\d+(\\.\\d{1," + unitDgRespDto.getDecimalLimit() + "})?$")) {
                    dto.setErrorMsg("SKU\u7f16\u7801" + dto.getSkuCode() + "\u7684\u8ba1\u5212\u5165\u5e93\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6570\uff0c\u4e14\u5c0f\u6570\u4f4d\u6570\u4e0d\u80fd\u8d85\u8fc7" + unitDgRespDto.getDecimalLimit() + "\u4f4d");
                    return true;
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)dto.getBizDate())) {
            dto.setBizDate(DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd"));
        } else if (!dto.getBizDate().matches("^\\d{4}(\\-|\\/|\\.)\\d{1,2}\\1\\d{1,2}$")) {
            log.info("dto.getBizDate:{}", (Object)dto.getBizDate());
            this.setErrorMsg(dto, "\u4e1a\u52a1\u65e5\u671f\u4e0d\u7b26\u5408\u201cYYYY/MM/DD\u201d\u7684\u683c\u5f0f\uff0c\u8bf7\u8c03\u6574");
            flag = true;
        }
        return flag;
    }

    private String getGroupKey(ImportInOtherOrderModeDto o) {
        return o.getBusinessType();
    }

    private String setErrorMsg(ImportInOtherOrderModeDto dto, String errorMsg) {
        log.info("\u6821\u9a8c\u9519\u8bef\u4fe1\u606f,errorMsg\uff1a{}", (Object)errorMsg);
        dto.setErrorMsg(errorMsg);
        return dto.getErrorMsg();
    }
}

