/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.IDirectoryDgQueryApi;
import com.yunxi.dg.base.mgmt.application.rpc.api.itembiz.sku.IItemSkuDgQueryApi;
import com.yunxi.dg.base.mgmt.application.rpc.api.oldbiz.IItemDgQueryApi;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.proxy.item.ItemSkuDgRespDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ImportShopItemSupplyStrategyDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="shop_item_supply_strategy")
public class InShopItemSupplyStrategyCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(InShopItemSupplyStrategyCommonServiceImpl.class);
    @Resource
    private IDirectoryDgQueryApi directoryDgQueryApi;
    @Resource
    private IItemSkuDgQueryApi itemSkuDgQueryApi;
    @Resource
    private IItemDgQueryApi itemDgQueryApi;

    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return new ArrayList();
        }
        CubeBeanUtils.copyCollection(list, (Collection)result.getList(), ImportShopItemSupplyStrategyDto.class);
        ArrayList<ImportShopItemSupplyStrategyDto> passList = new ArrayList<ImportShopItemSupplyStrategyDto>();
        List skuCodes = list.stream().map(ImportShopItemSupplyStrategyDto::getSkuCode).distinct().collect(Collectors.toList());
        List itemSkuDgRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApi.queryBySkuCode(skuCodes));
        Map<String, ItemSkuDgRespDto> itemSkuDgRespDtoMap = itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (k1, k2) -> k2));
        for (ImportShopItemSupplyStrategyDto dto : list) {
            Boolean verify = this.shopItemVerify(dto, itemSkuDgRespDtoMap);
            if (!verify.booleanValue()) {
                dto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", dto.getRowNum() + FileModeTypeEnum.getInstance((String)commonReqDto.getKey()).getHeadRows(), dto.getErrorMsg()));
                respDto.getErrorDetails().add(dto);
                continue;
            }
            passList.add(dto);
        }
        respDto.setDetails(passList);
        return passList;
    }

    private Boolean shopItemVerify(ImportShopItemSupplyStrategyDto dto, Map<String, ItemSkuDgRespDto> itemSkuDgRespDtoMap) {
        if (StringUtils.isBlank((CharSequence)dto.getSkuCode())) {
            dto.setErrorMsg("SKU\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            return false;
        }
        if (!itemSkuDgRespDtoMap.containsKey(dto.getSkuCode())) {
            dto.setErrorMsg("SKU\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDistributionUmerical())) {
            if (!InShopItemSupplyStrategyCommonServiceImpl.isMatch("^\\+{0,1}[1-9]\\d*", Convert.toStr((Object)dto.getDistributionUmerical()))) {
                dto.setErrorMsg("\u540c\u6b65\u6bd4\u4f8b\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002");
                return false;
            }
            if (Convert.toBigDecimal((Object)dto.getDistributionUmerical()).compareTo(BigDecimal.ZERO) < 0 || Convert.toBigDecimal((Object)dto.getDistributionUmerical()).compareTo(new BigDecimal("100")) > 0) {
                dto.setErrorMsg("\u540c\u6b65\u6bd4\u4f8b\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002");
                return false;
            }
        } else {
            dto.setDistributionUmerical(BigDecimal.ZERO.toString());
        }
        return true;
    }

    private static boolean isMatch(String regex, String orginal) {
        if (orginal == null || orginal.trim().equals("")) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher isNum = pattern.matcher(orginal);
        return isNum.matches();
    }
}

