/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.account.constants.CurrencyEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountBalanceAggBalanceDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountBalanceAggReqDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.response.ExportAccountFileAggCustomerDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_account_file_agg_customer")
public class AccountFileAggCustomerCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(AccountFileAggCustomerCommonServiceImpl.class);
    @Resource
    private IAccountApiProxy accountApiProxy;

    public List<ExportAccountFileAggCustomerDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) {
        List accountDtos;
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        log.info("\u5ba2\u6237\u8d26\u6237\u6863\u6848\u6309\u5ba2\u6237\u6c47\u603b\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        AssertUtils.isTrue((boolean)FileModeTypeEnum.ACCOUNT_FILE_AGG_CUSTOMER.getKey().equals(key), (String)"\u4e1a\u52a1key\u6709\u8bef");
        ArrayList<ExportAccountFileAggCustomerDto> list = new ArrayList<ExportAccountFileAggCustomerDto>();
        AccountBalanceAggReqDto reqDto = new AccountBalanceAggReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            reqDto = (AccountBalanceAggReqDto)JSON.parseObject((String)filter, AccountBalanceAggReqDto.class);
        }
        if (CollectionUtils.isNotEmpty((Collection)(accountDtos = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.accountApiProxy.queryBalancePageAggByCustomer(reqDto))).getList()))) {
            list.addAll(accountDtos.stream().map(o -> {
                ExportAccountFileAggCustomerDto exportDto = (ExportAccountFileAggCustomerDto)BeanCopyUtil.copyProperties((Object)o, ExportAccountFileAggCustomerDto.class);
                if (Objects.nonNull(o.getCurrency())) {
                    exportDto.setCurrency(CurrencyEnum.codeToName((String)o.getCurrency()));
                }
                if (o.getBalanceAggs() != null) {
                    for (AccountBalanceAggBalanceDto balanceAgg : o.getBalanceAggs()) {
                        if (StringUtils.isBlank((CharSequence)balanceAgg.getAccountTypeName())) continue;
                        if (balanceAgg.getAccountTypeName().contains("\u8d44\u91d1") || balanceAgg.getAccountTypeName().contains("\u73b0\u91d1")) {
                            exportDto.setBalance1(balanceAgg.getBalance());
                            exportDto.setDisposable1(balanceAgg.getDisposable());
                            exportDto.setFrozen1(balanceAgg.getFrozen());
                            exportDto.setPreempt1(balanceAgg.getPreempt());
                            continue;
                        }
                        if (balanceAgg.getAccountTypeName().contains("\u4fe1\u7528")) {
                            exportDto.setBalance2(balanceAgg.getBalance());
                            exportDto.setDisposable2(balanceAgg.getDisposable());
                            exportDto.setFrozen2(balanceAgg.getFrozen());
                            exportDto.setPreempt2(balanceAgg.getPreempt());
                            continue;
                        }
                        if (balanceAgg.getAccountTypeName().contains("\u8fd4\u5229")) {
                            exportDto.setBalance3(balanceAgg.getBalance());
                            exportDto.setDisposable3(balanceAgg.getDisposable());
                            exportDto.setFrozen3(balanceAgg.getFrozen());
                            exportDto.setPreempt3(balanceAgg.getPreempt());
                            continue;
                        }
                        if (!balanceAgg.getAccountTypeName().contains("\u5e02\u573a\u8d39\u7528")) continue;
                        exportDto.setBalance4(balanceAgg.getBalance());
                        exportDto.setDisposable4(balanceAgg.getDisposable());
                        exportDto.setFrozen4(balanceAgg.getFrozen());
                        exportDto.setPreempt4(balanceAgg.getPreempt());
                    }
                }
                return exportDto;
            }).collect(Collectors.toList()));
        }
        log.info("\u5ba2\u6237\u8d26\u6237\u6863\u6848\u6309\u5ba2\u6237\u6c47\u603b\u5bfc\u51fa\u5927\u5c0f:{}", (Object)list.size());
        return list;
    }
}

