/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.mgmt.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.mgmt.application.rpc.api.transform.ReportOrderApi;
import com.yunxi.dg.base.mgmt.application.rpc.proxy.reconciliationbiz.IChannelBillApiProxy;
import com.yunxi.dg.base.ocs.mgmt.application.dto.enums.FileModeTypeEnum;
import com.yunxi.dg.base.ocs.mgmt.application.dto.request.ExportPlatformSaleOrderVO;
import com.yunxi.dg.base.ocs.mgmt.application.dto.transform.OrderExtPageReqDto;
import com.yunxi.dg.base.ocs.mgmt.application.dto.transform.consts.OrderErrorType;
import com.yunxi.dg.base.ocs.mgmt.application.dto.transform.consts.OrderType;
import com.yunxi.dg.base.ocs.mgmt.application.dto.transform.consts.PlatformOrderStatus;
import com.yunxi.dg.base.ocs.mgmt.application.dto.transform.consts.TransferOrderStatus;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PlatformOrderCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger logger = LoggerFactory.getLogger(PlatformOrderCommonServiceImpl.class);
    @Resource
    protected IChannelBillApiProxy channelBillApi;
    @Resource
    private ReportOrderApi reportOrderApi;

    public List<? extends ExportBaseModeDto> callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        String key = exportQueryParamsReqDto.getExportFileParams().getKey();
        String filter = exportQueryParamsReqDto.getFilter();
        logger.info("\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)exportQueryParamsReqDto));
        if (FileModeTypeEnum.OMS_SALE_ORDER.getKey().equals(key)) {
            OrderExtPageReqDto dto = null;
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                dto = (OrderExtPageReqDto)JSON.parseObject((String)exportQueryParamsReqDto.getFilter(), OrderExtPageReqDto.class);
            }
            if (Objects.isNull(dto)) {
                dto = new OrderExtPageReqDto();
                dto.setPageNum(Integer.valueOf(1));
            }
            if (StrUtil.isBlank((CharSequence)dto.getPlatformStartTime()) || StringUtils.isBlank((CharSequence)dto.getPlatformEndTime())) {
                DateTime date = DateUtil.date();
                dto.setPlatformStartTime(DateUtil.formatDateTime((Date)DateUtil.offsetDay((Date)date, (int)-60)));
                dto.setPlatformEndTime(DateUtil.formatDateTime((Date)date));
            }
            dto.setOrderById(Long.valueOf(Long.MAX_VALUE));
            logger.info("\u67e5\u8be2\u5e73\u53f0\u8ba2\u5355\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
            List orderExtPageRespDtos = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.reportOrderApi.queryByPage(dto))).getList();
            if (CollUtil.isEmpty((Collection)orderExtPageRespDtos)) {
                return Collections.EMPTY_LIST;
            }
            exportQueryParamsReqDto.setBreakTag(true);
            DateTime date = DateUtil.date();
            return orderExtPageRespDtos.stream().map(info -> {
                ExportPlatformSaleOrderVO vo = new ExportPlatformSaleOrderVO();
                CubeBeanUtils.copyProperties((Object)vo, (Object)info, (String[])new String[0]);
                vo.setTransferOrderStatus(TransferOrderStatus.getNameByStatus((Integer)info.getTransferOrderStatus()));
                vo.setStationName(info.getShopWebsite());
                if (info.getTransferOrderTime() != null) {
                    vo.setTransferOrderTime(DateUtil.formatDateTime((Date)info.getTransferOrderTime()));
                }
                if (info.getPlatformCreateTime() != null) {
                    vo.setPlatformCreateTime(DateUtil.formatDateTime((Date)info.getPlatformCreateTime()));
                }
                if (info.getPayTime() != null) {
                    vo.setPayTime(DateUtil.formatDateTime((Date)info.getPayTime()));
                }
                vo.setExceptionType(OrderErrorType.convertExceptionType((String)info.getConvertExceptionType()));
                if (CollectionUtils.isNotEmpty((Collection)info.getExceptionReasons())) {
                    vo.setExceptionReason(String.join((CharSequence)";", info.getExceptionReasons()));
                }
                vo.setOrderTypeName(OrderType.getNameByType((Integer)info.getOrderType()));
                vo.setPlatformOrderStatus(null != info.getCovertOrderStatus() ? PlatformOrderStatus.getDescByCode((String)info.getCovertOrderStatus()) : null);
                vo.setGoodsTotalAmount(null != info.getGoodsTotalAmount() ? ParamConverter.convertToString((Object)info.getGoodsTotalAmount().setScale(2, 1)) : null);
                BigDecimal discountTotalAmount = (BigDecimal)ObjectUtil.defaultIfNull((Object)info.getDiscountTotalAmount(), (Object)info.getDiscountMerchantTotalAmount());
                vo.setDiscountAmount(null != discountTotalAmount ? ParamConverter.convertToString((Object)discountTotalAmount.setScale(2, 1)) : null);
                vo.setReceivableAmount(null != info.getMerchantReceivableAmount() ? ParamConverter.convertToString((Object)info.getMerchantReceivableAmount().setScale(2, 1)) : null);
                vo.setRealPayAmount(null != info.getRealPayAmount() ? ParamConverter.convertToString((Object)info.getRealPayAmount().setScale(2, 1)) : null);
                vo.setOrigRealPayAmount(null != info.getOrigRealPayAmount() ? ParamConverter.convertToString((Object)info.getOrigRealPayAmount().setScale(2, 1)) : null);
                vo.setStateSubsidiesAmount(null != info.getStateSubsidiesAmount() ? ParamConverter.convertToString((Object)info.getStateSubsidiesAmount().setScale(2, 1)) : null);
                vo.setBizCheckCustomerName(info.getHsCustomerName());
                vo.setLogicalWarehouseName(info.getAssignedStoreName());
                vo.setLogisticsCompanyName(info.getAssignedDeliveryCompany());
                vo.setDistrict(info.getCounty());
                vo.setDeliveryName(info.getReceiverName());
                vo.setDeliveryPhone(info.getReceiverPhone());
                vo.setGoodsTotalNum(ParamConverter.convertToString((Object)info.getGoodsTotalNum()));
                vo.setDaixiaoOrder(Objects.isNull(info.getDaixiao()) ? "" : (info.getDaixiao() == 1 ? "\u662f" : "\u5426"));
                vo.setIsMultiAreaStr(Objects.equals(info.getIsMultiArea(), 1) ? "\u662f" : "\u5426");
                String detailAddress = "";
                if (StringUtils.isNotEmpty((CharSequence)info.getProvince())) {
                    detailAddress = detailAddress + info.getProvince();
                }
                if (StringUtils.isNotEmpty((CharSequence)info.getCity())) {
                    detailAddress = detailAddress + info.getCity();
                }
                if (StringUtils.isNotEmpty((CharSequence)info.getCounty())) {
                    detailAddress = detailAddress + info.getCounty();
                }
                if (StringUtils.isNotEmpty((CharSequence)info.getReceiverAddress())) {
                    detailAddress = detailAddress + info.getReceiverAddress();
                }
                vo.setDetailAddress(detailAddress);
                Date createTime = Convert.toDate((Object)info.getCreateTime(), (Date)date);
                vo.setOrderTime(Convert.toDate((Object)info.getPlatformCreateTime(), (Date)createTime));
                return vo;
            }).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }
}

