/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.CollectionItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.FileType;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemType;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.CollectionQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.biz.service.ICollectionExtService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.CollectionDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.CollectionItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.RItemBundleDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.RItemBundleEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.CollectionEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.CollectionItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemStorageEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdCollectionItemEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CollectionExtServiceImpl
implements ICollectionExtService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IContext context;
    @Resource(name="${yunxi.dg.base.project:tcbj}ItemQueryApi")
    private IItemQueryApi itemQueryApi;
    @Resource
    private ItemDas itemDas;
    @Resource
    private IItemExtService itemExtService;
    @Resource
    private CollectionItemDas collectionItemDas;
    @Resource
    private CollectionDas collectionDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemStorageDas itemStorageDas;
    @Resource
    private RItemBundleDas rItemBundleDas;
    @Value(value="${item.storage.isVirStorage:false}")
    private boolean isVirStorage;

    @Override
    public PageInfo<CollectionItemRespDto> queryItemCollectionPage(CollectionQueryReqDto queryReqDto) {
        PageInfo pageInfo = new PageInfo();
        Long userId = this.context.userId();
        this.logger.info("context userId:", (Object)userId);
        if (Objects.isNull(userId)) {
            userId = queryReqDto.getUserId();
        }
        if (Objects.isNull(userId)) {
            return pageInfo;
        }
        CollectionEo collection = new CollectionEo();
        collection.setUserSerial(String.valueOf(userId));
        CollectionEo collectionEo = (CollectionEo)this.collectionDas.selectOne((BaseEo)collection);
        if (collectionEo == null) {
            return pageInfo;
        }
        if (Objects.isNull(collectionEo.getId())) {
            return pageInfo;
        }
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.collectionItemDas.filter().orderByDesc((Object)"update_time");
        sqlFilters.eq((Object)"collection_id", (Object)collectionEo.getId());
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getSearch())) {
            ArrayList itemIds = new ArrayList();
            ExtQueryChainWrapper itemEoExtQueryChainWrapper = this.itemDas.filter();
            StringBuilder sql = new StringBuilder();
            sql.append(" ( ");
            sql.append("code like '%" + queryReqDto.getSearch() + "%' or name like '%" + queryReqDto.getSearch() + "%'");
            sql.append(")");
            itemEoExtQueryChainWrapper.apply(sql.toString(), new Object[0]);
            List itemEoList = itemEoExtQueryChainWrapper.list();
            if (!CollectionUtils.isEmpty((Collection)itemEoList)) {
                itemEoList.forEach(v -> itemIds.add(String.valueOf(v.getId())));
                sqlFilters.in((Object)"item_serial", itemIds);
            }
        }
        PageInfo collectionItemEoPageInfo = sqlFilters.page(queryReqDto.getPageNum(), queryReqDto.getPageSize());
        this.logger.info("\u67e5\u8be2\u6536\u85cf\u7684\u5546\u54c1\u4fe1\u606f\uff0c\u7ed3\u679c\uff1a{}", (Object)JSON.toJsonString((Object)collectionItemEoPageInfo));
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)collectionItemEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        try {
            if (Objects.nonNull(collectionItemEoPageInfo) && CollectionUtil.isNotEmpty((Collection)collectionItemEoPageInfo.getList())) {
                List<Long> itemIds = collectionItemEoPageInfo.getList().stream().map(StdCollectionItemEo::getItemSerial).collect(Collectors.toList()).stream().map(v -> Long.valueOf(v)).collect(Collectors.toList());
                Map<Long, ItemRespDto> itemRespDtoMap = this.getItemByItemIds(itemIds);
                this.logger.info("1.\u67e5\u8be2\u5546\u54c1\u4fe1\u606f[it_item],\u7ed3\u679c\uff1a{}", (Object)JSON.toJsonString(itemRespDtoMap));
                Map<Long, List<ItemMediasRespDto>> itemMediasMap = this.getItemMediasByItemIds(itemIds);
                this.logger.info("2.\u67e5\u8be2\u5546\u54c1\u591a\u5a92\u4f53\u4fe1\u606f[it_item_medias],\u7ed3\u679c\uff1a{}", (Object)JSON.toJsonString(itemMediasMap));
                Map<Long, List<ItemSkuRespDto>> itemSkuRespDtoMap = this.getItemSkuListByItemIds(itemIds);
                this.logger.info("3.\u67e5\u8be2\u5546\u54c1SKU\u4fe1\u606f[it_item_sku],\u7ed3\u679c\uff1a{}", (Object)JSON.toJsonString(itemSkuRespDtoMap));
                Map<Long, List<ItemStorageRespDto>> itemStorageRespDtoMap = null;
                if (this.isVirStorage) {
                    itemStorageRespDtoMap = this.getItemStorageByItemIds(itemIds);
                }
                ArrayList<CollectionItemRespDto> collectionItemRespDtos = new ArrayList<CollectionItemRespDto>();
                for (CollectionItemEo v2 : collectionItemEoPageInfo.getList()) {
                    CollectionItemRespDto respDto = new CollectionItemRespDto();
                    CubeBeanUtils.copyProperties((Object)respDto, (Object)v2, (String[])new String[0]);
                    if (MapUtil.isNotEmpty(itemRespDtoMap)) {
                        List<RItemBundleEo> rItemBundleEos;
                        ItemRespDto itemRespDto = itemRespDtoMap.get(Long.valueOf(respDto.getItemSerial()));
                        respDto.setItemCode(itemRespDto != null ? itemRespDto.getCode() : null);
                        respDto.setShopId(itemRespDto != null ? itemRespDto.getShopId() : null);
                        respDto.setSaleCount(itemRespDto != null ? itemRespDto.getSalesCount() : null);
                        respDto.setItemId(itemRespDto != null ? itemRespDto.getId() : null);
                        respDto.setItemName(itemRespDto != null ? itemRespDto.getName() : null);
                        if (this.isVirStorage) {
                            this.logger.info("4\u3001\u5f00\u542f\u4e86\u865a\u62df\u5e93\u5b58");
                            if (itemRespDto != null && ItemType.COMB_ITEM.getStatus() == itemRespDto.getType()) {
                                rItemBundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().eq((Object)"item_id", (Object)itemRespDto.getItemId())).list();
                                if (CollectionUtil.isNotEmpty((Collection)rItemBundleEos)) {
                                    rItemBundleEos.forEach(i -> {
                                        List itemStorageEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStorageDas.filter().eq((Object)"shop_id", (Object)itemRespDto.getShopId())).eq((Object)"item_id", (Object)i.getSubItemId())).eq((Object)"sku_id", (Object)i.getSubSkuId())).orderByDesc((Object)"inventory_effective_date")).list();
                                        ItemStorageEo itemStorageEo = new ItemStorageEo();
                                        if (!CollectionUtils.isEmpty((Collection)itemStorageEos)) {
                                            itemStorageEo = (ItemStorageEo)itemStorageEos.get(0);
                                            Long num = itemStorageEo.getBalance() / (long)i.getNum().intValue();
                                            i.setNum(Integer.valueOf(num.intValue()));
                                        } else {
                                            i.setNum(Integer.valueOf(0));
                                        }
                                    });
                                    rItemBundleEos = rItemBundleEos.stream().sorted(Comparator.comparing(RItemBundleEo::getNum)).collect(Collectors.toList());
                                    respDto.setInventoryQuantity(String.valueOf(((RItemBundleEo)rItemBundleEos.get(0)).getNum()));
                                }
                            } else if (MapUtil.isNotEmpty(itemStorageRespDtoMap)) {
                                List<ItemStorageRespDto> itemStorageRespDtos = itemStorageRespDtoMap.get(Long.valueOf(respDto.getItemSerial()));
                                if (!CollectionUtils.isEmpty(itemStorageRespDtos)) {
                                    respDto.setInventoryQuantity(itemStorageRespDtos.get(0).getBalance() > 0L ? String.valueOf(itemStorageRespDtos.get(0).getBalance()) : "0");
                                } else {
                                    respDto.setInventoryQuantity("0");
                                }
                            }
                        } else {
                            this.logger.info("5\u3001\u5173\u95ed\u4e86\u865a\u62df\u5e93\u5b58");
                            if (Objects.nonNull(itemRespDto) && Objects.nonNull(itemRespDto.getType()) && ItemType.COMB_ITEM.getStatus().intValue() == itemRespDto.getType().intValue() && CollectionUtil.isNotEmpty((Collection)(rItemBundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().eq((Object)"item_id", (Object)itemRespDto.getItemId())).list()))) {
                                Map<String, Integer> subItemCodeMap = rItemBundleEos.stream().collect(Collectors.toMap(eo1 -> eo1.getSubItemCode(), eo1 -> eo1.getNum(), (s, a) -> s + a));
                                respDto.setSubItemCodeMap(subItemCodeMap);
                            }
                        }
                    }
                    if (MapUtil.isNotEmpty(itemSkuRespDtoMap)) {
                        respDto.setItemSkuRespList(itemSkuRespDtoMap.get(Long.valueOf(respDto.getItemSerial())));
                        List<ItemSkuRespDto> skuRespDtoList = itemSkuRespDtoMap.get(Long.valueOf(respDto.getItemSerial()));
                        respDto.setSkuId(CollectionUtils.isEmpty(skuRespDtoList) ? null : skuRespDtoList.get(0).getId());
                    }
                    if (MapUtil.isNotEmpty(itemMediasMap)) {
                        List<ItemMediasRespDto> itemMediasRespDtos = itemMediasMap.get(Long.valueOf(respDto.getItemSerial()));
                        respDto.setItemMediasList(itemMediasRespDtos);
                        if (!CollectionUtils.isEmpty(itemMediasRespDtos)) {
                            ItemMediasRespDto itemMediasRespDto = itemMediasRespDtos.get(0);
                            respDto.setImagePath(itemMediasRespDto.getPath1() != null ? itemMediasRespDto.getPath1() : null);
                        }
                    }
                    collectionItemRespDtos.add(respDto);
                }
                pageInfo.setList(collectionItemRespDtos);
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5546\u54c1\u6536\u85cf\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            throw new BizException("\u67e5\u8be2\u5546\u54c1\u6536\u85cf\u4fe1\u606f\u51fa\u9519");
        }
        return pageInfo;
    }

    private Map<Long, List<ItemMediasRespDto>> getItemMediasByItemIds(List<Long> itemIds) {
        if (CollectionUtil.isEmpty(itemIds)) {
            return null;
        }
        HashMap<Long, List<ItemMediasRespDto>> itemMediasMap = new HashMap<Long, List<ItemMediasRespDto>>(16);
        List itemMediasEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemMediasDas.filter().in((Object)"item_id", itemIds)).eq((Object)"dr", (Object)0)).eq((Object)"file_type", (Object)FileType.ITEM_PIC.getStatus())).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemMediasEoList)) {
            return itemMediasMap;
        }
        ArrayList mediasDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemMediasEoList, (Collection)mediasDtoList, ItemMediasRespDto.class);
        return mediasDtoList.stream().collect(Collectors.groupingBy(ItemMediasRespDto::getItemId));
    }

    private Map<Long, List<ItemSkuRespDto>> getItemSkuListByItemIds(List<Long> itemIds) {
        if (CollectionUtil.isEmpty(itemIds)) {
            return null;
        }
        HashMap<Long, List<ItemSkuRespDto>> itemSkuRespDtoMap = new HashMap<Long, List<ItemSkuRespDto>>(16);
        List itemSkuEoList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().in((Object)"item_id", itemIds)).list();
        if (CollectionUtils.isEmpty((Collection)itemSkuEoList)) {
            return itemSkuRespDtoMap;
        }
        ArrayList itemSkuRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemSkuRespDtos, (Collection)itemSkuEoList, ItemSkuRespDto.class);
        return itemSkuRespDtos.stream().collect(Collectors.groupingBy(ItemSkuRespDto::getItemId));
    }

    private Map<Long, List<ItemStorageRespDto>> getItemStorageByItemIds(List<Long> itemIds) {
        if (CollectionUtil.isEmpty(itemIds)) {
            return null;
        }
        Map<Long, List<ItemStorageRespDto>> itemStorageRespDtoMap = new HashMap<Long, List<ItemStorageRespDto>>(16);
        List itemStorageEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStorageDas.filter().in((Object)"item_id", itemIds)).orderByDesc((Object)"update_time")).list();
        if (CollectionUtils.isEmpty((Collection)itemStorageEos)) {
            return itemStorageRespDtoMap;
        }
        ArrayList itemStorageRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemStorageRespDtos, (Collection)itemStorageEos, ItemStorageRespDto.class);
        itemStorageRespDtoMap = itemStorageRespDtos.stream().collect(Collectors.groupingBy(ItemStorageRespDto::getItemId));
        return itemStorageRespDtoMap;
    }

    private Map<Long, ItemRespDto> getItemByItemIds(List<Long> itemIds) {
        if (CollectionUtil.isEmpty(itemIds)) {
            return null;
        }
        HashMap<Long, ItemRespDto> itemRespDtoMap = new HashMap<Long, ItemRespDto>(16);
        List itemEoList = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"id", itemIds)).list();
        if (CollectionUtils.isEmpty((Collection)itemEoList)) {
            return itemRespDtoMap;
        }
        ArrayList itemRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemRespDtoList, (Collection)itemEoList, ItemRespDto.class);
        return itemRespDtoList.stream().collect(Collectors.toMap(ItemRespDto::getId, Function.identity(), (k1, k2) -> k2));
    }
}

