/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.adapter.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.utils.UnitFormatUtils;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.impl.ItemServiceImpl;
import com.dtyunxi.yundt.cube.center.item.biz.service.IPcpItemService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtendDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemExtendEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.mapper.ItemExtendMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.adapter.api.dto.request.ItemExtendAdapterReqDto;
import com.yunxi.adapter.api.dto.response.ItemExtendAdapterRespDto;
import com.yunxi.adapter.biz.service.IItemExtendAdapterService;
import icu.mhb.mybatisplus.plugln.base.service.impl.JoinServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemExtendAdapterServiceImpl
extends JoinServiceImpl<ItemExtendMapper, ItemExtendEo>
implements IItemExtendAdapterService {
    private static final Logger log = LoggerFactory.getLogger(ItemExtendAdapterServiceImpl.class);
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource(name="${yunxi.dg.base.project:tcbj}PcpItemAdaptorService")
    private IPcpItemService pcpItemService;
    @Resource
    private ItemServiceImpl itemService;
    @Resource
    private ItemDas itemDas;
    @Resource
    private IItemSkuService itemSkuService;

    @Override
    public Long addItemExtend(ItemExtendReqDto addReqDto) {
        long id;
        this.dataWrapper(addReqDto);
        ItemExtendEo queryEo = (ItemExtendEo)this.itemExtendDas.selectByLogicKey((Object)addReqDto.getItemCode());
        if (queryEo != null && queryEo.getId() != null) {
            addReqDto.setId(queryEo.getId());
            this.modifyItemExtend(addReqDto);
            id = queryEo.getId();
        } else {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemExtendEo);
            itemExtendEo.setSpecification(addReqDto.getSpecifications());
            itemExtendEo.setZhTrayNum((Long)Optional.ofNullable(addReqDto.getZhTrayNum()).map(Long::valueOf).orElse(null));
            log.info("\u5546\u54c1\u4fee\u6539\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)itemExtendEo));
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
            this.pcpItemService.publishItemSyncEvent(itemExtendEo);
            id = itemExtendEo.getId();
        }
        return id;
    }

    private void dataWrapper(ItemExtendReqDto addReqDto) {
        addReqDto.setVolume((BigDecimal)Optional.ofNullable(addReqDto.getVolume()).map(va -> UnitFormatUtils.formatVolume((BigDecimal)va, (String)Optional.ofNullable(addReqDto.getVolumnUnit()).orElse(UnitFormatUtils.VolumeEnum.CM.getName()), (String)UnitFormatUtils.VolumeEnum.M.getName())).orElse(null));
        addReqDto.setExpirationUnit(Optional.ofNullable(addReqDto.getExpirationUnit()).filter(StringUtils::isNotBlank).orElse(UnitFormatUtils.DateEnum.DAY.getName()));
        addReqDto.setBigBox(addReqDto.getBigRatio());
        this.expirationDateTransfer(addReqDto);
        addReqDto.setVolumnUnit(UnitFormatUtils.VolumeEnum.M.getName());
    }

    private void expirationDateTransfer(ItemExtendReqDto addReqDto) {
        if (UnitFormatUtils.DateEnum.DAY.getName().equals(addReqDto.getExpirationUnit())) {
            Optional.ofNullable(addReqDto.getExpirationDate()).filter(StringUtils::isNotBlank).map(Long::valueOf).ifPresent(r -> {
                long month = UnitFormatUtils.formatDate((Long)r, (String)UnitFormatUtils.DateEnum.DAY.getName(), (String)UnitFormatUtils.DateEnum.MONTH.getName());
                int transferCoefficient = 12;
                if (month > 0L && month % (long)transferCoefficient == 0L) {
                    addReqDto.setExpirationUnit(UnitFormatUtils.DateEnum.YEAR.getName());
                    addReqDto.setExpirationDate(String.valueOf(month / 12L));
                } else {
                    addReqDto.setExpirationDate(String.valueOf(month));
                    addReqDto.setExpirationUnit(UnitFormatUtils.DateEnum.MONTH.getName());
                }
            });
        }
    }

    @Override
    public void addItemExtendBatch(List<ItemExtendReqDto> addReqDto) {
        addReqDto.stream().forEach(this::addItemExtend);
    }

    @Override
    public void modifyItemExtend(ItemExtendReqDto modifyReqDto) {
        ItemExtendEo itemExtendEo = (ItemExtendEo)this.itemExtendDas.selectByPrimaryKey(modifyReqDto.getId());
        BeanUtil.copyProperties((Object)modifyReqDto, (Object)itemExtendEo, (String[])new String[0]);
        itemExtendEo.setSpecification(modifyReqDto.getSpecifications());
        itemExtendEo.setZhTrayNum((Long)Optional.ofNullable(modifyReqDto.getZhTrayNum()).map(Long::valueOf).orElse(null));
        this.itemExtendDas.update((BaseEo)itemExtendEo);
        this.pcpItemService.publishItemSyncEvent(itemExtendEo);
    }

    @Override
    public void modifyPrice(ItemExtendReqDto modifyReqDto) {
        if (StringUtils.isBlank((CharSequence)modifyReqDto.getItemCode())) {
            throw new BizException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ItemExtendEo::getItemCode, (Object)modifyReqDto.getItemCode())).eq(BaseEo::getDr, (Object)0);
        ItemExtendEo itemExtendEo1 = (ItemExtendEo)this.itemExtendDas.getMapper().selectOne((Wrapper)queryWrapper);
        if (itemExtendEo1 == null) {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            itemExtendEo.setRecommendPrice(modifyReqDto.getRecommendPrice());
            itemExtendEo.setClaimPrice(modifyReqDto.getClaimPrice());
            itemExtendEo.setItemCode(modifyReqDto.getItemCode());
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
            return;
        }
        if (modifyReqDto.getRecommendPrice() != null) {
            itemExtendEo1.setRecommendPrice(modifyReqDto.getRecommendPrice());
        }
        if (modifyReqDto.getClaimPrice() != null) {
            itemExtendEo1.setClaimPrice(modifyReqDto.getClaimPrice());
        }
        this.itemExtendDas.update((BaseEo)itemExtendEo1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemExtend(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemExtendDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public List<ItemExtendAdapterRespDto> queryParam(ItemExtendAdapterReqDto reqDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getItemCode())) {
            queryWrapper.eq(ItemExtendEo::getItemCode, (Object)reqDto.getItemCode());
        } else if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemCodeList())) {
            queryWrapper.in(ItemExtendEo::getItemCode, (Collection)reqDto.getItemCodeList());
        } else {
            queryWrapper.last("limit 10");
        }
        queryWrapper.eq(BaseEo::getDr, (Object)"0");
        List list = this.itemExtendDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<ItemExtendAdapterRespDto> dtoList = new ArrayList<ItemExtendAdapterRespDto>();
        CubeBeanUtils.copyCollection(dtoList, (Collection)list, ItemExtendAdapterRespDto.class);
        return dtoList;
    }

    @Override
    public ItemExtendRespDto queryById(Long id) {
        ItemExtendEo itemExtendEo = (ItemExtendEo)this.itemExtendDas.selectByPrimaryKey(id);
        ItemExtendRespDto itemExtendRespDto = new ItemExtendRespDto();
        DtoHelper.eo2Dto((BaseEo)itemExtendEo, (BaseVo)itemExtendRespDto);
        return itemExtendRespDto;
    }

    @Override
    public PageInfo<ItemExtendRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemExtendReqDto itemExtendReqDto = (ItemExtendReqDto)JSON.parseObject((String)filter, ItemExtendReqDto.class);
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)itemExtendReqDto, (BaseEo)itemExtendEo);
        PageInfo eoPageInfo = this.itemExtendDas.selectPage((BaseEo)itemExtendEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemExtendRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ItemExtendAdapterRespDto> queryByPage(ItemExtendAdapterReqDto reqDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getItemCode())) {
            queryWrapper.eq(ItemExtendEo::getItemCode, (Object)reqDto.getItemCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemCodeList())) {
            queryWrapper.in(ItemExtendEo::getItemCode, (Collection)reqDto.getItemCodeList());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)"0");
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List itemExtendEoList = this.itemExtendDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)itemExtendEoList)) {
            return new PageInfo();
        }
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)itemExtendEoList, ItemExtendAdapterRespDto.class);
        return new PageInfo(itemExtendEoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateImportData(List<ItemExtendImportDto> updateDtoList) {
        if (CollectionUtils.isNotEmpty(updateDtoList)) {
            for (ItemExtendImportDto itemExtendImportDto : updateDtoList) {
                if (itemExtendImportDto.getClaimPrice() != null || itemExtendImportDto.getRecommendPrice() != null || itemExtendImportDto.getZhTrayNum() != null || itemExtendImportDto.getBigBox() != null || itemExtendImportDto.getBigRatio() != null || itemExtendImportDto.getSmallBox() != null) {
                    this.itemExtendDas.updateImportData(itemExtendImportDto);
                }
                if (!StringUtils.isNotBlank((CharSequence)itemExtendImportDto.getItemType())) continue;
                ItemEo itemEo = new ItemEo();
                itemEo.setLongCode(itemExtendImportDto.getItemCode());
                List select = this.itemDas.select((BaseEo)itemEo);
                if (!CollectionUtils.isNotEmpty((Collection)select)) continue;
                for (ItemEo eo : select) {
                    ItemEo updateEo = new ItemEo();
                    updateEo.setId(eo.getId());
                    updateEo.setSubType(Integer.valueOf(itemExtendImportDto.getItemType()));
                    this.itemDas.updateSelective((BaseEo)updateEo);
                }
            }
        }
    }
}

