/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepOutResultDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.mapper.KeepExceptionDetailMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.KeepOutResultDetailMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.PushKeepAccountsDetailMapper;
import com.yunxi.dg.base.center.finance.dto.SaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.enums.BillShopTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.ConditionTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceKeepStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.OrderKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.request.PushAccountDetailReqDto;
import com.yunxi.dg.base.center.finance.dto.request.PushKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepOutResultDetailEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsEo;
import com.yunxi.dg.base.center.finance.service.entity.HandlingExternalSystemsService;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.ILineItemInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BookKeepAccountServiceImpl
implements IBookKeepAccountService {
    private static final Logger log = LoggerFactory.getLogger(BookKeepAccountServiceImpl.class);
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;
    @Resource
    private IKeepOutResultDetailDas outResultDetailDas;
    @Resource
    private IPushKeepAccountsDas pushKeepAccountsDas;
    @Resource
    private IPushKeepAccountsDetailDas pushKeepAccountsDetailDas;
    @Value(value="${push.sap.flag:false}")
    private boolean isPushSap;
    @Value(value="${return.only.push.sap.flag:false}")
    private boolean isReturnOnlyPushSap;
    @Value(value="${return.base.push.sap.flag:false}")
    private boolean isReturnBasePushSap;
    @Value(value="${exchange.push.sap.flag:false}")
    private boolean isExchangeSap;
    @Value(value="${freight.push.sap.flag:false}")
    private boolean isFreightPushSap;
    @Value(value="${material.push.sap.flag:false}")
    private boolean isMaterialPushSap;
    @Value(value="${after.create.delivery.keep.flag:false}")
    private boolean isAfterCreateDelieryKeep;
    @Value(value="${relate.without.return:false}")
    private boolean isWithOutKeep;
    @Value(value="${keep.split.account.size:10000}")
    private Integer splitSize;
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    @Resource
    private ILineItemInfoService lineItemInfoService;
    @Resource
    private ILockService lockService;
    @Resource
    private HandlingExternalSystemsService handlingExternalSystemsService;
    private static final String TABLENAME_DELIVERY = "keep_create_delivery";
    private static final String TABLENAME_BILL = "keep_create_invoice";

    @Override
    public boolean isPushSap() {
        return this.isPushSap;
    }

    @Override
    public boolean isReturnOnlyPushSap() {
        return this.isReturnOnlyPushSap;
    }

    @Override
    public boolean isReturnBasePushSap() {
        return this.isReturnBasePushSap;
    }

    @Override
    public boolean isExchangeSap() {
        return this.isExchangeSap;
    }

    @Override
    public boolean isFreightPushSap() {
        return this.isFreightPushSap;
    }

    @Override
    public boolean isMaterialPushSap() {
        return this.isMaterialPushSap;
    }

    @Override
    public boolean afterCreateDeliveryKeep() {
        return this.isAfterCreateDelieryKeep;
    }

    @Override
    public boolean isWithOutKeep() {
        return this.isWithOutKeep;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void writeDeliveryKeepDetailInvoiceKeepStatus(String chargeCode, List<KeepAccountsDetailEo> billingKeepAccountsDetailEos) {
        List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"charge_code", (Object)chargeCode)).eq((Object)"voucher_type", (Object)VoucherTypeEnum.DELIVERY.getCode())).list();
        Map keepAccountsDetailEosMap = keepAccountsDetailEos.stream().collect(Collectors.toMap(k -> k.getOrderNo() + "-" + k.getOrderItemId(), Function.identity()));
        Map billingKeepAccountsDetailEosMap = billingKeepAccountsDetailEos.stream().collect(Collectors.toMap(k -> k.getOrderNo() + "-" + k.getOrderItemId(), Function.identity()));
        ArrayList updateKeepAccountsDetailEos = Lists.newArrayList();
        keepAccountsDetailEosMap.forEach((k, v) -> {
            if (!CollectionUtils.isEmpty((Map)billingKeepAccountsDetailEosMap) && null != billingKeepAccountsDetailEosMap.get(k)) {
                v.setInvoiceKeepStatus(InvoiceKeepStatusEnum.CREATED.getCode());
                updateKeepAccountsDetailEos.add(v);
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)updateKeepAccountsDetailEos)) {
            int length;
            int i = 0;
            for (length = updateKeepAccountsDetailEos.size(); length > 500; length -= 500) {
                this.keepAccountsDetailDas.batchUpdateDeliveryKeepDetail(updateKeepAccountsDetailEos.subList(i, i + 500));
                i += 500;
            }
            if (length > 0) {
                this.keepAccountsDetailDas.batchUpdateDeliveryKeepDetail(updateKeepAccountsDetailEos.subList(i, i + length));
            }
        }
    }

    @Override
    public void dealCustomerData(List<SaleOrderItemVo> orderItemVoList) {
        ArrayList customerCodes = Lists.newArrayList();
        List afterCustomerCodes = orderItemVoList.stream().map(SaleOrderItemVo::getAfterCustomerCode).distinct().collect(Collectors.toList());
        List zxItemCustomerCodes = orderItemVoList.stream().map(SaleOrderItemVo::getZxItemCustomerCode).distinct().collect(Collectors.toList());
        List zxOrderCustomerCodes = orderItemVoList.stream().map(SaleOrderItemVo::getZxOrderCustomerCode).distinct().collect(Collectors.toList());
        List shopCustomerCodes = orderItemVoList.stream().map(SaleOrderItemVo::getShopCustomerCode).distinct().collect(Collectors.toList());
        customerCodes.addAll(afterCustomerCodes);
        customerCodes.addAll(zxItemCustomerCodes);
        customerCodes.addAll(zxOrderCustomerCodes);
        customerCodes.addAll(shopCustomerCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void writeChargeCodeToDetail(List<PushKeepAccountsEo> keepAccountsEos) {
        ArrayList accountsDetailEos = Lists.newArrayList();
        keepAccountsEos.forEach(v -> {
            List<String> keepDetailIds;
            PushKeepAccountsEo accountsEo = new PushKeepAccountsEo();
            accountsEo.setChargeCode(v.getChargeCode());
            PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)this.pushKeepAccountsDas.selectOne((BaseEo)accountsEo);
            if (Objects.nonNull(pushKeepAccountsEo) && org.apache.commons.collections.CollectionUtils.isNotEmpty(keepDetailIds = Arrays.asList(v.getRealation().split(",")))) {
                keepDetailIds.forEach(m -> {
                    if (StringUtils.isNotBlank((CharSequence)m)) {
                        KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
                        detailEo.setId(Long.valueOf(Long.parseLong(m)));
                        detailEo.setChargeCode(pushKeepAccountsEo.getChargeCode());
                        accountsDetailEos.add(detailEo);
                    }
                });
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountsDetailEos)) {
            int length;
            int i = 0;
            for (length = accountsDetailEos.size(); length > 500; length -= 500) {
                this.keepAccountsDetailDas.batchUpdateKeepDetail(accountsDetailEos.subList(i, i + 500));
                i += 500;
            }
            if (length > 0) {
                this.keepAccountsDetailDas.batchUpdateKeepDetail(accountsDetailEos.subList(i, i + length));
            }
        }
    }

    @Override
    public List<KeepAccountsDetailEo> partialDealKeepAccountDetails(List<KeepAccountsDetailEo> accountsDetailEos, String orderType) {
        HashMap addKeepMap = Maps.newHashMap();
        HashMap updateKeepMap = Maps.newHashMap();
        List voucherTypes = accountsDetailEos.stream().map(KeepAccountsDetailEo::getVoucherType).distinct().collect(Collectors.toList());
        int totalLength = accountsDetailEos.size();
        int batchSize = 1000;
        for (int i = 0; i < totalLength; i += batchSize) {
            int endIndex = Math.min(i + batchSize, totalLength);
            List<KeepAccountsDetailEo> subList = accountsDetailEos.subList(i, endIndex);
            List orderNoList = subList.stream().map(KeepAccountsDetailEo::getOrderNo).distinct().collect(Collectors.toList());
            List keepAccountsDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_no", orderNoList)).in((Object)"voucher_type", voucherTypes)).eq((Object)"order_type", (Object)orderType)).list();
            Map<String, Object> keepAccountsDetailEoMap = new HashMap<String, KeepAccountsDetailEo>();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEoList)) {
                keepAccountsDetailEoMap = keepAccountsDetailEoList.stream().collect(Collectors.toMap(k -> k.getOrderItemId() + "_" + k.getVoucherType(), Function.identity(), (k1, k2) -> k1));
            }
            this.dealKeepAccountsDetail(addKeepMap, updateKeepMap, subList, keepAccountsDetailEoMap);
        }
        ArrayList<KeepAccountsDetailEo> keepAccountsDetailEos = new ArrayList<KeepAccountsDetailEo>(addKeepMap.values());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(keepAccountsDetailEos)) {
            log.info("\u63d2\u5165\u8bb0\u8d26\u660e\u7ec6\u548c\u8bb0\u8d26\u5355\u636e{}", JSON.toJSON(keepAccountsDetailEos));
            this.keepAccountsDetailDas.insertBatch(keepAccountsDetailEos);
        }
        return keepAccountsDetailEos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void partialOutDealKeepAccountDetails(List<KeepOutResultDetailEo> accountsDetailEos, String orderType) {
        ArrayList keepAccountsDetailEos;
        Map<String, Object> keepAccountsDetailEoMap;
        List keepAccountsDetailEoList;
        List orderItemIds;
        int length;
        HashMap addKeepMap = Maps.newHashMap();
        HashMap updateKeepMap = Maps.newHashMap();
        List vocherTypes = accountsDetailEos.stream().map(KeepOutResultDetailEo::getVoucherType).distinct().collect(Collectors.toList());
        int i = 0;
        for (length = accountsDetailEos.size(); length > 1000; length -= 1000) {
            orderItemIds = accountsDetailEos.subList(i, i + 1000).stream().map(KeepOutResultDetailEo::getResultDetailId).collect(Collectors.toList());
            keepAccountsDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.outResultDetailDas.filter().in((Object)"result_detail_id", orderItemIds)).in((Object)"voucher_type", vocherTypes)).eq((Object)"order_type", (Object)orderType)).list();
            keepAccountsDetailEoMap = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEoList)) {
                keepAccountsDetailEoMap = keepAccountsDetailEoList.stream().collect(Collectors.toMap(k -> k.getResultDetailId() + "_" + k.getVoucherType(), Function.identity()));
            }
            this.dealOutKeepAccountsDetail(addKeepMap, updateKeepMap, accountsDetailEos.subList(i, i + 1000), keepAccountsDetailEoMap);
            i += 1000;
        }
        if (length > 0) {
            orderItemIds = accountsDetailEos.subList(i, i + length).stream().map(KeepOutResultDetailEo::getResultDetailId).collect(Collectors.toList());
            keepAccountsDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.outResultDetailDas.filter().in((Object)"result_detail_id", orderItemIds)).in((Object)"voucher_type", vocherTypes)).eq((Object)"order_type", (Object)orderType)).list();
            keepAccountsDetailEoMap = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEoList)) {
                keepAccountsDetailEoMap = keepAccountsDetailEoList.stream().collect(Collectors.toMap(k -> k.getOrderItemId() + "_" + k.getVoucherType(), Function.identity(), (k1, k2) -> k1));
            }
            this.dealOutKeepAccountsDetail(addKeepMap, updateKeepMap, accountsDetailEos.subList(i, i + length), keepAccountsDetailEoMap);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(keepAccountsDetailEos = new ArrayList(addKeepMap.values()))) {
            SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            KeepOutResultDetailMapper mapper = (KeepOutResultDetailMapper)session.getMapper(KeepOutResultDetailMapper.class);
            try {
                int len;
                int size = 1000;
                int j = 0;
                for (len = keepAccountsDetailEos.size(); len > size; len -= size) {
                    keepAccountsDetailEos.subList(j, j + size).forEach(v -> mapper.insert(v));
                    j += size;
                }
                if (len > 0) {
                    keepAccountsDetailEos.subList(j, j + len).forEach(v -> mapper.insert(v));
                }
                session.commit();
                session.close();
                session.clearCache();
            }
            finally {
                session.close();
            }
        }
        if (!CollectionUtils.isEmpty((Map)updateKeepMap)) {
            updateKeepMap.forEach((k, v) -> this.outResultDetailDas.updateSelective((BaseEo)v));
        }
    }

    private void dealKeepAccountsDetail(Map<String, KeepAccountsDetailEo> addKeepMap, Map<String, KeepAccountsDetailEo> updateKeepMap, List<KeepAccountsDetailEo> accountsDetailEos, Map<String, KeepAccountsDetailEo> keepAccountsDetailEoMap) {
        if (null != keepAccountsDetailEoMap && keepAccountsDetailEoMap.size() > 0) {
            accountsDetailEos.forEach(k -> {
                String code = k.getOrderItemId() + "_" + k.getVoucherType();
                KeepAccountsDetailEo accountsDetailEo = new KeepAccountsDetailEo();
                KeepAccountsDetailEo detailEo = (KeepAccountsDetailEo)keepAccountsDetailEoMap.get(code);
                if (Objects.nonNull(detailEo)) {
                    detailEo.setItemNum(k.getItemNum());
                    detailEo.setItemType(k.getItemType());
                    detailEo.setItemPrice(k.getItemPrice());
                    detailEo.setOrderId(k.getOrderId());
                    detailEo.setOrderItemId(k.getOrderItemId());
                    detailEo.setOrderType(k.getOrderType());
                    detailEo.setVoucherType(k.getVoucherType());
                    detailEo.setConditionType(k.getConditionType());
                    detailEo.setOrderInterface(k.getOrderInterface());
                    detailEo.setBillingInterface(k.getBillingInterface());
                    detailEo.setOutResultCreateTime(k.getOutResultCreateTime());
                    detailEo.setOutResultUpdateTime(k.getOutResultUpdateTime());
                    detailEo.setChargeDate(k.getChargeDate());
                    updateKeepMap.put(code, detailEo);
                } else {
                    CubeBeanUtils.copyProperties((Object)accountsDetailEo, (Object)k, (String[])new String[0]);
                    accountsDetailEo.setChargeDate(k.getChargeDate());
                    addKeepMap.put(code, accountsDetailEo);
                }
            });
        } else {
            accountsDetailEos.forEach(k -> {
                String code = k.getOrderItemId() + "_" + k.getVoucherType();
                KeepAccountsDetailEo accountsDetailEo = new KeepAccountsDetailEo();
                CubeBeanUtils.copyProperties((Object)accountsDetailEo, (Object)k, (String[])new String[0]);
                accountsDetailEo.setChargeDate(k.getChargeDate());
                addKeepMap.put(code, accountsDetailEo);
            });
        }
    }

    private void dealOutKeepAccountsDetail(Map<String, KeepOutResultDetailEo> addKeepMap, Map<String, KeepOutResultDetailEo> updateKeepMap, List<KeepOutResultDetailEo> accountsDetailEos, Map<String, KeepOutResultDetailEo> keepAccountsDetailEoMap) {
        if (!CollectionUtils.isEmpty(keepAccountsDetailEoMap)) {
            accountsDetailEos.forEach(k -> {
                String code = k.getOrderItemId() + "_" + k.getVoucherType();
                KeepOutResultDetailEo accountsDetailEo = new KeepOutResultDetailEo();
                KeepOutResultDetailEo detailEo = (KeepOutResultDetailEo)keepAccountsDetailEoMap.get(code);
                if (Objects.nonNull(detailEo)) {
                    detailEo.setItemNum(k.getItemNum());
                    detailEo.setItemType(k.getItemType());
                    detailEo.setItemPrice(k.getItemPrice());
                    detailEo.setOrderId(k.getOrderId());
                    detailEo.setOrderItemId(k.getOrderItemId());
                    detailEo.setOrderType(k.getOrderType());
                    detailEo.setVoucherType(k.getVoucherType());
                    detailEo.setOutResultCreateTime(k.getOutResultCreateTime());
                    detailEo.setOutResultUpdateTime(k.getOutResultUpdateTime());
                    updateKeepMap.put(code, detailEo);
                } else {
                    CubeBeanUtils.copyProperties((Object)accountsDetailEo, (Object)k, (String[])new String[0]);
                    addKeepMap.put(code, accountsDetailEo);
                }
            });
        } else {
            accountsDetailEos.forEach(k -> {
                String code = k.getOrderItemId() + "_" + k.getVoucherType();
                KeepOutResultDetailEo accountsDetailEo = new KeepOutResultDetailEo();
                CubeBeanUtils.copyProperties((Object)accountsDetailEo, (Object)k, (String[])new String[0]);
                addKeepMap.put(code, accountsDetailEo);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchInsertKeepExceptionDetail(List<KeepExceptionDetailEo> list) {
        try (SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);){
            KeepExceptionDetailMapper mapper = (KeepExceptionDetailMapper)session.getMapper(KeepExceptionDetailMapper.class);
            list.forEach(v -> mapper.insert(v));
            session.commit();
            session.close();
            session.clearCache();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void savePushKeepAccounts(List<PushKeepAccountsEo> list) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            int length;
            ArrayList accountsEos = Lists.newArrayList();
            list.forEach(v -> {
                PushKeepAccountsEo pushKeepAccountsEo = (PushKeepAccountsEo)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"charge_code", (Object)v.getChargeCode())).one();
                if (null == pushKeepAccountsEo) {
                    accountsEos.add(v);
                }
            });
            int size = 500;
            int i = 0;
            for (length = accountsEos.size(); length > size; length -= size) {
                this.pushKeepAccountsDas.insertBatch(accountsEos.subList(i, i + size));
                i += size;
            }
            if (length > 0) {
                this.pushKeepAccountsDas.insertBatch(accountsEos.subList(i, i + length));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePushKeepAccountDetail(List<PushKeepAccountsDetailEo> list) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            PushKeepAccountsDetailMapper mapper = (PushKeepAccountsDetailMapper)session.getMapper(PushKeepAccountsDetailMapper.class);
            try {
                int length;
                int size = 1000;
                int i = 0;
                for (length = list.size(); length > size; length -= size) {
                    list.subList(i, i + size).forEach(v -> mapper.insert(v));
                    i += size;
                }
                if (length > 0) {
                    list.subList(i, i + length).forEach(v -> mapper.insert(v));
                }
                session.commit();
                session.close();
                session.clearCache();
            }
            finally {
                session.close();
            }
        }
    }

    private Long getId() {
        return IdGenrator.getDistributedId();
    }

    public PushKeepAccountReqDto getPushKeepAccountReqDto(String orderType, String chargeCode, String yxId, String chargeAccountName, String conditionType, String warehouseCode, String sapCode, Date keepingDate, String costCenter, String bookReason, String projectNo, String voucherType, String overFlag, String customerCode) {
        PushKeepAccountReqDto accountReqDto = new PushKeepAccountReqDto();
        accountReqDto.setSaleOrg("1220");
        accountReqDto.setSaleChannel("00");
        accountReqDto.setOrderType(orderType);
        accountReqDto.setChargeCode(chargeCode);
        accountReqDto.setYxId(yxId);
        accountReqDto.setCertificate(chargeAccountName);
        accountReqDto.setConditionType(conditionType);
        accountReqDto.setWareHouseCode(Objects.equals("virtual", warehouseCode) || Objects.equals("8888", warehouseCode) || Objects.equals("9999", warehouseCode) ? null : warehouseCode);
        accountReqDto.setSapCode(sapCode);
        accountReqDto.setCustomerCode(customerCode);
        accountReqDto.setChargeDate(keepingDate);
        accountReqDto.setCostCenter(Objects.equals("cost", costCenter) ? null : costCenter);
        accountReqDto.setBookReason(Objects.equals("reason", bookReason) ? null : bookReason);
        accountReqDto.setProjectId(Objects.equals("project", projectNo) ? null : projectNo);
        accountReqDto.setVoucherType(voucherType);
        accountReqDto.setOverFlag(overFlag);
        return accountReqDto;
    }

    private PushKeepAccountsDetailEo getPushAccountsDetail(PushAccountDetailReqDto detailReqDto) {
        PushKeepAccountsDetailEo detailEo = new PushKeepAccountsDetailEo();
        detailEo.setOrderType(detailReqDto.getOrderType());
        detailEo.setChargeCode(detailReqDto.getChargeCode());
        detailEo.setChargeAccountName(detailReqDto.getChargeAccountName());
        detailEo.setSapCode(detailReqDto.getSapCode());
        detailEo.setItemCode(detailReqDto.getItemCode());
        detailEo.setWarehouseCode(detailReqDto.getInventoryCode());
        detailEo.setNum(detailReqDto.getNum());
        detailEo.setPrice(detailReqDto.getPrice());
        detailEo.setAmount(detailReqDto.getAmount());
        detailEo.setProjectId(detailReqDto.getProjectId());
        detailEo.setVoucherType(detailReqDto.getVoucherType());
        detailEo.setExtension(detailReqDto.getExtension());
        return detailEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrderKeepAccounts(OrderKeepAccountReqDto orderKeepAccountReqDto) {
        long start = System.currentTimeMillis();
        List pushKeepAccountsEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"charge_code", (Object)orderKeepAccountReqDto.getChargeCode())).eq((Object)"condition_type", (Object)orderKeepAccountReqDto.getConditionType())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pushKeepAccountsEos)) {
            pushKeepAccountsEos.forEach(v -> {
                PushKeepAccountsEo pushKeepAccountsEo = new PushKeepAccountsEo();
                pushKeepAccountsEo.setId(v.getId());
                pushKeepAccountsEo.setChargeCode(v.getChargeCode());
                pushKeepAccountsEo.setPushStatus(orderKeepAccountReqDto.getPushStatus());
                if (ConditionTypeEnum.getDeliveryConditionTypeEnumList().contains(orderKeepAccountReqDto.getConditionType())) {
                    if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getDeliveryNo())) {
                        pushKeepAccountsEo.setDeliveryNote(orderKeepAccountReqDto.getDeliveryNo());
                    }
                    if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getSaleNo())) {
                        pushKeepAccountsEo.setSaleNo(orderKeepAccountReqDto.getSaleNo());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getBillNo())) {
                    pushKeepAccountsEo.setPostingNo(orderKeepAccountReqDto.getBillNo());
                }
                if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getInvoiceNo())) {
                    pushKeepAccountsEo.setInvoiceNo(orderKeepAccountReqDto.getInvoiceNo());
                }
                if (null != orderKeepAccountReqDto.getDeliveryPushTime()) {
                    pushKeepAccountsEo.setDeliveryPushTime(orderKeepAccountReqDto.getDeliveryPushTime());
                }
                if (null != orderKeepAccountReqDto.getInvoicePushTime()) {
                    pushKeepAccountsEo.setInvoicePushTime(orderKeepAccountReqDto.getInvoicePushTime());
                }
                if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getKeepingResult())) {
                    pushKeepAccountsEo.setKeepingResult(orderKeepAccountReqDto.getKeepingResult());
                }
                if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getVoucherNo())) {
                    pushKeepAccountsEo.setVoucher(orderKeepAccountReqDto.getVoucherNo());
                }
                if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getExtension())) {
                    pushKeepAccountsEo.setExtension(orderKeepAccountReqDto.getExtension());
                }
                pushKeepAccountsEo.setReason(orderKeepAccountReqDto.getReason());
                this.pushKeepAccountsDas.updateSelective((BaseEo)pushKeepAccountsEo);
            });
            this.logger.info("\u66f4\u65b0\u8bb0\u8d26\u5355\u8017\u65f6\uff1a{},{}", (Object)orderKeepAccountReqDto.getChargeCode(), (Object)(System.currentTimeMillis() - start));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateKeepAccountsDetails(OrderKeepAccountReqDto orderKeepAccountReqDto) {
        long start = System.currentTimeMillis();
        List pushKeepAccountsEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"charge_code", (Object)orderKeepAccountReqDto.getChargeCode())).eq((Object)"condition_type", (Object)orderKeepAccountReqDto.getConditionType())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pushKeepAccountsEos)) {
            ArrayList accountsDetailEos = Lists.newArrayList();
            pushKeepAccountsEos.forEach(v -> {
                List<String> keepDetailIds = Arrays.asList(v.getRealation().split(","));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(keepDetailIds)) {
                    keepDetailIds.forEach(m -> {
                        if (StringUtils.isNotBlank((CharSequence)m)) {
                            KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
                            detailEo.setId(Long.valueOf(Long.parseLong(m)));
                            if (ConditionTypeEnum.getDeliveryConditionTypeEnumList().contains(orderKeepAccountReqDto.getConditionType())) {
                                if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getDeliveryNo())) {
                                    detailEo.setDeliveryNote(orderKeepAccountReqDto.getDeliveryNo());
                                }
                                if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getSaleNo())) {
                                    detailEo.setSaleNo(orderKeepAccountReqDto.getSaleNo());
                                }
                                if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getBillNo())) {
                                    detailEo.setPostingNo(orderKeepAccountReqDto.getBillNo());
                                }
                            }
                            if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getBillingBookKeeping())) {
                                detailEo.setBookKeeping(orderKeepAccountReqDto.getBillingBookKeeping());
                            } else {
                                detailEo.setBookKeeping(orderKeepAccountReqDto.getBookKeeping());
                            }
                            if (StringUtils.isNotBlank((CharSequence)orderKeepAccountReqDto.getInvoiceNo())) {
                                detailEo.setInvoiceNo(orderKeepAccountReqDto.getInvoiceNo());
                            }
                            accountsDetailEos.add(detailEo);
                        }
                    });
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountsDetailEos)) {
                int length;
                int i = 0;
                for (length = accountsDetailEos.size(); length > 500; length -= 500) {
                    this.keepAccountsDetailDas.batchUpdateDeliveryAndBillingKeepDetail(accountsDetailEos.subList(i, i + 500));
                    i += 500;
                }
                if (length > 0) {
                    this.keepAccountsDetailDas.batchUpdateDeliveryAndBillingKeepDetail(accountsDetailEos.subList(i, i + length));
                }
            }
            this.logger.info("\u66f4\u65b0\u8bb0\u8d26\u660e\u7ec6\u6570\u636e\u8017\u65f6\uff1a{},{}", (Object)orderKeepAccountReqDto.getChargeCode(), (Object)(System.currentTimeMillis() - start));
        }
    }

    private List<KeepAccountsDetailEo> groupConcatOrderItemIds(String deliveryConfirmTime, String chargeAccountName, String customerCode, List<String> itemCodes, String voucherType, String warehouseCode, String conditionType, String costCenter, String bookReason, String projectNo, String orderType, String deliveryOrder, String chargeDate, String batchNo) {
        ExtQueryChainWrapper sqlFilters = this.keepAccountsDetailDas.filter();
        sqlFilters.eq((Object)"charge_account_name", (Object)chargeAccountName);
        sqlFilters.eq((Object)"customer_code", (Object)customerCode);
        sqlFilters.in((Object)"item_code", itemCodes);
        sqlFilters.eq((Object)"voucher_type", (Object)voucherType);
        if (Objects.nonNull(warehouseCode)) {
            sqlFilters.eq((Object)"warehouse_code", (Object)warehouseCode);
        }
        sqlFilters.eq((Object)"condition_type", (Object)conditionType);
        if (Objects.nonNull(costCenter)) {
            sqlFilters.eq((Object)"cost_center", (Object)costCenter);
        }
        if (Objects.nonNull(bookReason)) {
            sqlFilters.eq((Object)"book_reason", (Object)bookReason);
        }
        if (Objects.nonNull(projectNo)) {
            sqlFilters.eq((Object)"project_no", (Object)projectNo);
        }
        sqlFilters.eq((Object)"order_type", (Object)orderType);
        if (Objects.nonNull(deliveryOrder)) {
            StringBuilder sql = new StringBuilder();
            sql.append(" ( ");
            sql.append("delivery_note = '" + deliveryOrder + "' or sale_no =  '" + deliveryOrder + "'");
            sql.append(")");
            sqlFilters.apply(sql.toString(), new Object[0]);
        }
        sqlFilters.isNull((Object)"charge_code");
        sqlFilters.eq((Object)"batch_no", (Object)batchNo);
        sqlFilters.last("AND DATE_FORMAT(charge_date,'%Y-%m-%d') = '" + chargeDate + "' AND DATE_FORMAT(delivery_confirm_time,'%Y-%m-%d') = '" + deliveryConfirmTime + "'");
        List keepAccountsDetailEos = sqlFilters.list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)keepAccountsDetailEos)) {
            return keepAccountsDetailEos;
        }
        return new ArrayList<KeepAccountsDetailEo>();
    }

    @Override
    public void dealCache(String conditionType, String vocherType, String billShopType) {
        ICacheService cacheService = (ICacheService)SpringBeanUtil.getBean(ICacheService.class);
        if (Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), vocherType)) {
            switch (conditionType) {
                case "0": {
                    cacheService.setCache("SALE_LIST_" + VoucherTypeEnum.DELIVERY.getCode(), (Object)"0");
                    break;
                }
                case "2": {
                    cacheService.setCache("DELIVERY_REFUND_ONLY_" + VoucherTypeEnum.DELIVERY.getCode(), (Object)"0");
                    break;
                }
                case "4": {
                    cacheService.setCache("RETURN_BASE_" + VoucherTypeEnum.DELIVERY.getCode(), (Object)"0");
                    break;
                }
                case "6": {
                    cacheService.setCache("EXCHANGE_" + VoucherTypeEnum.DELIVERY.getCode(), (Object)"0");
                    break;
                }
                case "9": {
                    cacheService.setCache("FREIGHT_BOOKKEEPING_" + VoucherTypeEnum.DELIVERY.getCode(), (Object)"0");
                    break;
                }
                case "11": {
                    cacheService.setCache("PACKAGE_MATERIAL_" + VoucherTypeEnum.DELIVERY.getCode(), (Object)"0");
                    break;
                }
                case "13": {
                    cacheService.setCache("RECEIVE_ORDER_" + VoucherTypeEnum.DELIVERY.getCode(), (Object)"0");
                    break;
                }
                case "14": {
                    cacheService.setCache("RETURN_ORDER_" + VoucherTypeEnum.DELIVERY.getCode(), (Object)"0");
                    break;
                }
            }
        } else if (Objects.equals(VoucherTypeEnum.INVOICE.getCode(), vocherType)) {
            String value = Objects.equals(BillShopTypeEnum.B.getCode(), billShopType) ? BillShopTypeEnum.B.getCode() : VoucherTypeEnum.INVOICE.getCode();
            switch (conditionType) {
                case "1": {
                    cacheService.setCache("SALE_LIST_" + value, (Object)"0");
                    break;
                }
                case "3": {
                    cacheService.setCache("DELIVERY_REFUND_ONLY_" + value, (Object)"0");
                    break;
                }
                case "5": {
                    cacheService.setCache("RETURN_BASE_" + value, (Object)"0");
                    break;
                }
                case "7": {
                    cacheService.setCache("EXCHANGE_" + value, (Object)"0");
                    break;
                }
                case "10": {
                    cacheService.setCache("FREIGHT_BOOKKEEPING_" + value, (Object)"0");
                }
                case "12": {
                    cacheService.setCache("PACKAGE_MATERIAL_" + VoucherTypeEnum.INVOICE.getCode(), (Object)"0");
                    break;
                }
            }
        }
    }

    @Override
    public void batchUpdateZxSaleOrderItemRemainingRefundableAmountAndNum(List<Long> zxSaleOrderItemIds, List<KeepAccountsDetailEo> keepAccountsDetailEos) {
        List accountsDetailEos;
        int length;
        log.info("\u66f4\u65b0\u552e\u540e\u5355\u5bf9\u5e94\u7684\u6b63\u5411\u8bb0\u8d26\u5355\u7684\u5269\u4f59\u53ef\u63a8\u91d1\u8776\u4e0e\u5269\u4f59\u53ef\u9000\u6570\u91cf\uff1a{}", (Object)JSONObject.toJSONString(zxSaleOrderItemIds));
        log.info("\u66f4\u65b0\u552e\u540e\u5355\u5bf9\u5e94\u7684\u6b63\u5411\u8bb0\u8d26\u5355\u7684\u5269\u4f59\u53ef\u63a8\u91d1\u8776\u4e0e\u5269\u4f59\u53ef\u9000\u6570\u91cf\u660e\u7ec6\uff1a{}", (Object)JSONObject.toJSONString(keepAccountsDetailEos));
        Map accountsDetailEoMap = keepAccountsDetailEos.stream().collect(Collectors.toMap(KeepAccountsDetailEo::getZxOrderItemId, Function.identity(), (k1, k2) -> k1));
        int i = 0;
        for (length = zxSaleOrderItemIds.size(); length > 500; length -= 500) {
            accountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", zxSaleOrderItemIds.subList(i, i + 500))).eq((Object)"voucher_type", (Object)VoucherTypeEnum.INVOICE.getCode())).eq((Object)"order_type", (Object)BillTypeEnum.SALE_LIST.getCode())).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountsDetailEos)) {
                accountsDetailEos.forEach(v -> {
                    if (accountsDetailEoMap.containsKey(v.getOrderItemId())) {
                        KeepAccountsDetailEo accountsDetailEo = (KeepAccountsDetailEo)accountsDetailEoMap.get(v.getOrderItemId());
                        KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
                        keepAccountsDetailEo.setId(v.getId());
                        keepAccountsDetailEo.setRemainingRefundableAmount(Objects.isNull(accountsDetailEo) ? BigDecimal.ZERO : accountsDetailEo.getRemainingRefundableAmount());
                        keepAccountsDetailEo.setRemainingRefundableNum(Integer.valueOf(Objects.isNull(accountsDetailEo) ? 0 : accountsDetailEo.getRemainingRefundableNum()));
                        this.keepAccountsDetailDas.updateSelective((BaseEo)keepAccountsDetailEo);
                    }
                });
            }
            i += 500;
        }
        if (length > 0 && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(accountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", zxSaleOrderItemIds.subList(i, i + length))).eq((Object)"voucher_type", (Object)VoucherTypeEnum.INVOICE.getCode())).eq((Object)"order_type", (Object)BillTypeEnum.SALE_LIST.getCode())).list()))) {
            accountsDetailEos.forEach(v -> {
                if (accountsDetailEoMap.containsKey(v.getOrderItemId())) {
                    KeepAccountsDetailEo accountsDetailEo = (KeepAccountsDetailEo)accountsDetailEoMap.get(v.getOrderItemId());
                    KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
                    keepAccountsDetailEo.setId(v.getId());
                    keepAccountsDetailEo.setRemainingRefundableAmount(Objects.isNull(accountsDetailEo) ? BigDecimal.ZERO : accountsDetailEo.getRemainingRefundableAmount());
                    keepAccountsDetailEo.setRemainingRefundableNum(Integer.valueOf(Objects.isNull(accountsDetailEo) ? 0 : accountsDetailEo.getRemainingRefundableNum()));
                    this.keepAccountsDetailDas.updateSelective((BaseEo)keepAccountsDetailEo);
                }
            });
        }
    }
}

