/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.KeepTimeOutConverter;
import com.yunxi.dg.base.center.finance.dao.das.IKeepTimeOutDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDas;
import com.yunxi.dg.base.center.finance.dao.mapper.KeepTimeOutMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepTimeOutDomain;
import com.yunxi.dg.base.center.finance.dto.entity.KeepTimeOutDto;
import com.yunxi.dg.base.center.finance.dto.enums.KeepResultEnum;
import com.yunxi.dg.base.center.finance.dto.request.KeepTimeOutReqDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepTimeOutRespDto;
import com.yunxi.dg.base.center.finance.dto.response.RetryKeepReqDto;
import com.yunxi.dg.base.center.finance.eo.KeepTimeOutEo;
import com.yunxi.dg.base.center.finance.service.entity.IKeepTimeOutService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepAccountsService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepTimeOutServiceImpl
extends BaseServiceImpl<KeepTimeOutDto, KeepTimeOutEo, IKeepTimeOutDomain>
implements IKeepTimeOutService {
    private static final Logger log = LoggerFactory.getLogger(KeepTimeOutServiceImpl.class);
    @Resource
    private IKeepTimeOutDas keepTimeOutDas;
    @Resource
    private IKeepTimeOutDomain keepTimeOutDomain;
    @Resource
    private KeepTimeOutMapper keepTimeOutMapper;
    @Resource
    private IPushKeepAccountsDas pushKeepAccountsDas;
    @Resource
    private IPushKeepAccountsService pushKeepAccountsService;

    public KeepTimeOutServiceImpl(IKeepTimeOutDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<KeepTimeOutDto, KeepTimeOutEo> converter() {
        return KeepTimeOutConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addKeepTimeOut(KeepTimeOutReqDto addReqDto) {
        KeepTimeOutEo keepTimeOutEo = new KeepTimeOutEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)keepTimeOutEo);
        this.keepTimeOutDas.insert((BaseEo)keepTimeOutEo);
        return keepTimeOutEo.getId();
    }

    @Override
    public void modifyKeepTimeOut(KeepTimeOutReqDto modifyReqDto) {
        KeepTimeOutEo keepTimeOutEo = new KeepTimeOutEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)keepTimeOutEo);
        this.keepTimeOutDas.updateSelective((BaseEo)keepTimeOutEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeKeepTimeOut(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.keepTimeOutDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public KeepTimeOutRespDto queryById(Long id) {
        KeepTimeOutEo keepTimeOutEo = (KeepTimeOutEo)this.keepTimeOutDas.selectByPrimaryKey(id);
        KeepTimeOutRespDto keepTimeOutRespDto = new KeepTimeOutRespDto();
        DtoHelper.eo2Dto((BaseEo)keepTimeOutEo, (BaseVo)keepTimeOutRespDto);
        return keepTimeOutRespDto;
    }

    @Override
    public PageInfo<KeepTimeOutRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        KeepTimeOutReqDto keepTimeOutReqDto = (KeepTimeOutReqDto)JSON.parseObject((String)filter, KeepTimeOutReqDto.class);
        KeepTimeOutEo keepTimeOutEo = new KeepTimeOutEo();
        DtoHelper.dto2Eo((BaseVo)keepTimeOutReqDto, (BaseEo)keepTimeOutEo);
        PageInfo eoPageInfo = this.keepTimeOutDomain.selectPage((BaseEo)keepTimeOutEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, KeepTimeOutRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void removeKeepByChargeCodes(List<String> chargeCodes) {
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.in((Object)"charge_code", chargeCodes);
        this.keepTimeOutMapper.delete((Wrapper)deleteWrapper);
    }

    @Override
    public void repushAccounting(List<String> chargeCodes) {
        ExtQueryChainWrapper sqlFilters = this.pushKeepAccountsDas.filter();
        Integer pageNum = 1;
        sqlFilters.in((Object)"keeping_result", Arrays.asList(KeepResultEnum.PENDING.getCode(), KeepResultEnum.FAIL.getCode()));
        sqlFilters.in((Object)"charge_code", chargeCodes);
        sqlFilters.notLike((Object)"reason", (Object)"Read timed out executing");
        PageInfo pageInfo = sqlFilters.page(pageNum, Integer.valueOf(1000));
        log.info("\u67e5\u8be2\u8bb0\u8d26\u5931\u8d25\u8bb0\u8d26\u5355pageNum={},\u8fd4\u56depages={}", (Object)pageNum, Objects.nonNull(pageInfo) ? Integer.valueOf(pageInfo.getPages()) : null);
        if (Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List pushKeepIds = pageInfo.getList().stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            List<RetryKeepReqDto> retryKeepReqDtos = pushKeepIds.stream().map(v -> {
                RetryKeepReqDto reqDto = new RetryKeepReqDto();
                reqDto.setId(v);
                return reqDto;
            }).collect(Collectors.toList());
            this.pushKeepAccountsService.retryPushKingdee(retryKeepReqDtos);
        }
        for (int i = pageInfo.getPages() - 1; i >= 0; --i) {
            PageInfo eoPageInfo = sqlFilters.page(Integer.valueOf(i), Integer.valueOf(1000));
            log.info("\u67e5\u8be2\u8bb0\u8d26\u5931\u8d25\u8bb0\u8d26\u5355pageNum={},\u8fd4\u56depages={}", (Object)pageNum, Objects.nonNull(eoPageInfo) ? Integer.valueOf(eoPageInfo.getPages()) : null);
            if (!Objects.nonNull(eoPageInfo) || !CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) continue;
            List pushKeepIds = pageInfo.getList().stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            List<RetryKeepReqDto> retryKeepReqDtos = pushKeepIds.stream().map(v -> {
                RetryKeepReqDto reqDto = new RetryKeepReqDto();
                reqDto.setId(v);
                return reqDto;
            }).collect(Collectors.toList());
            this.pushKeepAccountsService.retryPushKingdee(retryKeepReqDtos);
        }
    }
}

