/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.convert.entity.PerformOrderInfoConverter;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderLineDas;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderInfoDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderItemExtensionDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderItemDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderItemExtensionDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderSnapshotDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.PlatFormOrderSelectTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.finance.eo.PerformOrderInfoEo;
import com.yunxi.dg.base.center.finance.eo.PerformOrderItemExtensionEo;
import com.yunxi.dg.base.center.finance.service.entity.IPerformOrderInfoService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderAmountDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PerformOrderInfoServiceImpl
extends BaseServiceImpl<PerformOrderInfoDto, PerformOrderInfoEo, IPerformOrderInfoDomain>
implements IPerformOrderInfoService {
    private static final Logger logger = LoggerFactory.getLogger(PerformOrderInfoServiceImpl.class);
    @Resource
    private IPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderLineDas performOrderItemDomain;
    @Resource
    private IPerformOrderItemExtensionDomain performOrderItemExtensionDomain;
    @Resource
    private IDgPerformOrderLineDomain iDgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain iDgPerformOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain iDgPerformOrderItemLineDomain;
    @Resource
    private IDgPerformOrderAmountDas iDgPerformOrderAmountDas;

    public PerformOrderInfoServiceImpl(IPerformOrderInfoDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<PerformOrderInfoDto, PerformOrderInfoEo> converter() {
        return PerformOrderInfoConverter.INSTANCE;
    }

    @Override
    public PerformOrderInfoDto queryInfoByOrderNo(String orderNo) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        PerformOrderInfoEo performOrderInfoEo = (PerformOrderInfoEo)((ExtQueryChainWrapper)((IPerformOrderInfoDomain)this.domain).filter().eq((Object)"sale_order_no", (Object)orderNo)).one();
        AssertUtil.isTrue(null != performOrderInfoEo, "\u6839\u636e\u8ba2\u5355\u53f7\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        PerformOrderInfoDto performOrderInfoDto = new PerformOrderInfoDto();
        CubeBeanUtils.copyProperties((Object)performOrderInfoDto, (Object)performOrderInfoEo, (String[])new String[0]);
        return performOrderInfoDto;
    }

    @Override
    public PerformOrderInfoDto queryByOrderNo(String orderNo) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        PerformOrderInfoEo performOrderInfoEo = (PerformOrderInfoEo)((ExtQueryChainWrapper)((IPerformOrderInfoDomain)this.domain).filter().eq((Object)"sale_order_no", (Object)orderNo)).one();
        AssertUtil.isTrue(null != performOrderInfoEo, "\u6839\u636e\u8ba2\u5355\u53f7\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        PerformOrderInfoDto performOrderInfoDto = new PerformOrderInfoDto();
        CubeBeanUtils.copyProperties((Object)performOrderInfoDto, (Object)performOrderInfoEo, (String[])new String[0]);
        List snapshotEoList = ((ExtQueryChainWrapper)this.performOrderSnapshotDomain.filter().eq((Object)"order_id", (Object)performOrderInfoEo.getId())).list();
        ArrayList snapshotDtoList = new ArrayList();
        CubeBeanUtils.copyCollection(snapshotDtoList, (Collection)snapshotEoList, PerformOrderSnapshotDto.class);
        performOrderInfoDto.setPerformOrderSnapshotDtoList(snapshotDtoList);
        List itemEoList = ((ExtQueryChainWrapper)this.performOrderItemDomain.filter().eq((Object)"order_id", (Object)performOrderInfoEo.getId())).list();
        if (CollectionUtils.isNotEmpty((Collection)itemEoList)) {
            List orderItemIdList = itemEoList.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            List orderItemExtensionEoList = ((ExtQueryChainWrapper)this.performOrderItemExtensionDomain.filter().in((Object)"order_item_id", orderItemIdList)).list();
            Map itemExtensionEoMap = ((List)Optional.ofNullable(orderItemExtensionEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(PerformOrderItemExtensionEo::getOrderItemId, Function.identity(), (v1, v2) -> v1));
            List amountEos = Optional.ofNullable(((ExtQueryChainWrapper)this.iDgPerformOrderLineAmountDomain.filter().in((Object)"order_line_id", orderItemIdList)).list()).orElse(Lists.newArrayList());
            Map<Long, BigDecimal> itemRealPayAmountMap = amountEos.stream().filter(item -> DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.equalsByCode(item.getAccountType())).collect(Collectors.toMap(DgPerformOrderLineAmountEo::getOrderLineId, DgPerformOrderLineAmountEo::getAmount, (v1, v2) -> v1));
            Map<Long, BigDecimal> itemSalePriceMap = amountEos.stream().filter(item -> DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.equalsByCode(item.getAccountType())).collect(Collectors.toMap(DgPerformOrderLineAmountEo::getOrderLineId, DgPerformOrderLineAmountEo::getAmount, (v1, v2) -> v1));
            ArrayList itemDtoList = new ArrayList();
            itemEoList.forEach(info -> {
                PerformOrderItemDto performOrderItemDto = new PerformOrderItemDto();
                CubeBeanUtils.copyProperties((Object)performOrderItemDto, (Object)info, (String[])new String[0]);
                if (itemExtensionEoMap.containsKey(info.getId())) {
                    PerformOrderItemExtensionEo performOrderItemExtensionEo = (PerformOrderItemExtensionEo)itemExtensionEoMap.get(info.getId());
                    PerformOrderItemExtensionDto performOrderItemExtensionDto = new PerformOrderItemExtensionDto();
                    CubeBeanUtils.copyProperties((Object)performOrderItemExtensionDto, (Object)performOrderItemExtensionEo, (String[])new String[0]);
                    performOrderItemDto.setPerformOrderItemExtensionDto(performOrderItemExtensionDto);
                }
                performOrderItemDto.setRealPayAmount(this.getLineAmount(itemRealPayAmountMap, info.getId()));
                performOrderItemDto.setSellPrice(this.getLineAmount(itemSalePriceMap, info.getId()));
                itemDtoList.add(performOrderItemDto);
            });
            performOrderInfoDto.setItemDtoList(itemDtoList);
        }
        return performOrderInfoDto;
    }

    private BigDecimal getLineAmount(Map<Long, BigDecimal> lineAmountMap, Long key) {
        return Optional.ofNullable(lineAmountMap.get(key)).orElse(BigDecimal.ZERO);
    }

    @Override
    public List<PerformOrderInfoDto> queryByPlatFormOrderNo(PerformOrderInfoPageReqDto performOrderInfoPageReqDto) {
        logger.info("\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)performOrderInfoPageReqDto));
        AssertUtils.isTrue((StringUtils.isNotBlank((CharSequence)performOrderInfoPageReqDto.getPlatformOrderNo()) || CollectionUtils.isNotEmpty((Collection)performOrderInfoPageReqDto.getPlatformOrderNoList()) ? 1 : 0) != 0, (String)"\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)performOrderInfoPageReqDto.getPlatFormOrderSelectTypeCode(), (String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        PlatFormOrderSelectTypeEnum platFormOrderSelectTypeEnum = PlatFormOrderSelectTypeEnum.forCode((String)performOrderInfoPageReqDto.getPlatFormOrderSelectTypeCode());
        ExtQueryChainWrapper filter = ((IPerformOrderInfoDomain)this.domain).filter();
        if (StringUtils.isNotBlank((CharSequence)performOrderInfoPageReqDto.getPlatformOrderNo())) {
            filter.eq((Object)"platform_order_no", (Object)performOrderInfoPageReqDto.getPlatformOrderNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)performOrderInfoPageReqDto.getPlatformOrderNoList())) {
            filter.in((Object)"platform_order_no", (Collection)performOrderInfoPageReqDto.getPlatformOrderNoList());
        }
        switch (platFormOrderSelectTypeEnum) {
            case NOW_USE: {
                if (Objects.equals(BillApplyTypeEnum.APPLY_BILL.getCode(), performOrderInfoPageReqDto.getBillApplyType())) {
                    filter.notIn((Object)"order_status", Arrays.asList(OmsSaleOrderStatus.SPLIT.getCode()));
                    break;
                }
                filter.notIn((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{OmsSaleOrderStatus.SPLIT.getCode(), OmsSaleOrderStatus.WAIT_CUSTOMER_AUDIT.getCode(), OmsSaleOrderStatus.WAIT_BUSINESS_AUDIT.getCode(), OmsSaleOrderStatus.WAIT_PICK.getCode(), OmsSaleOrderStatus.PICKED.getCode(), OmsSaleOrderStatus.WAIT_DELIVERY.getCode(), OmsSaleOrderStatus.WAIT_ASSIGN.getCode(), OmsSaleOrderStatus.CANCEL.getCode(), OmsSaleOrderStatus.OBSOLETE.getCode(), OmsSaleOrderStatus.LACK.getCode()}));
                break;
            }
            case ORIGIN: {
                filter.isNull((Object)"split_level");
                filter.isNull((Object)"main_order_no");
                filter.notIn((Object)"order_type", (Collection)Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.REPLENISH_ORDER.getType(), SaleOrderTypeEnum.EXCHANGE_ORDER.getType()}));
                break;
            }
            case ALL: {
                break;
            }
            default: {
                throw new BizException("\u9519\u8befplatFormOrderSelectTypeCode");
            }
        }
        List saleOrderEos = filter.list();
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)respDtoList, PerformOrderInfoDto.class);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return respDtoList;
        }
        List idList = respDtoList.stream().map(BaseDto::getId).distinct().collect(Collectors.toList());
        List nonzeroOrderList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgPerformOrderAmountDas.filter().in((Object)"order_id", idList)).ne((Object)"real_pay_amount", (Object)0)).list(Integer.valueOf(Integer.MAX_VALUE));
        if (CollectionUtils.isEmpty((Collection)nonzeroOrderList)) {
            return Collections.emptyList();
        }
        Map nonzeroOrderMap = nonzeroOrderList.stream().collect(Collectors.toMap(DgPerformOrderAmountEo::getOrderId, Function.identity()));
        respDtoList.removeIf(item -> !nonzeroOrderMap.containsKey(item.getId()));
        if (CollectionUtils.isEmpty((Collection)respDtoList)) {
            return Collections.emptyList();
        }
        List snapshotEoList = ((ExtQueryChainWrapper)this.performOrderSnapshotDomain.filter().in((Object)"order_id", idList)).list();
        ArrayList snapshotDtoList = new ArrayList();
        CubeBeanUtils.copyCollection(snapshotDtoList, (Collection)snapshotEoList, PerformOrderSnapshotDto.class);
        Map<Long, List<PerformOrderSnapshotDto>> orderIdMap = snapshotDtoList.stream().collect(Collectors.groupingBy(PerformOrderSnapshotDto::getOrderId));
        List amountEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgPerformOrderLineAmountDomain.filter().in((Object)"order_id", idList)).eq((Object)"account_type", (Object)"LINE_ACTUAL_PRICE")).list();
        Map amountEoMap = ((List)Optional.ofNullable(amountEos).orElse(new ArrayList())).parallelStream().collect(Collectors.toMap(DgPerformOrderLineAmountEo::getOrderLineId, Function.identity()));
        List refundedOrderItemEo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgPerformOrderItemLineDomain.filter().eq((Object)"refund_status", (Object)"REFUNDED")).in((Object)"order_line_id", amountEoMap.keySet())).list();
        List dgPerformOrderItemLineEos = BeanUtil.copyToList((Collection)refundedOrderItemEo, DgPerformOrderItemLineEo.class);
        Map refundedItemMap = ((List)Optional.ofNullable(dgPerformOrderItemLineEos).orElse(new ArrayList())).stream().collect(Collectors.toMap(DgPerformOrderItemLineEo::getOrderLineId, Function.identity(), (v1, v2) -> {
            v1.setPayAmount(v1.getPayAmount().add(v2.getPayAmount()));
            v1.setItemNum(v2.getItemNum().add(v1.getItemNum()));
            return v1;
        }));
        List itemEoList = ((ExtQueryChainWrapper)this.iDgPerformOrderLineDomain.filter().in((Object)"order_id", idList)).list();
        ArrayList itemDtoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)itemEoList)) {
            itemEoList.forEach(info -> {
                PerformOrderItemDto performOrderItemDto = new PerformOrderItemDto();
                CubeBeanUtils.copyProperties((Object)performOrderItemDto, (Object)info, (String[])new String[0]);
                DgPerformOrderLineAmountEo amountEo = (DgPerformOrderLineAmountEo)amountEoMap.get(info.getId());
                performOrderItemDto.setRealPayAmount(Objects.isNull(amountEo) || Objects.isNull(amountEo.getAmount()) ? BigDecimal.ZERO : amountEo.getAmount());
                DgPerformOrderItemLineEo itemLineEo = refundedItemMap.getOrDefault(info.getId(), new DgPerformOrderItemLineEo());
                performOrderItemDto.setRefundedPayAmount(itemLineEo.getPayAmount());
                performOrderItemDto.setRefundedItemNum(Objects.nonNull(itemLineEo.getItemNum()) ? itemLineEo.getItemNum() : BigDecimal.ZERO);
                if (BigDecimalUtils.gtZero((BigDecimal)performOrderItemDto.getRealPayAmount()).booleanValue() && BigDecimalUtils.gtZero((BigDecimal)performOrderItemDto.getItemNum()).booleanValue()) {
                    performOrderItemDto.setSalePrice(performOrderItemDto.getRealPayAmount().subtract(performOrderItemDto.getRefundedPayAmount().abs()).divide(performOrderItemDto.getItemNum(), 2, RoundingMode.HALF_UP));
                }
                itemDtoList.add(performOrderItemDto);
            });
        }
        Map<Long, List<PerformOrderItemDto>> itemMap = itemDtoList.stream().collect(Collectors.groupingBy(PerformOrderItemDto::getOrderId));
        respDtoList.forEach(info -> {
            if (orderIdMap.containsKey(info.getId())) {
                info.setPerformOrderSnapshotDtoList((List)orderIdMap.get(info.getId()));
            }
            if (itemMap.containsKey(info.getId())) {
                info.setItemDtoList((List)itemMap.get(info.getId()));
            }
        });
        logger.info("\u7533\u8bf7\u5f00\u7968\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)respDtoList));
        return respDtoList;
    }

    @Override
    public List<PerformOrderInfoDto> queryByPlatformOrderNoList(List<String> platformOrderNoList) {
        if (CollectionUtils.isEmpty(platformOrderNoList)) {
            return new ArrayList<PerformOrderInfoDto>();
        }
        List infoEoList = ((ExtQueryChainWrapper)((IPerformOrderInfoDomain)this.domain).filter().in((Object)"platform_order_no", platformOrderNoList)).list();
        ArrayList<PerformOrderInfoDto> performOrderInfoDtoList = new ArrayList<PerformOrderInfoDto>();
        CubeBeanUtils.copyCollection(performOrderInfoDtoList, (Collection)infoEoList, PerformOrderInfoDto.class);
        return performOrderInfoDtoList;
    }

    @Override
    public List<PerformOrderInfoDto> queryBySaleOrderNoList(List<String> saleOrderNoList) {
        if (CollectionUtils.isEmpty(saleOrderNoList)) {
            return new ArrayList<PerformOrderInfoDto>();
        }
        List infoEoList = ((ExtQueryChainWrapper)((IPerformOrderInfoDomain)this.domain).filter().in((Object)"sale_order_no", saleOrderNoList)).list();
        ArrayList<PerformOrderInfoDto> performOrderInfoDtoList = new ArrayList<PerformOrderInfoDto>();
        CubeBeanUtils.copyCollection(performOrderInfoDtoList, (Collection)infoEoList, PerformOrderInfoDto.class);
        return performOrderInfoDtoList;
    }

    @Override
    public PerformOrderInfoDto queryByOrderNo(List<String> orderNos) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(orderNos), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List performOrderInfoEos = ((ExtQueryChainWrapper)((IPerformOrderInfoDomain)this.domain).filter().in((Object)"sale_order_no", orderNos)).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)performOrderInfoEos), "\u6839\u636e\u8ba2\u5355\u53f7\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        PerformOrderInfoDto performOrderInfoDto = new PerformOrderInfoDto();
        CubeBeanUtils.copyProperties((Object)performOrderInfoDto, performOrderInfoEos.get(0), (String[])new String[0]);
        List Ids = performOrderInfoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List snapshotEoList = ((ExtQueryChainWrapper)this.performOrderSnapshotDomain.filter().in((Object)"order_id", Ids)).list();
        ArrayList snapshotDtoList = new ArrayList();
        CubeBeanUtils.copyCollection(snapshotDtoList, (Collection)snapshotEoList, PerformOrderSnapshotDto.class);
        performOrderInfoDto.setPerformOrderSnapshotDtoList(snapshotDtoList);
        List itemEoList = ((ExtQueryChainWrapper)this.performOrderItemDomain.filter().in((Object)"order_id", Ids)).list();
        if (CollectionUtils.isEmpty((Collection)itemEoList)) {
            return performOrderInfoDto;
        }
        List orderItemIdList = itemEoList.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        List orderItemExtensionEoList = ((ExtQueryChainWrapper)this.performOrderItemExtensionDomain.filter().in((Object)"order_item_id", orderItemIdList)).list();
        Map itemExtensionEoMap = ((List)Optional.ofNullable(orderItemExtensionEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(PerformOrderItemExtensionEo::getOrderItemId, Function.identity(), (v1, v2) -> v1));
        List amountEos = Optional.ofNullable(((ExtQueryChainWrapper)this.iDgPerformOrderLineAmountDomain.filter().in((Object)"order_line_id", orderItemIdList)).list()).orElse(Lists.newArrayList());
        Map<Long, BigDecimal> itemRealPayAmountMap = amountEos.stream().filter(item -> DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.equalsByCode(item.getAccountType())).collect(Collectors.toMap(DgPerformOrderLineAmountEo::getOrderLineId, DgPerformOrderLineAmountEo::getAmount, (v1, v2) -> v1));
        Map<Long, BigDecimal> itemSalePriceMap = amountEos.stream().filter(item -> DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.equalsByCode(item.getAccountType())).collect(Collectors.toMap(DgPerformOrderLineAmountEo::getOrderLineId, DgPerformOrderLineAmountEo::getAmount, (v1, v2) -> v1));
        ArrayList itemDtoList = new ArrayList();
        HashMap itemMap = new HashMap();
        itemEoList.forEach(info -> {
            if (Objects.nonNull(itemMap.get(info.getItemId()))) {
                PerformOrderItemDto performOrderItemDto = (PerformOrderItemDto)itemMap.get(info.getItemId());
                performOrderItemDto.setRealPayAmount(performOrderItemDto.getRefundedPayAmount().add(this.getLineAmount(itemRealPayAmountMap, info.getId())));
                performOrderItemDto.setItemNum(performOrderItemDto.getItemNum().add(info.getItemNum()));
                return;
            }
            PerformOrderItemDto performOrderItemDto = new PerformOrderItemDto();
            CubeBeanUtils.copyProperties((Object)performOrderItemDto, (Object)info, (String[])new String[0]);
            if (itemExtensionEoMap.containsKey(info.getId())) {
                PerformOrderItemExtensionEo performOrderItemExtensionEo = (PerformOrderItemExtensionEo)itemExtensionEoMap.get(info.getId());
                PerformOrderItemExtensionDto performOrderItemExtensionDto = new PerformOrderItemExtensionDto();
                CubeBeanUtils.copyProperties((Object)performOrderItemExtensionDto, (Object)performOrderItemExtensionEo, (String[])new String[0]);
                performOrderItemDto.setPerformOrderItemExtensionDto(performOrderItemExtensionDto);
            }
            performOrderItemDto.setRealPayAmount(this.getLineAmount(itemRealPayAmountMap, info.getId()));
            performOrderItemDto.setSellPrice(this.getLineAmount(itemSalePriceMap, info.getId()));
            if (BigDecimalUtils.gtZero((BigDecimal)performOrderItemDto.getRealPayAmount()).booleanValue() && BigDecimalUtils.gtZero((BigDecimal)performOrderItemDto.getItemNum()).booleanValue()) {
                performOrderItemDto.setSalePrice(performOrderItemDto.getRealPayAmount().divide(performOrderItemDto.getItemNum(), 2, RoundingMode.HALF_UP));
            }
            itemMap.put(info.getItemId(), performOrderItemDto);
            itemDtoList.add(performOrderItemDto);
        });
        performOrderInfoDto.setItemDtoList(itemDtoList);
        return performOrderInfoDto;
    }

    @Override
    public List<String> queryPlatformOrderNoByShopCodeAndSubsidesTypes(List<String> platformOrderNos, Collection<String> shopCodes, Collection<Integer> subsidiesTypes) {
        return ((IPerformOrderInfoDomain)this.domain).queryPlatformOrderNoByShopCodeAndSubsidesTypes(platformOrderNos, shopCodes, subsidiesTypes);
    }
}

