/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl.rule;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.dao.das.inventory.IOutResultOrderDas;
import com.yunxi.dg.base.center.finance.dao.das.inventory.IOutResultOrderDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderInfoOutNoticeSyncRecordDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderItemLineDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderSnapshotDas;
import com.yunxi.dg.base.center.finance.dao.vo.BookAccountsReqVo;
import com.yunxi.dg.base.center.finance.dto.ResultSaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.SaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BookKeepingType;
import com.yunxi.dg.base.center.finance.dto.enums.ConditionTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KingdeeErpConstantEnum;
import com.yunxi.dg.base.center.finance.dto.enums.MasterSlaveTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsOrderStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SingleTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.RuleParamReqDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepInterfaceTypeRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepOutResultDetailEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepNodeCommonService;
import com.yunxi.dg.base.center.finance.service.entity.IShopService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import com.yunxi.dg.base.center.finance.service.utils.TradeUtil;
import com.yunxi.dg.base.center.inventory.eo.OutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.OutResultOrderEo;
import com.yunxi.dg.base.center.logistics.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.logistics.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoOutNoticeSyncRecordEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class HckSaleDeliveryKeepingNodeRule
implements KeepNodeRule {
    private static final Logger log = LoggerFactory.getLogger(HckSaleDeliveryKeepingNodeRule.class);
    private String voucherType = "0";
    @Value(value="${keep.base.mode:AJR}")
    private String keepSystem;

    public HckSaleDeliveryKeepingNodeRule(String keepSystem) {
        this.keepSystem = keepSystem;
    }

    @Override
    public void execute(KeepNodeRuleParam context) {
        context.setVoucherType("0");
        long start = System.currentTimeMillis();
        BookAccountsReqVo reqVo = new BookAccountsReqVo();
        reqVo.setOrderStatus(Arrays.asList(OmsOrderStatusEnum.DELIVERED.getCode(), OmsOrderStatusEnum.COMPLETE.getCode()));
        if (Objects.equals(KeepTypeEnum.AUTO.getCode(), context.getParamReqDto().getType())) {
            reqVo.setStartTime(context.getParamReqDto().getStartDate());
            reqVo.setEndTime(context.getOrderRuleEo().getBillTime());
        } else if (Objects.equals(KeepTypeEnum.REAL.getCode(), context.getParamReqDto().getType())) {
            reqVo.setInnerOrderNo(context.getParamReqDto().getInnerOrderNo());
            reqVo.setRealTimeFlag(Integer.valueOf(BigDecimal.ONE.intValue()));
        }
        IKeepNodeCommonService keepNodeCommonService = (IKeepNodeCommonService)SpringBeanUtil.getBean(IKeepNodeCommonService.class);
        context.getParamReqDto().setVoucherType(this.voucherType);
        List<SaleOrderItemVo> saleOrderItemVos = keepNodeCommonService.matcherCustomerItemWarehouseInfo(context, reqVo);
        log.info("\u6b63\u5411\u5355\u636e-\u67e5\u8be2\u5230\u7684\u5355\u636e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(saleOrderItemVos));
        if (CollectionUtils.isNotEmpty(saleOrderItemVos)) {
            keepNodeCommonService.summaryGroupingKeepNode(context, saleOrderItemVos);
        }
        log.info("\u6b63\u5411\u5355\u636e-\u6c47\u603b\u540e\u5355\u636e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(saleOrderItemVos));
        if (CollectionUtils.isEmpty(saleOrderItemVos)) {
            return;
        }
        keepNodeCommonService.insertPushKeepAccountAndDetail(saleOrderItemVos, context);
        keepNodeCommonService.handlerPushKeepAccountsAmount(saleOrderItemVos);
        List<String> chargCodes = saleOrderItemVos.stream().map(SaleOrderItemVo::getChargeCode).distinct().collect(Collectors.toList());
        IKeepNodeCommonService iKeepNodeCommonService = (IKeepNodeCommonService)SpringBeanUtil.getBean(IKeepNodeCommonService.class);
        iKeepNodeCommonService.sendPushKeepAccountMessage(chargCodes);
    }

    public void handler(List<KeepAccountsDetailEo> keepAccountsDetailEos, List<KeepOutResultDetailEo> outResultDetailEos, String startTime, String endTime, String orderType) {
        long start = System.currentTimeMillis();
        IBookKeepAccountService iBookKeepAccountService = (IBookKeepAccountService)SpringBeanUtil.getBean(IBookKeepAccountService.class);
        if (CollectionUtils.isNotEmpty(keepAccountsDetailEos)) {
            iBookKeepAccountService.partialDealKeepAccountDetails(keepAccountsDetailEos, orderType);
            log.info("\u4fdd\u5b58\u8bb0\u8d26\u660e\u7ec6\u8017\u65f6\uff1a{}~{}\uff0c{}", new Object[]{startTime, endTime, System.currentTimeMillis() - start});
        }
        if (CollectionUtils.isNotEmpty(outResultDetailEos)) {
            iBookKeepAccountService.partialOutDealKeepAccountDetails(outResultDetailEos, orderType);
            log.info("\u4fdd\u5b58\u51fa\u5e93\u7ed3\u679c\u8bb0\u8d26\u660e\u7ec6\u8017\u65f6\uff1a{}~{}\uff0c{}", new Object[]{startTime, endTime, System.currentTimeMillis() - start});
        }
    }

    public void handlerException(List<KeepExceptionDetailEo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            IBookKeepAccountService iBookKeepAccountService = (IBookKeepAccountService)SpringBeanUtil.getBean(IBookKeepAccountService.class);
            iBookKeepAccountService.batchInsertKeepExceptionDetail(list);
        }
    }

    public List<SaleOrderItemVo> matcherCustomerItemWarehouseInfo(KeepNodeRuleParam context, BookAccountsReqVo reqVo) {
        Map interfaceTypeListMap = context.getParamReqDto().getInterfaceTypeListMap();
        RuleParamReqDto paramReqDto = context.getParamReqDto();
        IDgPerformOrderInfoDas dgPerformOrderInfoDas = (IDgPerformOrderInfoDas)SpringBeanUtil.getBean(IDgPerformOrderInfoDas.class);
        List performOrderInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)dgPerformOrderInfoDas.filter().in((Object)"sale_order_no", (Collection)paramReqDto.getInnerOrderNos())).in((Object)"order_status", Arrays.asList(OmsSaleOrderStatus.DELIVERED.getCode(), OmsSaleOrderStatus.COMPLETE.getCode(), OmsSaleOrderStatus.DELIVERY_PART.getCode(), OmsSaleOrderStatus.DELIVERY_ALL.getCode()))).list();
        Map performOrderInfoMap = performOrderInfoEos.stream().collect(Collectors.toMap(DgPerformOrderInfoEo::getSaleOrderNo, Function.identity(), (v1, v2) -> v2));
        IDgPerformOrderSnapshotDas dgPerformOrderSnapshotDas = (IDgPerformOrderSnapshotDas)SpringBeanUtil.getBean(IDgPerformOrderSnapshotDas.class);
        List performOrderIds = performOrderInfoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List performOrderSnapshotEos = ((ExtQueryChainWrapper)dgPerformOrderSnapshotDas.filter().in((Object)"order_id", performOrderIds)).list();
        Map performOrderSnapshotMap = performOrderSnapshotEos.stream().collect(Collectors.toMap(DgPerformOrderSnapshotEo::getOrderId, Function.identity(), (v1, v2) -> v2));
        IDgPerformOrderItemLineDas dgPerformOrderItemLineDas = (IDgPerformOrderItemLineDas)SpringBeanUtil.getBean(IDgPerformOrderItemLineDas.class);
        List performOrderItemLineEos = ((ExtQueryChainWrapper)dgPerformOrderItemLineDas.filter().in((Object)"order_id", performOrderIds)).list();
        Map dgPerformOrderItemLineEoMap = performOrderItemLineEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v2));
        List orderItemList = performOrderItemLineEos.stream().map(DgPerformOrderItemLineEo::getOrderLineId).collect(Collectors.toList());
        IDgPerformOrderLineDomain dgPerformOrderLineDomain = (IDgPerformOrderLineDomain)SpringBeanUtil.getBean(IDgPerformOrderLineDomain.class);
        List dgPerformOrderLineEos = dgPerformOrderLineDomain.selectByIds(orderItemList);
        Map dgPerformOrderLineEoMap = dgPerformOrderLineEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v2));
        IShopService shopService = (IShopService)SpringBeanUtil.getBean(IShopService.class);
        List<String> shopCodes = performOrderSnapshotEos.stream().map(DgPerformOrderSnapshotEo::getShopCode).collect(Collectors.toList());
        List<ShopEo> shopEos = shopService.selectShopByCodes(shopCodes);
        Map shopEoMap = shopEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v2));
        IDgPerformOrderInfoOutNoticeSyncRecordDas dgPerformOrderInfoOutNoticeSyncRecordDas = (IDgPerformOrderInfoOutNoticeSyncRecordDas)SpringBeanUtil.getBean(IDgPerformOrderInfoOutNoticeSyncRecordDas.class);
        List dgPerformOrderInfoOutNoticeSyncRecordEos = ((ExtQueryChainWrapper)dgPerformOrderInfoOutNoticeSyncRecordDas.filter().in((Object)"order_id", performOrderIds)).list();
        Map<Long, List<DgPerformOrderInfoOutNoticeSyncRecordEo>> dgPerformOrderInfoOutNoticeSyncRecordEoMap = dgPerformOrderInfoOutNoticeSyncRecordEos.stream().collect(Collectors.groupingBy(DgPerformOrderInfoOutNoticeSyncRecordEo::getOrderId));
        IOutResultOrderDas outResultOrderDas = (IOutResultOrderDas)SpringBeanUtil.getBean(IOutResultOrderDas.class);
        List outResultOrderEos = ((ExtQueryChainWrapper)outResultOrderDas.filter().in((Object)"relevance_no", (Collection)paramReqDto.getInnerOrderNos())).list();
        Map outResultOrderEoMap = outResultOrderEos.stream().collect(Collectors.toMap(OutResultOrderEo::getRelevanceNo, Function.identity(), (k1, k2) -> k1));
        IOutResultOrderDetailDas outResultOrderDetailDas = (IOutResultOrderDetailDas)SpringBeanUtil.getBean(IOutResultOrderDetailDas.class);
        List outResultOrderDetailEos = ((ExtQueryChainWrapper)outResultOrderDetailDas.filter().in((Object)"relevance_no", (Collection)paramReqDto.getInnerOrderNos())).list();
        Map outResultOrderDetailEoMap = outResultOrderDetailEos.stream().collect(Collectors.toMap(OutResultOrderDetailEo::getSkuCode, Function.identity(), (k1, k2) -> k1));
        ILogicWarehouseDomain logicWarehouseDomain = (ILogicWarehouseDomain)SpringBeanUtil.getBean(ILogicWarehouseDomain.class);
        Collection values = outResultOrderEoMap.values();
        ArrayList<String> queryWarehouseCode = new ArrayList<String>();
        for (OutResultOrderEo value : values) {
            String orderType = value.getOrderType();
            if (orderType.equals("out")) {
                queryWarehouseCode.add(value.getOutLogicWarehouseCode());
                continue;
            }
            queryWarehouseCode.add(value.getInLogicWarehouseCode());
        }
        List logicWarehouseEos = ((ExtQueryChainWrapper)logicWarehouseDomain.filter().in((Object)"warehouse_code", queryWarehouseCode)).list();
        Map logicWarehouseRespDtoMap = logicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        HashMap chargeCodeCache = Maps.newHashMap();
        String TABLENAME = "sale_order_item_id#";
        ILockService lockService = (ILockService)SpringBeanUtil.getBean(ILockService.class);
        ArrayList<SaleOrderItemVo> list = new ArrayList<SaleOrderItemVo>();
        paramReqDto.getGoodsList().forEach(itemDto -> {
            DgPerformOrderItemLineEo itemLineEo;
            DgPerformOrderLineEo orderLineEo;
            Mutex mutex = null;
            String primaryKey = paramReqDto.getInnerOrderNo() + "_" + Convert.toStr((Object)itemDto.getItemLineId()) + "_" + itemDto.getBatchNo();
            mutex = lockService.lock(TABLENAME, primaryKey);
            if (null == mutex) {
                throw new BizException(String.format("\u63a5\u6536\u9500\u552e\u5355\u8bb0\u8d26\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,primaryKey:\u3010%s\u3011", primaryKey));
            }
            SaleOrderItemVo saleOrderItemVo = new SaleOrderItemVo();
            saleOrderItemVo.setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
            String code = (String)chargeCodeCache.get(paramReqDto.getInnerOrderNo());
            if (StringUtils.isBlank((CharSequence)code)) {
                String chargeCode = "BL" + TradeUtil.generateTradeNo();
                saleOrderItemVo.setChargeCode(chargeCode);
                chargeCodeCache.put(paramReqDto.getInnerOrderNo(), chargeCode);
            } else {
                saleOrderItemVo.setChargeCode(code);
            }
            saleOrderItemVo.setBatchNo(itemDto.getBatchNo());
            saleOrderItemVo.setRealTimeFlag(reqVo.getRealTimeFlag());
            saleOrderItemVo.setSingle(SingleTypeEnum.YES.getCode());
            saleOrderItemVo.setMasterDeputyIdentity(MasterSlaveTypeEnum.MASTER.getCode());
            saleOrderItemVo.setRealTimeFlag(Integer.valueOf(null != reqVo.getRealTimeFlag() ? reqVo.getRealTimeFlag().intValue() : BigDecimal.ZERO.intValue()));
            saleOrderItemVo.setGeneratePerson(null != context.getParamReqDto().getGeneratePerson() ? context.getParamReqDto().getGeneratePerson() : "system");
            saleOrderItemVo.setOrderType(BillTypeEnum.SALE_LIST.getCode());
            saleOrderItemVo.setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
            saleOrderItemVo.setConditionType(ConditionTypeEnum.SALE_CREATE_DELIVERY.getCode());
            DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)performOrderInfoMap.get(itemDto.getSaleOrderNo());
            saleOrderItemVo.setOrderId(performOrderInfoEo.getId());
            saleOrderItemVo.setOrderNo(performOrderInfoEo.getSaleOrderNo());
            saleOrderItemVo.setTenantId(performOrderInfoEo.getTenantId());
            saleOrderItemVo.setInstanceId(performOrderInfoEo.getInstanceId());
            saleOrderItemVo.setPlatformCreateTime(performOrderInfoEo.getSaleCreateTime());
            DgPerformOrderSnapshotEo dgPerformOrderSnapshotEo = (DgPerformOrderSnapshotEo)performOrderSnapshotMap.get(performOrderInfoEo.getId());
            if (StringUtils.isNotBlank((CharSequence)dgPerformOrderSnapshotEo.getCustomerCode())) {
                saleOrderItemVo.setCustomerId(dgPerformOrderSnapshotEo.getCustomerId() != null ? dgPerformOrderSnapshotEo.getCustomerId() : null);
                saleOrderItemVo.setCustomerCode(dgPerformOrderSnapshotEo.getCustomerCode() != null ? dgPerformOrderSnapshotEo.getCustomerCode() : null);
                saleOrderItemVo.setCustomerName(dgPerformOrderSnapshotEo.getCustomerName() != null ? dgPerformOrderSnapshotEo.getCustomerName() : null);
            } else {
                saleOrderItemVo.setCustomerId(dgPerformOrderSnapshotEo.getHsCustomerId() != null ? dgPerformOrderSnapshotEo.getHsCustomerId() : null);
                saleOrderItemVo.setCustomerCode(dgPerformOrderSnapshotEo.getHsCustomerCode() != null ? dgPerformOrderSnapshotEo.getHsCustomerCode() : null);
                saleOrderItemVo.setCustomerName(dgPerformOrderSnapshotEo.getHsCustomerName() != null ? dgPerformOrderSnapshotEo.getHsCustomerName() : null);
            }
            if (null != shopEoMap.get(dgPerformOrderSnapshotEo.getShopId())) {
                ShopEo shopEo = (ShopEo)shopEoMap.get(dgPerformOrderSnapshotEo.getShopId());
                saleOrderItemVo.setShopId(shopEo.getId());
                saleOrderItemVo.setShopCode(shopEo.getCode());
                saleOrderItemVo.setShopCustomerCode(shopEo.getCustomerCode());
                saleOrderItemVo.setShopOrganizationCode(shopEo.getOrganizationCode());
                saleOrderItemVo.setShopOrganizationName(shopEo.getOrganizationName());
                saleOrderItemVo.setSiteName(shopEo.getSiteName());
                saleOrderItemVo.setSiteName(shopEo.getSiteName());
                saleOrderItemVo.setSupplierCode(shopEo.getSupplierCode());
            }
            if (dgPerformOrderItemLineEoMap.containsKey(itemDto.getItemLineId()) && null != (orderLineEo = (DgPerformOrderLineEo)dgPerformOrderLineEoMap.get((itemLineEo = (DgPerformOrderItemLineEo)dgPerformOrderItemLineEoMap.get(itemDto.getItemLineId())).getOrderLineId()))) {
                saleOrderItemVo.setItemId(((DgPerformOrderLineEo)dgPerformOrderLineEoMap.get(itemLineEo.getOrderLineId())).getItemId());
                saleOrderItemVo.setItemCode(((DgPerformOrderLineEo)dgPerformOrderLineEoMap.get(itemLineEo.getOrderLineId())).getItemCode());
                saleOrderItemVo.setItemName(((DgPerformOrderLineEo)dgPerformOrderLineEoMap.get(itemLineEo.getOrderLineId())).getItemName());
                saleOrderItemVo.setItemType(itemDto.getGift());
                saleOrderItemVo.setOrderItemId(itemDto.getItemLineId());
                saleOrderItemVo.setItemNum(Integer.valueOf(itemDto.getItemNum().intValue()));
                saleOrderItemVo.setItemPrice(itemLineEo.getPayAmount());
            }
            if (CollectionUtil.isNotEmpty((Collection)((Collection)dgPerformOrderInfoOutNoticeSyncRecordEoMap.get(performOrderInfoEo.getId())))) {
                List syncRecordEos = (List)dgPerformOrderInfoOutNoticeSyncRecordEoMap.get(performOrderInfoEo.getId());
                syncRecordEos.forEach(outRecord -> {
                    if (Objects.nonNull(outRecord.getOutNoticeResultJson())) {
                        JSONObject jsonObject = JSONObject.parseObject((String)outRecord.getOutNoticeResultJson());
                        HashSet shippingNos = new HashSet();
                        JSONArray jsonArray = JSONArray.parseArray((String)jsonObject.getString("shippingInfoList"));
                        jsonArray.forEach(json -> {
                            JSONObject object = JSONObject.parseObject((String)json.toString());
                            shippingNos.add(null != object ? object.getString("shippingNo") : null);
                        });
                        saleOrderItemVo.setShippingNo(String.join((CharSequence)",", shippingNos));
                    }
                });
            }
            if (null != outResultOrderEoMap.get(performOrderInfoEo.getSaleOrderNo()) && CollectionUtil.isNotEmpty((Map)outResultOrderDetailEoMap) && null != outResultOrderDetailEoMap.get(itemDto.getSkuCode())) {
                String warehousCode;
                OutResultOrderEo outResultOrderEo = (OutResultOrderEo)outResultOrderEoMap.get(performOrderInfoEo.getSaleOrderNo());
                OutResultOrderDetailEo outResultOrderDetailEo = (OutResultOrderDetailEo)outResultOrderDetailEoMap.get(itemDto.getSkuCode());
                ResultSaleOrderItemVo vo = new ResultSaleOrderItemVo();
                vo.setDocumentId(outResultOrderEo.getId());
                vo.setDocumentNo(outResultOrderDetailEo.getDocumentNo());
                vo.setOutResultCreateTime(outResultOrderEo.getCreateTime());
                vo.setOutResultUpdateTime(outResultOrderEo.getUpdateTime());
                vo.setPreOrderNo(outResultOrderEo.getPreOrderNo());
                vo.setResultOrderDetailId(outResultOrderDetailEo.getId());
                saleOrderItemVo.setResultSaleOrderItemVo(vo);
                String orderType = outResultOrderEo.getOrderType();
                String string = warehousCode = orderType.equals("out") ? outResultOrderEo.getOutLogicWarehouseCode() : outResultOrderEo.getInLogicWarehouseCode();
                if (logicWarehouseRespDtoMap.containsKey(warehousCode)) {
                    LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)logicWarehouseRespDtoMap.get(warehousCode);
                    String outLogicWarehouseCode = outResultOrderEo.getOutLogicWarehouseCode();
                    saleOrderItemVo.setOrganizationId(Objects.nonNull(outResultOrderEo) ? outResultOrderEo.getOrganizationId() : null);
                    saleOrderItemVo.setOrganizationCode(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getOrganizationCode() : null);
                    saleOrderItemVo.setOrganizationName(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getCargoEscheatageName() : null);
                    saleOrderItemVo.setCargoEscheatageId(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getCargoEscheatageId() : null);
                    saleOrderItemVo.setCargoEscheatageName(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getCargoEscheatageName() : null);
                    saleOrderItemVo.setWarehouseProperty(Objects.nonNull(logicWarehouseEo) ? logicWarehouseEo.getWarehouseProperty() : null);
                    saleOrderItemVo.setWarehouseName(logicWarehouseEo.getWarehouseName());
                }
            }
            List interfaceTypeRespDtos = (List)interfaceTypeListMap.get(performOrderInfoEo.getOrderType());
            if (SaleOrderTypeEnum.COMMON_ORDER.getType().equalsIgnoreCase(performOrderInfoEo.getOrderType()) || SaleOrderTypeEnum.PRE_SALE_ORDER.getType().equalsIgnoreCase(performOrderInfoEo.getOrderType()) || SaleOrderTypeEnum.GIFT_ORDER.getType().equalsIgnoreCase(performOrderInfoEo.getOrderType()) || SaleOrderTypeEnum.EXCHANGE_ORDER.getType().equalsIgnoreCase(performOrderInfoEo.getOrderType())) {
                Map interfaceTypeRespDtoMap = interfaceTypeRespDtos.stream().collect(Collectors.toMap(KeepInterfaceTypeRespDto::getOrderType, Function.identity(), (k1, k2) -> k1));
                KeepInterfaceTypeRespDto keepInterfaceTypeRespDto = (KeepInterfaceTypeRespDto)interfaceTypeRespDtoMap.get(performOrderInfoEo.getOrderType());
                if (null != keepInterfaceTypeRespDto && Convert.toInt((Object)InvoiceTypeEnum.YES.getCode()) == keepInterfaceTypeRespDto.getInvoice()) {
                    saleOrderItemVo.setInvoice(InvoiceTypeEnum.YES.getCode());
                    saleOrderItemVo.setBillAccountName("\u6682\u4f30\u5e94\u6536\u5355");
                } else {
                    saleOrderItemVo.setInvoice(InvoiceTypeEnum.NO.getCode());
                }
                saleOrderItemVo.setInterfaceName(keepInterfaceTypeRespDto.getInterfaceName());
                saleOrderItemVo.setInterfaceNameValue(keepInterfaceTypeRespDto.getInterfaceNameValue());
                saleOrderItemVo.setInvoiceName(keepInterfaceTypeRespDto.getInvoiceName());
                saleOrderItemVo.setInvoiceNameValue(keepInterfaceTypeRespDto.getInvoiceNameValue());
                saleOrderItemVo.setOrderInterface(keepInterfaceTypeRespDto.getInterfaceName());
                saleOrderItemVo.setBillingInterface(keepInterfaceTypeRespDto.getInvoiceName());
                saleOrderItemVo.setChargeAccountName(keepInterfaceTypeRespDto.getChargeAccountName());
            } else if (SaleOrderTypeEnum.REPLENISH_ORDER.getType().equalsIgnoreCase(performOrderInfoEo.getOrderType()) || SaleOrderTypeEnum.PROXY_SALE.getType().equalsIgnoreCase(performOrderInfoEo.getOrderType()) || SaleOrderTypeEnum.CONSIGNMENT_BACK.getType().equalsIgnoreCase(performOrderInfoEo.getOrderType()) || SaleOrderTypeEnum.CONSIGNMENT_NOT_BACK.getType().equalsIgnoreCase(performOrderInfoEo.getOrderType())) {
                KeepInterfaceTypeRespDto keepInterfaceTypeRespDto = (KeepInterfaceTypeRespDto)interfaceTypeRespDtos.get(0);
                if (Convert.toInt((Object)InvoiceTypeEnum.YES.getCode()) == keepInterfaceTypeRespDto.getInvoice()) {
                    saleOrderItemVo.setInvoice(InvoiceTypeEnum.YES.getCode());
                    saleOrderItemVo.setBillAccountName("\u6682\u4f30\u5e94\u6536\u5355");
                } else {
                    saleOrderItemVo.setInvoice(InvoiceTypeEnum.NO.getCode());
                }
                saleOrderItemVo.setInterfaceName(keepInterfaceTypeRespDto.getInterfaceName());
                saleOrderItemVo.setInterfaceNameValue(keepInterfaceTypeRespDto.getInterfaceNameValue());
                saleOrderItemVo.setInvoiceName(keepInterfaceTypeRespDto.getInvoiceName());
                saleOrderItemVo.setInvoiceNameValue(keepInterfaceTypeRespDto.getInvoiceNameValue());
                saleOrderItemVo.setOrderInterface(keepInterfaceTypeRespDto.getInterfaceName());
                saleOrderItemVo.setBillingInterface(keepInterfaceTypeRespDto.getInvoiceName());
                saleOrderItemVo.setChargeAccountName(keepInterfaceTypeRespDto.getChargeAccountName());
            }
            list.add(saleOrderItemVo);
        });
        return list;
    }

    public Map<String, Object> validateKeep(List<SaleOrderItemVo> orderItemVoList, KeepNodeRuleParam context) {
        HashMap keepDetailMap = Maps.newHashMap();
        ArrayList keepAccountsDetailEos = Lists.newArrayList();
        ArrayList outResultDetailEos = Lists.newArrayList();
        HashSet exceptionDetailEos = new HashSet();
        orderItemVoList.forEach(v -> {
            KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
            StringBuffer buffer = new StringBuffer();
            if (context.isAction()) {
                v.setPushPerson(context.getCreator());
            }
            IKeepNodeCommonService keepNodeCommonService = (IKeepNodeCommonService)SpringBeanUtil.getBean(IKeepNodeCommonService.class);
            keepNodeCommonService.initKeepAccountsDetail(keepAccountsDetailEo, (SaleOrderItemVo)v);
            keepAccountsDetailEos.add(keepAccountsDetailEo);
        });
        keepDetailMap.put("keepDetails", keepAccountsDetailEos);
        keepDetailMap.put("outKeepDetails", outResultDetailEos);
        keepDetailMap.put("exceptionDetails", exceptionDetailEos);
        return keepDetailMap;
    }

    private KeepExceptionDetailEo setKeepException(String saleOrderNo, String itemCode, String extension) {
        KeepExceptionDetailEo exceptionDetailEo = new KeepExceptionDetailEo();
        exceptionDetailEo.setOrderNo(saleOrderNo);
        exceptionDetailEo.setConditionType(ConditionTypeEnum.SALE_CREATE_DELIVERY.getCode());
        exceptionDetailEo.setOrderType(BillTypeEnum.SALE_LIST.getCode());
        exceptionDetailEo.setItemCode(itemCode);
        exceptionDetailEo.setExtension(extension);
        return exceptionDetailEo;
    }

    public void initKeepAccountsDetail(KeepAccountsDetailEo keepAccountsDetailEo, SaleOrderItemVo v) {
        keepAccountsDetailEo.setTenantId(v.getTenantId());
        keepAccountsDetailEo.setInstanceId(v.getInstanceId());
        keepAccountsDetailEo.setChargeCode(v.getChargeCode());
        keepAccountsDetailEo.setBatchNo(v.getBatchNo());
        keepAccountsDetailEo.setOrderNo(v.getOrderNo());
        keepAccountsDetailEo.setCustomerId(v.getCustomerId());
        keepAccountsDetailEo.setCustomerCode(v.getCustomerCode());
        keepAccountsDetailEo.setCustomerName(v.getCustomerName());
        keepAccountsDetailEo.setSapCode(v.getSapCode());
        keepAccountsDetailEo.setItemCode(v.getItemCode());
        keepAccountsDetailEo.setWarehouseCode(v.getWarehouseCode());
        keepAccountsDetailEo.setWarehouseName(v.getWarehouseName());
        keepAccountsDetailEo.setOutWarehouseCode(v.getWarehouseCode());
        keepAccountsDetailEo.setItemNum(v.getItemNum());
        keepAccountsDetailEo.setItemPrice(v.getItemPrice());
        keepAccountsDetailEo.setBookKeeping(BookKeepingType.NOT_DEAL.getCode());
        keepAccountsDetailEo.setOrderInterface(v.getOrderInterface());
        keepAccountsDetailEo.setBillingInterface(v.getBillingInterface());
        keepAccountsDetailEo.setItemType(Convert.toStr((Object)v.getItemType()));
        keepAccountsDetailEo.setOrderType(v.getOrderType());
        keepAccountsDetailEo.setOrderId(v.getOrderId());
        keepAccountsDetailEo.setConditionType(v.getConditionType());
        keepAccountsDetailEo.setVoucherType(v.getVoucherType());
        keepAccountsDetailEo.setDeliveryConfirmTime(v.getDeliveryCompleteDate());
        keepAccountsDetailEo.setItemName(v.getItemName());
        keepAccountsDetailEo.setSiteCode(v.getSiteCode());
        keepAccountsDetailEo.setSiteName(v.getSiteName());
        keepAccountsDetailEo.setOrderItemId(v.getOrderItemId());
        keepAccountsDetailEo.setInvoice(v.getInvoice());
        keepAccountsDetailEo.setShopCode(v.getShopCode());
        keepAccountsDetailEo.setShopName(v.getShopName());
        keepAccountsDetailEo.setShopId(v.getShopId());
        keepAccountsDetailEo.setSingle(v.getSingle());
        keepAccountsDetailEo.setProductType(v.getProductType());
        keepAccountsDetailEo.setLineOrderType(v.getLineOrderType());
        keepAccountsDetailEo.setPlaceTime(v.getPlaceTime());
        keepAccountsDetailEo.setPlatformNo(v.getPlatformOrderNo());
        keepAccountsDetailEo.setPlatformOrderNo(v.getPlatformOrderNo());
        keepAccountsDetailEo.setDocumentNo(v.getDocumentNo());
        keepAccountsDetailEo.setDocumentId(v.getDocumentId());
        keepAccountsDetailEo.setOrderStatus(v.getOrderStatus());
        keepAccountsDetailEo.setCompleteTime(v.getConfirmReceiveTime());
        keepAccountsDetailEo.setDeliveryTime(v.getDeliveryCompleteDate());
        keepAccountsDetailEo.setItemId(v.getItemId());
        keepAccountsDetailEo.setGeneratePerson(v.getGeneratePerson());
        keepAccountsDetailEo.setPlatformCreateTime(v.getPlatformCreateTime());
        keepAccountsDetailEo.setSaleOrderType(v.getSaleOrderType());
        keepAccountsDetailEo.setLineOrderType(v.getLineOrderType());
        keepAccountsDetailEo.setBusinessType(v.getBusinessType());
        keepAccountsDetailEo.setCompanyCode(v.getCompanyCode());
        keepAccountsDetailEo.setCompanyCategory(v.getCompanyCategory());
        keepAccountsDetailEo.setCompanyTypeCode(v.getCompanyCategoryCode());
        keepAccountsDetailEo.setItemType(v.getItemType() == 0 ? "\u6b63\u54c1" : "\u8d60\u54c1");
        keepAccountsDetailEo.setCompleteTime(v.getConfirmReceiveTime());
        keepAccountsDetailEo.setGroupSkuCode(v.getGroupSkuCode());
        keepAccountsDetailEo.setGroupItemName(v.getGroupItemName());
        keepAccountsDetailEo.setGroupItemId(v.getGroupItemId());
        keepAccountsDetailEo.setRealTimeFlag(v.getRealTimeFlag());
        keepAccountsDetailEo.setOrganizationCode(v.getOrganizationCode());
        keepAccountsDetailEo.setOrganizationName(v.getOrganizationName());
        if (Objects.equals(KingdeeErpConstantEnum.OmsErp21Service.getCode(), v.getOrderInterface()) || Objects.equals(KingdeeErpConstantEnum.OmsErp3Service.getCode(), v.getOrderInterface())) {
            keepAccountsDetailEo.setErpOrderType("XSDD14_SYS");
            keepAccountsDetailEo.setErpOutOrderType("XSCKD14_SYS");
        }
        keepAccountsDetailEo.setRemark(v.getRemark());
        keepAccountsDetailEo.setSellerRemark(v.getSellerRemark());
        keepAccountsDetailEo.setBuyerRemark(v.getBuyerRemark());
        keepAccountsDetailEo.setShippingNo(v.getShippingNo());
        keepAccountsDetailEo.setShopOrganizationCode(v.getShopOrganizationCode());
        keepAccountsDetailEo.setShopOrganizationName(v.getShopOrganizationName());
        keepAccountsDetailEo.setWarehouseType(v.getWarehouseType());
        keepAccountsDetailEo.setDeliveryWay(v.getDeliveryWay());
        keepAccountsDetailEo.setWarehouseProperty(v.getWarehouseProperty());
        keepAccountsDetailEo.setOutResultCreateTime(v.getOutResultCreateTime());
        keepAccountsDetailEo.setOutResultUpdateTime(v.getOutResultUpdateTime());
        keepAccountsDetailEo.setPreOrderNo(v.getPreOrderNo());
        keepAccountsDetailEo.setChargeAccountName(v.getChargeAccountName());
        keepAccountsDetailEo.setBillAccountName(v.getBillAccountName());
        keepAccountsDetailEo.setSupplierCode(v.getSupplierCode());
        keepAccountsDetailEo.setPlatformCompleteTime(v.getPlatformCompleteTime());
        keepAccountsDetailEo.setPlatformOrderId(v.getPlatformOrderId());
        keepAccountsDetailEo.setPlatformOrderItemNo(v.getPlatformOrderItemNo());
        keepAccountsDetailEo.setPlatformItemName(v.getPlatformItemName());
        keepAccountsDetailEo.setPlatformItemCode(v.getPlatformItemCode());
        keepAccountsDetailEo.setPlatformItemSkuCode(v.getPlatformItemSkuCode());
        keepAccountsDetailEo.setPlatformOrderNo(v.getBusinessNo());
        keepAccountsDetailEo.setDeliveryTime(v.getDeliveryTime());
    }

    public void initResultKeepAccountsDetail(KeepOutResultDetailEo keepAccountsDetailEo, SaleOrderItemVo v) {
        keepAccountsDetailEo.setOrderType(v.getOrderType());
        keepAccountsDetailEo.setChargeCode(v.getChargeCode());
        keepAccountsDetailEo.setOrderNo(v.getOrderNo());
        keepAccountsDetailEo.setItemId(v.getItemId());
        keepAccountsDetailEo.setItemCode(v.getItemCode());
        keepAccountsDetailEo.setWarehouseCode(v.getWarehouseCode());
        keepAccountsDetailEo.setWarehouseName(v.getWarehouseName());
        keepAccountsDetailEo.setItemNum(v.getItemNum());
        keepAccountsDetailEo.setItemPrice(v.getItemPrice());
        keepAccountsDetailEo.setBookKeeping(BookKeepingType.NOT_DEAL.getCode());
        keepAccountsDetailEo.setItemType(Convert.toStr((Object)v.getItemType()));
        keepAccountsDetailEo.setItemName(v.getItemName());
        keepAccountsDetailEo.setSingle(v.getSingle());
        keepAccountsDetailEo.setProductType(v.getProductType());
        keepAccountsDetailEo.setLineOrderType(v.getLineOrderType());
        keepAccountsDetailEo.setBatchNo(v.getBatchNo());
        keepAccountsDetailEo.setGeneratePerson(v.getGeneratePerson());
        ResultSaleOrderItemVo vo = v.getResultSaleOrderItemVo();
        keepAccountsDetailEo.setOrderId(vo.getDocumentId());
        keepAccountsDetailEo.setDocumentNo(vo.getDocumentNo());
        keepAccountsDetailEo.setResultDetailId(vo.getResultOrderDetailId());
        keepAccountsDetailEo.setOutResultCreateTime(vo.getOutResultCreateTime());
        keepAccountsDetailEo.setOutResultUpdateTime(vo.getOutResultUpdateTime());
        keepAccountsDetailEo.setPreOrderNo(vo.getPreOrderNo());
        keepAccountsDetailEo.setVoucherType(VoucherTypeEnum.DELIVERY.getCode());
    }
}

