/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.convert.entity.BusinessTypeConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBusinessTypeDas;
import com.yunxi.dg.base.center.finance.domain.entity.IBusinessTypeDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BusinessTypeDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.BusinessTypeReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillBusinessTypeRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BusinessTypeRespDto;
import com.yunxi.dg.base.center.finance.eo.BusinessTypeEo;
import com.yunxi.dg.base.center.finance.service.entity.IBusinessTypeService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusinessTypeServiceImpl
extends BaseServiceImpl<BusinessTypeDto, BusinessTypeEo, IBusinessTypeDomain>
implements IBusinessTypeService {
    @Resource
    private IBusinessTypeDas businessTypeDas;
    @Resource
    private IBusinessTypeDomain businessTypeDomain;

    public BusinessTypeServiceImpl(IBusinessTypeDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BusinessTypeDto, BusinessTypeEo> converter() {
        return BusinessTypeConverter.INSTANCE;
    }

    @Override
    public Long addBusinessType(BusinessTypeReqDto addReqDto) {
        BusinessTypeEo businessTypeEo = new BusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)businessTypeEo);
        this.businessTypeDas.insert((BaseEo)businessTypeEo);
        return businessTypeEo.getId();
    }

    @Override
    public void modifyBusinessType(BusinessTypeReqDto modifyReqDto) {
        BusinessTypeEo businessTypeEo = new BusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)businessTypeEo);
        this.businessTypeDas.updateSelective((BaseEo)businessTypeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBusinessType(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.businessTypeDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BusinessTypeRespDto queryById(Long id) {
        BusinessTypeEo businessTypeEo = (BusinessTypeEo)this.businessTypeDas.selectByPrimaryKey(id);
        BusinessTypeRespDto businessTypeRespDto = new BusinessTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)businessTypeEo, (BaseVo)businessTypeRespDto);
        return businessTypeRespDto;
    }

    @Override
    public PageInfo<BusinessTypeRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        BusinessTypeReqDto businessTypeReqDto = (BusinessTypeReqDto)JSON.parseObject((String)filter, BusinessTypeReqDto.class);
        BusinessTypeEo businessTypeEo = new BusinessTypeEo();
        DtoHelper.dto2Eo((BaseVo)businessTypeReqDto, (BaseEo)businessTypeEo);
        PageInfo eoPageInfo = this.businessTypeDomain.selectPage((BaseEo)businessTypeEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BusinessTypeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<BusinessTypeRespDto> queryList(BusinessTypeReqDto businessTypeReqDto) {
        List businessTypeEos = ((ExtQueryChainWrapper)this.businessTypeDas.filter().orderByAsc((Object)"id")).list();
        ArrayList businessTypeRespDtos = Lists.newArrayListWithCapacity((int)businessTypeEos.size());
        CubeBeanUtils.copyCollection((Collection)businessTypeRespDtos, (Collection)businessTypeEos, BusinessTypeRespDto.class);
        return businessTypeRespDtos;
    }

    @Override
    public BillBusinessTypeRespDto queryBillBusinessList() {
        BillBusinessTypeRespDto typeRespDto = new BillBusinessTypeRespDto();
        List list = BillTypeEnum.toList();
        typeRespDto.setBillTypeLists(list);
        List businessTypeEos = ((ExtQueryChainWrapper)this.businessTypeDas.filter().orderByAsc((Object)"id")).list();
        ArrayList businessTypeRespDtos = Lists.newArrayListWithCapacity((int)businessTypeEos.size());
        CubeBeanUtils.copyCollection((Collection)businessTypeRespDtos, (Collection)businessTypeEos, BusinessTypeRespDto.class);
        typeRespDto.setBusinessTypeRespDtos((List)businessTypeRespDtos);
        return typeRespDto;
    }
}

