/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dto.entity.KeepAccountsDetailDto;
import com.yunxi.dg.base.center.finance.dto.request.PushStatusToTradeDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.service.entity.HandlingExternalSystemsService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepExceptionDetailService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HandlingExternalSystemsServiceImpl
implements HandlingExternalSystemsService {
    private static final Logger log = LoggerFactory.getLogger(HandlingExternalSystemsServiceImpl.class);
    @Resource
    private IKeepExceptionDetailService keepExceptionDetailService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;

    @Override
    public void pushStatusToTrade(List<KeepAccountsDetailEo> keepAccountsDetailEos) {
        Map<String, List<KeepAccountsDetailEo>> collect = keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getOrderType));
        collect.forEach((k, v) -> {
            Map group = v.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getOrderNo, Collectors.toList()));
            int maxBatchSize = 682;
            ArrayList batchList = new ArrayList();
            AtomicReference currentBatch = new AtomicReference();
            group.forEach((k1, v1) -> {
                boolean newBatch;
                boolean bl = newBatch = currentBatch.get() == null || ((List)currentBatch.get()).size() >= maxBatchSize;
                if (newBatch) {
                    currentBatch.set(new ArrayList());
                    batchList.add(currentBatch.get());
                }
                ((List)currentBatch.get()).addAll(v1);
            });
            int currentBatchIndex = 0;
            for (List batch : batchList) {
                log.info("\u5f00\u59cb\u5206\u6279\u63a8\u9001\u8bb0\u8d26\u72b6\u6001\u4ea4\u6613\u6d88\u606f: orderType={}, \u6279\u6b21={}/{}, \u603b\u6570={}, \u5f53\u524d\u6279\u6b21\u6570\u91cf={}", new Object[]{k, ++currentBatchIndex, batchList.size(), v.size(), batch.size()});
                PushStatusToTradeDto pushStatusToTradeDto = new PushStatusToTradeDto();
                pushStatusToTradeDto.setOrderType(k);
                ArrayList detailDtos = new ArrayList();
                CubeBeanUtils.copyCollection(detailDtos, (Collection)batch, KeepAccountsDetailDto.class);
                pushStatusToTradeDto.setDetailDtos(detailDtos);
                boolean success = this.sendOrderCancelResult(pushStatusToTradeDto);
                List idList = batch.stream().map(BaseEo::getId).collect(Collectors.toList());
                if (success) {
                    log.info("\u5206\u6279\u63a8\u9001\u8bb0\u8d26\u72b6\u6001\u4ea4\u6613\u6d88\u606f\u6210\u529f: orderType={}, \u6279\u6b21={}/{}, \u603b\u6570={}, \u5f53\u524d\u6279\u6b21\u6570\u91cf={}", new Object[]{k, currentBatchIndex, batchList.size(), v.size(), batch.size()});
                    this.keepAccountsDetailDas.batchUpdateSynchronizationAction(idList, "yes");
                    continue;
                }
                log.info("\u5206\u6279\u63a8\u9001\u8bb0\u8d26\u72b6\u6001\u4ea4\u6613\u6d88\u606f\u5931\u8d25: orderType={}, \u6279\u6b21={}/{}, \u603b\u6570={}, \u5f53\u524d\u6279\u6b21\u6570\u91cf={}, idList={}", new Object[]{k, currentBatchIndex, batchList.size(), v.size(), batch.size(), idList});
            }
        });
    }

    public boolean sendOrderCancelResult(PushStatusToTradeDto pushStatusToTradeDto) {
        log.info("\u63a8\u9001\u8ba2\u5355\u72b6\u6001\u4ea4\u6613\u4fe1\u606f: size={}, {}", (Object)pushStatusToTradeDto.getDetailDtos().size(), (Object)JSON.toJSONString((Object)pushStatusToTradeDto));
        MessageVo message = new MessageVo();
        message.setCenterType("\u4ea4\u6613\u4e2d\u5fc3");
        message.setSingleOr("\u5355\u53d1");
        message.setData((Object)JSON.toJSONString((Object)pushStatusToTradeDto));
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("PUSH_STATUS_TO_TRADE", (Object)message);
        log.info("\u63a8\u9001\u54cd\u5e94\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)messageResponse));
        return Objects.equals(messageResponse.getresultCode(), 0) && !Objects.equals(messageResponse.getResultMsg(), "error");
    }
}

