/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yunxi.dg.base.center.finance.convert.entity.PushKeepInternalOrderConverter;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepInternalOrderDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepInternalOrderDetailDas;
import com.yunxi.dg.base.center.finance.dao.mapper.PushKeepInternalOrderDetailMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.PushKeepInternalOrderMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IPushKeepInternalOrderDomain;
import com.yunxi.dg.base.center.finance.dto.entity.KeepAccountsDetailDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepAccountsDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepInternalOrderDetailDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepInternalOrderDetailReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepInternalOrderDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepInternalOrderPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepInternalOrderReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepInternalUpdateOrderDto;
import com.yunxi.dg.base.center.finance.dto.enums.AccountRuleEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InternalOrderTypeEnum;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepInternalOrderDetailEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepInternalOrderEo;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepAccountsService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepInternalOrderService;
import com.yunxi.dg.base.center.finance.service.utils.TradeUtil;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PushKeepInternalOrderServiceImpl
extends BaseServiceImpl<PushKeepInternalOrderDto, PushKeepInternalOrderEo, IPushKeepInternalOrderDomain>
implements IPushKeepInternalOrderService {
    private static final Logger log = LoggerFactory.getLogger(PushKeepInternalOrderServiceImpl.class);
    @Resource
    private IPushKeepInternalOrderDas internalOrderDas;
    @Resource
    private IPushKeepInternalOrderDetailDas internalOrderDetailDas;
    @Resource
    private PushKeepInternalOrderMapper internalOrderMapper;
    @Resource
    private PushKeepInternalOrderDetailMapper internalOrderDetailMapper;
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;
    @Resource
    private IPushKeepAccountsDas pushKeepAccountsDas;
    @Resource
    private IPushKeepAccountsService pushKeepAccountsService;
    public static final ThreadPoolExecutor ACCOUNT_EXECUTOR = new ThreadPoolExecutor(Math.max(2, Runtime.getRuntime().availableProcessors() + 1), Math.max(2, Runtime.getRuntime().availableProcessors() + 1) * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNameFormat("PushKeepInternalOrder-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public PushKeepInternalOrderServiceImpl(IPushKeepInternalOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<PushKeepInternalOrderDto, PushKeepInternalOrderEo> converter() {
        return PushKeepInternalOrderConverter.INSTANCE;
    }

    @Override
    public Long insert(PushKeepInternalOrderReqDto dto) {
        log.info("\u65b0\u589e\u5185\u90e8\u4ea4\u6613\u5355\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        String type = dto.getChargeAmount().compareTo(BigDecimal.ZERO) > 0 ? dto.getVoucherType() + "-" + dto.getStepOrgTrade() + "-" + dto.getOrderType() + "-1" : (dto.getChargeAmount().compareTo(BigDecimal.ZERO) < 0 ? dto.getVoucherType() + "-" + dto.getStepOrgTrade() + "-" + dto.getOrderType() + "--1" : dto.getVoucherType() + "-" + dto.getStepOrgTrade() + "-" + dto.getOrderType() + "-0");
        log.info("\u5224\u65ad\u51fa\u6765\u7684type\u4e3a\uff1a{}", (Object)type);
        this.handelInternalOrderType(type, dto);
        return 1L;
    }

    @Override
    public List<PushKeepInternalOrderDto> list(PushKeepInternalOrderPageReqDto dto) {
        log.info("\u67e5\u8be2\u5217\u8868\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PushKeepInternalOrderEo eo = new PushKeepInternalOrderEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
        eo.setDr(0);
        List pushKeepInternalOrderEos = this.internalOrderDas.selectList((BaseEo)eo);
        if (CollectionUtil.isEmpty((Collection)pushKeepInternalOrderEos)) {
            return Lists.newArrayList();
        }
        List internalNos = pushKeepInternalOrderEos.stream().map(PushKeepInternalOrderEo::getInternalNo).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"internal_no", internalNos);
        queryWrapper.eq((Object)"dr", (Object)0);
        List pushKeepInternalOrderDetailEos = this.internalOrderDetailMapper.selectList((Wrapper)queryWrapper);
        Map<String, List<PushKeepInternalOrderDetailEo>> maps = pushKeepInternalOrderDetailEos.stream().collect(Collectors.groupingBy(PushKeepInternalOrderDetailEo::getInternalNo));
        log.info("\u8f6c\u6362\u51fa\u6765\u7684\u660e\u7ec6\u4e3a\uff1a{}", (Object)JSON.toJSONString(maps));
        ArrayList result = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)result, (Collection)pushKeepInternalOrderEos, PushKeepInternalOrderDto.class);
        for (PushKeepInternalOrderDto pushKeepInternalOrderDto : result) {
            pushKeepInternalOrderDto.setOrderTypeName(BillTypeEnum.getDesc((String)pushKeepInternalOrderDto.getOrderType()));
            pushKeepInternalOrderDto.setVoucherTypeName("0".equals(pushKeepInternalOrderDto.getVoucherType()) ? "\u4ea4\u8d27\u51ed\u8bc1" : "\u5f00\u7968\u51ed\u8bc1");
            pushKeepInternalOrderDto.setOrderPathName(0 == pushKeepInternalOrderDto.getOrderPath() ? "\u6b63\u5411" : "\u9006\u5411");
            pushKeepInternalOrderDto.setInternalOrderTypeName(InternalOrderTypeEnum.getNameByCode((String)pushKeepInternalOrderDto.getInternalOrderType()));
            List<PushKeepInternalOrderDetailEo> detailEos = maps.get(pushKeepInternalOrderDto.getInternalNo());
            if (CollectionUtil.isEmpty(detailEos)) continue;
            ArrayList detailDtos = new ArrayList();
            CubeBeanUtils.copyCollection(detailDtos, detailEos, PushKeepInternalOrderDetailDto.class);
            for (PushKeepInternalOrderDetailDto detailDto : detailDtos) {
                detailDto.setOrderTypeName(BillTypeEnum.getDesc((String)detailDto.getOrderType()));
                detailDto.setVoucherTypeName("0".equals(detailDto.getVoucherType()) ? "\u4ea4\u8d27\u51ed\u8bc1" : "\u5f00\u7968\u51ed\u8bc1");
                detailDto.setOrderPathName(0 == detailDto.getOrderPath() ? "\u6b63\u5411" : "\u9006\u5411");
                detailDto.setInternalOrderTypeName(InternalOrderTypeEnum.getNameByCode((String)detailDto.getInternalOrderType()));
            }
            pushKeepInternalOrderDto.setDtos(detailDtos);
        }
        return result;
    }

    public void updateKeepAccounts(PushKeepInternalOrderEo pushKeepInternalOrderEo, PushKeepInternalUpdateOrderDto dto) {
        boolean action;
        log.info("\u66f4\u65b0\u8bb0\u8d26\u660e\u7ec6\u6570\u636e\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)pushKeepInternalOrderEo), (Object)JSON.toJSONString((Object)dto));
        String internalOrderType = pushKeepInternalOrderEo.getInternalOrderType();
        String chargeNo = pushKeepInternalOrderEo.getChargeNo();
        KeepAccountsDetailDto keepAccountsDetailDto = new KeepAccountsDetailDto();
        List keepAccountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"charge_code", (Object)chargeNo)).list();
        PushKeepAccountsDto pushKeepAccountsDto = new PushKeepAccountsDto();
        List pushKeepAccountsEos = ((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().eq((Object)"charge_code", (Object)chargeNo)).list();
        switch (InternalOrderTypeEnum.getByCode((String)internalOrderType)) {
            case XF_SALES_ORDER: 
            case USE_DELIVERY_ORDER: 
            case USE_INBOUND_ORDER: 
            case XF_SALES_RETURN_ORDER: {
                keepAccountsDetailDto.setXfSalesOrderNo(dto.getFinanceOrderNo());
                pushKeepAccountsDto.setXfSalesOrderNo(dto.getFinanceOrderNo());
                break;
            }
            case XF_PURCHASE_ORDER: 
            case XF_STOCK_RETURN_ORDER: {
                keepAccountsDetailDto.setXfPurchaseOrderNo(dto.getFinanceOrderNo());
                pushKeepAccountsDto.setXfPurchaseOrderNo(dto.getFinanceOrderNo());
                break;
            }
            case GROUP_PURCHASE_ORDER: 
            case GROUP_SALES_RETURN_ORDER: {
                keepAccountsDetailDto.setGroupPurchaseOrderNo(dto.getFinanceOrderNo());
                pushKeepAccountsDto.setGroupPurchaseOrderNo(dto.getFinanceOrderNo());
                break;
            }
            case XF_RECEIVE_ORDER: {
                keepAccountsDetailDto.setXfReceiveOrderNo(dto.getFinanceOrderNo());
                pushKeepAccountsDto.setXfReceiveOrderNo(dto.getFinanceOrderNo());
                break;
            }
            case GROUP_RECEIVE_ORDER: {
                keepAccountsDetailDto.setGroupReceiveOrder(dto.getFinanceOrderNo());
                pushKeepAccountsDto.setGroupReceiveOrder(dto.getFinanceOrderNo());
            }
        }
        List pushKeepInternalOrderEos = ((ExtQueryChainWrapper)this.internalOrderDas.filter().eq((Object)"charge_no", (Object)chargeNo)).list();
        int size = pushKeepInternalOrderEos.stream().filter(e -> null != e.getChargeResult()).collect(Collectors.toList()).size();
        boolean bl = action = size == pushKeepInternalOrderEos.size();
        if (action) {
            keepAccountsDetailDto.setCompleteTime(dto.getFinanceChargeDate());
            keepAccountsDetailDto.setAccountingCompleteTime(dto.getFinanceChargeDate());
            pushKeepAccountsDto.setCompleteTime(dto.getFinanceChargeDate());
            pushKeepAccountsDto.setAccountingCompleteTime(dto.getFinanceChargeDate());
            List chrageResult = pushKeepInternalOrderEos.stream().map(PushKeepInternalOrderEo::getChargeResult).distinct().collect(Collectors.toList());
            if (chrageResult.size() == 1) {
                keepAccountsDetailDto.setAccountingResult((String)chrageResult.get(0));
                pushKeepAccountsDto.setAccountingResult((String)chrageResult.get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getChargeFailReason()) || dto.getChargeResult().equals(AccountRuleEnum.ACCOUNT_FAIL.getCode())) {
            pushKeepAccountsDto.setReason(dto.getChargeFailReason());
            pushKeepAccountsDto.setAccountingResult(AccountRuleEnum.ACCOUNT_FAIL.getCode());
            keepAccountsDetailDto.setAccountingResult(AccountRuleEnum.ACCOUNT_FAIL.getCode());
        } else {
            List internalOrderEoList = ((ExtQueryChainWrapper)this.internalOrderDas.filter().eq((Object)"charge_no", (Object)chargeNo)).list();
            if (internalOrderEoList.stream().allMatch(a -> StringUtils.isBlank((CharSequence)a.getChargeResult()))) {
                pushKeepAccountsDto.setReason(null);
                pushKeepAccountsDto.setAccountingResult(AccountRuleEnum.PUSHING.getCode());
                keepAccountsDetailDto.setAccountingResult(AccountRuleEnum.PUSHING.getCode());
            } else if (internalOrderEoList.stream().allMatch(a -> a.getChargeResult().equals(AccountRuleEnum.ACCOUNT_SUCCESS.getCode()))) {
                pushKeepAccountsDto.setReason(null);
                pushKeepAccountsDto.setAccountingResult(AccountRuleEnum.ACCOUNT_SUCCESS.getCode());
                pushKeepAccountsDto.setAccountingCompleteTime(dto.getFinanceChargeDate());
                keepAccountsDetailDto.setAccountingResult(AccountRuleEnum.ACCOUNT_SUCCESS.getCode());
                keepAccountsDetailDto.setAccountingCompleteTime(dto.getFinanceChargeDate());
            } else {
                List failList = internalOrderEoList.stream().filter(f -> f.getChargeResult() != null && f.getChargeResult().equals(AccountRuleEnum.ACCOUNT_FAIL.getCode())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(failList)) {
                    pushKeepAccountsDto.setReason(((PushKeepInternalOrderEo)failList.get(0)).getChargeFailReason());
                    pushKeepAccountsDto.setAccountingResult(AccountRuleEnum.ACCOUNT_FAIL.getCode());
                    keepAccountsDetailDto.setAccountingResult(AccountRuleEnum.ACCOUNT_FAIL.getCode());
                } else {
                    List otherList = internalOrderEoList.stream().filter(f -> f.getChargeResult() != null && !f.getChargeResult().equals(AccountRuleEnum.ACCOUNT_SUCCESS.getCode())).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(otherList)) {
                        pushKeepAccountsDto.setAccountingResult(((PushKeepInternalOrderEo)otherList.get(0)).getChargeResult());
                        keepAccountsDetailDto.setAccountingResult(((PushKeepInternalOrderEo)otherList.get(0)).getChargeResult());
                    }
                }
            }
        }
        this.keepAccountsDetailDas.updateAccountOutSideNumber(keepAccountsDetailEos, keepAccountsDetailDto);
        this.pushKeepAccountsDas.updateAccountOutSideNumber(pushKeepAccountsEos, pushKeepAccountsDto);
        try {
            this.pushKeepAccountsService.afterSendMqBySaleSuccess((PushKeepAccountsEo)pushKeepAccountsEos.get(0));
        }
        catch (Exception e2) {
            log.error("\u9500\u552e\u5355\u8bb0\u8d26\u6210\u529f\uff0c\u89e6\u53d1\u6ca1\u6709\u8bb0\u8d26\u6210\u529f\u7684\u9006\u5411\u5355\u636e\u8fdb\u884c\u8bb0\u8d26\u5f02\u5e38\uff1a{}", (Object)e2.getMessage());
            log.error(e2.getMessage(), (Throwable)e2);
        }
        this.pushKeepAccountsService.invoiceAccountingWhenSuccess((PushKeepAccountsEo)pushKeepAccountsEos.get(0));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updateByInternalNo(String internalNo, PushKeepInternalUpdateOrderDto dto) {
        log.info("\u6839\u636e\u4ea4\u6613\u5355\u53f7\u66f4\u65b0\u6570\u636e\uff1a{}\uff0c {}", (Object)internalNo, (Object)JSON.toJSONString((Object)dto));
        PushKeepInternalOrderEo eo = new PushKeepInternalOrderEo();
        eo.setDr(0);
        eo.setInternalNo(internalNo);
        PushKeepInternalOrderEo pushKeepInternalOrderEo = (PushKeepInternalOrderEo)this.internalOrderDas.selectOne((BaseEo)eo);
        if (Objects.isNull(pushKeepInternalOrderEo)) {
            throw new BizException("\u672a\u627e\u5230\u5bf9\u5e94\u5185\u90e8\u4ea4\u6613\u5355\uff01{}", internalNo);
        }
        PushKeepInternalOrderEo updateEo = new PushKeepInternalOrderEo();
        if (StrUtil.isNotBlank((CharSequence)dto.getFinanceOrderNo())) {
            updateEo.setFinanceOrderNo(dto.getFinanceOrderNo());
        }
        if (Objects.nonNull(dto.getFinanceChargeDate())) {
            updateEo.setFinanceChargeDate(dto.getFinanceChargeDate());
        }
        if (StrUtil.isNotBlank((CharSequence)dto.getChargeResult())) {
            updateEo.setChargeResult(dto.getChargeResult());
        }
        if (StrUtil.isNotBlank((CharSequence)dto.getChargeFailReason())) {
            updateEo.setChargeFailReason(dto.getChargeFailReason());
        }
        if (StrUtil.isNotBlank((CharSequence)dto.getMessageNo())) {
            updateEo.setMessageNo(dto.getMessageNo());
        }
        PushKeepInternalOrderDetailEo detailEo = new PushKeepInternalOrderDetailEo();
        detailEo.setDr(0);
        detailEo.setInternalOrderId(pushKeepInternalOrderEo.getId());
        List pushKeepInternalOrderDetailEos = this.internalOrderDetailDas.selectList((BaseEo)detailEo);
        ArrayList<PushKeepInternalOrderDetailEo> updateList = new ArrayList<PushKeepInternalOrderDetailEo>();
        for (PushKeepInternalOrderDetailEo pushKeepInternalOrderDetailEo : pushKeepInternalOrderDetailEos) {
            PushKeepInternalOrderDetailEo updateDetailEo = new PushKeepInternalOrderDetailEo();
            updateDetailEo.setId(pushKeepInternalOrderDetailEo.getId());
            updateDetailEo.setFinanceOrderNo(StrUtil.isNotBlank((CharSequence)dto.getFinanceOrderNo()) ? dto.getFinanceOrderNo() : pushKeepInternalOrderDetailEo.getFinanceOrderNo());
            updateDetailEo.setFinanceChargeDate(Objects.nonNull(dto.getFinanceChargeDate()) ? dto.getFinanceChargeDate() : pushKeepInternalOrderDetailEo.getFinanceChargeDate());
            updateDetailEo.setChargeResult(StrUtil.isNotBlank((CharSequence)dto.getChargeResult()) ? dto.getChargeResult() : pushKeepInternalOrderDetailEo.getChargeResult());
            updateDetailEo.setChargeFailReason(StrUtil.isNotBlank((CharSequence)dto.getChargeFailReason()) ? dto.getChargeFailReason() : pushKeepInternalOrderDetailEo.getChargeFailReason());
            updateList.add(updateDetailEo);
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        updateWrapper.eq((Object)"id", (Object)pushKeepInternalOrderEo.getId());
        if (AccountRuleEnum.ACCOUNT_SUCCESS.getCode().equals(dto.getChargeResult())) {
            updateWrapper.set((Object)"charge_fail_reason", null);
            updateEo.setCompleteDate(new Date());
        }
        ((IPushKeepInternalOrderDomain)this.domain).getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
        this.updatePushKeepInternalOrderDetail(updateList);
        PushKeepInternalOrderEo finalPushKeepInternalOrderEo = pushKeepInternalOrderEo = (PushKeepInternalOrderEo)this.internalOrderDas.selectOne((BaseEo)eo);
        HashMap objs = new HashMap(ServiceContext.getContext().getAttachments());
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : objs.entrySet()) {
                ServiceContext.getContext().setAttachment((String)entry.getKey(), (String)entry.getValue());
            }
            MDC.put((String)"yes.req.requestId", (String)reqId);
            this.updateKeepAccounts(finalPushKeepInternalOrderEo, dto);
        }, ACCOUNT_EXECUTOR);
        return new RestResponse();
    }

    public void updatePushKeepInternalOrderDetail(List<PushKeepInternalOrderDetailEo> detailEos) {
        for (PushKeepInternalOrderDetailEo detailEo : detailEos) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            updateWrapper.eq((Object)"id", (Object)detailEo.getId());
            if (AccountRuleEnum.ACCOUNT_SUCCESS.getCode().equals(detailEo.getChargeResult())) {
                updateWrapper.set((Object)"charge_fail_reason", null);
            }
            this.internalOrderDetailMapper.update((Object)detailEo, (Wrapper)updateWrapper);
        }
    }

    @Override
    public RestResponse<Void> updateByChargeNo(String chargeNo, PushKeepInternalUpdateOrderDto dto) {
        List pushKeepInternalOrderEos = ((ExtQueryChainWrapper)this.internalOrderDas.filter().eq((Object)"charge_no", (Object)chargeNo)).list();
        if (CollectionUtil.isEmpty((Collection)pushKeepInternalOrderEos)) {
            return new RestResponse();
        }
        log.info("\u6839\u636e\u8bb0\u8d26\u5355\u597d\u66f4\u65b0\u6570\u636e\uff1a{}\uff0c {}", (Object)chargeNo, (Object)JSON.toJSONString((Object)dto));
        if (StrUtil.isBlank((CharSequence)chargeNo)) {
            throw new BizException("\u66f4\u65b0\u5f02\u5e38\uff0c\u8bb0\u8d26\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        UpdateWrapper detailEoUpdateWrapper = new UpdateWrapper();
        if (StrUtil.isNotBlank((CharSequence)dto.getFinanceOrderNo())) {
            updateWrapper.set((Object)"finance_order_no", (Object)dto.getFinanceOrderNo());
            detailEoUpdateWrapper.set((Object)"finance_order_no", (Object)dto.getFinanceOrderNo());
        }
        if (Objects.nonNull(dto.getFinanceChargeDate())) {
            updateWrapper.set((Object)"finance_charge_date", (Object)dto.getFinanceChargeDate());
            detailEoUpdateWrapper.set((Object)"finance_charge_date", (Object)dto.getFinanceChargeDate());
        }
        if (StrUtil.isNotBlank((CharSequence)dto.getChargeResult())) {
            updateWrapper.set((Object)"charge_result", (Object)dto.getChargeResult());
            detailEoUpdateWrapper.set((Object)"charge_result", (Object)dto.getChargeResult());
        }
        if (StrUtil.isNotBlank((CharSequence)dto.getChargeFailReason())) {
            updateWrapper.set((Object)"charge_fail_reason", (Object)dto.getChargeFailReason());
            detailEoUpdateWrapper.set((Object)"charge_fail_reason", (Object)dto.getChargeFailReason());
        }
        updateWrapper.eq((Object)"charge_no", (Object)chargeNo);
        detailEoUpdateWrapper.eq((Object)"charge_no", (Object)chargeNo);
        this.internalOrderMapper.update(null, (Wrapper)updateWrapper);
        this.internalOrderDetailMapper.update(null, (Wrapper)detailEoUpdateWrapper);
        return new RestResponse();
    }

    @Override
    public PageInfo<PushKeepInternalOrderDto> page(PushKeepInternalOrderPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List list = this.internalOrderMapper.list(dto);
        for (PushKeepInternalOrderDto pushKeepInternalOrderDto : list) {
            pushKeepInternalOrderDto.setOrderTypeName(BillTypeEnum.getDesc((String)pushKeepInternalOrderDto.getOrderType()));
            pushKeepInternalOrderDto.setVoucherTypeName("0".equals(pushKeepInternalOrderDto.getVoucherType()) ? "\u4ea4\u8d27\u51ed\u8bc1" : "\u5f00\u7968\u51ed\u8bc1");
            pushKeepInternalOrderDto.setOrderPathName(0 == pushKeepInternalOrderDto.getOrderPath() ? "\u6b63\u5411" : "\u9006\u5411");
            pushKeepInternalOrderDto.setInternalOrderTypeName(InternalOrderTypeEnum.getNameByCode((String)pushKeepInternalOrderDto.getInternalOrderType()));
        }
        return new PageInfo(list);
    }

    @Override
    public List<PushKeepInternalOrderDetailDto> listByDetail(Long id) {
        PushKeepInternalOrderDetailEo detailEo = new PushKeepInternalOrderDetailEo();
        detailEo.setInternalOrderId(id);
        detailEo.setDr(0);
        List pushKeepInternalOrderDetailEos = this.internalOrderDetailDas.selectList((BaseEo)detailEo);
        ArrayList<PushKeepInternalOrderDetailDto> list = new ArrayList<PushKeepInternalOrderDetailDto>();
        if (CollectionUtil.isNotEmpty((Collection)pushKeepInternalOrderDetailEos)) {
            CubeBeanUtils.copyCollection(list, (Collection)pushKeepInternalOrderDetailEos, PushKeepInternalOrderDetailDto.class);
        }
        for (PushKeepInternalOrderDetailDto detailDto : list) {
            detailDto.setOrderTypeName(BillTypeEnum.getDesc((String)detailDto.getOrderType()));
            detailDto.setVoucherTypeName("0".equals(detailDto.getVoucherType()) ? "\u4ea4\u8d27\u51ed\u8bc1" : "\u5f00\u7968\u51ed\u8bc1");
            detailDto.setOrderPathName(0 == detailDto.getOrderPath() ? "\u6b63\u5411" : "\u9006\u5411");
            detailDto.setInternalOrderTypeName(InternalOrderTypeEnum.getNameByCode((String)detailDto.getInternalOrderType()));
        }
        return list;
    }

    @Override
    public void updateChargeDateByChargeNo(PushKeepInternalOrderReqDto dto) {
        log.info("\u6839\u636e\u8bb0\u8d26\u5355\u53f7\u96c6\u5408\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (CollectionUtil.isEmpty((Collection)dto.getChargeNoList()) || ObjectUtil.isEmpty((Object)dto.getChargeDate())) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
            return;
        }
        List internalOrderEoList = ((ExtQueryChainWrapper)this.internalOrderDas.filter().in((Object)"charge_no", (Collection)dto.getChargeNoList())).list();
        if (CollectionUtil.isNotEmpty((Collection)internalOrderEoList)) {
            internalOrderEoList.forEach(eo -> {
                PushKeepInternalOrderEo internalOrderEo = new PushKeepInternalOrderEo();
                internalOrderEo.setId(eo.getId());
                internalOrderEo.setChargeDate(dto.getChargeDate());
                this.internalOrderDas.updateSelective((BaseEo)internalOrderEo);
            });
        }
    }

    private void handelInternalOrderType(String type, PushKeepInternalOrderReqDto dto) {
        switch (type) {
            case "0-1-SALE_LIST-1": {
                this.handelInternalOrder(InternalOrderTypeEnum.XF_SALES_ORDER.getCode(), dto);
                this.handelInternalOrder(InternalOrderTypeEnum.XF_PURCHASE_ORDER.getCode(), dto);
                this.handelInternalOrder(InternalOrderTypeEnum.GROUP_PURCHASE_ORDER.getCode(), dto);
                break;
            }
            case "0-1-SALE_LIST-0": {
                this.handelInternalOrder(InternalOrderTypeEnum.USE_DELIVERY_ORDER.getCode(), dto);
                this.handelInternalOrder(InternalOrderTypeEnum.XF_PURCHASE_ORDER.getCode(), dto);
                this.handelInternalOrder(InternalOrderTypeEnum.GROUP_PURCHASE_ORDER.getCode(), dto);
                break;
            }
            case "0-1-RETURN_BASE-1": 
            case "0-1-EXCHANGE-1": {
                this.handelInternalOrder(InternalOrderTypeEnum.XF_SALES_RETURN_ORDER.getCode(), dto);
                this.handelInternalOrder(InternalOrderTypeEnum.XF_STOCK_RETURN_ORDER.getCode(), dto);
                this.handelInternalOrder(InternalOrderTypeEnum.GROUP_SALES_RETURN_ORDER.getCode(), dto);
                break;
            }
            case "0-1-RETURN_BASE-0": 
            case "0-1-EXCHANGE-0": {
                this.handelInternalOrder(InternalOrderTypeEnum.USE_INBOUND_ORDER.getCode(), dto);
                this.handelInternalOrder(InternalOrderTypeEnum.XF_STOCK_RETURN_ORDER.getCode(), dto);
                this.handelInternalOrder(InternalOrderTypeEnum.GROUP_SALES_RETURN_ORDER.getCode(), dto);
                break;
            }
            case "0-0-SALE_LIST-1": {
                this.handelInternalOrder(InternalOrderTypeEnum.XF_SALES_ORDER.getCode(), dto);
                break;
            }
            case "0-0-SALE_LIST-0": {
                this.handelInternalOrder(InternalOrderTypeEnum.USE_DELIVERY_ORDER.getCode(), dto);
                break;
            }
            case "0-0-RETURN_BASE-1": 
            case "0-0-EXCHANGE-1": {
                this.handelInternalOrder(InternalOrderTypeEnum.XF_SALES_RETURN_ORDER.getCode(), dto);
                break;
            }
            case "0-0-RETURN_BASE-0": 
            case "0-0-EXCHANGE-0": {
                this.handelInternalOrder(InternalOrderTypeEnum.USE_INBOUND_ORDER.getCode(), dto);
                break;
            }
            case "1-1-SALE_LIST-1": 
            case "1-1-RETURN_BASE-1": 
            case "1-1-EXCHANGE-1": {
                this.handelInternalOrder(InternalOrderTypeEnum.XF_RECEIVE_ORDER.getCode(), dto);
                this.handelInternalOrder(InternalOrderTypeEnum.GROUP_RECEIVE_ORDER.getCode(), dto);
                break;
            }
            case "1-1-SALE_LIST-0": 
            case "1-1-RETURN_BASE-0": 
            case "1-1-EXCHANGE-0": {
                this.handelInternalOrder(InternalOrderTypeEnum.GROUP_RECEIVE_ORDER.getCode(), dto);
                break;
            }
            case "1-1-DELIVERY_REFUND_ONLY-1": 
            case "1-0-SALE_LIST-1": 
            case "1-0-RETURN_BASE-1": 
            case "1-0-EXCHANGE-1": {
                this.handelInternalOrder(InternalOrderTypeEnum.XF_RECEIVE_ORDER.getCode(), dto);
            }
        }
    }

    private void handelInternalOrder(String type, PushKeepInternalOrderReqDto dto) {
        log.info("\u5904\u7406\u5185\u90e8\u4ea4\u6613\u5355\uff1a{}\uff0c{}", (Object)type, (Object)JSON.toJSONString((Object)dto));
        PushKeepInternalOrderEo eo = new PushKeepInternalOrderEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
        eo.setInternalOrderType(type);
        switch (type) {
            case "XF_SALES_ORDER": 
            case "XF_SALES_RETURN_ORDER": 
            case "XF_RECEIVE_ORDER": {
                eo.setBuyId(dto.getCustomerId());
                eo.setBuyCode(dto.getCustomerCode());
                eo.setBuyName(dto.getCustomerName());
                eo.setBuyType("0");
                eo.setSellId(dto.getOrgId());
                eo.setSellCode(dto.getOrgCode());
                eo.setSellName(dto.getOrgName());
                eo.setSellType("1");
                eo.setTotalAmount(dto.getChargeAmount());
                break;
            }
            case "USE_INBOUND_ORDER": 
            case "USE_DELIVERY_ORDER": {
                eo.setBuyId(dto.getCustomerId());
                eo.setBuyCode(dto.getCustomerCode());
                eo.setBuyName(dto.getCustomerName());
                eo.setBuyType("0");
                eo.setSellId(dto.getOrgId());
                eo.setSellCode(dto.getOrgCode());
                eo.setSellName(dto.getOrgName());
                eo.setSellType("1");
                eo.setTotalAmount(new BigDecimal(0));
                break;
            }
            case "XF_PURCHASE_ORDER": 
            case "GROUP_PURCHASE_ORDER": {
                eo.setBuyId(dto.getOrgId());
                eo.setBuyCode(dto.getOrgCode());
                eo.setBuyName(dto.getOrgName());
                eo.setBuyType("1");
                eo.setSellId(dto.getCargoOrgId());
                eo.setSellCode(dto.getCargoOrgCode());
                eo.setSellName(dto.getCargoOrgName());
                eo.setSellType("1");
                eo.setTotalAmount(dto.getPurchasePrice());
                break;
            }
            case "XF_STOCK_RETURN_ORDER": 
            case "GROUP_SALES_RETURN_ORDER": {
                eo.setBuyId(dto.getOrgId());
                eo.setBuyCode(dto.getOrgCode());
                eo.setBuyName(dto.getOrgName());
                eo.setBuyType("1");
                eo.setSellId(dto.getReturnCargoOrgId());
                eo.setSellCode(dto.getReturnCargoOrgCode());
                eo.setSellName(dto.getReturnCargoOrgName());
                eo.setSellType("1");
                eo.setTotalAmount(dto.getPurchasePrice());
                break;
            }
            case "GROUP_RECEIVE_ORDER": {
                eo.setBuyId(dto.getOrgId());
                eo.setBuyCode(dto.getOrgCode());
                eo.setBuyName(dto.getOrgName());
                eo.setBuyType("1");
                if (dto.getOrderPath() == 0) {
                    eo.setSellId(dto.getCargoOrgId());
                    eo.setSellCode(dto.getCargoOrgCode());
                    eo.setSellName(dto.getCargoOrgName());
                } else {
                    eo.setSellId(dto.getReturnCargoOrgId());
                    eo.setSellCode(dto.getReturnCargoOrgCode());
                    eo.setSellName(dto.getReturnCargoOrgName());
                }
                eo.setSellType("1");
                eo.setTotalAmount(dto.getPurchasePrice());
            }
        }
        String innerCode = TradeUtil.genCode("TO", 6);
        eo.setInternalNo(innerCode);
        eo.setGenerateTime(new Date());
        log.info("\u65b0\u589e\u5185\u90e8\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)eo));
        this.internalOrderDas.insert((BaseEo)eo);
        int i = 1;
        for (PushKeepInternalOrderDetailReqDto detailReqDto : dto.getDtos()) {
            PushKeepInternalOrderDetailEo detailEo = new PushKeepInternalOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)eo, (String[])new String[0]);
            detailEo.setId(null);
            detailEo.setInternalOrderId(eo.getId());
            detailEo.setSkuId(detailReqDto.getSkuId());
            detailEo.setSkuCode(detailReqDto.getSkuCode());
            detailEo.setSkuName(detailReqDto.getSkuName());
            detailEo.setItemNum(detailReqDto.getItemNum());
            detailEo.setItemUnit(detailReqDto.getItemUnit());
            if (InternalOrderTypeEnum.isNeedPurchasePrice((String)type)) {
                detailEo.setItemPrice(detailReqDto.getItemPurchasePrice());
                detailEo.setTotalAmount(detailReqDto.getItemPurchaseTotalAmount());
            } else {
                detailEo.setItemPrice(detailReqDto.getItemPrice());
                detailEo.setTotalAmount(detailReqDto.getTotalAmount());
            }
            detailEo.setExtension(detailReqDto.getExtension());
            detailEo.setLineNum(Integer.valueOf(i++));
            log.info("\u65b0\u589e\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)detailEo));
            this.internalOrderDetailDas.insert((BaseEo)detailEo);
        }
    }
}

