/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.cube.center.account.proxy.IAccountAugmentOrderApiProxy;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.customer.dao.das.IDgCsOrgCustomerRelationDas;
import com.yunxi.dg.base.center.finance.dao.das.IAccountAugmentOrderDas;
import com.yunxi.dg.base.center.finance.domain.entity.IAccountDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IAccountFlowDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ICsCustomerAreaDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ICsRRelationShopDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ICustomerDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationAccountRangeDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationBillDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationBillDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationCustomerConditionDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationDataRangeDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationOrderAreaDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationOrderDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationOrderTotalDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationRejectCustomerDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationRuleDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationShopCustomerDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IShopDomain;
import com.yunxi.dg.base.center.finance.dto.entity.AccountDto;
import com.yunxi.dg.base.center.finance.dto.entity.AccountFlowDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsOrgCustomerRelationPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsRRelationShopDto;
import com.yunxi.dg.base.center.finance.dto.entity.CustomerDto;
import com.yunxi.dg.base.center.finance.dto.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.finance.dto.entity.GenerateReconciliationReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationRuleDto;
import com.yunxi.dg.base.center.finance.dto.entity.ShopDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillsTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.dto.enums.ReconciliationBillStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.ReconciliationOrderTypeEnum;
import com.yunxi.dg.base.center.finance.eo.AccountAugmentOrderEo;
import com.yunxi.dg.base.center.finance.eo.AccountEo;
import com.yunxi.dg.base.center.finance.eo.AccountFlowEo;
import com.yunxi.dg.base.center.finance.eo.CsCustomerAreaEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationAccountRangeEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationBillDetailEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationBillEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationCustomerConditionEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationDataRangeEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationOrderAreaEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationOrderEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationOrderTotalEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationRejectCustomerEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationShopCustomerEo;
import com.yunxi.dg.base.center.finance.service.entity.IDgOrgCustomerRelationService;
import com.yunxi.dg.base.center.finance.service.entity.IReconciliationService;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.generate.IGenerateCodeService;
import com.yunxi.dg.base.center.finance.service.utils.DateUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ReconciliationServiceImpl
implements IReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationServiceImpl.class);
    private static final String CREATE_RECONCILIATION_TABLENAME = "CREATE_RECONCILIATION_TABLENAME";
    @Resource
    private IReconciliationRuleDomain ruleDomain;
    @Resource
    private IReconciliationShopCustomerDomain shopCustomerDomain;
    @Resource
    private IReconciliationCustomerConditionDomain customerConditionDomain;
    @Resource
    private IReconciliationRejectCustomerDomain rejectCustomerDomain;
    @Resource
    private IShopDomain shopDomain;
    @Resource
    private ICustomerDomain customerDomain;
    @Resource
    private IReconciliationOrderDomain orderDomain;
    @Resource
    private ICsRRelationShopDomain relationShopDomain;
    @Resource
    private IReconciliationBillDomain billDomain;
    @Resource
    private IReconciliationDataRangeDomain dataRangeDomain;
    @Resource
    private IAccountDomain accountDomain;
    @Resource
    private ICsCustomerAreaDomain iDgCustomerAreaDomain;
    @Resource
    private IReconciliationOrderAreaDomain orderAreaDomain;
    @Resource
    private IAccountFlowDomain accountFlowDomain;
    @Resource
    private IAccountAugmentOrderApiProxy proxy;
    @Resource
    private IReconciliationOrderDetailDomain orderDetailDomain;
    @Resource
    private IReconciliationAccountRangeDomain accountRangeDomain;
    @Resource
    private IReconciliationOrderTotalDomain orderTotalDomain;
    @Resource
    private IReconciliationBillDetailDomain billDetailDomain;
    @Resource
    private IDgCsOrgCustomerRelationDas customerRelationDas;
    @Resource
    private ICsRRelationShopDomain iDgCsRRelationShopDomain;
    @Resource
    private IAccountAugmentOrderDas accountAugmentOrderDas;
    @Resource
    private IDgOrgCustomerRelationService dgOrgCustomerRegionService;
    @Resource
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generateRealation(List<String> ruleCodes, boolean job) {
        Mutex mutex;
        block16: {
            mutex = null;
            mutex = this.lockService.lock(CREATE_RECONCILIATION_TABLENAME, "generateRealation:create_bills", 2, 180, TimeUnit.SECONDS);
            if (null != mutex) break block16;
            log.info("\u83b7\u53d6\u4e0d\u5230\u9501\uff0c\u8bf4\u660e\u5df2\u7ecf\u5728\u6709\u4efb\u52a1\u518d\u8dd1\u4e86\uff0c\u5c31\u4e0d\u8981\u91cd\u590d\u8dd1\u4e86");
            if (mutex == null) return;
            this.lockService.unlock(mutex);
            return;
        }
        try {
            ExtQueryChainWrapper sqlFilters = this.ruleDomain.filter();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(ruleCodes)) {
                sqlFilters.in((Object)"rule_code", ruleCodes);
            }
            String currentDate = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            sqlFilters.le((Object)"effect_begin_time", (Object)currentDate);
            StringBuilder sql = new StringBuilder();
            sql.append(" ( ");
            sql.append("effect_end_time >= '" + currentDate + "' or effect = 1");
            sql.append(")");
            sqlFilters.apply(sql.toString(), new Object[0]);
            List ruleEoList = sqlFilters.list();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)ruleEoList)) {
                log.info("\u5339\u914d\u4e0d\u5230\u5bf9\u8d26\u89c4\u5219");
            }
            ArrayList ruleDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)ruleDtoList, (Collection)ruleEoList, ReconciliationRuleDto.class);
            HashSet shopIdList = new HashSet();
            HashSet customerIdList = new HashSet();
            HashSet rejectCustomerIdList = new HashSet();
            for (ReconciliationRuleDto v : ruleDtoList) {
                List customerEos;
                List shopEos;
                List shopCustomerEos = ((ExtQueryChainWrapper)this.shopCustomerDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).list();
                List collectShopList = shopCustomerEos.stream().filter(x -> 0 == x.getApplicableRange()).collect(Collectors.toList());
                List collectCustomerList = shopCustomerEos.stream().filter(x -> 1 == x.getApplicableRange()).collect(Collectors.toList());
                List conditionEos = ((ExtQueryChainWrapper)this.customerConditionDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).list();
                List rejectCustomerEoList = ((ExtQueryChainWrapper)this.rejectCustomerDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(collectShopList)) {
                    shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"code", (Collection)collectShopList.stream().map(ReconciliationShopCustomerEo::getShopCode).distinct().collect(Collectors.toList()))).list();
                    shopIdList.addAll(shopEos.stream().map(BaseEo::getId).collect(Collectors.toSet()));
                } else {
                    shopEos = this.shopDomain.selectAll();
                    shopIdList.addAll(shopEos.stream().map(BaseEo::getId).collect(Collectors.toSet()));
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(collectCustomerList)) {
                    List customerCodes = collectCustomerList.stream().map(ReconciliationShopCustomerEo::getCustomerCode).distinct().collect(Collectors.toList());
                    List list = ((ExtQueryChainWrapper)this.customerDomain.filter().in((Object)"code", customerCodes)).list();
                    customerIdList.addAll(list.stream().map(BaseEo::getId).collect(Collectors.toSet()));
                } else {
                    customerEos = this.customerDomain.selectAll();
                    customerIdList.addAll(customerEos.stream().map(BaseEo::getId).collect(Collectors.toSet()));
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionEos)) {
                    String typeIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerTypeIds())).map(ReconciliationCustomerConditionEo::getCustomerTypeIds).distinct().collect(Collectors.joining(","));
                    String string = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerAreaCodes())).map(ReconciliationCustomerConditionEo::getCustomerAreaCodes).distinct().collect(Collectors.joining(","));
                    String levelIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerLevelIds())).map(ReconciliationCustomerConditionEo::getCustomerLevelIds).distinct().collect(Collectors.joining(","));
                    String groupIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerGroupIds())).map(ReconciliationCustomerConditionEo::getCustomerGroupIds).distinct().collect(Collectors.joining(","));
                    ArrayList custimerTypeIds = StringUtils.isBlank((CharSequence)typeIds) ? new ArrayList() : Arrays.stream(typeIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    ArrayList customerAreaIds = StringUtils.isBlank((CharSequence)string) ? new ArrayList() : Arrays.stream(string.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    ArrayList customerLevelIds = StringUtils.isBlank((CharSequence)levelIds) ? new ArrayList() : Arrays.stream(levelIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    ArrayList customerGroupIds = StringUtils.isBlank((CharSequence)groupIds) ? new ArrayList() : Arrays.stream(groupIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    CsOrgCustomerRelationPageReqDto reqDto = new CsOrgCustomerRelationPageReqDto();
                    reqDto.setCustomerTypeIds(custimerTypeIds);
                    reqDto.setAreaIds(customerAreaIds);
                    reqDto.setLevelIds(customerLevelIds);
                    reqDto.setCustomerGroupIds(customerGroupIds);
                    List customerRelationDtos = this.orderDomain.queryList(reqDto);
                    log.info("\u6307\u5b9a\u5ba2\u6237\u8303\u56f4\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerRelationDtos));
                    customerIdList.addAll(customerRelationDtos.stream().map(CsOrgCustomerRelationDto::getCustomerId).collect(Collectors.toSet()));
                }
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rejectCustomerEoList)) continue;
                customerEos = ((ExtQueryChainWrapper)this.customerDomain.filter().in((Object)"code", (Collection)rejectCustomerEoList.stream().map(ReconciliationRejectCustomerEo::getCustomerCode).distinct().collect(Collectors.toList()))).list();
                rejectCustomerIdList.addAll(customerEos.stream().map(BaseEo::getId).collect(Collectors.toSet()));
            }
            CsOrgCustomerRelationPageReqDto reqDto = new CsOrgCustomerRelationPageReqDto();
            reqDto.setShopIdList(new ArrayList(shopIdList));
            reqDto.setCustomerIdList(new ArrayList(customerIdList));
            reqDto.setRejectCustomerIdList(new ArrayList(rejectCustomerIdList));
            List<CsOrgCustomerRelationDto> orgCustomerRelationDtos = this.dgOrgCustomerRegionService.queryTobCustomerRelationPage(reqDto);
            List<ReconciliationRuleDto> ruleDtos = this.matchRuleCustomerAndShop(ruleDtoList);
            List<ReconciliationBillEo> reconciliationBillEos = this.matchRuleAndSaveReconciliationBillEo(orgCustomerRelationDtos, ruleDtos, job);
            log.info("reconciliationBillEos:{},ruleDtos\uff1a{}", (Object)reconciliationBillEos.size(), (Object)ruleDtos.size());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(reconciliationBillEos)) {
                void var20_25;
                List billDate = reconciliationBillEos.stream().map(ReconciliationBillEo::getBillDate).distinct().collect(Collectors.toList());
                List shopCodes = reconciliationBillEos.stream().map(ReconciliationBillEo::getShopCode).distinct().collect(Collectors.toList());
                List customerCodes = reconciliationBillEos.stream().map(ReconciliationBillEo::getCustomerCode).distinct().collect(Collectors.toList());
                List billEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billDomain.filter().in((Object)"shop_code", shopCodes)).in((Object)"customer_code", customerCodes)).in((Object)"bill_date", billDate)).list();
                HashMap hashMap = Maps.newHashMap();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billEoList)) {
                    Map map = billEoList.stream().collect(Collectors.toMap(x -> x.getCustomerCode() + ";" + x.getShopCode() + ";" + x.getBillDate(), Function.identity(), (k1, k2) -> k1));
                }
                ArrayList reconciliationBillEoList = Lists.newArrayList();
                ArrayList billEoIds = Lists.newArrayList();
                void finalBillEoMap = var20_25;
                reconciliationBillEos.forEach(arg_0 -> ReconciliationServiceImpl.lambda$generateRealation$12((Map)finalBillEoMap, billEoIds, reconciliationBillEoList, arg_0));
                if (job && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billEoIds)) {
                    this.billDomain.logicDeleteByIds((List)billEoIds);
                }
                if (!job) {
                    this.billDomain.getMapper().update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ReconciliationBillEo.class).in(ReconciliationBillEo::getStatus, (Collection)Lists.newArrayList((Object[])new String[]{"NOT_GERERATE", "CLOSE"}))).eq(BaseEo::getDr, (Object)0)).set(BaseEo::getDr, (Object)1));
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reconciliationBillEoList)) {
                    this.billDomain.insertBatch((List)reconciliationBillEoList);
                }
            }
            if (mutex == null) return;
        }
        catch (Throwable throwable) {
            if (mutex == null) throw throwable;
            this.lockService.unlock(mutex);
            throw throwable;
        }
        this.lockService.unlock(mutex);
    }

    private List<ReconciliationBillEo> matchRuleAndSaveReconciliationBillEo(List<CsOrgCustomerRelationDto> customerRelationDtos, List<ReconciliationRuleDto> ruleDtos, boolean job) {
        ArrayList reconciliationBillEos = Lists.newArrayList();
        String billDate = DateUtils.getPrevMonthFormat(new Date(), 1, "yyyy-MM-dd");
        customerRelationDtos.forEach(v -> {
            String customerCode = v.getCustomerCode();
            List shopList = v.getShopList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopList)) {
                log.info("\u5ba2\u6237\u5173\u7cfb\u91cc\u5e97\u94fa\u4fe1\u606f\u4e3a\u7a7a");
                return;
            }
            String shopCode = ((CsRRelationShopDto)shopList.get(0)).getShopCode();
            ReconciliationRuleDto ruleDto = this.matchRule(customerCode, shopCode, billDate, ruleDtos);
            if (Objects.isNull(ruleDto)) {
                log.info("\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u89c4\u5219");
                return;
            }
            String prevMonthFormat = billDate;
            if (!job) {
                prevMonthFormat = DateUtils.getPrevMonthFormat(ruleDto.getEffectBeginTime(), 1, "yyyy-MM-dd");
            }
            List<String> billDateList = DateUtils.getMonthBetweenFormat(prevMonthFormat, billDate, "yyyy-MM");
            for (String billDateStr : billDateList) {
                ReconciliationBillEo billEo = new ReconciliationBillEo();
                billEo.setBillDate(billDateStr);
                String days = DateUtils.getDateFormDays(DateUtils.parseStr(billDateStr, "yyyy-MM"), Convert.toInt((Object)ruleDto.getBillDay()) - 1, 1);
                billEo.setBillDay(days);
                billEo.setBillingDay(ruleDto.getBillDay());
                billEo.setShopId(((CsRRelationShopDto)shopList.get(0)).getShopId());
                billEo.setShopCode(((CsRRelationShopDto)shopList.get(0)).getShopCode());
                billEo.setShopName(((CsRRelationShopDto)shopList.get(0)).getShopName());
                billEo.setCustomerId(v.getCustomerId());
                billEo.setCustomerCode(v.getCustomerCode());
                billEo.setCustomerName(v.getCustomerName());
                billEo.setStatus("NOT_GERERATE");
                billEo.setRuleCode(ruleDto.getRuleCode());
                billEo.setRuleName(ruleDto.getRuleName());
                billEo.setConfirmBillDay(ruleDto.getConfirmBillDay());
                billEo.setConfirmWay(ruleDto.getConfirmWay());
                billEo.setAutoGenerateBill(ruleDto.getAutoGenerateBill());
                billEo.setAutoAuditBill(ruleDto.getAutoAuditBill());
                billEo.setAutoPublishBill(ruleDto.getAutoPublishBill());
                billEo.setAutoConfirm(ruleDto.getAutoConfirm());
                reconciliationBillEos.add(billEo);
            }
        });
        Map map = reconciliationBillEos.stream().collect(Collectors.toMap(e -> e.getCustomerCode() + e.getBillDate() + e.getShopCode(), Function.identity(), (v1, v2) -> v1));
        return Lists.newArrayList(map.values());
    }

    private ReconciliationRuleDto matchRule(String customerCode, String shopCode, String billDate, List<ReconciliationRuleDto> ruleDtos) {
        ArrayList ruleDtoList = Lists.newArrayList();
        ruleDtos.forEach(v -> {
            List customerCodeList = v.getCustomerCodeList();
            List shopCodeList = v.getShopCodeList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerCodeList) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopCodeList)) {
                log.info("\u89c4\u5219\u914d\u7f6e\u7684\u5ba2\u6237\u548c\u5e97\u94fa\u4fe1\u606f\u4e3a\u7a7a:{}", (Object)v.getRuleCode());
                return;
            }
            if (!customerCodeList.contains(customerCode) || !shopCodeList.contains(shopCode)) {
                log.info("\u5e97\u94fa\u548c\u5ba2\u6237\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u89c4\u5219\uff1a{},{},{}", new Object[]{customerCode, shopCode, v.getRuleCode()});
                return;
            }
            ruleDtoList.add(v);
        });
        List reconciliationRuleDtos = ruleDtoList.stream().sorted(Comparator.comparing(BaseDto::getCreateTime).reversed()).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(reconciliationRuleDtos)) {
            return null;
        }
        return (ReconciliationRuleDto)reconciliationRuleDtos.get(0);
    }

    private List<ReconciliationRuleDto> matchRuleCustomerAndShop(List<ReconciliationRuleDto> ruleDtoList) {
        ArrayList ruleDtos = Lists.newArrayList();
        log.info("ruleEoList:{}", (Object)JSONObject.toJSONString(ruleDtoList));
        ruleDtoList.forEach(v -> {
            List shopCustomerEos;
            List<CustomerDto> customerDtos;
            List<ShopDto> shopDtos;
            List<ShopDto> shopDtos2;
            ReconciliationRuleDto ruleDto = new ReconciliationRuleDto();
            if (0 == v.getApplicableShopRange() && 0 == v.getApplicableCustomerRange()) {
                CubeBeanUtils.copyProperties((Object)ruleDto, (Object)v, (String[])new String[0]);
                List<CustomerDto> customerDtos2 = this.getCustomerDtoList(null);
                shopDtos2 = this.getShopDtoList(null);
                ruleDto.setCustomerCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(customerDtos2) ? null : customerDtos2.stream().map(CustomerDto::getCode).distinct().collect(Collectors.toList()));
                ruleDto.setShopCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(shopDtos2) ? null : shopDtos2.stream().map(ShopDto::getCode).distinct().collect(Collectors.toList()));
            }
            if (0 == v.getApplicableShopRange() && 1 == v.getApplicableCustomerRange()) {
                List<CustomerDto> customerDtos3;
                List rejectCustomerEos;
                CubeBeanUtils.copyProperties((Object)ruleDto, (Object)v, (String[])new String[0]);
                shopDtos = this.getShopDtoList(null);
                List<Object> customerCodes = Lists.newArrayList();
                List conditionEos = ((ExtQueryChainWrapper)this.customerConditionDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionEos)) {
                    String typeIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerTypeIds())).map(ReconciliationCustomerConditionEo::getCustomerTypeIds).distinct().collect(Collectors.joining(","));
                    String areaIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerAreaCodes())).map(ReconciliationCustomerConditionEo::getCustomerAreaCodes).distinct().collect(Collectors.joining(","));
                    String levelIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerLevelIds())).map(ReconciliationCustomerConditionEo::getCustomerLevelIds).distinct().collect(Collectors.joining(","));
                    String groupIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerGroupIds())).map(ReconciliationCustomerConditionEo::getCustomerGroupIds).distinct().collect(Collectors.joining(","));
                    ArrayList custimerTypeIds = StringUtils.isBlank((CharSequence)typeIds) ? new ArrayList() : Arrays.stream(typeIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    ArrayList customerAreaIds = StringUtils.isBlank((CharSequence)areaIds) ? new ArrayList() : Arrays.stream(areaIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    ArrayList customerLevelIds = StringUtils.isBlank((CharSequence)levelIds) ? new ArrayList() : Arrays.stream(levelIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    ArrayList customerGroupIds = StringUtils.isBlank((CharSequence)groupIds) ? new ArrayList() : Arrays.stream(groupIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    CsOrgCustomerRelationPageReqDto reqDto = new CsOrgCustomerRelationPageReqDto();
                    reqDto.setCustomerTypeIds(custimerTypeIds);
                    reqDto.setAreaIds(customerAreaIds);
                    reqDto.setLevelIds(customerLevelIds);
                    reqDto.setCustomerGroupIds(customerGroupIds);
                    List customerRelationDtoList = this.orderDomain.queryList(reqDto);
                    log.info("\u6307\u5b9a\u5ba2\u6237\u8303\u56f4\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerRelationDtoList));
                    customerCodes = customerRelationDtoList.stream().map(CsOrgCustomerRelationDto::getCustomerCode).distinct().collect(Collectors.toList());
                }
                ArrayList rejectCustomerCodes = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(rejectCustomerEos = ((ExtQueryChainWrapper)this.rejectCustomerDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).list())) ? Lists.newArrayList() : rejectCustomerEos.stream().map(ReconciliationRejectCustomerEo::getCustomerCode).distinct().collect(Collectors.toList());
                List resultCodes = Lists.newArrayList();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerCodes)) {
                    resultCodes = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rejectCustomerCodes) ? (List)org.apache.commons.collections.CollectionUtils.subtract((Collection)customerCodes, (Collection)rejectCustomerCodes) : customerCodes;
                }
                ruleDto.setCustomerCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(customerDtos3 = this.getCustomerDtoList(resultCodes)) ? null : customerDtos3.stream().map(CustomerDto::getCode).distinct().collect(Collectors.toList()));
                ruleDto.setShopCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(shopDtos) ? null : shopDtos.stream().map(ShopDto::getCode).distinct().collect(Collectors.toList()));
            }
            if (0 == v.getApplicableShopRange() && 2 == v.getApplicableCustomerRange()) {
                CubeBeanUtils.copyProperties((Object)ruleDto, (Object)v, (String[])new String[0]);
                shopDtos = this.getShopDtoList(null);
                List shopCustomerEos2 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).eq((Object)"applicable_range", (Object)1)).list();
                customerDtos = this.getCustomerDtoList(shopCustomerEos2.stream().map(ReconciliationShopCustomerEo::getCustomerCode).distinct().collect(Collectors.toList()));
                ruleDto.setCustomerCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(customerDtos) ? null : customerDtos.stream().map(CustomerDto::getCode).distinct().collect(Collectors.toList()));
                ruleDto.setShopCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(shopDtos) ? null : shopDtos.stream().map(ShopDto::getCode).distinct().collect(Collectors.toList()));
            }
            if (1 == v.getApplicableShopRange() && 0 == v.getApplicableCustomerRange()) {
                CubeBeanUtils.copyProperties((Object)ruleDto, (Object)v, (String[])new String[0]);
                shopCustomerEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).eq((Object)"applicable_range", (Object)0)).list();
                shopDtos2 = this.getShopDtoList(shopCustomerEos.stream().map(ReconciliationShopCustomerEo::getShopCode).distinct().collect(Collectors.toList()));
                customerDtos = this.getCustomerDtoList(null);
                ruleDto.setCustomerCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(customerDtos) ? null : customerDtos.stream().map(CustomerDto::getCode).distinct().collect(Collectors.toList()));
                ruleDto.setShopCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(shopDtos2) ? null : shopDtos2.stream().map(ShopDto::getCode).distinct().collect(Collectors.toList()));
            }
            if (1 == v.getApplicableShopRange() && 1 == v.getApplicableCustomerRange()) {
                List<CustomerDto> customerDtos4;
                List rejectCustomerEos;
                CubeBeanUtils.copyProperties((Object)ruleDto, (Object)v, (String[])new String[0]);
                shopCustomerEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).eq((Object)"applicable_range", (Object)0)).list();
                shopDtos2 = this.getShopDtoList(shopCustomerEos.stream().map(ReconciliationShopCustomerEo::getShopCode).distinct().collect(Collectors.toList()));
                List<Object> customerCodes = Lists.newArrayList();
                List conditionEos = ((ExtQueryChainWrapper)this.customerConditionDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)conditionEos)) {
                    String typeIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerTypeIds())).map(ReconciliationCustomerConditionEo::getCustomerTypeIds).distinct().collect(Collectors.joining(","));
                    String areaIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerAreaCodes())).map(ReconciliationCustomerConditionEo::getCustomerAreaCodes).distinct().collect(Collectors.joining(","));
                    String levelIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerLevelIds())).map(ReconciliationCustomerConditionEo::getCustomerLevelIds).distinct().collect(Collectors.joining(","));
                    String groupIds = conditionEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCustomerGroupIds())).map(ReconciliationCustomerConditionEo::getCustomerGroupIds).distinct().collect(Collectors.joining(","));
                    ArrayList custimerTypeIds = StringUtils.isBlank((CharSequence)typeIds) ? new ArrayList() : Arrays.stream(typeIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    ArrayList customerAreaIds = StringUtils.isBlank((CharSequence)areaIds) ? new ArrayList() : Arrays.stream(areaIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    ArrayList customerLevelIds = StringUtils.isBlank((CharSequence)levelIds) ? new ArrayList() : Arrays.stream(levelIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    ArrayList customerGroupIds = StringUtils.isBlank((CharSequence)groupIds) ? new ArrayList() : Arrays.stream(groupIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                    CsOrgCustomerRelationPageReqDto reqDto = new CsOrgCustomerRelationPageReqDto();
                    reqDto.setCustomerTypeIds(custimerTypeIds);
                    reqDto.setAreaIds(customerAreaIds);
                    reqDto.setLevelIds(customerLevelIds);
                    reqDto.setCustomerGroupIds(customerGroupIds);
                    List customerRelationDtoList = this.orderDomain.queryList(reqDto);
                    log.info("\u6307\u5b9a\u5ba2\u6237\u8303\u56f4\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerRelationDtoList));
                    customerCodes = customerRelationDtoList.stream().map(CsOrgCustomerRelationDto::getCustomerCode).distinct().collect(Collectors.toList());
                }
                ArrayList rejectCustomerCodes = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(rejectCustomerEos = ((ExtQueryChainWrapper)this.rejectCustomerDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).list())) ? Lists.newArrayList() : rejectCustomerEos.stream().map(ReconciliationRejectCustomerEo::getCustomerCode).distinct().collect(Collectors.toList());
                List resultCodes = Lists.newArrayList();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerCodes)) {
                    resultCodes = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rejectCustomerCodes) ? (List)org.apache.commons.collections.CollectionUtils.subtract((Collection)customerCodes, (Collection)rejectCustomerCodes) : customerCodes;
                }
                ruleDto.setCustomerCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(customerDtos4 = this.getCustomerDtoList(resultCodes)) ? null : customerDtos4.stream().map(CustomerDto::getCode).distinct().collect(Collectors.toList()));
                ruleDto.setShopCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(shopDtos2) ? null : shopDtos2.stream().map(ShopDto::getCode).distinct().collect(Collectors.toList()));
            }
            if (1 == v.getApplicableShopRange() && 2 == v.getApplicableCustomerRange()) {
                CubeBeanUtils.copyProperties((Object)ruleDto, (Object)v, (String[])new String[0]);
                shopCustomerEos = ((ExtQueryChainWrapper)this.shopCustomerDomain.filter().eq((Object)"rule_code", (Object)v.getRuleCode())).list();
                List collectShopList = shopCustomerEos.stream().filter(x -> 0 == x.getApplicableRange()).collect(Collectors.toList());
                List collectCustomerList = shopCustomerEos.stream().filter(x -> 1 == x.getApplicableRange()).collect(Collectors.toList());
                List<ShopDto> shopDtos3 = this.getShopDtoList(collectShopList.stream().map(ReconciliationShopCustomerEo::getShopCode).distinct().collect(Collectors.toList()));
                List<CustomerDto> customerDtos5 = this.getCustomerDtoList(collectCustomerList.stream().map(ReconciliationShopCustomerEo::getCustomerCode).distinct().collect(Collectors.toList()));
                ruleDto.setCustomerCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(customerDtos5) ? null : customerDtos5.stream().map(CustomerDto::getCode).distinct().collect(Collectors.toList()));
                ruleDto.setShopCodeList(org.apache.commons.collections.CollectionUtils.isEmpty(shopDtos3) ? null : shopDtos3.stream().map(ShopDto::getCode).distinct().collect(Collectors.toList()));
            }
            ruleDtos.add(ruleDto);
        });
        return ruleDtos;
    }

    private List<ReconciliationRuleDto> getReconciliationRuleDtoList() {
        ExtQueryChainWrapper sqlFilters = this.ruleDomain.filter();
        String currentDate = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        sqlFilters.le((Object)"effect_begin_time", (Object)currentDate);
        StringBuilder sql = new StringBuilder();
        sql.append(" ( ");
        sql.append("effect_end_time >= '" + currentDate + "' or effect = 1");
        sql.append(")");
        sqlFilters.apply(sql.toString(), new Object[0]);
        List ruleEoList = sqlFilters.list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)ruleEoList)) {
            log.info("\u5339\u914d\u4e0d\u5230\u5bf9\u8d26\u89c4\u5219");
        }
        ArrayList ruleDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)ruleDtoList, (Collection)ruleEoList, ReconciliationRuleDto.class);
        return ruleDtoList;
    }

    public void generateBill(ReconciliationBillEo billEo) {
        Date date = new Date();
        Date newDate = DateUtil.addMonths((Date)date, (int)-1);
        Date monthBegin = DateUtil.getMonthBegin((Date)newDate);
        Date monthEnd = DateUtil.getMonthEnd((Date)newDate);
        List<ReconciliationRuleDto> ruleDtoList = this.getReconciliationRuleDtoList();
        List<ReconciliationRuleDto> ruleDtos = this.matchRuleCustomerAndShop(ruleDtoList);
        ReconciliationRuleDto ruleDto = this.matchRule(billEo.getCustomerCode(), billEo.getShopCode(), billEo.getBillDate(), ruleDtos);
        Integer billDay = ruleDto.getBillDay();
        Long days = DateUtils.getDays();
        if (days.intValue() > billDay) {
            List dataRangeEoList = ((ExtQueryChainWrapper)this.dataRangeDomain.filter().in((Object)"rule_code", new Object[]{ruleDto.getRuleCode()})).list();
            List<String> accountTypes = dataRangeEoList.stream().map(ReconciliationDataRangeEo::getRangeCode).distinct().collect(Collectors.toList());
            this.executeCustomerBill(monthBegin, monthEnd, ruleDto, accountTypes, billEo);
        } else {
            log.info("\u672a\u5230\u8d26\u5355\u65e5\u4e0d\u751f\u6210\u5bf9\u8d26\u5355\uff1a{},{}", (Object)ruleDto.getRuleCode(), (Object)ruleDto.getBillDay());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void executeCustomerBill(Date monthBegin, Date monthEnd, ReconciliationRuleDto ruleDto, List<String> accountTypes, ReconciliationBillEo billEo) {
        ReconciliationOrderEo reconciliationOrderEo = new ReconciliationOrderEo();
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.BILL_RECONCILIATION_ORDER.getCode());
        String orderNo = generateCodeService.getCode("DZD");
        reconciliationOrderEo.setOrderNo(orderNo);
        reconciliationOrderEo.setRuleCode(billEo.getRuleCode());
        reconciliationOrderEo.setOrderName(ruleDto.getRuleName());
        reconciliationOrderEo.setBillDate(billEo.getBillDate());
        reconciliationOrderEo.setCustomerCode(billEo.getCustomerCode());
        reconciliationOrderEo.setCustomerName(billEo.getCustomerName());
        reconciliationOrderEo.setShopCode(billEo.getShopCode());
        reconciliationOrderEo.setShopName(billEo.getShopName());
        reconciliationOrderEo.setStatus(ReconciliationBillStatusEnum.WAIT_AUDIT.getCode());
        AccountDto dto = new AccountDto();
        dto.setCustomerNo(billEo.getCustomerCode());
        dto.setShopCode(billEo.getShopCode());
        dto.setAccountTypeList(accountTypes);
        List accountEoList = this.billDomain.queryAccountList(dto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)accountEoList)) {
            log.info("\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u8d26\u6237");
            return;
        }
        List<ReconciliationOrderTotalEo> orderTotalEos = this.dealOrderTotal(accountEoList, billEo, ruleDto, reconciliationOrderEo, monthBegin, monthEnd);
        Map<String, Object> resultMap = this.dealReconciliationBillDetail(accountEoList, monthBegin, monthEnd, ruleDto, accountTypes, billEo, reconciliationOrderEo);
        if (!CollectionUtils.isEmpty(resultMap)) {
            List billDetailEos = (List)resultMap.get("billDetailEos");
            List accountRangeEos = (List)resultMap.get("accountRangeEos");
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billDetailEos)) {
                this.billDetailDomain.insertBatch(billDetailEos);
                this.accountRangeDomain.insertBatch(accountRangeEos);
                this.orderTotalDomain.insertBatch(orderTotalEos);
                this.saveOrderArea(billEo, orderNo);
                this.orderDomain.insert((BaseEo)reconciliationOrderEo);
                ReconciliationBillEo reconciliationBillEo = new ReconciliationBillEo();
                reconciliationBillEo.setId(billEo.getId());
                reconciliationBillEo.setOrderNo(reconciliationOrderEo.getOrderNo());
                reconciliationBillEo.setOrderName(billEo.getRuleName());
                reconciliationBillEo.setStatus("GERERATE");
                this.billDomain.updateSelective((BaseEo)reconciliationBillEo);
            }
        }
    }

    public List<ReconciliationOrderTotalEo> dealOrderTotal(List<AccountEo> accountEoList, ReconciliationBillEo billEo, ReconciliationRuleDto ruleDto, ReconciliationOrderEo orderEo, Date monthBegin, Date monthEnd) {
        ArrayList orderTotalEos = Lists.newArrayList();
        accountEoList.forEach(v -> {
            ReconciliationOrderTotalEo totalEo = new ReconciliationOrderTotalEo();
            totalEo.setOrderNo(orderEo.getOrderNo());
            totalEo.setOrderName(orderEo.getOrderName());
            totalEo.setRuleCode(ruleDto.getRuleCode());
            totalEo.setShopCode(billEo.getShopCode());
            totalEo.setShopName(billEo.getShopName());
            totalEo.setCustomerCode(billEo.getCustomerCode());
            totalEo.setCustomerName(billEo.getCustomerName());
            totalEo.setCurrency(v.getCurrency());
            totalEo.setBalanceType(v.getBalanceType());
            totalEo.setAccountType(v.getAccountType());
            totalEo.setAccountTypeName(v.getAccountTypeName());
            totalEo.setSaleCompanyCode(v.getSaleCompanyCode());
            totalEo.setSaleCompanyName(v.getSaleCompanyName());
            totalEo.setBillDate(billEo.getBillDate());
            String customerNo = v.getCustomerNo();
            String shopCode = v.getShopCode();
            List accountFlowEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.accountFlowDomain.filter().ge((Object)"create_time", (Object)monthBegin)).le((Object)"create_time", (Object)monthEnd)).eq((Object)"customer_no", (Object)customerNo)).eq((Object)"account_type", (Object)v.getAccountType())).eq((Object)"shop_code", (Object)shopCode)).in((Object)"amount_business_type", Arrays.asList("income", "disburse"))).orderByAsc((Object)"create_time")).list();
            BigDecimal beforeBalance = BigDecimal.ZERO;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountFlowEos)) {
                beforeBalance = ((AccountFlowEo)accountFlowEos.get(0)).getBeforeBalance();
            } else {
                List accountFlowEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.accountFlowDomain.filter().le((Object)"create_time", (Object)monthBegin)).eq((Object)"customer_no", (Object)billEo.getCustomerCode())).eq((Object)"account_type", (Object)v.getAccountType())).eq((Object)"shop_code", (Object)billEo.getShopCode())).in((Object)"amount_business_type", Arrays.asList("income", "disburse"))).orderByDesc((Object)"create_time")).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountFlowEoList)) {
                    beforeBalance = ((AccountFlowEo)accountFlowEoList.get(0)).getBeforeBalance();
                }
            }
            totalEo.setBeforeAmount(beforeBalance);
            List inComeAccountFlowEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.accountFlowDomain.filter().ge((Object)"create_time", (Object)monthBegin)).le((Object)"create_time", (Object)monthEnd)).eq((Object)"customer_no", (Object)customerNo)).eq((Object)"account_type", (Object)v.getAccountType())).eq((Object)"shop_code", (Object)shopCode)).in((Object)"amount_business_type", Arrays.asList("income"))).list();
            BigDecimal inComeAmount = BigDecimal.ZERO;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)inComeAccountFlowEos)) {
                inComeAmount = inComeAccountFlowEos.stream().map(AccountFlowEo::getTradeAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
            }
            totalEo.setCurrentIncomeAmount(inComeAmount);
            List disburseAccountFlowEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.accountFlowDomain.filter().ge((Object)"create_time", (Object)monthBegin)).le((Object)"create_time", (Object)monthEnd)).eq((Object)"customer_no", (Object)customerNo)).eq((Object)"account_type", (Object)v.getAccountType())).eq((Object)"shop_code", (Object)shopCode)).in((Object)"amount_business_type", Arrays.asList("disburse"))).list();
            BigDecimal disburseAmount = BigDecimal.ZERO;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)disburseAccountFlowEos)) {
                disburseAmount = disburseAccountFlowEos.stream().map(AccountFlowEo::getTradeAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
            }
            totalEo.setCurrentDisburseAmount(disburseAmount);
            BigDecimal endAmount = beforeBalance.add(inComeAmount).subtract(disburseAmount);
            totalEo.setEndAmount(endAmount);
            orderTotalEos.add(totalEo);
        });
        return orderTotalEos;
    }

    private Map<String, Object> dealReconciliationBillDetail(List<AccountEo> accountEoList, Date monthBegin, Date monthEnd, ReconciliationRuleDto ruleDto, List<String> accountTypes, ReconciliationBillEo billEo, ReconciliationOrderEo reconciliationOrderEo) {
        HashMap resultMap = Maps.newHashMap();
        ArrayList billDetailEos = Lists.newArrayList();
        ArrayList accountRangeEos = Lists.newArrayList();
        Map accountEoMap = accountEoList.stream().collect(Collectors.toMap(x -> x.getShopCode() + ";" + x.getCustomerNo(), Function.identity(), (k1, k2) -> k1));
        accountEoMap.forEach((k, value) -> {
            List<String> key = Arrays.asList(k.split(";"));
            AccountFlowDto dto = new AccountFlowDto();
            dto.setCreateStartTime(DateUtils.formatDate(monthBegin, "yyyy-MM-dd HH:mm:ss"));
            dto.setCreateEndTime(DateUtils.formatDate(monthEnd, "yyyy-MM-dd HH:mm:ss"));
            dto.setAccountTypeList(accountTypes);
            dto.setShopCodeList(Arrays.asList(key.get(0)));
            dto.setCustomerCodeList(Arrays.asList(key.get(1)));
            List accountFlowDtos = this.billDomain.queryAccountFlowList(dto);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)accountFlowDtos)) {
                log.info("\u5339\u914d\u4e0d\u5230\u8d26\u53f7\u6d41\u6c34");
                return;
            }
            HashMap relevanceNoAccountTypeCache = Maps.newHashMap();
            accountFlowDtos.forEach(j -> {
                List augmentOrderEos;
                ReconciliationBillDetailEo detailEo = new ReconciliationBillDetailEo();
                ArrayList accountRangeDetailEos = Lists.newArrayList();
                Long detailId = IdGenrator.getDistributedId();
                detailEo.setId(detailId);
                detailEo.setOrderNo(reconciliationOrderEo.getOrderNo());
                detailEo.setOrderName(reconciliationOrderEo.getOrderName());
                detailEo.setOrderType(BillsTypeEnum.getName((String)j.getDocumentType()));
                detailEo.setOrderType(j.getDocumentType());
                detailEo.setBusinessDate(j.getBusinessTime());
                detailEo.setShopCode(billEo.getShopCode());
                detailEo.setShopName(billEo.getShopName());
                detailEo.setCustomerCode(billEo.getCustomerCode());
                detailEo.setCustomerName(billEo.getCustomerName());
                detailEo.setCurrency(j.getCurrency());
                detailEo.setBalanceType(j.getBalanceType());
                detailEo.setAccountType(j.getAccountType());
                detailEo.setAccountTypeName(j.getAccountTypeName());
                detailEo.setSaleCompanyCode(j.getSaleCompanyCode());
                detailEo.setSaleCompanyName(j.getSaleCompanyName());
                detailEo.setBillDate(billEo.getBillDate());
                detailEo.setRuleCode(ruleDto.getRuleCode());
                detailEo.setRelevanceNo(j.getRelevanceNo());
                detailEo.setStatus(ReconciliationBillStatusEnum.WAIT_AUDIT.getCode());
                if ((ReconciliationOrderTypeEnum.ACCOUNT_CHARGE_08.getCode().equals(j.getChangeType()) || ReconciliationOrderTypeEnum.ACCOUNT_DEDUCTION_09.getCode().equals(j.getChangeType())) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(augmentOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.accountAugmentOrderDas.filter().eq((Object)"trade_type", (Object)j.getChangeType())).eq((Object)"apply_order_no", (Object)j.getRelevanceNo())).list()))) {
                    AccountAugmentOrderEo accountAugmentOrderEo = (AccountAugmentOrderEo)augmentOrderEos.get(0);
                    detailEo.setRemarkAbstract(accountAugmentOrderEo.getRemark());
                }
                List dataRangeEoList = ((ExtQueryChainWrapper)this.dataRangeDomain.filter().eq((Object)"rule_code", (Object)ruleDto.getRuleCode())).list();
                Map dataRangeEoMap = dataRangeEoList.stream().collect(Collectors.toMap(ReconciliationDataRangeEo::getRangeCode, Function.identity(), (k1, k2) -> k1));
                accountTypes.forEach(i -> {
                    log.info("accountTypes:{}", i);
                    AccountFlowDto flowDto = new AccountFlowDto();
                    flowDto.setBusinessOrderNo(j.getRelevanceNo());
                    flowDto.setBusinessTime(j.getBusinessTime());
                    flowDto.setAccountType(i);
                    List flowDtoList = this.billDomain.groupAccountFlow(flowDto);
                    log.info("flowDtoList:{}", (Object)JSONObject.toJSONString((Object)flowDtoList));
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)flowDtoList)) {
                        log.info("\u5339\u914d\u4e0d\u5230\u5ba2\u6237\u6d41\u6c34:{}\uff0c{}", new Object[]{i, j.getBusinessOrderNo(), j.getBusinessTime()});
                        return;
                    }
                    String code = (String)relevanceNoAccountTypeCache.get(j.getRelevanceNo() + "-" + i);
                    if (StringUtils.isNotBlank((CharSequence)code)) {
                        log.info("\u5b58\u5728\u540c\u4e00\u4e2a\u5355\u53f7\u548c\u8d26\u53f7\u7c7b\u578b\u591a\u6761\u8d26\u53f7\u8bb0\u5f55\uff0c\u8df3\u8fc7\u5904\u7406\uff1a{},{},{}", new Object[]{reconciliationOrderEo.getOrderNo(), j.getRelevanceNo(), i});
                        return;
                    }
                    for (AccountFlowDto accountFlowDto : flowDtoList) {
                        ReconciliationAccountRangeEo accountRangeEo = new ReconciliationAccountRangeEo();
                        accountRangeEo.setOrderNo(reconciliationOrderEo.getOrderNo());
                        accountRangeEo.setOrderName(billEo.getRuleName());
                        accountRangeEo.setRelevanceNo(accountFlowDto.getBusinessOrderNo());
                        accountRangeEo.setSaleCompanyCode(accountFlowDto.getSaleCompanyCode());
                        accountRangeEo.setSaleCompanyName(accountFlowDto.getSaleCompanyName());
                        accountRangeEo.setAccountType(i);
                        accountRangeEo.setAmount(accountFlowDto.getTradeAmount());
                        accountRangeEo.setAmountBusinessType(accountFlowDto.getAmountBusinessType());
                        accountRangeEo.setBusinessDate(j.getBusinessTime());
                        if (dataRangeEoMap.containsKey(i)) {
                            ReconciliationDataRangeEo dataRangeEo = (ReconciliationDataRangeEo)dataRangeEoMap.get(i);
                            accountRangeEo.setAccountTypeName(dataRangeEo.getRangeName());
                        }
                        accountRangeEos.add(accountRangeEo);
                        accountRangeDetailEos.add(accountRangeEo);
                    }
                    relevanceNoAccountTypeCache.put(j.getRelevanceNo() + "-" + i, j.getRelevanceNo());
                });
                if (BillsTypeEnum.BILLS_TYPE_00.getCode().equals(j.getDocumentType())) {
                    detailEo.setSaleAmount(new BigDecimal(accountRangeDetailEos.stream().collect(Collectors.summingDouble(e -> e.getAmount().doubleValue())) + ""));
                }
                if (BillsTypeEnum.BILLS_TYPE_07.getCode().equals(j.getDocumentType()) || BillsTypeEnum.BILLS_TYPE_08.getCode().equals(j.getDocumentType())) {
                    detailEo.setSaleAmount(new BigDecimal(accountRangeDetailEos.stream().collect(Collectors.summingDouble(e -> e.getAmount().doubleValue())) + ""));
                }
                billDetailEos.add(detailEo);
            });
        });
        resultMap.put("billDetailEos", billDetailEos);
        resultMap.put("accountRangeEos", accountRangeEos);
        return resultMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOrderArea(ReconciliationBillEo billEo, String orderNo) {
        CsOrgCustomerRelationPageReqDto pageReqDto = new CsOrgCustomerRelationPageReqDto();
        pageReqDto.setShopIdList(Arrays.asList(billEo.getShopId()));
        pageReqDto.setCustomerIdList(Arrays.asList(billEo.getCustomerId()));
        List customerRelationDtos = this.orderDomain.queryList(pageReqDto);
        Map<Long, List<DgBusinessAreaLevelDto>> areaLevelMap = this.mapAreaLevel(customerRelationDtos.stream().map(CsOrgCustomerRelationDto::getAreaId).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(areaLevelMap)) {
            ArrayList areaEoList = Lists.newArrayList();
            areaLevelMap.forEach((k, v) -> v.forEach(j -> {
                ReconciliationOrderAreaEo areaEo = new ReconciliationOrderAreaEo();
                areaEo.setAreaId(j.getId());
                areaEo.setAreaCode(j.getCode());
                areaEo.setAreaName(j.getName());
                areaEo.setOrderNo(orderNo);
                areaEo.setOrderName(billEo.getOrderName());
                areaEo.setLevel(j.getLevel());
                areaEo.setShopCode(billEo.getShopCode());
                areaEo.setCustomerCode(billEo.getCustomerCode());
                areaEoList.add(areaEo);
            }));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)areaEoList)) {
                this.orderAreaDomain.insertBatch((List)areaEoList);
            }
        }
    }

    public Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel(List<Long> areaIdList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(areaIdList)) {
            return Collections.emptyMap();
        }
        List respDtoList = ((ExtQueryChainWrapper)this.iDgCustomerAreaDomain.filter().in((Object)"id", areaIdList)).list();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)respDtoList)) {
            return Collections.emptyMap();
        }
        List indexPathIdList = respDtoList.stream().filter(dto -> Objects.nonNull(dto.getIndexPath())).map(dto -> Arrays.stream(dto.getIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        Map<Long, List> indexPathIdsMap = respDtoList.stream().collect(Collectors.toMap(BaseEo::getId, o -> Arrays.stream(o.getIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList()), (k1, k2) -> k1));
        Map indexPathEoMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.iDgCustomerAreaDomain.filter().in((Object)"id", indexPathIdList)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        HashMap<Long, List<DgBusinessAreaLevelDto>> resultMap = new HashMap<Long, List<DgBusinessAreaLevelDto>>();
        for (Long areaId : areaIdList) {
            List indexPathIds = indexPathIdsMap.get(areaId);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)indexPathIds)) continue;
            ArrayList<DgBusinessAreaLevelDto> levelDtoList = new ArrayList<DgBusinessAreaLevelDto>();
            for (Long indexPathId : indexPathIds) {
                if (Objects.equals(indexPathId, 0L)) continue;
                CsCustomerAreaEo customerAreaEo = (CsCustomerAreaEo)indexPathEoMap.get(indexPathId);
                DgBusinessAreaLevelDto levelDto = (DgBusinessAreaLevelDto)BeanUtil.toBean((Object)customerAreaEo, DgBusinessAreaLevelDto.class);
                levelDtoList.add(levelDto);
            }
            resultMap.put(areaId, levelDtoList);
        }
        return resultMap;
    }

    private List<ShopDto> getShopDtoList(List<String> shopCodes) {
        ArrayList shopDtos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(shopCodes)) {
            Integer pageNum;
            ExtQueryChainWrapper sqlFilters = this.shopDomain.filter();
            PageInfo pageInfo = sqlFilters.page(pageNum = Integer.valueOf(1), Integer.valueOf(1000));
            if (Objects.nonNull(pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
                ArrayList shopDtoList = new ArrayList();
                CubeBeanUtils.copyCollection(shopDtoList, (Collection)pageInfo.getList(), ShopDto.class);
                shopDtos.addAll(shopDtoList);
            }
            for (int i = pageInfo.getPages() - 1; i >= 0; --i) {
                PageInfo eoPageInfo = sqlFilters.page(Integer.valueOf(i), Integer.valueOf(1000));
                if (!Objects.nonNull(eoPageInfo) || !CollectionUtil.isNotEmpty((Collection)eoPageInfo.getList())) continue;
                ArrayList shopDtoList = new ArrayList();
                CubeBeanUtils.copyCollection(shopDtoList, (Collection)eoPageInfo.getList(), ShopDto.class);
                shopDtos.addAll(shopDtoList);
            }
            return shopDtos;
        }
        List shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"code", shopCodes)).list();
        CubeBeanUtils.copyCollection((Collection)shopDtos, (Collection)shopEos, ShopDto.class);
        return shopDtos;
    }

    private List<CustomerDto> getCustomerDtoList(List<String> customerCodes) {
        ArrayList customerDtos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerCodes)) {
            Integer pageNum;
            ExtQueryChainWrapper sqlFilters = this.customerDomain.filter();
            PageInfo pageInfo = sqlFilters.page(pageNum = Integer.valueOf(1), Integer.valueOf(1000));
            if (Objects.nonNull(pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
                ArrayList customerDtoList = new ArrayList();
                CubeBeanUtils.copyCollection(customerDtoList, (Collection)pageInfo.getList(), CustomerDto.class);
                customerDtos.addAll(customerDtoList);
            }
            for (int i = pageInfo.getPages() - 1; i >= 0; --i) {
                PageInfo eoPageInfo = sqlFilters.page(Integer.valueOf(i), Integer.valueOf(1000));
                if (!Objects.nonNull(eoPageInfo) || !CollectionUtil.isNotEmpty((Collection)eoPageInfo.getList())) continue;
                ArrayList customerDtoList = new ArrayList();
                CubeBeanUtils.copyCollection(customerDtoList, (Collection)eoPageInfo.getList(), CustomerDto.class);
                customerDtos.addAll(customerDtoList);
            }
            return customerDtos;
        }
        List customerEos = ((ExtQueryChainWrapper)this.customerDomain.filter().in((Object)"code", customerCodes)).list();
        CubeBeanUtils.copyCollection((Collection)customerDtos, (Collection)customerEos, CustomerDto.class);
        return customerDtos;
    }

    @Override
    @Transactional
    public void manualGenerateRealation(List<GenerateReconciliationReqDto> dtos) {
        dtos.forEach(v -> {
            Mutex mutex;
            block4: {
                mutex = null;
                try {
                    String primaryKey = MD5Util.getMd5ByString((String)(v.getId() + ";" + v.getCustomerCode() + ";" + v.getShopCode()));
                    mutex = this.lockService.lock(CREATE_RECONCILIATION_TABLENAME, primaryKey, 5, 50, TimeUnit.SECONDS);
                    if (null != mutex) break block4;
                    log.info("\u751f\u6210\u5bf9\u8d26\u5355\u5df2\u7ecf\u8fdb\u884c\u4e2d\u4e86\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b");
                    if (mutex == null) return;
                }
                catch (Throwable throwable) {
                    if (mutex == null) throw throwable;
                    this.lockService.unlock(mutex);
                    throw throwable;
                }
                this.lockService.unlock(mutex);
                return;
            }
            ReconciliationBillEo billEo = (ReconciliationBillEo)((ExtQueryChainWrapper)this.billDomain.filter().eq((Object)"id", (Object)v.getId())).one();
            if (Objects.nonNull(billEo) && (billEo.getStatus().equals("CLOSE") || billEo.getStatus().equals("NOT_GERERATE"))) {
                this.generateBill(billEo);
            }
            if (mutex == null) return;
            this.lockService.unlock(mutex);
        });
    }

    @Override
    public void autoGenerateCustomerBill(String ruleStrategy) {
        List ruleDtoList = this.ruleDomain.getRuleDtoList(ruleStrategy);
        log.info("autoGenerateCustomerBill:{}", (Object)JSONObject.toJSONString((Object)ruleDtoList));
        List<ReconciliationRuleDto> ruleDtos = this.matchRuleCustomerAndShop(ruleDtoList);
        List reconciliationBillEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billDomain.filter().in((Object)"status", Arrays.asList("NOT_GERERATE", "CLOSE"))).eq((Object)"bill_date", (Object)DateUtils.getPrevMonth(new Date(), 1))).list();
        Date date = new Date();
        Date newDate = DateUtil.addMonths((Date)date, (int)-1);
        Date monthBegin = DateUtil.getMonthBegin((Date)newDate);
        Date monthEnd = DateUtil.getMonthEnd((Date)newDate);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reconciliationBillEos)) {
            reconciliationBillEos.forEach(v -> {
                Mutex mutex = null;
                try {
                    mutex = this.lockService.lock("bill" + ruleStrategy + "-" + v.getId(), Convert.toStr((Object)v.getId()), 10, 20, TimeUnit.SECONDS);
                    if (null == mutex) {
                        log.error("\u81ea\u52a8\u751f\u6210\u5bf9\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                        throw new BizException("\u81ea\u52a8\u751f\u6210\u5bf9\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    ReconciliationRuleDto ruleDto = this.matchRule(v.getCustomerCode(), v.getShopCode(), v.getBillDate(), ruleDtos);
                    if (Objects.nonNull(ruleDto)) {
                        Integer billDay = ruleDto.getBillDay();
                        String dateFormDays = DateUtils.getDateFormDays(billDay - 1);
                        Date dateTime = DateUtils.parseString(dateFormDays, "yyyy-MM-dd");
                        Date currendDate = DateUtils.parseString(DateUtils.formatDate(new Date(), "yyyy-MM-dd"), "yyyy-MM-dd");
                        if (currendDate.after(dateTime)) {
                            List dataRangeEoList = ((ExtQueryChainWrapper)this.dataRangeDomain.filter().in((Object)"rule_code", new Object[]{ruleDto.getRuleCode()})).list();
                            List<String> accountTypes = dataRangeEoList.stream().map(ReconciliationDataRangeEo::getRangeCode).distinct().collect(Collectors.toList());
                            this.executeCustomerBill(monthBegin, monthEnd, ruleDto, accountTypes, (ReconciliationBillEo)v);
                        } else {
                            log.info("\u672a\u5230\u8d26\u5355\u65e5\u4e0d\u751f\u6210\u5bf9\u8d26\u5355\uff1a{},{}", (Object)ruleDto.getRuleCode(), (Object)ruleDto.getBillDay());
                        }
                    }
                    if (mutex == null) return;
                }
                catch (Exception e) {
                    try {
                        log.error("\u5ba1\u6838\u5bf9\u8d26\u5355\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
                        throw new BizException("\u5ba1\u6838\u5bf9\u8d26\u5355\u5931\u8d25:" + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (mutex == null) throw throwable;
                        this.lockService.unlock(mutex);
                        throw throwable;
                    }
                }
                this.lockService.unlock(mutex);
                return;
            });
        }
    }

    @Override
    public void autoAuditOrPublishBill(String ruleStrategy) {
        List ruleDtoList = this.ruleDomain.getRuleDtoList(ruleStrategy);
        log.info("autoAuditOrPublishBill:{}", (Object)JSONObject.toJSONString((Object)ruleDtoList));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ruleDtoList)) {
            List ruleCodeList = ruleDtoList.stream().map(ReconciliationRuleDto::getRuleCode).distinct().collect(Collectors.toList());
            String status = null;
            if ("auto_audit_bill".equals(ruleStrategy)) {
                status = ReconciliationBillStatusEnum.WAIT_AUDIT.getCode();
            } else if ("auto_publish_bill".equals(ruleStrategy)) {
                status = ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode();
            }
            List orderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderDomain.filter().in((Object)"rule_code", ruleCodeList)).eq((Object)"status", (Object)status)).list();
            for (ReconciliationOrderEo v : orderEoList) {
                Mutex mutex = null;
                try {
                    mutex = this.lockService.lock("bill" + ruleStrategy + "-" + v.getId(), Convert.toStr((Object)v.getId()), 10, 20, TimeUnit.SECONDS);
                    if (null == mutex) {
                        log.error("\u5ba1\u6838\u5bf9\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                        throw new BizException("\u5ba1\u6838\u5bf9\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    ReconciliationOrderEo eo = new ReconciliationOrderEo();
                    eo.setId(v.getId());
                    if ("auto_audit_bill".equals(ruleStrategy)) {
                        eo.setAuditRemark("\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
                        eo.setStatus(ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode());
                    } else if ("auto_publish_bill".equals(ruleStrategy)) {
                        eo.setStatus(ReconciliationBillStatusEnum.WAIT_CONFIRM.getCode());
                    }
                    this.orderDomain.updateSelective((BaseEo)eo);
                    List billDetailEos = ((ExtQueryChainWrapper)this.billDetailDomain.filter().eq((Object)"order_no", (Object)v.getOrderNo())).list();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billDetailEos)) {
                        billDetailEos.forEach(j -> {
                            ReconciliationBillDetailEo detailEo = new ReconciliationBillDetailEo();
                            detailEo.setId(j.getId());
                            detailEo.setStatus(eo.getStatus());
                            this.billDetailDomain.updateSelective((BaseEo)detailEo);
                        });
                    }
                    if (mutex == null) continue;
                }
                catch (Exception e) {
                    try {
                        log.error("\u5ba1\u6838\u5bf9\u8d26\u5355\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
                        throw new BizException("\u5ba1\u6838\u5bf9\u8d26\u5355\u5931\u8d25:" + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (mutex != null) {
                            this.lockService.unlock(mutex);
                        }
                        throw throwable;
                    }
                }
                this.lockService.unlock(mutex);
            }
        }
    }

    @Override
    public void autoConfirm(String ruleStrategy) {
        List ruleDtoList = this.ruleDomain.getRuleDtoList(ruleStrategy);
        log.info("autoAuditOrPublishBill:{}", (Object)JSONObject.toJSONString((Object)ruleDtoList));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ruleDtoList)) {
            Map ruleDtoMap = ruleDtoList.stream().collect(Collectors.toMap(ReconciliationRuleDto::getRuleCode, Function.identity(), (k1, k2) -> k1));
            List ruleCodeList = ruleDtoList.stream().map(ReconciliationRuleDto::getRuleCode).distinct().collect(Collectors.toList());
            List orderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderDomain.filter().in((Object)"rule_code", ruleCodeList)).eq((Object)"status", (Object)ReconciliationBillStatusEnum.WAIT_CONFIRM.getCode())).list();
            for (ReconciliationOrderEo v : orderEoList) {
                if (!ruleDtoMap.containsKey(v.getRuleCode())) continue;
                Mutex mutex = null;
                try {
                    Date currendDate;
                    mutex = this.lockService.lock("bill" + ruleStrategy + "-" + v.getId(), Convert.toStr((Object)v.getId()), 10, 20, TimeUnit.SECONDS);
                    if (null == mutex) {
                        log.error("\u786e\u8ba4\u5bf9\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                        throw new BizException("\u786e\u8ba4\u5bf9\u8d26\u5355\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    ReconciliationRuleDto ruleDto = (ReconciliationRuleDto)ruleDtoMap.get(v.getRuleCode());
                    Integer billDay = ruleDto.getBillDay();
                    Integer confirmBillDay = ruleDto.getConfirmBillDay();
                    String dateFormDays = DateUtils.getDateFormDays(billDay + confirmBillDay - 1);
                    Date date = DateUtils.parseString(dateFormDays, "yyyy-MM-dd");
                    if (date.before(currendDate = DateUtils.parseString(DateUtils.formatDate(new Date(), "yyyy-MM-dd"), "yyyy-MM-dd"))) {
                        ReconciliationOrderEo eo = new ReconciliationOrderEo();
                        eo.setId(v.getId());
                        eo.setStatus(ReconciliationBillStatusEnum.COMPLETE.getCode());
                        this.orderDomain.updateSelective((BaseEo)eo);
                        List billDetailEos = ((ExtQueryChainWrapper)this.billDetailDomain.filter().eq((Object)"order_no", (Object)v.getOrderNo())).list();
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billDetailEos)) {
                            billDetailEos.forEach(j -> {
                                ReconciliationBillDetailEo detailEo = new ReconciliationBillDetailEo();
                                detailEo.setId(j.getId());
                                detailEo.setStatus(eo.getStatus());
                                this.billDetailDomain.updateSelective((BaseEo)detailEo);
                            });
                        }
                    }
                    if (mutex == null) continue;
                }
                catch (Exception e) {
                    try {
                        log.error("\u786e\u8ba4\u5bf9\u8d26\u5355\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
                        throw new BizException("\u786e\u8ba4\u5bf9\u8d26\u5355\u5931\u8d25:" + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (mutex != null) {
                            this.lockService.unlock(mutex);
                        }
                        throw throwable;
                    }
                }
                this.lockService.unlock(mutex);
            }
        }
    }

    @Override
    public void autoDealOrderBillTest() {
        log.info("=========\u5ba2\u6237\u5bf9\u8d26\u4efb\u52a1\u6267\u884c\u4e2d==========");
        try {
            this.autoGenerateCustomerBill("auto_generate_bill");
            this.autoAuditOrPublishBill("auto_audit_bill");
            this.autoAuditOrPublishBill("auto_publish_bill");
            this.autoConfirm("auto_confirm");
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u5bf9\u8d26\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private static /* synthetic */ void lambda$generateRealation$12(Map finalBillEoMap, List billEoIds, List reconciliationBillEoList, ReconciliationBillEo v) {
        String key = v.getCustomerCode() + ";" + v.getShopCode() + ";" + v.getBillDate();
        ReconciliationBillEo reconciliationBillEo = (ReconciliationBillEo)finalBillEoMap.get(key);
        if (Objects.nonNull(reconciliationBillEo)) {
            if (reconciliationBillEo.getStatus().equals("GERERATE")) {
                log.info("\u4e0d\u9700\u8981\u91cd\u65b0\u751f\u6210\u6570\u636e\u4e86");
                return;
            }
            billEoIds.add(reconciliationBillEo.getId());
        }
        reconciliationBillEoList.add(v);
    }
}

