/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.center.finance.dto.enums.BillStrategyOrderPointEnum;
import com.yunxi.dg.base.center.finance.dto.enums.StrategyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.center.finance.service.mq.GenerateInvoiceInfoByAfterOrderConsumer;
import com.yunxi.dg.base.center.finance.service.mq.GenerateInvoiceInfoByOrderConsumer;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.finance.service.utils.LogUtils;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class BaseGenerateInvoiceInfoOrderConsumer<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseGenerateInvoiceInfoOrderConsumer.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IBillStrategyService billStrategyService;

    public MessageResponse process(T t) {
        log.info("\u63a5\u6536\u8ba2\u5355\u5230\u4fe1\u606f\u53d8\u66f4mq=>>{}", JSON.toJSON(t));
        Object shopCode = null;
        if (this.getClass().equals(GenerateInvoiceInfoByAfterOrderConsumer.class)) {
            this.commonsMqService.sendSingleMessage("CIS_FINANCE_AFTER_SALE_ORDER_REFUND_STATUS_CHANGE_TAG", t);
        } else {
            this.commonsMqService.sendSingleMessage("CIS_FINANCE_SALE_ORDER_REFUND_STATUS_CHANGE_TAG", t);
        }
        if (t instanceof MessageVo) {
            MessageVo message = (MessageVo)t;
            message.setExtValue2(this.getClass());
            if (this.isKeepComplete(message).booleanValue()) {
                return MessageResponse.SUCCESS;
            }
        }
        return this.processBiz(t);
    }

    abstract MessageResponse processBiz(T var1);

    public Boolean isKeepComplete(MessageVo message) {
        try {
            String shopCode = null;
            if (Objects.isNull(message)) {
                log.info("\u4e0d\u77e5\u9053\u795e\u9a6c\u4fe1\u606f\u4e0d\u5904\u7406");
                return false;
            }
            Map dataMap = JacksonUtil.toMap((String)JacksonUtil.toJson((Object)message.getData()));
            Object reqId = dataMap.get("requestId");
            String requestId = Objects.isNull(reqId) ? RequestId.createReqId() : (String)reqId;
            log.info("\u5904\u7406\u4e0a\u9762mq \u4e4b\u540e\u56de\u8c03\u901a\u77e5\u4e86requestId={}", (Object)requestId);
            MDC.put((String)"yes.req.requestId", (String)requestId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
            if (message.getExtValue2().equals(GenerateInvoiceInfoByAfterOrderConsumer.class)) {
                shopCode = dataMap.get("shopCode").toString();
            } else if (message.getExtValue2().equals(GenerateInvoiceInfoByOrderConsumer.class)) {
                shopCode = JacksonUtil.toMap((String)JacksonUtil.toJson(dataMap.get("performOrderSnapshotDto"))).get("shopCode").toString();
            }
            if (shopCode == null) {
                log.info("\u4e3a\u7a7a\u5e97\u94fa\u4fe1\u606f");
                return false;
            }
            BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
            log.info("handleBatchOrder==>billStrategyRespDto:{}", (Object)LogUtils.buildLogContent(billStrategyRespDto));
            AssertUtil.isTrue(null != billStrategyRespDto.getId(), "\u5e97\u94fa\u672a\u7ed1\u5b9a\u5f00\u7968\u7b56\u7565");
            return BillStrategyOrderPointEnum.KEEP_COMPLETE.getCode().equals(billStrategyRespDto.getBillOrderPoint());
        }
        catch (Exception e) {
            log.error("\u63a5\u6536\u8ba2\u5355\u5230\u4fe1\u606f\u53d8\u66f4\u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }
}

