/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.BillBlacklistConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillBlacklistDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.mapper.BillBlacklistMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IBillBlacklistDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillBlacklistDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillBlacklistPageReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillBlacklistReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillBlacklistRespDto;
import com.yunxi.dg.base.center.finance.eo.BillBlacklistEo;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillBlacklistService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillBlacklistServiceImpl
extends BaseServiceImpl<BillBlacklistDto, BillBlacklistEo, IBillBlacklistDomain>
implements IBillBlacklistService {
    private static final Logger log = LoggerFactory.getLogger(BillBlacklistServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(BillBlacklistServiceImpl.class);
    @Resource
    private IBillBlacklistDas billBlacklistDas;
    @Resource
    private BillBlacklistMapper billBlacklistMapper;
    @Resource
    private IBillInfoDas billInfoDas;

    public BillBlacklistServiceImpl(IBillBlacklistDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillBlacklistDto, BillBlacklistEo> converter() {
        return BillBlacklistConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBillBlacklist(BillBlacklistReqDto addReqDto) {
        BillBlacklistEo billBlacklistEo = new BillBlacklistEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billBlacklistEo);
        this.billBlacklistDas.insert((BaseEo)billBlacklistEo);
        return billBlacklistEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer batchAddBillBlacklist(List<BillBlacklistReqDto> addReqDtos) {
        if (addReqDtos == null || addReqDtos.isEmpty()) {
            throw new RuntimeException("\u6279\u91cf\u65b0\u589e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int successCount = 0;
        for (BillBlacklistReqDto reqDto : addReqDtos) {
            try {
                BillBlacklistEo billBlacklistEo = new BillBlacklistEo();
                DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)billBlacklistEo);
                this.billBlacklistDas.insert((BaseEo)billBlacklistEo);
                ++successCount;
            }
            catch (Exception e) {
                this.logger.error("\u6279\u91cf\u65b0\u589e\u5f00\u7968\u9ed1\u540d\u5355\u5931\u8d25\uff0c\u5e73\u53f0\u8ba2\u5355\u53f7\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{reqDto.getPlatformOrderNo(), e.getMessage(), e});
            }
        }
        this.logger.info("\u6279\u91cf\u65b0\u589e\u5f00\u7968\u9ed1\u540d\u5355\u5b8c\u6210\uff0c\u603b\u6570\uff1a{}\uff0c\u6210\u529f\uff1a{}", (Object)addReqDtos.size(), (Object)successCount);
        return successCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBillBlacklist(BillBlacklistReqDto modifyReqDto) {
        BillBlacklistEo billBlacklistEo = new BillBlacklistEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billBlacklistEo);
        this.billBlacklistDas.updateSelective((BaseEo)billBlacklistEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillBlacklist(List<BillBlacklistReqDto> billBlacklistReqDtos) {
        if (billBlacklistReqDtos == null || billBlacklistReqDtos.isEmpty()) {
            throw new RuntimeException("\u5220\u9664\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (BillBlacklistReqDto reqDto : billBlacklistReqDtos) {
            List billInfoList;
            if (reqDto.getId() == null) continue;
            BillBlacklistEo exist = (BillBlacklistEo)this.billBlacklistDas.selectByPrimaryKey(reqDto.getId());
            if (exist != null && StringUtils.isNotBlank((CharSequence)exist.getPlatformOrderNo()) && (billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)exist.getPlatformOrderNo())).list()) != null) {
                billInfoList.stream().filter(billInfo -> InvoiceStateEnum.BLACKLIST.getCode().equals(billInfo.getInvoiceState())).forEach(billInfo -> {
                    BillInfoEo update = new BillInfoEo();
                    update.setId(billInfo.getId());
                    update.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
                    this.billInfoDas.updateSelective((BaseEo)update);
                });
            }
            BillBlacklistEo billBlacklistEo = new BillBlacklistEo();
            billBlacklistEo.setId(reqDto.getId());
            billBlacklistEo.setDr(1);
            this.billBlacklistDas.updateSelective((BaseEo)billBlacklistEo);
        }
    }

    @Override
    public BillBlacklistRespDto queryById(BillBlacklistPageReqDto reqDto) {
        BillBlacklistEo billBlacklistEo = (BillBlacklistEo)this.billBlacklistDas.selectByPrimaryKey(reqDto.getId());
        if (billBlacklistEo == null) {
            return null;
        }
        BillBlacklistRespDto respDto = new BillBlacklistRespDto();
        DtoHelper.eo2Dto((BaseEo)billBlacklistEo, (BaseVo)respDto);
        return respDto;
    }

    @Override
    public PageInfo<BillBlacklistRespDto> queryByPage(BillBlacklistPageReqDto reqDto) {
        this.parseStringToList(reqDto);
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List billBlacklistEos = this.billBlacklistMapper.queryByPageWithConditions(reqDto);
        PageInfo pageInfo = new PageInfo(billBlacklistEos);
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List respDtoList = billBlacklistEos.stream().map(eo -> {
            BillBlacklistRespDto respDto = new BillBlacklistRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
            return respDto;
        }).collect(Collectors.toList());
        result.setList(respDtoList);
        return result;
    }

    private void parseStringToList(BillBlacklistPageReqDto reqDto) {
        List<String> values;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPlatformOrderNo()) && (values = this.splitString(reqDto.getPlatformOrderNo())).size() > 1) {
            reqDto.setPlatformOrderNoList(values);
            reqDto.setPlatformOrderNo(null);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getFxOrderNo()) && (values = this.splitString(reqDto.getFxOrderNo())).size() > 1) {
            reqDto.setFxOrderNoList(values);
            reqDto.setFxOrderNo(null);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderNo()) && (values = this.splitString(reqDto.getSaleOrderNo())).size() > 1) {
            reqDto.setSaleOrderNoList(values);
            reqDto.setSaleOrderNo(null);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getShopName()) && (values = this.splitString(reqDto.getShopName())).size() > 1) {
            reqDto.setShopNameList(values);
            reqDto.setShopName(null);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getChannelName()) && (values = this.splitString(reqDto.getChannelName())).size() > 1) {
            reqDto.setChannelNameList(values);
            reqDto.setChannelName(null);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCreatePerson()) && (values = this.splitString(reqDto.getCreatePerson())).size() > 1) {
            reqDto.setCreatePersonList(values);
            reqDto.setCreatePerson(null);
        }
    }

    private List<String> splitString(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return new ArrayList<String>();
        }
        return Arrays.stream(str.split("[,\\s]+")).map(String::trim).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
    }

    @Override
    public List<BillBlacklistRespDto> queryByPlatformOrderNo(BillBlacklistReqDto reqDto) {
        if (reqDto == null || reqDto.getPlatformOrderNo() == null) {
            throw new RuntimeException("\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillBlacklistEo queryEo = new BillBlacklistEo();
        queryEo.setPlatformOrderNo(reqDto.getPlatformOrderNo());
        queryEo.setDr(0);
        List billBlacklistEos = this.billBlacklistDas.selectList((BaseEo)queryEo);
        return billBlacklistEos.stream().map(eo -> {
            BillBlacklistRespDto respDto = new BillBlacklistRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
            return respDto;
        }).collect(Collectors.toList());
    }
}

