/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepAccountsDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderInfoDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillInvoiceRemarkContentDto;
import com.yunxi.dg.base.center.finance.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.finance.dto.entity.InvoiceRemarkContentReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoDto;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoColourTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.SpecialInvoiceRemarkEnum;
import com.yunxi.dg.base.center.finance.dto.enums.StrategyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.BillApplyEo;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.eo.BillItemEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoValidateService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInvoiceRemarkRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.center.inventory.domain.entity.IOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BillInfoValidateServiceImpl
implements IBillInfoValidateService {
    private static final Logger log = LoggerFactory.getLogger(BillInfoValidateServiceImpl.class);
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    @Resource
    private IKeepAccountsDetailDomain keepAccountsDetailDomain;
    @Resource
    private IBillStrategyService billStrategyService;
    @Resource
    private IOutResultOrderDetailDomain outResultOrderDetailDomain;
    @Resource
    private IPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderLineDomain orderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain orderItemLineDomain;
    @Resource
    private IBillInvoiceRemarkRuleService remarkRuleService;

    @Override
    public boolean validateBillInfo(String platformOrderNo, BillInfoEo billInfoEo) {
        boolean isConsistency = false;
        log.info("\u53d1\u7968\u4fe1\u606f\u6821\u9a8c\u5165\u53c2\uff1a{},{},{},{},{},{}", new Object[]{platformOrderNo, billInfoEo.getTaxesCode(), billInfoEo.getInvoiceAmount(), billInfoEo.getInvoiceRemarks(), billInfoEo.getInvoiceType(), JSONObject.toJSONString((Object)billInfoEo)});
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.billInfoDas.filter().orderByDesc((Object)"id");
        sqlFilters.eq((Object)"platform_order_no", (Object)platformOrderNo);
        sqlFilters.eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode());
        sqlFilters.in((Object)"invoice_state", Arrays.asList(InvoiceStateEnum.INVOICING.getCode(), InvoiceStateEnum.WAIT_AUDIT.getCode(), InvoiceStateEnum.BILLED.getCode(), InvoiceStateEnum.WAIT_BILL.getCode()));
        List billInfoEoList = sqlFilters.list();
        if (CollectionUtils.isEmpty((Collection)billInfoEoList)) {
            log.info("\u4e0d\u5b58\u5728\u6709\u6548\u7684\u84dd\u7968\uff1a{},{},{}", new Object[]{platformOrderNo, JSONObject.toJSONString((Object)billInfoEoList), JSONObject.toJSONString((Object)billInfoEo)});
            return false;
        }
        BillInfoEo infoEo = (BillInfoEo)billInfoEoList.get(0);
        log.info("\u6709\u6548\u7684\u84dd\u7968\u4fe1\u606f\uff1a{},{},{},{},{},{}", new Object[]{platformOrderNo, infoEo.getTaxesCode(), infoEo.getInvoiceAmount(), infoEo.getInvoiceRemarks(), infoEo.getInvoiceType(), JSONObject.toJSONString((Object)infoEo)});
        String invoiceTaxesCode = StringUtils.isNotBlank((CharSequence)billInfoEo.getTaxesCode()) ? billInfoEo.getTaxesCode().trim() : null;
        String infoTaxesCode = StringUtils.isNotBlank((CharSequence)infoEo.getTaxesCode()) ? infoEo.getTaxesCode().trim() : null;
        boolean isTaxesCode = Objects.equals(invoiceTaxesCode, infoTaxesCode);
        log.info("invoiceTaxesCode:{},infoTaxesCode:{},isTaxesCode:{}", new Object[]{invoiceTaxesCode, infoTaxesCode, isTaxesCode});
        String invoiceRemarks = StringUtils.isNotBlank((CharSequence)billInfoEo.getInvoiceRemarks()) ? billInfoEo.getInvoiceRemarks().trim() : null;
        String infoRemarks = StringUtils.isNotBlank((CharSequence)infoEo.getInvoiceRemarks()) ? infoEo.getInvoiceRemarks().trim() : null;
        boolean isInvoiceRemarks = Objects.equals(invoiceRemarks, infoRemarks);
        log.info("invoiceRemarks:{},infoRemarks:{},isInvoiceRemarks:{}", new Object[]{invoiceRemarks, infoRemarks, isInvoiceRemarks});
        String titleType = StringUtils.isNotBlank((CharSequence)billInfoEo.getTitleType()) ? billInfoEo.getTitleType().trim() : null;
        String infoTitleType = StringUtils.isNotBlank((CharSequence)infoEo.getTitleType()) ? infoEo.getTitleType().trim() : null;
        boolean isTitleType = Objects.equals(titleType, infoTitleType);
        log.info("titleType:{},infoTitleType:{},isTitleType:{}", new Object[]{titleType, infoTitleType, isTitleType});
        if (billInfoEo.getInvoiceAmount().compareTo(infoEo.getInvoiceAmount()) == 0 && Objects.equals(billInfoEo.getInvoiceType(), infoEo.getInvoiceType()) && Objects.equals(billInfoEo.getBillTitle(), infoEo.getBillTitle()) && isTaxesCode && isInvoiceRemarks && isTitleType) {
            log.info("\u6821\u9a8c\u53d1\u7968\u4fe1\u606f:{}", (Object)platformOrderNo);
            log.info("\u5e73\u53f0\u8ba2\u5355\uff1a{}\uff0c\u53d1\u7968\u4fe1\u606f\u5f00\u7968\u91d1\u989d\u3001\u53d1\u7968\u7c7b\u578b\u3001\u62ac\u5934\u3001\u7a0e\u53f7\u3001\u53d1\u7968\u5907\u6ce8\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u53d1\u7968\u6570\u636e", (Object)platformOrderNo);
            isConsistency = true;
        }
        log.info("\u6821\u9a8c\u53d1\u7968\u4fe1\u606f\u662f\u5426\u4e00\u81f4:{}", (Object)isConsistency);
        return isConsistency;
    }

    @Override
    public boolean validateApplyInfo(String platformOrderNo, BillApplyEo billApplyEo, BigDecimal invoiceAmount) {
        boolean isConsistency = false;
        log.info("\u53d1\u7968\u7533\u8bf7\u4fe1\u606f\u6821\u9a8c\u5165\u53c2\uff1a{},{},{},{},{},{}", (Object)platformOrderNo, (Object)JSONObject.toJSONString((Object)billApplyEo));
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.billInfoDas.filter().orderByDesc((Object)"id");
        sqlFilters.eq((Object)"platform_order_no", (Object)platformOrderNo);
        sqlFilters.eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode());
        sqlFilters.in((Object)"invoice_state", Arrays.asList(InvoiceStateEnum.INVOICING.getCode(), InvoiceStateEnum.WAIT_AUDIT.getCode(), InvoiceStateEnum.BILLED.getCode(), InvoiceStateEnum.WAIT_BILL.getCode()));
        List billInfoEoList = sqlFilters.list();
        if (CollectionUtils.isEmpty((Collection)billInfoEoList)) {
            log.info("\u4e0d\u5b58\u5728\u6709\u6548\u7684\u84dd\u7968\uff1a{},{},{}", (Object)platformOrderNo);
            return false;
        }
        BillInfoEo infoEo = (BillInfoEo)billInfoEoList.get(0);
        log.info("\u6709\u6548\u7684\u84dd\u7968\u4fe1\u606f\uff1a{},{},{},{},{},{}", (Object)platformOrderNo, (Object)JSONObject.toJSONString((Object)infoEo));
        String invoiceTaxesCode = StringUtils.isNotBlank((CharSequence)billApplyEo.getTaxesCode()) ? billApplyEo.getTaxesCode().trim() : null;
        String infoTaxesCode = StringUtils.isNotBlank((CharSequence)infoEo.getTaxesCode()) ? infoEo.getTaxesCode().trim() : null;
        boolean isTaxesCode = Objects.equals(invoiceTaxesCode, infoTaxesCode);
        log.info("invoiceTaxesCode:{},infoTaxesCode:{},isTaxesCode:{}", new Object[]{invoiceTaxesCode, infoTaxesCode, isTaxesCode});
        String invoiceRemarks = StringUtils.isNotBlank((CharSequence)billApplyEo.getRemark()) ? billApplyEo.getRemark().trim() : null;
        String infoRemarks = StringUtils.isNotBlank((CharSequence)infoEo.getInvoiceRemarks()) ? infoEo.getInvoiceRemarks().trim() : null;
        boolean isInvoiceRemarks = Objects.equals(invoiceRemarks, infoRemarks);
        log.info("invoiceRemarks:{},infoRemarks:{},isInvoiceRemarks:{}", new Object[]{invoiceRemarks, infoRemarks, isInvoiceRemarks});
        String titleType = StringUtils.isNotBlank((CharSequence)billApplyEo.getTitleType()) ? billApplyEo.getTitleType().trim() : null;
        String infoTitleType = StringUtils.isNotBlank((CharSequence)infoEo.getTitleType()) ? infoEo.getTitleType().trim() : null;
        boolean isTitleType = Objects.equals(titleType, infoTitleType);
        log.info("titleType:{},infoTitleType:{},isTitleType:{}", new Object[]{titleType, infoTitleType, isTitleType});
        if (invoiceAmount.compareTo(infoEo.getInvoiceAmount()) == 0 && Objects.equals(billApplyEo.getBillType(), infoEo.getInvoiceType()) && Objects.equals(billApplyEo.getBillTitle(), infoEo.getBillTitle()) && isTaxesCode && isInvoiceRemarks && isTitleType) {
            log.info("\u6821\u9a8c\u53d1\u7968\u4fe1\u606f:{}", (Object)platformOrderNo);
            log.info("\u5e73\u53f0\u8ba2\u5355\uff1a{}\uff0c\u53d1\u7968\u4fe1\u606f\u5f00\u7968\u91d1\u989d\u3001\u53d1\u7968\u7c7b\u578b\u3001\u62ac\u5934\u3001\u7a0e\u53f7\u3001\u53d1\u7968\u5907\u6ce8\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u53d1\u7968\u6570\u636e", (Object)platformOrderNo);
            isConsistency = true;
        }
        log.info("\u6821\u9a8c\u53d1\u7968\u4fe1\u606f\u662f\u5426\u4e00\u81f4:{}", (Object)isConsistency);
        return isConsistency;
    }

    @Override
    public boolean canBillForGiftAfterSaleOrder(String afterSaleOrderNo) {
        AfterSaleOrderEo afterSaleOrderEo = (AfterSaleOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().eq((Object)"after_sale_order_no", (Object)afterSaleOrderNo)).in((Object)"after_sale_order_type", Arrays.asList(AfterSaleOrderTypeEnum.THTK.getCode(), AfterSaleOrderTypeEnum.thtk.getCode()))).one();
        if (Objects.isNull(afterSaleOrderEo)) {
            log.info("\u552e\u540e\u5355{}\u4e0d\u5b58\u5728", (Object)afterSaleOrderNo);
            return true;
        }
        List afterSaleOrderItemEos = this.afterSaleOrderItemDomain.queryEosByAfsOrderIds(Arrays.asList(afterSaleOrderEo.getId()));
        List orderItemEos = afterSaleOrderItemEos.stream().filter(x -> null != x.getGift() && null != x.getRefundAmount() && x.getRefundAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)afterSaleOrderItemEos) || CollectionUtils.isNotEmpty(orderItemEos)) {
            log.info("\u552e\u540e\u5546\u54c1\u884c\u660e\u7ec6\u4e3a\u7a7a\u6216\u8005\u5b58\u5728\u91d1\u989d\u4e0d\u4e3a0\u7684\u5546\u54c1\u884c:{}", (Object)afterSaleOrderNo);
            return true;
        }
        String shopCode = afterSaleOrderEo.getShopCode();
        BillStrategyRespDto strategy = this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
        log.info("\u83b7\u53d6\u5f00\u7968\u7b56\u7565\uff1a{},{}", (Object)afterSaleOrderNo, (Object)JSONObject.toJSONString((Object)strategy));
        if (strategy == null) {
            return true;
        }
        return strategy.getBillGift() == null || "1".equals(strategy.getBillGift());
    }

    @Override
    public String getSnCode(String platformOrderNo) {
        String snCode = null;
        List performOrderInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.performOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).in((Object)"order_status", Arrays.asList(OmsSaleOrderStatus.DELIVERED.getCode(), OmsSaleOrderStatus.COMPLETE.getCode()))).eq((Object)"subsidies_type", (Object)1)).list();
        log.info("\u56fd\u8865\u8ba2\u5355\u4fe1\u606fperformOrderInfoEos\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderInfoEos));
        if (CollectionUtils.isNotEmpty((Collection)performOrderInfoEos)) {
            List orderIds = performOrderInfoEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            List performOrderLineEos = ((ExtQueryChainWrapper)this.orderLineDomain.filter().in((Object)"order_id", orderIds)).list();
            log.info("\u56fd\u8865\u8ba2\u5355\u884c\u4fe1\u606fperformOrderLineEos\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderLineEos));
            if (CollectionUtils.isNotEmpty((Collection)performOrderLineEos)) {
                List collect = performOrderLineEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
                List orderItemLineEos = ((ExtQueryChainWrapper)this.orderItemLineDomain.filter().in((Object)"order_line_id", collect)).list();
                log.info("\u56fd\u8865\u8ba2\u5355\u5546\u54c1\u884c\u4fe1\u606forderItemLineEos\uff1a{}", (Object)JSONObject.toJSONString((Object)orderItemLineEos));
                if (CollectionUtils.isNotEmpty((Collection)orderItemLineEos)) {
                    List snCodeList = orderItemLineEos.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getSnCode())).map(DgPerformOrderItemLineEo::getSnCode).distinct().collect(Collectors.toList());
                    snCode = CollectionUtils.isNotEmpty(snCodeList) ? snCodeList.stream().collect(Collectors.joining(",")) : null;
                }
            }
        }
        log.info("\u56fd\u8865\u8ba2\u5355\u7684sn\u7801:{}", snCode);
        return snCode;
    }

    @Override
    public String getInvoiceRemarks(BillInfoEo billInfoEo, List<BillItemEo> billItemEoList) {
        String remark = null;
        if (null != billInfoEo.getSubsidiesType() && 1 == billInfoEo.getSubsidiesType()) {
            List energyEfficiencyRatingList = billItemEoList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getEnergyEfficiencyRating())).map(BillItemEo::getEnergyEfficiencyRating).distinct().collect(Collectors.toList());
            List specificationList = billItemEoList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getSpecification())).map(BillItemEo::getSpecification).distinct().collect(Collectors.toList());
            List<String> collect = billItemEoList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getSpecialInvoiceRemark())).map(BillItemEo::getSpecialInvoiceRemark).distinct().collect(Collectors.toList());
            ArrayList specialInvoiceRemarkList = Lists.newArrayList();
            collect.forEach(v -> specialInvoiceRemarkList.add(SpecialInvoiceRemarkEnum.getNameByCode((String)v)));
            List thirdCodeList = billItemEoList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getThirdCode())).map(BillItemEo::getThirdCode).distinct().collect(Collectors.toList());
            String snCode = this.getSnCode(billInfoEo.getPlatformOrderNo());
            StringBuffer buffer = new StringBuffer();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(energyEfficiencyRatingList)) {
                if (energyEfficiencyRatingList.size() > 1) {
                    buffer.append(energyEfficiencyRatingList.stream().collect(Collectors.joining(","))).append(",");
                } else {
                    buffer.append((String)energyEfficiencyRatingList.get(0)).append(",");
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(specificationList)) {
                if (specificationList.size() > 1) {
                    buffer.append(specificationList.stream().collect(Collectors.joining(","))).append(",");
                } else {
                    buffer.append((String)specificationList.get(0)).append(",");
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)specialInvoiceRemarkList)) {
                if (specialInvoiceRemarkList.size() > 1) {
                    buffer.append(specialInvoiceRemarkList.stream().collect(Collectors.joining(","))).append(",");
                } else {
                    buffer.append((String)specialInvoiceRemarkList.get(0)).append(",");
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(thirdCodeList)) {
                if (thirdCodeList.size() > 1) {
                    buffer.append(thirdCodeList.stream().collect(Collectors.joining(","))).append(",");
                } else {
                    buffer.append((String)thirdCodeList.get(0)).append(",");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)snCode)) {
                buffer.append(snCode).append(",");
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
                remark = buffer.toString();
            }
        }
        return remark;
    }

    @Override
    public BillInvoiceRemarkContentDto getInvoiceRemarkContentDto(BillInfoEo billInfoEo, PerformOrderInfoDto performOrderInfoDto, List<BillItemEo> billItemEoList) {
        BillInvoiceRemarkContentDto contentDto = new BillInvoiceRemarkContentDto();
        if (null != billInfoEo.getSubsidiesType() && 1 == billInfoEo.getSubsidiesType()) {
            InvoiceRemarkContentReqDto reqDto = new InvoiceRemarkContentReqDto();
            reqDto.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
            reqDto.setShopCode(billInfoEo.getShopCode());
            reqDto.setSkuCode(billItemEoList.get(0).getItemCode());
            List orderAddrDtoList = performOrderInfoDto.getPerformOrderAddrDtoList();
            reqDto.setProvince(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getProvince() : null);
            reqDto.setProvinceCode(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getProvinceCode() : null);
            reqDto.setCity(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getCity() : null);
            reqDto.setCityCode(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getCityCode() : null);
            reqDto.setCounty(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getCounty() : null);
            reqDto.setCountyCode(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getCountyCode() : null);
            contentDto = this.remarkRuleService.matchInvoiceRemark(reqDto, billInfoEo);
        }
        log.info("\u5339\u914d\u5230\u7684\u53d1\u7968\u5907\u6ce8\u4fe1\u606f\uff1a{}\uff0c{}", (Object)performOrderInfoDto.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)contentDto));
        return contentDto;
    }
}

