/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.BillRuleConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillRuleShopDas;
import com.yunxi.dg.base.center.finance.dao.mapper.BillRuleMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.BillRuleShopMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IBillRuleDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillRuleDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillRulePageReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillRuleStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillRuleReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillRuleRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillRuleShopRespDto;
import com.yunxi.dg.base.center.finance.eo.BillRuleEo;
import com.yunxi.dg.base.center.finance.eo.BillRuleShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillRuleService;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillRuleServiceImpl
extends BaseServiceImpl<BillRuleDto, BillRuleEo, IBillRuleDomain>
implements IBillRuleService {
    private static final Logger log = LoggerFactory.getLogger(BillRuleServiceImpl.class);
    @Resource
    private IBillRuleDas billRuleDas;
    @Resource
    private IBillRuleShopDas billRuleShopDas;
    @Resource
    private BillRuleMapper billRuleMapper;
    @Resource
    private BillRuleShopMapper billRuleShopMapper;

    public BillRuleServiceImpl(IBillRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillRuleDto, BillRuleEo> converter() {
        return BillRuleConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBillRule(BillRuleReqDto addReqDto) {
        log.info("\u65b0\u589e\u5f00\u7968\u89c4\u5219\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)addReqDto));
        this.checkParam(addReqDto);
        String ruleCode = StringUtils.isNotBlank((CharSequence)addReqDto.getRuleCode()) ? addReqDto.getRuleCode() : GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.BILL_RULE.getCode()).getCode("KPGZ");
        log.info("\u5f00\u7968\u89c4\u5219\u7f16\u7801\uff1a{}", (Object)ruleCode);
        List shopReqDtos = addReqDto.getShopReqDtos();
        BillRuleEo billRuleEo = new BillRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billRuleEo, (String[])new String[]{"id"});
        billRuleEo.setRuleCode(ruleCode);
        billRuleEo.setRuleStatus(BillRuleStatusEnum.DISABLE.getCode());
        this.billRuleDas.insert((BaseEo)billRuleEo);
        ArrayList shopEos = new ArrayList();
        shopReqDtos.forEach(reqDto -> {
            BillRuleShopEo eo = new BillRuleShopEo();
            eo.setShopCode(reqDto.getShopCode());
            eo.setShopName(reqDto.getShopName());
            eo.setBillRuleId(billRuleEo.getId());
            shopEos.add(eo);
        });
        this.billRuleShopDas.insertBatch(shopEos);
        return billRuleEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBillRule(BillRuleReqDto modifyReqDto) {
        log.info("\u4fee\u6539\u5f00\u7968\u89c4\u5219\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)modifyReqDto));
        this.checkParam(modifyReqDto);
        AssertUtil.isTrue(Objects.nonNull(modifyReqDto.getId()), "\u5f00\u7968\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)modifyReqDto.getRuleCode()), "\u5f00\u7968\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        BillRuleEo billRuleEo = (BillRuleEo)this.billRuleDas.selectByPrimaryKey(modifyReqDto.getId());
        AssertUtil.isTrue(Objects.nonNull(billRuleEo), "\u975e\u6cd5\u6570\u636e\uff0c\u8bf7\u9000\u51fa\u5f53\u524d\u9875\uff0c\u5237\u65b0\u6570\u636e\u540e\u91cd\u8bd5");
        this.removeBillRule(Lists.newArrayList((Object[])new Long[]{modifyReqDto.getId()}));
        modifyReqDto.setCreatePerson(billRuleEo.getCreatePerson());
        modifyReqDto.setCreateTime(billRuleEo.getCreateTime());
        this.addBillRule(modifyReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillRule(List<Long> ids) {
        log.info("\u5220\u9664\u5f00\u7968\u89c4\u5219\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(ids));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(ids), "\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5f00\u7968\u89c4\u5219");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", ids);
        queryWrapper.eq((Object)"dr", (Object)0);
        List billRuleEos = this.billRuleMapper.selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)billRuleEos), "\u67e5\u8be2\u4e0d\u5230\u5f00\u7968\u89c4\u5219\u6570\u636e");
        List idList = billRuleEos.stream().filter(eo -> BillRuleStatusEnum.DISABLE.getCode().equals(eo.getRuleStatus())).map(BaseEo::getId).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(idList), "\u9009\u62e9\u7684\u89c4\u5219\u5305\u62ec\u5df2\u542f\u7528\u7684\u89c4\u5219");
        QueryWrapper shopEoQueryWrapper = new QueryWrapper();
        shopEoQueryWrapper.in((Object)"bill_rule_id", idList);
        shopEoQueryWrapper.eq((Object)"dr", (Object)0);
        List ruleShopEos = this.billRuleShopMapper.selectList((Wrapper)shopEoQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)ruleShopEos)) {
            List ruleShopIds = ruleShopEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.billRuleShopDas.logicDeleteByIds(ruleShopIds);
        }
        this.billRuleDas.logicDeleteByIds(idList);
    }

    @Override
    public BillRuleRespDto queryById(Long id) {
        BillRuleEo billRuleEo = (BillRuleEo)this.billRuleMapper.selectById((Serializable)id);
        AssertUtil.isTrue(Objects.nonNull(billRuleEo), "\u67e5\u8be2\u4e0d\u5230\u5f00\u7968\u89c4\u5219\u6570\u636e");
        log.info("\u6839\u636eid\u67e5\u8be2\u5f00\u7968\u89c4\u5219\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)billRuleEo));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bill_rule_id", (Object)id);
        queryWrapper.eq((Object)"dr", (Object)0);
        List billRuleShopEos = this.billRuleShopMapper.selectList((Wrapper)queryWrapper);
        ArrayList shopRespDtos = Lists.newArrayList();
        billRuleShopEos.forEach(billRuleShopEo -> {
            BillRuleShopRespDto shopRespDto = new BillRuleShopRespDto();
            CubeBeanUtils.copyProperties((Object)shopRespDto, (Object)billRuleShopEo, (String[])new String[0]);
            shopRespDtos.add(shopRespDto);
        });
        BillRuleRespDto billRuleRespDto = new BillRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)billRuleEo, (BaseVo)billRuleRespDto);
        billRuleRespDto.setShopRespDtos((List)shopRespDtos);
        return billRuleRespDto;
    }

    @Override
    public PageInfo<BillRuleRespDto> queryByPage(BillRulePageReqDto reqDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u5f00\u7968\u89c4\u5219\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        AssertUtil.isTrue(Objects.nonNull(reqDto), "\u8bf7\u6c42\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        Integer pageNum = reqDto.getPageNum();
        Integer pageSize = reqDto.getPageSize();
        AssertUtil.isTrue(null != pageNum && pageNum > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != pageSize && pageSize > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getRuleCode())) {
            queryWrapper.like((Object)"rule_code", (Object)reqDto.getRuleCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getRuleName())) {
            queryWrapper.like((Object)"rule_name", (Object)reqDto.getRuleName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getRuleStatus())) {
            queryWrapper.eq((Object)"rule_status", (Object)reqDto.getRuleStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getApplyShop())) {
            queryWrapper.eq((Object)"apply_shop", (Object)reqDto.getApplyShop());
        }
        if (Objects.nonNull(reqDto.getPriority())) {
            queryWrapper.eq((Object)"priority", (Object)reqDto.getPriority());
        }
        if (Objects.nonNull(reqDto.getAutoGenerateInvoice())) {
            queryWrapper.eq((Object)"auto_generate_invoice", (Object)reqDto.getAutoGenerateInvoice());
        }
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByDesc((Object)"update_time");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List billRuleEos = this.billRuleMapper.selectList((Wrapper)queryWrapper);
        PageInfo eoPageInfo = new PageInfo(billRuleEos);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void modifyStatus(BillRuleReqDto reqDto) {
        log.info("\u4fee\u6539\u5f00\u7968\u89c4\u5219\u72b6\u6001\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        BillRuleStatusEnum statusEnum = BillRuleStatusEnum.getByCode((String)reqDto.getRuleStatus());
        AssertUtil.isTrue(Objects.nonNull(statusEnum), "\u6ca1\u6709\u8be5\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5");
        BillRuleEo billRuleEo = (BillRuleEo)this.billRuleMapper.selectById((Serializable)reqDto.getId());
        log.info("\u6570\u636e\u5e93\u67e5\u8be2\u5f00\u7968\u89c4\u5219\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)billRuleEo));
        AssertUtil.isTrue(Objects.nonNull(billRuleEo), "\u67e5\u8be2\u4e0d\u5230\u5f00\u7968\u89c4\u5219\u6570\u636e");
        AssertUtil.isTrue(!reqDto.getRuleStatus().equals(billRuleEo.getRuleStatus()), String.format("\u5df2\u662f\uff1a%s\u72b6\u6001\uff0c\u8bf7\u5237\u65b0\u67e5\u770b", statusEnum.getDesc()));
        billRuleEo.setRuleStatus(reqDto.getRuleStatus());
        this.billRuleDas.update((BaseEo)billRuleEo);
    }

    private void checkParam(BillRuleReqDto addReqDto) {
        AssertUtil.isTrue(Objects.nonNull(addReqDto), "\u5f00\u7968\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addReqDto.getRuleName()), "\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(addReqDto.getPriority()), "\u4f18\u5148\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)addReqDto.getApplyShop()), "\u9002\u7528\u5e97\u94fa\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(addReqDto.getAutoGenerateInvoice()), "\u81ea\u52a8\u5f00\u7968\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)addReqDto.getShopReqDtos()), "\u5f00\u7968\u7b56\u7565\u5e97\u94fa\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(addReqDto.getFirstLevelEfficiency()), "\u4e00\u7ea7\u80fd\u6548\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(Objects.nonNull(addReqDto.getSecondLevelEfficiency()), "\u4e8c\u7ea7\u80fd\u6548\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

