/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillItemDas;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderInfoDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoColourTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.PushPlatformStateEnum;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.eo.BillItemEo;
import com.yunxi.dg.base.center.finance.eo.PerformOrderInfoEo;
import com.yunxi.dg.base.center.finance.eo.PerformOrderSnapshotEo;
import com.yunxi.dg.base.center.finance.service.entity.ICallBackPassPlatformInvoiceService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.pull.dto.IinvoiceItemsReqDto;
import com.yunxi.dg.base.center.pull.dto.IinvoiceUploadReqDto;
import com.yunxi.dg.base.center.pull.proxy.IInvoiceChannelApiProxy;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CallBackPassPlatformInvoiceServiceImpl
implements ICallBackPassPlatformInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(CallBackPassPlatformInvoiceServiceImpl.class);
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IBillItemDas billItemDas;
    @Resource
    private IInvoiceChannelApiProxy iInvoiceChannelApiProxy;
    @Resource
    private IPerformOrderSnapshotDomain iPerformOrderSnapshotDomain;
    @Resource
    private IPerformOrderInfoDomain iPerformOrderInfoDomain;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private ICacheService cacheService;
    private final Semaphore semaphore = new Semaphore(5);

    @Override
    @Async
    public void callBackChannelInvoiceInfo(String billFlowNo) {
        BillInfoEo updateInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)billFlowNo)).one();
        this.callBackChannelInvoiceInfo(updateInfoEo);
    }

    @Override
    public void callBackChannelInvoiceInfo(BillInfoEo updateInfoEo) {
        this.callBackChannelInvoiceInfo(updateInfoEo, false);
    }

    @Override
    public void callBackChannelInvoiceInfo(BillInfoEo updateInfoEo, boolean retry) {
        log.info("\u67e5\u8be2\u5904\u7406\u56de\u4f20\u5e73\u53f0\u5355\u636e\uff1a{}", JSON.toJSON((Object)updateInfoEo));
        if (!BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(updateInfoEo.getBillType())) {
            log.info("\u975e\u84dd\u7968\u4e0d\u9700\u8981\u5904\u7406:{},{}", (Object)updateInfoEo.getPlatformOrderNo(), (Object)updateInfoEo.getBillFlowNo());
            return;
        }
        List performOrderInfoEos = ((ExtQueryChainWrapper)this.iPerformOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)updateInfoEo.getPlatformOrderNo())).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)performOrderInfoEos), String.format("\u3010%s\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f", updateInfoEo.getPlatformOrderNo()));
        List collect = performOrderInfoEos.stream().filter(x -> 1 == x.getOrderSource()).collect(Collectors.toList());
        List orderIds = performOrderInfoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List orderLabelRecordEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderLabelRecordDomain.filter().in((Object)"order_id", orderIds)).eq((Object)"label_code", (Object)"SALE_ORDER_CREATE")).list();
        if (CollectionUtils.isNotEmpty((Collection)orderLabelRecordEos) && CollectionUtils.isEmpty(collect)) {
            log.info("\u8bf4\u660e\u662f\u624b\u5de5\uff0c\u4e0d\u9700\u8981\u5904\u7406 \u6216\u8005\u975e\u84dd\u7968: {} - {}", (Object)updateInfoEo.getBillFlowNo(), (Object)updateInfoEo.getPlatformOrderNo());
            return;
        }
        String pushPlatformState = null;
        String pushPlatformError = null;
        try {
            IinvoiceUploadReqDto reqDto = this.buildInvoiceUploadReqDto(updateInfoEo);
            log.info("\u53d1\u8d77\u8bf7\u6c42\u56de\u8c03\u5e73\u53f0\u5165\u53c2=\u300b{}", (Object)JSONUtil.toJsonStr((Object)updateInfoEo));
            RestResponse restResp = retry ? this.iInvoiceChannelApiProxy.invoiceUploadRetries(reqDto) : this.iInvoiceChannelApiProxy.invoiceUpload(reqDto);
            log.info("\u56de\u8c03\u7ed3\u679c=\u300b{}", (Object)JSONUtil.toJsonStr((Object)restResp));
            String code = restResp.getResultCode();
            if ("0".equals(code)) {
                pushPlatformState = PushPlatformStateEnum.SUCCESS.getCode();
                pushPlatformError = "";
            } else {
                pushPlatformState = PushPlatformStateEnum.FAIL.getCode();
                pushPlatformError = restResp.getResultMsg();
            }
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u5e73\u53f0\u53d1\u7968\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            pushPlatformState = PushPlatformStateEnum.FAIL.getCode();
            pushPlatformError = e.getMessage();
        }
        BillInfoEo u = new BillInfoEo();
        u.setId(updateInfoEo.getId());
        u.setPushPlatformState(pushPlatformState);
        u.setPushPlatformError(pushPlatformError);
        this.billInfoDas.updateSelective((BaseEo)u);
    }

    private IinvoiceUploadReqDto buildInvoiceUploadReqDto(BillInfoEo infoEo) {
        List performOrderInfoEos = ((ExtQueryChainWrapper)this.iPerformOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)infoEo.getPlatformOrderNo())).list();
        PerformOrderInfoEo performOrderInfoEo = (PerformOrderInfoEo)performOrderInfoEos.get(0);
        List snapshotEoList = ((ExtQueryChainWrapper)this.iPerformOrderSnapshotDomain.filter().eq((Object)"order_id", (Object)performOrderInfoEo.getId())).list();
        PerformOrderSnapshotEo performOrderSnapshotEo = (PerformOrderSnapshotEo)snapshotEoList.get(0);
        IinvoiceUploadReqDto reqDto = new IinvoiceUploadReqDto();
        reqDto.setChannelCode(performOrderSnapshotEo.getSiteCode());
        reqDto.setShopCode(performOrderSnapshotEo.getShopCode());
        reqDto.setPlatformOrderNo(infoEo.getPlatformOrderNo());
        reqDto.setReceiverTaxNo(infoEo.getDistributorTaxesCode());
        reqDto.setReceiverName(infoEo.getEntityName());
        reqDto.setInvoiceNo(infoEo.getExternalInvoiceNo());
        reqDto.setInvoiceCode(infoEo.getExternalInvoiceCode());
        reqDto.setIvcTitle(infoEo.getBillTitle());
        reqDto.setRegisteredAddress(infoEo.getRegisteredAddress());
        reqDto.setRegisteredPhone(infoEo.getRegisteredPhone());
        reqDto.setBankAccount(infoEo.getBankAccount());
        reqDto.setBank(infoEo.getBank());
        reqDto.setPayerRegisterNo(infoEo.getTaxesCode());
        reqDto.setTotalPrice(infoEo.getInvoiceAmount());
        reqDto.setInvoiceTime(com.dtyunxi.util.DateUtil.format((Date)infoEo.getExternalInvoiceTime()));
        reqDto.setPdfUrl(StrUtil.isNotBlank((CharSequence)infoEo.getUploadPdfUrl()) ? infoEo.getUploadPdfUrl() : infoEo.getInvoiceConnectUrl());
        reqDto.setInvoiceKind(this.convertPlatformInvoiceType(infoEo.getInvoiceType()));
        reqDto.setBusinessType(Integer.valueOf(infoEo.getTitleType().equals("person") ? 0 : 1));
        this.buildInvoiceItems(infoEo, reqDto);
        return reqDto;
    }

    private void buildInvoiceItems(BillInfoEo infoEo, IinvoiceUploadReqDto reqDto) {
        List billItemEoList = ((ExtQueryChainWrapper)this.billItemDas.filter().eq((Object)"bill_flow_no", (Object)infoEo.getBillFlowNo())).list(Integer.valueOf(Integer.MAX_VALUE));
        ArrayList<IinvoiceItemsReqDto> invoiceItems = new ArrayList<IinvoiceItemsReqDto>();
        for (BillItemEo billItemEo : billItemEoList) {
            IinvoiceItemsReqDto dto = IinvoiceItemsReqDto.builder().taxRate(billItemEo.getTaxRate()).tax(billItemEo.getTaxAmount()).price(billItemEo.getUnitPrice()).quantity(Integer.valueOf(billItemEo.getQuantity().intValue())).sumPrice(billItemEo.getAmount().subtract(billItemEo.getTaxAmount())).amount(billItemEo.getAmount()).itemNo(billItemEo.getTaxClassificationCode()).itemName(billItemEo.getItemName()).productName(billItemEo.getBillLineItemName()).specification(billItemEo.getSpecification()).unit(billItemEo.getUnit()).build();
            invoiceItems.add(dto);
            reqDto.setSumPrice(reqDto.getSumPrice().add(dto.getSumPrice()));
            reqDto.setSumTax(reqDto.getSumTax().add(billItemEo.getTaxAmount()));
        }
        reqDto.setInvoiceItems(invoiceItems);
    }

    private Integer convertPlatformInvoiceType(String invoiceType) {
        switch (invoiceType) {
            case "electronic_general_invoice": {
                return 0;
            }
            case "paper_general_invoice": {
                return 1;
            }
            case "special_paper_invoice": {
                return 2;
            }
            case "electronic_special_invoice": {
                return 3;
            }
            case "all_electronic_general_invoice": {
                return 4;
            }
            case "all_electronic_special_invoice": {
                return 5;
            }
            case "num_electronic_special_paper_invoice": {
                return 6;
            }
            case "num_electronic_paper_general_invoice": {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public void callbackFailedInvoiceInfo(Date startTime, Date endTime) {
        this.callbackFailedInvoiceInfo(startTime, endTime, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callbackFailedInvoiceInfo(Date startTime, Date endTime, boolean retry) {
        if (StrUtil.isBlank((CharSequence)ServiceContext.getContext().getRequestId())) {
            String reqId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)reqId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        }
        log.info("\u6839\u636e\u65f6\u95f4\u8303\u56f4\u56de\u4f20\u5e73\u53f0\u53d1\u7968\uff1astartTime={}, endTime={}", (Object)DateUtil.formatDateTime((Date)startTime), (Object)DateUtil.formatDateTime((Date)endTime));
        String cacheKey = "batch_callback_platform_invoice";
        try {
            boolean hasNextPage;
            Boolean success = this.cacheService.setIfAbsent(cacheKey, (Object)true, 18000);
            if (success == null || !success.booleanValue()) {
                throw new BizException("\u5df2\u6709\u4e00\u4e2a\u6309\u65f6\u95f4\u8303\u56f4\u56de\u4f20\u5e73\u53f0\u53d1\u7968\u7684\u4efb\u52a1\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            int pageNum = 1;
            do {
                PageInfo page = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"dr", (Object)0)).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).eq((Object)"invoice_state", (Object)InvoiceStateEnum.BILLED.getCode())).eq((Object)"push_platform_state", (Object)PushPlatformStateEnum.FAIL.getCode())).between((Object)"external_invoice_time", (Object)startTime, (Object)endTime)).page(Integer.valueOf(pageNum), Integer.valueOf(1000));
                hasNextPage = page.isHasNextPage();
                log.info("\u9700\u8981\u56de\u4f20\u5e73\u53f0\u53d1\u7968\u7684\u84dd\u7968\u603b\u6570={}\uff0c\u5f53\u524d\u9875\u7801={}/{}\uff0c\u9875\u5927\u5c0f={}\uff0c\u5f53\u524d\u9875\u6570\u91cf={}", new Object[]{page.getTotal(), page.getPageNum(), page.getPages(), page.getPageSize(), page.getList().size()});
                this.callBackChannelInvoiceInfo(page.getList(), retry);
                ++pageNum;
            } while (hasNextPage);
        }
        finally {
            this.cacheService.delCache(cacheKey);
        }
    }

    private void callBackChannelInvoiceInfo(List<BillInfoEo> list, boolean retry) {
        log.info("\u51c6\u5907\u56de\u4f20\u5e73\u53f0\u53d1\u7968\u6570\u636e\uff0c\u5171 {} \u6761", (Object)list.size());
        String reqId = ServiceContext.getContext().getRequestId();
        CompletableFuture.allOf((CompletableFuture[])list.stream().map(billInfoEo -> CompletableFuture.runAsync(() -> {
            try {
                ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                MDC.put((String)"yes.req.requestId", (String)reqId);
                this.semaphore.acquire();
                Thread.sleep(1000L);
                this.callBackChannelInvoiceInfo((BillInfoEo)billInfoEo, retry);
            }
            catch (Exception e) {
                log.warn("\u56de\u4f20\u5e73\u53f0\u53d1\u7968\u6570\u636e\u5931\u8d25\uff1a{}", (Object)billInfoEo.getBillFlowNo(), (Object)e);
            }
            finally {
                this.semaphore.release();
            }
        })).toArray(CompletableFuture[]::new)).join();
    }
}

