/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.convert.entity.KeepAccountsDetailConverter;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDas;
import com.yunxi.dg.base.center.finance.dao.das.IShopDas;
import com.yunxi.dg.base.center.finance.dao.vo.DeliveryProjectKeeVo;
import com.yunxi.dg.base.center.finance.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepAccountsDetailDomain;
import com.yunxi.dg.base.center.finance.dto.common.FinanceConstant;
import com.yunxi.dg.base.center.finance.dto.entity.DeliveryProjectKeeDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepAccountsDetailDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepFinancialRemarksDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepTotalDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.KeepAccountingReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepAccountsDetailReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepWhetherAccruedReqDto;
import com.yunxi.dg.base.center.finance.dto.response.AccountingDetailRespDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepAccountsDetailExcelDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepAccountsDetailRespDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderChargeCodeRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IKeepAccountsDetailService;
import com.yunxi.dg.base.center.inventory.dao.das.IAdjustmentOrderDas;
import com.yunxi.dg.base.center.inventory.dao.das.IAdjustmentOrderDetailDas;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.IInventoryAdjustmentOrderApiProxy;
import com.yunxi.dg.base.center.report.api.IDgSaleOrderApi;
import com.yunxi.dg.base.center.report.dto.BillShopInfoDto;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepAccountsDetailServiceImpl
extends BaseServiceImpl<KeepAccountsDetailDto, KeepAccountsDetailEo, IKeepAccountsDetailDomain>
implements IKeepAccountsDetailService {
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IDgSaleOrderApi iDgSaleOrderApi;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;
    @Resource
    private IKeepAccountsDetailDomain keepAccountsDetailDomain;
    @Resource
    private IPushKeepAccountsDas pushKeepAccountsDas;
    @Resource
    private IShopDas shopDas;
    @Resource
    private IAdjustmentOrderDetailDas adjustmentOrderDetailDas;
    @Resource
    private IAdjustmentOrderDas adjustmentOrderDas;
    @Resource
    private IInventoryAdjustmentOrderApiProxy proxy;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;

    public KeepAccountsDetailServiceImpl(IKeepAccountsDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<KeepAccountsDetailDto, KeepAccountsDetailEo> converter() {
        return KeepAccountsDetailConverter.INSTANCE;
    }

    @Override
    public Long addKeepAccountsDetail(KeepAccountsDetailReqDto addReqDto) {
        KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)keepAccountsDetailEo);
        this.keepAccountsDetailDas.insert((BaseEo)keepAccountsDetailEo);
        return keepAccountsDetailEo.getId();
    }

    @Override
    public void modifyKeepAccountsDetail(KeepAccountsDetailReqDto modifyReqDto) {
        KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)keepAccountsDetailEo);
        this.keepAccountsDetailDas.updateSelective((BaseEo)keepAccountsDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeKeepAccountsDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.keepAccountsDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public KeepAccountsDetailRespDto queryById(Long id) {
        KeepAccountsDetailEo keepAccountsDetailEo = (KeepAccountsDetailEo)this.keepAccountsDetailDas.selectByPrimaryKey(id);
        KeepAccountsDetailRespDto keepAccountsDetailRespDto = new KeepAccountsDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)keepAccountsDetailEo, (BaseVo)keepAccountsDetailRespDto);
        return keepAccountsDetailRespDto;
    }

    @Override
    public List<KeepAccountsDetailRespDto> queryByIds(List<Long> ids, String vocherType) {
        List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", ids)).eq((Object)"voucher_type", (Object)vocherType)).list();
        ArrayList keepAccountsDetailRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)keepAccountsDetailRespDtos, (Collection)keepAccountsDetailEos, KeepAccountsDetailRespDto.class);
        return keepAccountsDetailRespDtos;
    }

    @Override
    public PageInfo<KeepAccountsDetailRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        KeepAccountsDetailReqDto keepAccountsDetailReqDto = (KeepAccountsDetailReqDto)JSON.parseObject((String)filter, KeepAccountsDetailReqDto.class);
        KeepAccountsDetailEo keepAccountsDetailEo = new KeepAccountsDetailEo();
        DtoHelper.dto2Eo((BaseVo)keepAccountsDetailReqDto, (BaseEo)keepAccountsDetailEo);
        PageInfo eoPageInfo = this.keepAccountsDetailDomain.selectPage((BaseEo)keepAccountsDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, KeepAccountsDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<KeepAccountsDetailRespDto> queryPage(KeepAccountsDetailReqDto accountsDetailReqDto, Integer pageNum, Integer pageSize) {
        this.logger.info("\u8bb0\u8d26\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)accountsDetailReqDto));
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().orderByDesc((Object)"id");
        this.queryCondition((ExtQueryChainWrapper<KeepAccountsDetailEo>)sqlFilters, accountsDetailReqDto);
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, KeepAccountsDetailRespDto.class);
        HashSet chargeCodes = new HashSet();
        HashSet skuCodes = new HashSet();
        dtoList.forEach(v -> {
            chargeCodes.add(v.getChargeCode());
            skuCodes.add(v.getItemCode());
        });
        Map accountsMap = this.pushKeepAccountsDas.getMapByChargeCodes(chargeCodes);
        Map skuMap = this.itemSkuDgDomain.getMapByCodes(skuCodes);
        Set platformOrderNos = dtoList.stream().map(KeepAccountsDetailRespDto::getPlatformOrderNo).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Object, Object> platformToDistributionMap = new HashMap();
        if (CollectionUtils.isNotEmpty(platformOrderNos)) {
            try {
                RestResponse response = this.iDgSaleOrderApi.queryByPlatformOrderNos(new ArrayList(platformOrderNos));
                if (response != null && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
                    platformToDistributionMap = ((List)response.getData()).stream().filter(dto -> dto.getPlatformOrderNo() != null && dto.getDistributionOrderNo() != null).collect(Collectors.toMap(BillShopInfoDto::getPlatformOrderNo, BillShopInfoDto::getDistributionOrderNo, (k1, k2) -> k1));
                }
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636e\u5e73\u53f0\u5355\u53f7\u67e5\u8be2\u5206\u9500\u5355\u53f7\u5f02\u5e38", (Throwable)e);
            }
        }
        HashMap finalPlatformToDistributionMap = platformToDistributionMap;
        dtoList.forEach(v -> {
            if (null != v.getAccountingResult()) {
                v.setAccountingResult(v.getAccountingResult());
            }
            if (Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), v.getVoucherType())) {
                v.setChargeAccountName(v.getChargeAccountName());
            } else if (Objects.equals(VoucherTypeEnum.INVOICE.getCode(), v.getVoucherType())) {
                v.setChargeAccountName(v.getBillAccountName());
            }
            v.setMealOrSingleItem(Integer.valueOf(StringUtils.isNotBlank((CharSequence)v.getGroupSkuCode()) ? BigDecimal.ONE.intValue() : BigDecimal.ZERO.intValue()));
            v.setCrossOrganizationalTransactionName(StrUtil.isNotBlank((CharSequence)v.getCrossOrganizationalTransaction()) ? ("yes".equalsIgnoreCase(v.getCrossOrganizationalTransaction()) ? "\u662f" : "\u5426") : "");
            ArrayList<String> reasons = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)v.getQueryPriceResult()) && !"SUCCESS".equals(v.getQueryPriceResult())) {
                reasons.add(v.getQueryPriceResult());
            }
            if (StringUtils.isNotBlank((CharSequence)v.getUpdateQtyResult()) && !"SUCCESS".equals(v.getUpdateQtyResult())) {
                reasons.add(v.getUpdateQtyResult());
            }
            v.setReason(reasons.isEmpty() ? "" : String.join((CharSequence)";", reasons));
            Optional.ofNullable(accountsMap.get(v.getChargeCode())).ifPresent(account -> {
                v.setSaleAreaCode(account.getSaleAreaCode());
                v.setSaleAreaName(account.getSaleAreaName());
                if (StringUtils.isBlank((CharSequence)v.getReason())) {
                    v.setReason(account.getReason());
                }
            });
            Optional.ofNullable(skuMap.get(v.getItemCode())).ifPresent(sku -> v.setSpecModel(sku.getSpecModel()));
            v.setSaleDepartment(v.getSaleDeptName());
            if (StringUtils.isBlank((CharSequence)v.getDistributionOrderNo()) && StringUtils.isNotBlank((CharSequence)v.getPlatformOrderNo())) {
                v.setDistributionOrderNo((String)finalPlatformToDistributionMap.get(v.getPlatformOrderNo()));
            }
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Map<String, BigDecimal> queryTotalNew(KeepAccountsDetailReqDto accountsDetailReqDto) {
        this.logger.info("queryTotalNew-\u8bb0\u8d26\u660e\u7ec6\u6570\u91cf\uff0c\u91d1\u989d\u6c47\u603b\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)accountsDetailReqDto));
        if (Objects.nonNull(accountsDetailReqDto)) {
            if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getChargeCodes())) {
                if (accountsDetailReqDto.getChargeCodes().size() > 1) {
                    accountsDetailReqDto.setChargeCodes(accountsDetailReqDto.getChargeCodes());
                } else {
                    accountsDetailReqDto.setChargeCode((String)accountsDetailReqDto.getChargeCodes().get(0));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getOrderNos())) {
                if (accountsDetailReqDto.getOrderNos().size() > 1) {
                    accountsDetailReqDto.setOrderNos(accountsDetailReqDto.getOrderNos());
                } else {
                    accountsDetailReqDto.setOrderNo((String)accountsDetailReqDto.getOrderNos().get(0));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getPlatformOrderNos())) {
                if (accountsDetailReqDto.getPlatformOrderNos().size() > 1) {
                    List distributionOrderEos = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"distribution_order_no", (Collection)accountsDetailReqDto.getPlatformOrderNos())).select(new String[]{"distribution_order_no", "platform_order_no"}).list();
                    if (CollectionUtils.isNotEmpty((Collection)distributionOrderEos)) {
                        List matchedPlatformOrderNos = distributionOrderEos.stream().map(DgPerformOrderInfoEo::getPlatformOrderNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                        accountsDetailReqDto.getPlatformOrderNos().addAll(matchedPlatformOrderNos);
                        List platFormOrderNos = accountsDetailReqDto.getPlatformOrderNos().stream().distinct().collect(Collectors.toList());
                        accountsDetailReqDto.setPlatformOrderNos(platFormOrderNos);
                    } else {
                        accountsDetailReqDto.setPlatformOrderNos(accountsDetailReqDto.getPlatformOrderNos());
                    }
                } else {
                    String orderNo = (String)accountsDetailReqDto.getPlatformOrderNos().get(0);
                    List distributionOrderEos = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().like((Object)"distribution_order_no", (Object)orderNo)).select(new String[]{"distribution_order_no", "platform_order_no"}).list();
                    if (CollectionUtils.isNotEmpty((Collection)distributionOrderEos)) {
                        List matchedPlatformOrderNos = distributionOrderEos.stream().map(DgPerformOrderInfoEo::getPlatformOrderNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                        accountsDetailReqDto.setPlatformOrderNos(matchedPlatformOrderNos);
                        accountsDetailReqDto.setPlatformOrderNo(orderNo);
                    } else {
                        accountsDetailReqDto.setPlatformOrderNo(orderNo);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getCustomerCodeList())) {
                if (accountsDetailReqDto.getCustomerCodeList().size() > 1) {
                    accountsDetailReqDto.setCustomerCodeList(accountsDetailReqDto.getCustomerCodeList());
                } else {
                    accountsDetailReqDto.setCustomerCode((String)accountsDetailReqDto.getCustomerCodeList().get(0));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getWarehouseCodeList())) {
                if (accountsDetailReqDto.getWarehouseCodeList().size() > 1) {
                    accountsDetailReqDto.setWarehouseCodeList(accountsDetailReqDto.getWarehouseCodeList());
                } else {
                    accountsDetailReqDto.setWarehouseCode((String)accountsDetailReqDto.getWarehouseCodeList().get(0));
                }
            }
            if (Objects.nonNull(accountsDetailReqDto.getStartTime())) {
                accountsDetailReqDto.setStartTime(accountsDetailReqDto.getStartTime() + " 00:00:00");
            }
            if (Objects.nonNull(accountsDetailReqDto.getEndTime())) {
                accountsDetailReqDto.setEndTime(accountsDetailReqDto.getEndTime() + " 23:59:59");
            }
            if (Objects.nonNull(accountsDetailReqDto.getSaleChargeStartDate())) {
                accountsDetailReqDto.setSaleChargeStartDate(accountsDetailReqDto.getSaleChargeStartDate() + " 00:00:00");
            }
            if (Objects.nonNull(accountsDetailReqDto.getSaleChargeEndDate())) {
                accountsDetailReqDto.setSaleChargeEndDate(accountsDetailReqDto.getSaleChargeEndDate() + " 23:59:59");
            }
            if (Objects.nonNull(accountsDetailReqDto.getCreateTimeStart())) {
                accountsDetailReqDto.setCreateTimeStart(accountsDetailReqDto.getCreateTimeStart() + " 00:00:00");
            }
            if (Objects.nonNull(accountsDetailReqDto.getCreateTimeEnd())) {
                accountsDetailReqDto.setCreateTimeEnd(accountsDetailReqDto.getCreateTimeEnd() + " 23:59:59");
            }
            if (Objects.nonNull(accountsDetailReqDto.getDeliveryTimeStart())) {
                accountsDetailReqDto.setDeliveryTimeStart(accountsDetailReqDto.getDeliveryTimeStart() + " 00:00:00");
            }
            if (Objects.nonNull(accountsDetailReqDto.getDeliveryTimeEnd())) {
                accountsDetailReqDto.setDeliveryTimeEnd(accountsDetailReqDto.getDeliveryTimeEnd() + " 23:59:59");
            }
            if (Objects.nonNull(accountsDetailReqDto.getCompleteTimeStart())) {
                accountsDetailReqDto.setCompleteTimeStart(accountsDetailReqDto.getCompleteTimeStart() + " 00:00:00");
            }
            if (Objects.nonNull(accountsDetailReqDto.getCompleteTimeEnd())) {
                accountsDetailReqDto.setCompleteTimeEnd(accountsDetailReqDto.getCompleteTimeEnd() + " 23:59:59");
            }
            if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getSpecifyPricingPlan())) {
                if (Objects.equals(accountsDetailReqDto.getSpecifyPricingPlan(), "\u9ed8\u8ba4")) {
                    accountsDetailReqDto.setSpecifyPricingPlan(null);
                } else {
                    accountsDetailReqDto.setSpecifyPricingPlan(accountsDetailReqDto.getSpecifyPricingPlan().trim());
                }
            }
        }
        HashMap resultMap = Maps.newHashMap();
        KeepTotalDto keepTotalDto = this.keepAccountsDetailDas.queryTotalNew(accountsDetailReqDto);
        if (Objects.isNull(keepTotalDto)) {
            resultMap.put("sumItemNum", BigDecimal.ZERO);
            resultMap.put("sumItemPrice", BigDecimal.ZERO);
            return resultMap;
        }
        this.logger.info("\u8bb0\u8d26\u660e\u7ec6\u6570\u91cf\uff0c\u91d1\u989d\u6c47\u603b\uff1a\uff1a{}", (Object)JSONObject.toJSONString((Object)keepTotalDto));
        resultMap.put("sumItemNum", keepTotalDto.getSumItemNum());
        resultMap.put("sumItemPrice", keepTotalDto.getSumItemPrice());
        return resultMap;
    }

    @Override
    public Map<String, BigDecimal> queryTotal(KeepAccountsDetailReqDto accountsDetailReqDto) {
        this.logger.info("\u8bb0\u8d26\u660e\u7ec6\u6570\u91cf\uff0c\u91d1\u989d\u6c47\u603b\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)accountsDetailReqDto));
        ExtQueryChainWrapper sqlFilters = this.keepAccountsDetailDas.filter().select(new String[]{"item_num,order_type,item_price"});
        this.queryCondition((ExtQueryChainWrapper<KeepAccountsDetailEo>)sqlFilters, accountsDetailReqDto);
        List keepAccountsDetailEos = sqlFilters.list();
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty((Collection)keepAccountsDetailEos)) {
            resultMap.put("sumItemNum", BigDecimal.ZERO);
            resultMap.put("sumItemPrice", BigDecimal.ZERO);
            return resultMap;
        }
        Integer saleItemNum = 0;
        BigDecimal saleSumItemPrice = BigDecimal.ZERO;
        List keepAccountsEos = keepAccountsDetailEos.stream().filter(x -> null != x.getItemNum() && BillTypeEnum.SALE_LIST.getCode().equals(x.getOrderType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(keepAccountsEos)) {
            saleItemNum = keepAccountsEos.stream().filter(x -> null != x.getItemNum()).map(KeepAccountsDetailEo::getItemNum).reduce(Integer::sum).get();
            saleSumItemPrice = keepAccountsEos.stream().filter(x -> null != x.getItemPrice()).map(KeepAccountsDetailEo::getItemPrice).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(4, 4);
        }
        this.logger.info("\u6b63\u5411\u8bb0\u8d26\u660e\u7ec6\u5408\u8ba1:saleItemNum:{},saleSumItemPrice:{}", (Object)saleItemNum, (Object)saleSumItemPrice);
        Integer afterItemNum = 0;
        BigDecimal afterSumItemPrice = BigDecimal.ZERO;
        List accountsEos = keepAccountsDetailEos.stream().filter(x -> null != x.getItemNum() && !BillTypeEnum.SALE_LIST.getCode().equals(x.getOrderType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(accountsEos)) {
            afterItemNum = accountsEos.stream().filter(x -> null != x.getItemNum()).map(KeepAccountsDetailEo::getItemNum).reduce(Integer::sum).get();
            afterSumItemPrice = accountsEos.stream().filter(x -> null != x.getItemPrice()).map(KeepAccountsDetailEo::getItemPrice).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(4, 4);
        }
        this.logger.info("\u9006\u5411\u8bb0\u8d26\u660e\u7ec6\u5408\u8ba1:afterItemNum:{},afterSumItemPrice:{}", (Object)afterItemNum, (Object)afterSumItemPrice);
        BigDecimal sumItemNum = BigDecimal.ZERO;
        sumItemNum = sumItemNum.add(new BigDecimal(saleItemNum)).add(0 == afterItemNum ? BigDecimal.ZERO : new BigDecimal(afterItemNum).negate());
        BigDecimal sumItemPrice = BigDecimal.ZERO;
        sumItemPrice = sumItemPrice.add(saleSumItemPrice).add(afterSumItemPrice.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : afterSumItemPrice.negate());
        this.logger.info("\u8bb0\u8d26\u660e\u7ec6\u6570\u91cf\uff0c\u91d1\u989d\u6c47\u603b\uff1asumItemNum{}\uff0csumItemPrice\uff1a{}", (Object)sumItemNum, (Object)sumItemPrice);
        resultMap.put("sumItemNum", sumItemNum);
        resultMap.put("sumItemPrice", sumItemPrice);
        return resultMap;
    }

    @Override
    public String export(KeepAccountsDetailReqDto accountsDetailReqDto) {
        String fileName = "/\u8bb0\u8d26\u660e\u7ec6\u6570\u636e_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        OssRegistryVo ossRegistryVo = (OssRegistryVo)SpringBeanUtil.getBean(OssRegistryVo.class);
        String url = ossRegistryVo.getEndpoint() + "/" + ossRegistryVo.getDir() + fileName + ".xls";
        try {
            ArrayList result = Lists.newArrayList();
            ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().orderByDesc((Object)"create_time");
            this.queryCondition((ExtQueryChainWrapper<KeepAccountsDetailEo>)sqlFilters, accountsDetailReqDto);
            PageInfo pageInfo = sqlFilters.page(Integer.valueOf(1), Integer.valueOf(1000));
            result.addAll(this.assembleAccountExportVo(pageInfo.getList()));
            int pageNo = (int)Math.ceil(Double.valueOf(pageInfo.getTotal()) / Double.valueOf(1000.0));
            for (int i = 2; i < pageNo; ++i) {
                PageInfo eoPageInfo = sqlFilters.page(Integer.valueOf(i), Integer.valueOf(1000));
                result.addAll(this.assembleAccountExportVo(eoPageInfo.getList()));
            }
        }
        catch (Exception e) {
            this.logger.error("fileName: {}\u5bfc\u51fa\u8bb0\u8d26\u660e\u7ec6\u6570\u636e\u5f02\u5e38: {}", (Object)fileName, (Object)e);
            throw new BizException("\u5bfc\u51fa\u8bb0\u8d26\u660e\u7ec6\u6570\u636e\u5f02\u5e38:", e.getMessage());
        }
        return url;
    }

    @Override
    public List<AccountingDetailRespDto> queryKeepAccountDetailList(KeepAccountsDetailReqDto accountsDetailReqDto) {
        ArrayList result = Lists.newArrayList();
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().orderByDesc((Object)"create_time");
        this.queryCondition((ExtQueryChainWrapper<KeepAccountsDetailEo>)sqlFilters, accountsDetailReqDto);
        PageInfo pageInfo = sqlFilters.page(Integer.valueOf(1), Integer.valueOf(1000));
        result.addAll(this.assembleVo(pageInfo.getList()));
        int pageNo = (int)Math.ceil(Double.valueOf(pageInfo.getTotal()) / Double.valueOf(1000.0));
        for (int i = 2; i < pageNo; ++i) {
            PageInfo eoPageInfo = sqlFilters.page(Integer.valueOf(i), Integer.valueOf(1000));
            result.addAll(this.assembleVo(eoPageInfo.getList()));
        }
        return result;
    }

    private List<AccountingDetailRespDto> assembleVo(List<KeepAccountsDetailEo> accountsDetailEos) {
        ArrayList excelDtoList = Lists.newArrayList();
        accountsDetailEos.forEach(v -> {
            AccountingDetailRespDto excelDto = new AccountingDetailRespDto();
            CubeBeanUtils.copyProperties((Object)excelDto, (Object)v, (String[])new String[0]);
            excelDto.setBookKeeping("1".equals(v.getBookKeeping()) ? "\u5df2\u8bb0\u8d26" : "\u672a\u8bb0\u8d26");
            if (Objects.equals("virtual", v.getWarehouseCode())) {
                excelDto.setWarehouseCode(null);
            }
            excelDtoList.add(excelDto);
        });
        return excelDtoList;
    }

    private List<KeepAccountsDetailExcelDto> assembleAccountExportVo(List<KeepAccountsDetailEo> accountsDetailEos) {
        ArrayList excelDtoList = Lists.newArrayList();
        accountsDetailEos.forEach(v -> {
            KeepAccountsDetailExcelDto excelDto = new KeepAccountsDetailExcelDto();
            CubeBeanUtils.copyProperties((Object)excelDto, (Object)v, (String[])new String[0]);
            excelDto.setBookKeeping("1".equals(v.getBookKeeping()) ? "\u5df2\u8bb0\u8d26" : "\u672a\u8bb0\u8d26");
            excelDtoList.add(excelDto);
        });
        return excelDtoList;
    }

    private void queryCondition(ExtQueryChainWrapper<KeepAccountsDetailEo> sqlFilters, KeepAccountsDetailReqDto accountsDetailReqDto) {
        StringBuilder sql;
        sqlFilters.isNotNull((Object)"charge_code");
        if (Objects.isNull(accountsDetailReqDto)) {
            return;
        }
        if (Objects.nonNull(accountsDetailReqDto.getChargeCode())) {
            sqlFilters.like((Object)"charge_code", (Object)accountsDetailReqDto.getChargeCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getChargeCodes())) {
            if (accountsDetailReqDto.getChargeCodes().size() > 1) {
                sqlFilters.in((Object)"charge_code", (Collection)accountsDetailReqDto.getChargeCodes());
            } else {
                sqlFilters.like((Object)"charge_code", accountsDetailReqDto.getChargeCodes().get(0));
            }
        }
        if (Objects.nonNull(accountsDetailReqDto.getOrderNo())) {
            sql = new StringBuilder();
            sql.append(" ( ");
            sql.append(" order_no like '%" + accountsDetailReqDto.getOrderNo() + "%' or platform_order_no like '%" + accountsDetailReqDto.getOrderNo() + "%' or platform_no like '%" + accountsDetailReqDto.getOrderNo() + "%'");
            sql.append(")");
            sqlFilters.apply(sql.toString(), new Object[0]);
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getOrderNos())) {
            if (accountsDetailReqDto.getOrderNos().size() > 1) {
                sqlFilters.in((Object)"order_no", (Collection)accountsDetailReqDto.getOrderNos());
            } else {
                sqlFilters.like((Object)"order_no", accountsDetailReqDto.getOrderNos().get(0));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getGroupReceiveOrderNos())) {
            if (accountsDetailReqDto.getGroupReceiveOrderNos().size() > 1) {
                sqlFilters.in((Object)"group_receive_order", (Collection)accountsDetailReqDto.getGroupReceiveOrderNos());
            } else {
                sqlFilters.like((Object)"group_receive_order", accountsDetailReqDto.getGroupReceiveOrderNos().get(0));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getPlatformOrderNos())) {
            if (accountsDetailReqDto.getPlatformOrderNos().size() > 1) {
                List distributionOrderEos = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"distribution_order_no", (Collection)accountsDetailReqDto.getPlatformOrderNos())).select(new String[]{"distribution_order_no", "platform_order_no"}).list();
                if (CollectionUtils.isNotEmpty((Collection)distributionOrderEos)) {
                    List matchedPlatformOrderNos = distributionOrderEos.stream().map(DgPerformOrderInfoEo::getPlatformOrderNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                    accountsDetailReqDto.getPlatformOrderNos().addAll(matchedPlatformOrderNos);
                    List platFormOrderNos = accountsDetailReqDto.getPlatformOrderNos().stream().distinct().collect(Collectors.toList());
                    sqlFilters.in((Object)"platform_no", platFormOrderNos);
                } else {
                    sqlFilters.in((Object)"platform_no", (Collection)accountsDetailReqDto.getPlatformOrderNos());
                }
            } else {
                String orderNo = (String)accountsDetailReqDto.getPlatformOrderNos().get(0);
                List distributionOrderEos = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().like((Object)"distribution_order_no", (Object)orderNo)).select(new String[]{"distribution_order_no", "platform_order_no"}).list();
                if (CollectionUtils.isNotEmpty((Collection)distributionOrderEos)) {
                    List matchedPlatformOrderNos = distributionOrderEos.stream().map(DgPerformOrderInfoEo::getPlatformOrderNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                    sqlFilters.and(wrapper -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"platform_no", (Collection)matchedPlatformOrderNos)).or()).like((Object)"platform_no", (Object)orderNo);
                    });
                } else {
                    sqlFilters.like((Object)"platform_no", (Object)orderNo);
                }
            }
        }
        if (Objects.nonNull(accountsDetailReqDto.getAccountingResult())) {
            sqlFilters.eq((Object)"accounting_result", (Object)accountsDetailReqDto.getAccountingResult());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getCustomerCodeList())) {
            if (accountsDetailReqDto.getCustomerCodeList().size() > 1) {
                sqlFilters.in((Object)"customer_code", (Collection)accountsDetailReqDto.getCustomerCodeList());
            } else {
                sqlFilters.eq((Object)"customer_code", accountsDetailReqDto.getCustomerCodeList().get(0));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getWarehouseCodeList())) {
            if (accountsDetailReqDto.getWarehouseCodeList().size() > 1) {
                sqlFilters.in((Object)"warehouse_code", (Collection)accountsDetailReqDto.getWarehouseCodeList());
            } else {
                sqlFilters.eq((Object)"warehouse_code", accountsDetailReqDto.getWarehouseCodeList().get(0));
            }
        }
        if (Objects.nonNull(accountsDetailReqDto.getStartTime())) {
            sqlFilters.ge((Object)"charge_date", (Object)(accountsDetailReqDto.getStartTime() + " 00:00:00"));
        }
        if (Objects.nonNull(accountsDetailReqDto.getEndTime())) {
            sqlFilters.le((Object)"charge_date", (Object)(accountsDetailReqDto.getEndTime() + " 23:59:59"));
        }
        if (Objects.nonNull(accountsDetailReqDto.getSaleChargeStartDate())) {
            sqlFilters.ge((Object)"sale_charge_date", (Object)(accountsDetailReqDto.getSaleChargeStartDate() + " 00:00:00"));
        }
        if (Objects.nonNull(accountsDetailReqDto.getSaleChargeEndDate())) {
            sqlFilters.le((Object)"sale_charge_date", (Object)(accountsDetailReqDto.getSaleChargeEndDate() + " 23:59:59"));
        }
        if (Objects.nonNull(accountsDetailReqDto.getVoucherType())) {
            sqlFilters.eq((Object)"voucher_type", (Object)accountsDetailReqDto.getVoucherType());
        }
        if (Objects.nonNull(accountsDetailReqDto.getSaleNo())) {
            sqlFilters.like((Object)"sale_no", (Object)accountsDetailReqDto.getSaleNo());
        }
        if (Objects.nonNull(accountsDetailReqDto.getDeliveryNote())) {
            sqlFilters.like((Object)"delivery_note", (Object)accountsDetailReqDto.getDeliveryNote());
        }
        if (Objects.nonNull(accountsDetailReqDto.getPostingNo())) {
            sqlFilters.like((Object)"posting_no", (Object)accountsDetailReqDto.getPostingNo());
        }
        if (Objects.nonNull(accountsDetailReqDto.getInvoiceNo())) {
            sqlFilters.like((Object)"invoice_no", (Object)accountsDetailReqDto.getInvoiceNo());
        }
        if (Objects.nonNull(accountsDetailReqDto.getItemCode())) {
            sqlFilters.like((Object)"item_code", (Object)accountsDetailReqDto.getItemCode());
        }
        if (CollectionUtil.isNotEmpty((Collection)accountsDetailReqDto.getItemCodes())) {
            sqlFilters.in((Object)"item_code", (Collection)accountsDetailReqDto.getItemCodes());
        }
        if (Objects.nonNull(accountsDetailReqDto.getSaleOrderTypes())) {
            sqlFilters.in((Object)"sale_order_type", (Collection)accountsDetailReqDto.getSaleOrderTypes());
        }
        if (Objects.nonNull(accountsDetailReqDto.getPlatformOrderNo())) {
            sqlFilters.like((Object)"platform_order_no", (Object)accountsDetailReqDto.getPlatformOrderNo());
        }
        if (Objects.nonNull(accountsDetailReqDto.getChargeAccountName())) {
            sql = new StringBuilder();
            sql.append(" ( ");
            sql.append("charge_account_name like '%" + accountsDetailReqDto.getChargeAccountName() + "%' or bill_account_name like '%" + accountsDetailReqDto.getChargeAccountName() + "%'");
            sql.append(")");
            sqlFilters.apply(sql.toString(), new Object[0]);
        }
        if (CollectionUtil.isNotEmpty((Collection)accountsDetailReqDto.getChargeAccountCodes())) {
            sqlFilters.in((Object)"charge_account_code", (Collection)accountsDetailReqDto.getChargeAccountCodes());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getBookKeeping())) {
            sqlFilters.eq((Object)"book_keeping", (Object)accountsDetailReqDto.getBookKeeping());
        }
        if (null != accountsDetailReqDto.getInvoiceKeepStatus()) {
            sqlFilters.eq((Object)"invoice_keep_status", (Object)accountsDetailReqDto.getInvoiceKeepStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getSiteCode())) {
            sqlFilters.eq((Object)"site_code", (Object)accountsDetailReqDto.getSiteCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getSiteCodes())) {
            sqlFilters.in((Object)"site_code", (Collection)accountsDetailReqDto.getSiteCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getSiteCodes())) {
            sqlFilters.in((Object)"site_code", (Collection)accountsDetailReqDto.getSiteCodes());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getShopCode())) {
            sqlFilters.like((Object)"shop_code", (Object)accountsDetailReqDto.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getShopName())) {
            sqlFilters.like((Object)"shop_name", (Object)accountsDetailReqDto.getShopName());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getShopCodes())) {
            sqlFilters.in((Object)"shop_code", (Collection)accountsDetailReqDto.getShopCodes());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getOrderType())) {
            sqlFilters.eq((Object)"order_type", (Object)accountsDetailReqDto.getOrderType());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getOrderTypes())) {
            sqlFilters.in((Object)"order_type", (Collection)accountsDetailReqDto.getOrderTypes());
        }
        if (Objects.nonNull(accountsDetailReqDto.getCreateTimeStart())) {
            sqlFilters.ge((Object)"create_time", (Object)(accountsDetailReqDto.getCreateTimeStart() + " 00:00:00"));
        }
        if (Objects.nonNull(accountsDetailReqDto.getCreateTimeEnd())) {
            sqlFilters.le((Object)"create_time", (Object)(accountsDetailReqDto.getCreateTimeEnd() + " 23:59:59"));
        }
        if (Objects.nonNull(accountsDetailReqDto.getDeliveryTimeStart())) {
            sqlFilters.ge((Object)"delivery_time", (Object)(accountsDetailReqDto.getDeliveryTimeStart() + " 00:00:00"));
        }
        if (Objects.nonNull(accountsDetailReqDto.getDeliveryTimeEnd())) {
            sqlFilters.le((Object)"delivery_time", (Object)(accountsDetailReqDto.getDeliveryTimeEnd() + " 23:59:59"));
        }
        if (Objects.nonNull(accountsDetailReqDto.getCompleteTimeStart())) {
            sqlFilters.ge((Object)"complete_time", (Object)(accountsDetailReqDto.getCompleteTimeStart() + " 00:00:00"));
        }
        if (Objects.nonNull(accountsDetailReqDto.getCompleteTimeEnd())) {
            sqlFilters.le((Object)"complete_time", (Object)(accountsDetailReqDto.getCompleteTimeEnd() + " 23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getMasterDeputyIdentity())) {
            sqlFilters.eq((Object)"master_deputy_identity", (Object)accountsDetailReqDto.getMasterDeputyIdentity());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getSaleOrderType())) {
            sqlFilters.eq((Object)"sale_order_type", (Object)accountsDetailReqDto.getSaleOrderType());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getLineOrderTypes())) {
            sqlFilters.in((Object)"line_order_type", (Collection)accountsDetailReqDto.getLineOrderTypes());
        }
        if (Objects.nonNull(accountsDetailReqDto.getCrossOrganizationalTransaction())) {
            sqlFilters.eq((Object)"cross_organizational_transaction", (Object)accountsDetailReqDto.getCrossOrganizationalTransaction());
        }
        if (CollectionUtil.isNotEmpty((Collection)accountsDetailReqDto.getXfAndGroupOrderNos())) {
            sqlFilters.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"xf_sales_order_no", (Collection)accountsDetailReqDto.getXfAndGroupOrderNos())).or()).in((Object)"xf_purchase_order_no", (Collection)accountsDetailReqDto.getXfAndGroupOrderNos())).or()).in((Object)"group_purchase_order_no", (Collection)accountsDetailReqDto.getXfAndGroupOrderNos())).or()).in((Object)"xf_receive_order_no", (Collection)accountsDetailReqDto.getXfAndGroupOrderNos())).or()).in((Object)"group_receive_order", (Collection)accountsDetailReqDto.getXfAndGroupOrderNos());
            });
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getSpecifyPricingPlan())) {
            if (Objects.equals(accountsDetailReqDto.getSpecifyPricingPlan(), "\u9ed8\u8ba4")) {
                sqlFilters.isNull((Object)"specify_pricing_plan");
            } else {
                sqlFilters.eq((Object)"specify_pricing_plan", (Object)accountsDetailReqDto.getSpecifyPricingPlan().trim());
            }
        }
        if (Objects.nonNull(accountsDetailReqDto) && null != accountsDetailReqDto.getWhetherAccrued()) {
            sqlFilters.eq((Object)"whether_accrued", (Object)accountsDetailReqDto.getWhetherAccrued());
        }
        if (Objects.nonNull(accountsDetailReqDto) && CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getSaleAreaCodes())) {
            sqlFilters.in((Object)"sale_area_code", (Collection)accountsDetailReqDto.getSaleAreaCodes());
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getSaleDeptName())) {
            sqlFilters.like((Object)"sale_dept_name", (Object)accountsDetailReqDto.getSaleDeptName());
        }
        if (Objects.nonNull(accountsDetailReqDto) && CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getSaleDeptCodes())) {
            sqlFilters.in((Object)"sale_dept_code", (Collection)accountsDetailReqDto.getSaleDeptCodes());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getAdjustmentNo())) {
            sqlFilters.like((Object)"adjustment_no", (Object)accountsDetailReqDto.getAdjustmentNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getAdjustmentNoList())) {
            if (accountsDetailReqDto.getAdjustmentNoList().size() > 1) {
                sqlFilters.in((Object)"adjustment_no", (Collection)accountsDetailReqDto.getAdjustmentNoList());
            } else {
                sqlFilters.like((Object)"adjustment_no", accountsDetailReqDto.getAdjustmentNoList().get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getU9ConversionOrderNo())) {
            sqlFilters.like((Object)"u9_conversion_order_no", (Object)accountsDetailReqDto.getU9ConversionOrderNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getU9ConversionOrderNoList())) {
            if (accountsDetailReqDto.getU9ConversionOrderNoList().size() > 1) {
                sqlFilters.in((Object)"u9_conversion_order_no", (Collection)accountsDetailReqDto.getU9ConversionOrderNoList());
            } else {
                sqlFilters.like((Object)"u9_conversion_order_no", accountsDetailReqDto.getU9ConversionOrderNoList().get(0));
            }
        }
        if (Objects.nonNull(accountsDetailReqDto) && CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getSaleAreaCodes())) {
            sqlFilters.in((Object)"sale_area_code", (Collection)accountsDetailReqDto.getSaleAreaCodes());
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getSaleDeptName())) {
            sqlFilters.like((Object)"sale_dept_name", (Object)accountsDetailReqDto.getSaleDeptName());
        }
        if (Objects.nonNull(accountsDetailReqDto) && CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getSaleDeptCodes())) {
            sqlFilters.in((Object)"sale_dept_code", (Collection)accountsDetailReqDto.getSaleDeptCodes());
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getPricingSourceSystem())) {
            sqlFilters.eq((Object)"pricing_source_system", (Object)accountsDetailReqDto.getPricingSourceSystem());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getAdjustmentNo())) {
            sqlFilters.like((Object)"adjustment_no", (Object)accountsDetailReqDto.getAdjustmentNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getAdjustmentNoList())) {
            if (accountsDetailReqDto.getAdjustmentNoList().size() > 1) {
                sqlFilters.in((Object)"adjustment_no", (Collection)accountsDetailReqDto.getAdjustmentNoList());
            } else {
                sqlFilters.like((Object)"adjustment_no", accountsDetailReqDto.getAdjustmentNoList().get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getU9ConversionOrderNo())) {
            sqlFilters.like((Object)"u9_conversion_order_no", (Object)accountsDetailReqDto.getU9ConversionOrderNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getU9ConversionOrderNoList())) {
            if (accountsDetailReqDto.getU9ConversionOrderNoList().size() > 1) {
                sqlFilters.in((Object)"u9_conversion_order_no", (Collection)accountsDetailReqDto.getU9ConversionOrderNoList());
            } else {
                sqlFilters.like((Object)"u9_conversion_order_no", accountsDetailReqDto.getU9ConversionOrderNoList().get(0));
            }
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getFinancialRemark())) {
            sqlFilters.like((Object)"financial_remark", (Object)accountsDetailReqDto.getFinancialRemark());
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getProvince())) {
            sqlFilters.like((Object)"province", (Object)accountsDetailReqDto.getProvince());
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getCity())) {
            sqlFilters.like((Object)"city", (Object)accountsDetailReqDto.getCity());
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getProvinceCode())) {
            sqlFilters.eq((Object)"province_code", (Object)accountsDetailReqDto.getProvinceCode());
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getCityCode())) {
            sqlFilters.eq((Object)"city_code", (Object)accountsDetailReqDto.getCityCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getProvinceCodes())) {
            if (accountsDetailReqDto.getProvinceCodes().size() > 1) {
                sqlFilters.in((Object)"province_code", (Collection)accountsDetailReqDto.getProvinceCodes());
            } else {
                sqlFilters.like((Object)"province_code", accountsDetailReqDto.getProvinceCodes().get(0));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getCityCodes())) {
            if (accountsDetailReqDto.getCityCodes().size() > 1) {
                sqlFilters.in((Object)"city_code", (Collection)accountsDetailReqDto.getCityCodes());
            } else {
                sqlFilters.like((Object)"city_code", accountsDetailReqDto.getCityCodes().get(0));
            }
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getSaleAreaCode())) {
            sqlFilters.eq((Object)"sale_area_code", (Object)accountsDetailReqDto.getSaleAreaCode());
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getSaleAreaName())) {
            sqlFilters.like((Object)"sale_area_name", (Object)accountsDetailReqDto.getCity());
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getSaleDeptCode())) {
            sqlFilters.eq((Object)"sale_dept_code", (Object)accountsDetailReqDto.getSaleDeptCode());
        }
        if (Objects.nonNull(accountsDetailReqDto) && StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getSaleDeptName())) {
            sqlFilters.like((Object)"sale_dept_name", (Object)accountsDetailReqDto.getSaleDeptName());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getSaleAreaCodes())) {
            if (accountsDetailReqDto.getSaleAreaCodes().size() > 1) {
                sqlFilters.in((Object)"sale_area_code", (Collection)accountsDetailReqDto.getSaleAreaCodes());
            } else {
                sqlFilters.like((Object)"sale_area_code", accountsDetailReqDto.getSaleAreaCodes().get(0));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getSaleDeptCodes())) {
            if (accountsDetailReqDto.getSaleDeptCodes().size() > 1) {
                sqlFilters.in((Object)"sale_dept_code", (Collection)accountsDetailReqDto.getSaleDeptCodes());
            } else {
                sqlFilters.like((Object)"sale_dept_code", accountsDetailReqDto.getSaleDeptCodes().get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getFailReason())) {
            sqlFilters.like((Object)"fail_reason", (Object)accountsDetailReqDto.getFailReason());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getPlatformSellerEntityNumber())) {
            sqlFilters.eq((Object)"platform_seller_entity_number", (Object)accountsDetailReqDto.getPlatformSellerEntityNumber());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getPlatformSellerEntityNumberList())) {
            if (accountsDetailReqDto.getPlatformSellerEntityNumberList().size() > 1) {
                sqlFilters.in((Object)"platform_seller_entity_number", (Collection)accountsDetailReqDto.getPlatformSellerEntityNumberList());
            } else {
                sqlFilters.like((Object)"platform_seller_entity_number", accountsDetailReqDto.getPlatformSellerEntityNumberList().get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getRelatedEntityName())) {
            sqlFilters.like((Object)"related_entity_name", (Object)accountsDetailReqDto.getRelatedEntityName());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getRelatedEntityNumberList())) {
            if (accountsDetailReqDto.getRelatedEntityNumberList().size() > 1) {
                sqlFilters.in((Object)"related_entity_number", (Collection)accountsDetailReqDto.getRelatedEntityNumberList());
            } else {
                sqlFilters.like((Object)"related_entity_number", accountsDetailReqDto.getRelatedEntityNumberList().get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getRuleCode())) {
            sqlFilters.eq((Object)"rule_code", (Object)accountsDetailReqDto.getRuleCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)accountsDetailReqDto.getRuleCodeList())) {
            if (accountsDetailReqDto.getRuleCodeList().size() > 1) {
                sqlFilters.in((Object)"rule_code", (Collection)accountsDetailReqDto.getRuleCodeList());
            } else {
                sqlFilters.like((Object)"rule_code", accountsDetailReqDto.getRuleCodeList().get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getOwnEntity())) {
            sqlFilters.eq((Object)"own_entity", (Object)accountsDetailReqDto.getOwnEntity());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getGroupReceiveOrder())) {
            sqlFilters.like((Object)"group_receive_order", (Object)accountsDetailReqDto.getGroupReceiveOrder());
        }
        if (StringUtils.isNotBlank((CharSequence)accountsDetailReqDto.getRemark())) {
            sqlFilters.like((Object)"remark", (Object)accountsDetailReqDto.getRemark());
        }
        if (Objects.nonNull(accountsDetailReqDto.getPriceInquiryStartTime())) {
            sqlFilters.ge((Object)"price_inquiry_time", (Object)accountsDetailReqDto.getPriceInquiryStartTime());
        }
        if (Objects.nonNull(accountsDetailReqDto.getPriceInquiryEndTime())) {
            sqlFilters.le((Object)"price_inquiry_time", (Object)accountsDetailReqDto.getPriceInquiryEndTime());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveKeepAccounts(List<KeepAccountsDetailReqDto> keepAccountsDetailReqDtos) {
        ArrayList keepAccountsDetailEos = new ArrayList();
        CubeBeanUtils.copyCollection(keepAccountsDetailEos, keepAccountsDetailReqDtos, KeepAccountsDetailEo.class);
        this.keepAccountsDetailDas.insertBatch(keepAccountsDetailEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveKeepAccounts(List<KeepAccountsDetailReqDto> keepAccountsDetailReqDtos) {
        this.logger.info("\u63a5\u6536\u4fdd\u5b58\u8bb0\u8d26\u660e\u7ec6\u7ba1\u7406\u8868\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(keepAccountsDetailReqDtos));
        if (CollectionUtils.isNotEmpty(keepAccountsDetailReqDtos)) {
            List chargeCodes = keepAccountsDetailReqDtos.stream().map(KeepAccountsDetailReqDto::getChargeCode).distinct().collect(Collectors.toList());
            List keepAccountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", chargeCodes)).list();
            if (CollectionUtils.isEmpty((Collection)keepAccountsDetailEos)) {
                ArrayList keepAccountsDetailEoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)keepAccountsDetailEoList, keepAccountsDetailReqDtos, KeepAccountsDetailEo.class);
                this.keepAccountsDetailDas.insertBatch((List)keepAccountsDetailEoList);
            } else {
                Map keepAccountsDetailEoMap = keepAccountsDetailEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
                keepAccountsDetailEoMap.forEach((k, v) -> this.keepAccountsDetailDas.logicDeleteById(k));
                ArrayList keepAccountsDetailEoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)keepAccountsDetailEoList, keepAccountsDetailReqDtos, KeepAccountsDetailEo.class);
                this.keepAccountsDetailDas.insertBatch((List)keepAccountsDetailEoList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateKeepAccountDetail(List<KeepAccountsDetailReqDto> keepAccountsDetailReqDtos) {
        if (CollectionUtils.isNotEmpty(keepAccountsDetailReqDtos)) {
            keepAccountsDetailReqDtos.forEach(v -> {
                KeepAccountsDetailEo accountsDetailEo = (KeepAccountsDetailEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", new Object[]{v.getChargeCode()})).eq((Object)"order_type", (Object)BillTypeEnum.TRANSFERS.getCode())).one();
                if (Objects.nonNull(accountsDetailEo)) {
                    accountsDetailEo.setDeliveryNote(v.getDeliveryNote());
                    accountsDetailEo.setSaleNo(v.getSaleNo());
                    accountsDetailEo.setPostingNo(v.getPostingNo());
                    if (null != v.getChargeDate()) {
                        accountsDetailEo.setChargeDate(v.getChargeDate());
                    }
                    this.keepAccountsDetailDas.updateSelective((BaseEo)accountsDetailEo);
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDetailByCode(KeepAccountsDetailReqDto detailReqDto) {
        if (StringUtils.isEmpty((CharSequence)detailReqDto.getChargeCode())) {
            this.logger.info("\u6839\u636e\u7f16\u7801\u66f4\u65b0\u660e\u7ec6\u4fe1\u606f\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
        CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailReqDto, (String[])new String[0]);
        ArrayList sqlFilterList = Lists.newArrayList();
        sqlFilterList.add(SqlFilter.eq((String)"charge_code", (Object)detailReqDto.getChargeCode()));
        detailEo.setSqlFilters((List)sqlFilterList);
        this.keepAccountsDetailDas.updateSelectiveSqlFilter((BaseEo)detailEo);
    }

    @Override
    public Map<Long, List<KeepAccountsDetailEo>> getKeepAccountsDetailEoListMap(List<Long> orderItemIds, String orderType) {
        HashMap keepAccountsDetailEoListMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orderItemIds)) {
            List keepAccountsDetailEos;
            int length;
            int i = 0;
            for (length = orderItemIds.size(); length > FinanceConstant.SIZE; length -= 1000) {
                keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", orderItemIds.subList(i, i + 1000))).eq((Object)"voucher_type", (Object)VoucherTypeEnum.DELIVERY.getCode())).eq((Object)"order_type", (Object)orderType)).list();
                keepAccountsDetailEoListMap.putAll(keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getOrderItemId)));
                i += 1000;
            }
            if (length > 0) {
                keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", orderItemIds.subList(i, i + length))).eq((Object)"voucher_type", (Object)VoucherTypeEnum.DELIVERY.getCode())).eq((Object)"order_type", (Object)orderType)).list();
                keepAccountsDetailEoListMap.putAll(keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getOrderItemId)));
            }
        }
        return keepAccountsDetailEoListMap;
    }

    @Override
    public List<KeepAccountsDetailRespDto> queryChargeDateByOrderItemIds(List<Long> orderItemIds) {
        ArrayList keepAccountsDetailRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(orderItemIds)) {
            LinkedList keepAccountsDetailRespDtoList;
            List keepAccountsDetailEos;
            int length;
            int i = 0;
            for (length = orderItemIds.size(); length > 1000; length -= 1000) {
                keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", orderItemIds.subList(i, i + 1000))).eq((Object)"voucher_type", (Object)VoucherTypeEnum.DELIVERY.getCode())).list();
                keepAccountsDetailRespDtoList = Lists.newLinkedList();
                CubeBeanUtils.copyCollection((Collection)keepAccountsDetailRespDtoList, (Collection)keepAccountsDetailEos, KeepAccountsDetailRespDto.class);
                keepAccountsDetailRespDtos.addAll(keepAccountsDetailRespDtoList);
                i += 1000;
            }
            if (length > 0) {
                keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"order_item_id", orderItemIds.subList(i, i + length))).eq((Object)"voucher_type", (Object)VoucherTypeEnum.DELIVERY.getCode())).list();
                keepAccountsDetailRespDtoList = Lists.newLinkedList();
                CubeBeanUtils.copyCollection((Collection)keepAccountsDetailRespDtoList, (Collection)keepAccountsDetailEos, KeepAccountsDetailRespDto.class);
                keepAccountsDetailRespDtos.addAll(keepAccountsDetailRespDtoList);
            }
        }
        return keepAccountsDetailRespDtos;
    }

    @Override
    public List<KeepAccountsDetailRespDto> queryAccountsDetailByOrderNos(KeepAccountsDetailReqDto reqDto) {
        ArrayList keepAccountsDetailRespDtos = Lists.newArrayList();
        ExtQueryChainWrapper sqlFilters = this.keepAccountsDetailDas.filter();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrderNos())) {
            sqlFilters.in((Object)"order_no", (Collection)reqDto.getOrderNos());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getChargeCodes())) {
            sqlFilters.in((Object)"charge_code", (Collection)reqDto.getChargeCodes());
        }
        if (null != reqDto.getVoucherType()) {
            sqlFilters.eq((Object)"voucher_type", (Object)reqDto.getVoucherType());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBookKeeping())) {
            sqlFilters.eq((Object)"book_keeping", (Object)reqDto.getBookKeeping());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getAccountingResult())) {
            sqlFilters.eq((Object)"accounting_result", (Object)reqDto.getAccountingResult());
        }
        List keepAccountsDetailEos = sqlFilters.list();
        LinkedList keepAccountsDetailRespDtoList = Lists.newLinkedList();
        CubeBeanUtils.copyCollection((Collection)keepAccountsDetailRespDtoList, (Collection)keepAccountsDetailEos, KeepAccountsDetailRespDto.class);
        keepAccountsDetailRespDtos.addAll(keepAccountsDetailRespDtoList);
        return keepAccountsDetailRespDtos;
    }

    @Override
    public void batchUpdateDetailInvoiceNoAndsaleNoById(List<KeepAccountsDetailReqDto> modifyReqDtos) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void batchModifyKeepAccountsDetail(List<KeepAccountsDetailEo> detailEos) {
        detailEos.forEach(eo -> ((IKeepAccountsDetailDomain)this.domain).updateSelective((BaseEo)eo));
    }

    @Override
    public List<KeepAccountsDetailRespDto> getAccountingOrderNos(List<String> orderNos) {
        ExtQueryChainWrapper sqlFilters = this.keepAccountsDetailDas.filter();
        sqlFilters.in((Object)"order_no", orderNos);
        List detailRespDtos = sqlFilters.list();
        ArrayList accountsDetailRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)accountsDetailRespDtos, (Collection)detailRespDtos, KeepAccountsDetailRespDto.class);
        return accountsDetailRespDtos;
    }

    @Override
    public PageInfo<KeepAccountsDetailRespDto> queryListPage(KeepAccountingReqDto reqDto) {
        this.logger.info("\u8bb0\u8d26\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().orderByDesc((Object)"id");
        if (null == reqDto.getPageNum()) {
            reqDto.setPageNum(Integer.valueOf(1));
        }
        if (null == reqDto.getPageSize()) {
            reqDto.setPageSize(Integer.valueOf(20));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getChargeCode())) {
            sqlFilters.eq((Object)"charge_code", (Object)reqDto.getChargeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPricingSourceSystem())) {
            sqlFilters.eq((Object)"pricing_source_system", (Object)reqDto.getPricingSourceSystem());
        } else {
            sqlFilters.isNotNull((Object)"pricing_source_system");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getChargeStartDate())) {
            sqlFilters.ge((Object)"charge_date", (Object)(reqDto.getChargeStartDate() + " 00:00:00"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getChargeEndDate())) {
            sqlFilters.le((Object)"charge_date", (Object)(reqDto.getChargeEndDate() + " 23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getVoucherType())) {
            sqlFilters.eq((Object)"voucher_type", (Object)reqDto.getVoucherType());
        } else {
            sqlFilters.eq((Object)"voucher_type", (Object)VoucherTypeEnum.DELIVERY.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getAccountingResult())) {
            sqlFilters.eq((Object)"accounting_result", (Object)reqDto.getAccountingResult());
        } else {
            sqlFilters.eq((Object)"accounting_result", (Object)"ACCOUNT_SUCCESS");
        }
        if (null != reqDto.getWhetherAccrued()) {
            sqlFilters.eq((Object)"whether_accrued", (Object)reqDto.getWhetherAccrued());
        } else {
            sqlFilters.eq((Object)"whether_accrued", (Object)0);
        }
        PageInfo eoPageInfo = sqlFilters.page(reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, KeepAccountsDetailRespDto.class);
        HashSet chargeCodes = new HashSet();
        HashSet skuCodes = new HashSet();
        dtoList.forEach(v -> {
            chargeCodes.add(v.getChargeCode());
            skuCodes.add(v.getItemCode());
        });
        Map accountsMap = this.pushKeepAccountsDas.getMapByChargeCodes(chargeCodes);
        Map skuMap = this.itemSkuDgDomain.getMapByCodes(skuCodes);
        List<String> shopCodes = dtoList.stream().map(KeepAccountsDetailRespDto::getShopCode).distinct().collect(Collectors.toList());
        Map<String, ShopEo> shopEoMap = this.getShopList(shopCodes);
        dtoList.forEach(v -> {
            if (null != v.getAccountingResult()) {
                v.setAccountingResult(v.getAccountingResult());
            }
            if (Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), v.getVoucherType())) {
                v.setChargeAccountName(v.getChargeAccountName());
            } else if (Objects.equals(VoucherTypeEnum.INVOICE.getCode(), v.getVoucherType())) {
                v.setChargeAccountName(v.getBillAccountName());
            }
            v.setMealOrSingleItem(Integer.valueOf(StringUtils.isNotBlank((CharSequence)v.getGroupSkuCode()) ? BigDecimal.ONE.intValue() : BigDecimal.ZERO.intValue()));
            v.setCrossOrganizationalTransactionName(StrUtil.isNotBlank((CharSequence)v.getCrossOrganizationalTransaction()) ? ("yes".equalsIgnoreCase(v.getCrossOrganizationalTransaction()) ? "\u662f" : "\u5426") : "");
            ArrayList<String> reasons = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)v.getQueryPriceResult()) && !"SUCCESS".equals(v.getQueryPriceResult())) {
                reasons.add(v.getQueryPriceResult());
            }
            if (StringUtils.isNotBlank((CharSequence)v.getUpdateQtyResult()) && !"SUCCESS".equals(v.getUpdateQtyResult())) {
                reasons.add(v.getUpdateQtyResult());
            }
            v.setReason(reasons.isEmpty() ? "" : String.join((CharSequence)";", reasons));
            Optional.ofNullable(accountsMap.get(v.getChargeCode())).ifPresent(account -> {
                v.setSaleAreaCode(account.getSaleAreaCode());
                v.setSaleAreaName(account.getSaleAreaName());
                if (StringUtils.isBlank((CharSequence)v.getReason())) {
                    v.setReason(account.getReason());
                }
            });
            Optional.ofNullable(skuMap.get(v.getItemCode())).ifPresent(sku -> v.setSpecModel(sku.getSpecModel()));
            if (shopEoMap.containsKey(v.getShopCode())) {
                ShopEo shopEo = (ShopEo)shopEoMap.get(v.getShopCode());
                v.setSaleDepartment(Objects.nonNull(shopEo) ? shopEo.getSaleDeptName() : null);
                v.setSaleDeptId(Objects.nonNull(shopEo) ? shopEo.getSaleDeptId() : null);
                v.setSaleDeptCode(Objects.nonNull(shopEo) ? shopEo.getSaleDeptCode() : null);
            }
            v.setFreight(v.getFreightCost());
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateKeepWhetherAccrued(KeepWhetherAccruedReqDto reqDto) {
        List accountsDetailEos;
        int length;
        this.logger.info("\u66f4\u65b0\u8bb0\u8d26\u660e\u7ec6\u662f\u5426\u4e3a\u8ba1\u63d0\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        if (Objects.isNull(reqDto) || CollectionUtils.isEmpty((Collection)reqDto.getKeepIds())) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqDto) || null == reqDto.getWhetherAccrued()) {
            throw new BizException("\u662f\u5426\u8ba1\u63d0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = 0;
        for (length = reqDto.getKeepIds().size(); length > 500; length -= 500) {
            accountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"id", reqDto.getKeepIds().subList(i, i + 500))).list();
            if (CollectionUtils.isNotEmpty((Collection)accountsDetailEos)) {
                accountsDetailEos.forEach(v -> {
                    KeepAccountsDetailEo update = new KeepAccountsDetailEo();
                    update.setId(v.getId());
                    update.setWhetherAccrued(reqDto.getWhetherAccrued());
                    this.keepAccountsDetailDas.updateSelective((BaseEo)update);
                });
            }
            i += 500;
        }
        if (length > 0 && CollectionUtils.isNotEmpty((Collection)(accountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"id", reqDto.getKeepIds().subList(i, i + length))).list()))) {
            accountsDetailEos.forEach(v -> {
                KeepAccountsDetailEo update = new KeepAccountsDetailEo();
                update.setId(v.getId());
                update.setWhetherAccrued(reqDto.getWhetherAccrued());
                this.keepAccountsDetailDas.updateSelective((BaseEo)update);
            });
        }
    }

    private Map<String, ShopEo> getShopList(List<String> shopCodes) {
        Map collect;
        List shopEos;
        int length;
        if (CollectionUtils.isEmpty(shopCodes)) {
            return Maps.newHashMap();
        }
        HashMap shopEoMap = Maps.newHashMap();
        int i = 0;
        for (length = shopCodes.size(); length > 1000; length -= 1000) {
            shopEos = ((ExtQueryChainWrapper)this.shopDas.filter().in((Object)"code", shopCodes.subList(i, i + 500))).list();
            if (CollectionUtils.isNotEmpty((Collection)shopEos)) {
                collect = shopEos.stream().collect(Collectors.toMap(ShopEo::getCode, Function.identity(), (k1, k2) -> k1));
                shopEoMap.putAll(collect);
            }
            i += 1000;
        }
        if (length > 0 && CollectionUtils.isNotEmpty((Collection)(shopEos = ((ExtQueryChainWrapper)this.shopDas.filter().in((Object)"code", shopCodes.subList(i, i + length))).list()))) {
            collect = shopEos.stream().collect(Collectors.toMap(ShopEo::getCode, Function.identity(), (k1, k2) -> k1));
            shopEoMap.putAll(collect);
        }
        return shopEoMap;
    }

    @Override
    public List<AdjustmentOrderDetailDto> queryAdjustmentOrderDetails(List<String> adjustmentNos) {
        List adjustmentOrderEos;
        int length;
        if (CollectionUtils.isEmpty(adjustmentNos)) {
            return Lists.newArrayList();
        }
        ArrayList orderDetailDtos = Lists.newArrayList();
        int i = 0;
        for (length = adjustmentNos.size(); length > 500; length -= 500) {
            adjustmentOrderEos = ((ExtQueryChainWrapper)this.adjustmentOrderDas.filter().in((Object)"adjustment_no", adjustmentNos.subList(i, i + 500))).list();
            this.getAdjustmentOrders(orderDetailDtos, adjustmentOrderEos);
            i += 500;
        }
        if (length > 0) {
            adjustmentOrderEos = ((ExtQueryChainWrapper)this.adjustmentOrderDas.filter().in((Object)"adjustment_no", adjustmentNos.subList(i, i + length))).list();
            this.getAdjustmentOrders(orderDetailDtos, adjustmentOrderEos);
        }
        return orderDetailDtos;
    }

    private void getAdjustmentOrders(List<AdjustmentOrderDetailDto> orderDetailDtos, List<AdjustmentOrderEo> adjustmentOrderEos) {
        if (CollectionUtils.isNotEmpty(adjustmentOrderEos)) {
            Map orderEoMap = adjustmentOrderEos.stream().collect(Collectors.toMap(AdjustmentOrderEo::getAdjustmentNo, Function.identity(), (k1, k2) -> k1));
            List collect = adjustmentOrderEos.stream().map(AdjustmentOrderEo::getAdjustmentNo).collect(Collectors.toList());
            List adjustmentOrderDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.adjustmentOrderDetailDas.filter().eq((Object)"change_type", (Object)"increase")).in((Object)"adjustment_no", collect)).list();
            if (CollectionUtils.isNotEmpty((Collection)adjustmentOrderDetailEos)) {
                ArrayList adjustmentOrderDetailDtoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)adjustmentOrderDetailDtoList, (Collection)adjustmentOrderDetailEos, AdjustmentOrderDetailDto.class);
                adjustmentOrderDetailDtoList.forEach(v -> {
                    if (orderEoMap.containsKey(v.getAdjustmentNo())) {
                        v.setOrderStatus(Objects.nonNull(orderEoMap.get(v.getAdjustmentNo())) ? ((AdjustmentOrderEo)orderEoMap.get(v.getAdjustmentNo())).getOrderStatus() : null);
                    }
                });
                orderDetailDtos.addAll(adjustmentOrderDetailDtoList);
            }
        }
    }

    @Override
    public void updateAdjustmentRemark(List<AdjustmentOrderDto> orderDtos) {
        this.logger.info("\u66f4\u65b0\u8c03\u6574\u5355\u5907\u6ce8-U9\u5f62\u6001\u8f6c\u6362\u5355\u53f7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(orderDtos));
        this.proxy.updateAdjustmentRemark(orderDtos);
    }

    @Override
    public Map<String, DeliveryProjectKeeDto> getDeliveryProjects(List<String> chargeCodes) {
        List projectKeeVos;
        int length;
        HashMap keepAccountsDetailRespDtoMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(chargeCodes)) {
            return keepAccountsDetailRespDtoMap;
        }
        int i = 0;
        for (length = chargeCodes.size(); length > 500; length -= 500) {
            projectKeeVos = this.keepAccountsDetailDas.getDeliveryProjects(chargeCodes.subList(i, i + 500));
            this.getDeliveryProjectsList(keepAccountsDetailRespDtoMap, projectKeeVos);
            i += 500;
        }
        if (length > 0) {
            projectKeeVos = this.keepAccountsDetailDas.getDeliveryProjects(chargeCodes.subList(i, i + length));
            this.getDeliveryProjectsList(keepAccountsDetailRespDtoMap, projectKeeVos);
        }
        return keepAccountsDetailRespDtoMap;
    }

    private void getDeliveryProjectsList(Map<String, DeliveryProjectKeeDto> keepAccountsDetailRespDtoMap, List<DeliveryProjectKeeVo> projectKeeVos) {
        ArrayList projectKeeDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)projectKeeDtos, projectKeeVos, DeliveryProjectKeeDto.class);
        Map collect = projectKeeDtos.stream().collect(Collectors.toMap(x -> x.getChargeCode() + "-" + x.getOrderItemId(), Function.identity(), (k1, k2) -> k1));
        keepAccountsDetailRespDtoMap.putAll(collect);
    }

    @Override
    public Map<String, String> judgmentGiftByChargeCodes(List<String> chargeCodes) {
        List keepAccountsDetailEos;
        int length;
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(chargeCodes)) {
            return resultMap;
        }
        int i = 0;
        for (length = chargeCodes.size(); length > 500; length -= 500) {
            keepAccountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + 500))).list();
            this.getKeepDetail(resultMap, keepAccountsDetailEos);
            i += 500;
        }
        if (length > 0) {
            keepAccountsDetailEos = ((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + length))).list();
            this.getKeepDetail(resultMap, keepAccountsDetailEos);
        }
        return resultMap;
    }

    private void getKeepDetail(Map<String, String> resultMap, List<KeepAccountsDetailEo> keepAccountsDetailEos) {
        if (CollectionUtils.isNotEmpty(keepAccountsDetailEos)) {
            Map<String, List<KeepAccountsDetailEo>> accountsDetailsListMap = keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getChargeCode));
            accountsDetailsListMap.forEach((k, v) -> resultMap.put((String)k, ((KeepAccountsDetailEo)v.get(0)).getItemType()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDealFinancialRemark(List<KeepFinancialRemarksDto> remarksDtos) {
        int length;
        if (CollectionUtils.isEmpty(remarksDtos)) {
            this.logger.info("\u5bfc\u5165\u8d22\u52a1\u5907\u6ce8\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        this.logger.info("\u8bb0\u8d26\u660e\u7ec6\u8868\u652f\u6301\u6279\u91cf\u5bfc\u5165\u8d22\u52a1\u5907\u6ce8\u6761\u6570\uff1a{}", (Object)remarksDtos.size());
        Map<String, List<KeepFinancialRemarksDto>> collect = remarksDtos.stream().collect(Collectors.groupingBy(KeepFinancialRemarksDto::getChargeCode));
        ArrayList keepAccountsDetailEos = Lists.newArrayList();
        collect.forEach((k, v) -> v.forEach(j -> {
            KeepAccountsDetailEo accountsDetailEo = new KeepAccountsDetailEo();
            accountsDetailEo.setChargeCode(k);
            accountsDetailEo.setFinancialRemark(j.getFinancialRemark());
            keepAccountsDetailEos.add(accountsDetailEo);
        }));
        if (CollectionUtils.isEmpty((Collection)keepAccountsDetailEos)) {
            this.logger.info("\u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u8bb0\u8d26\u660e\u7ec6\u6570\u636e");
            return;
        }
        int i = 0;
        for (length = keepAccountsDetailEos.size(); length > 500; length -= 500) {
            this.keepAccountsDetailDas.batchDealFinancialRemark(keepAccountsDetailEos.subList(i, i + 500));
            i += 500;
        }
        if (length > 0) {
            this.keepAccountsDetailDas.batchDealFinancialRemark(keepAccountsDetailEos.subList(i, i + length));
        }
    }

    @Override
    public List<KeepAccountsDetailRespDto> queryKeepDetaiByOrderNolList(List<String> orderNoList) {
        List list = this.keepAccountsDetailDas.queryKeepDetaiByOrderNolList(orderNoList);
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)list, KeepAccountsDetailRespDto.class);
        return respDtos;
    }

    @Override
    public List<KeepAccountsDetailRespDto> queryKeepDetailPlatformNoList(List<String> platformNoList) {
        List list = this.keepAccountsDetailDas.queryKeepDetailPlatformNoList(platformNoList);
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)list, KeepAccountsDetailRespDto.class);
        return respDtos;
    }

    @Override
    public List<OrderChargeCodeRespDto> queryChargeCodeListByOrderNo(List<String> orderNoList) {
        return this.keepAccountsDetailDas.queryChargeCodeListByOrderNo(orderNoList);
    }
}

