/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yunxi.dg.base.center.finance.convert.entity.ShopConverter;
import com.yunxi.dg.base.center.finance.domain.entity.IShopDomain;
import com.yunxi.dg.base.center.finance.dto.entity.ShopDto;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IShopService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ShopServiceImpl
extends BaseServiceImpl<ShopDto, ShopEo, IShopDomain>
implements IShopService {
    public ShopServiceImpl(IShopDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ShopDto, ShopEo> converter() {
        return ShopConverter.INSTANCE;
    }

    @Override
    public ShopEo selectShopByCode(String shopCode) {
        if (StringUtils.isNotBlank((CharSequence)shopCode)) {
            List shopList = ((ExtQueryChainWrapper)((IShopDomain)this.domain).filter().eq((Object)"code", (Object)shopCode)).list();
            if (CollectionUtils.isNotEmpty((Collection)shopList)) {
                return (ShopEo)shopList.get(0);
            }
            return new ShopEo();
        }
        return new ShopEo();
    }

    @Override
    public List<ShopEo> selectShopByCodes(List<String> shopCodes) {
        if (CollectionUtil.isNotEmpty(shopCodes)) {
            List shopList = ((ExtQueryChainWrapper)((IShopDomain)this.domain).filter().in((Object)"code", shopCodes)).list();
            if (CollectionUtils.isNotEmpty((Collection)shopList)) {
                return shopList;
            }
            return new ArrayList<ShopEo>();
        }
        return new ArrayList<ShopEo>();
    }

    @Override
    public List<ShopDto> queryShopListAll() {
        ArrayList<ShopDto> shopDtoList = new ArrayList<ShopDto>();
        List shopEos = ((IShopDomain)this.domain).selectAll();
        CubeBeanUtils.copyCollection(shopDtoList, (Collection)shopEos, ShopDto.class);
        return shopDtoList;
    }
}

