/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    protected static Logger logger = LoggerFactory.getLogger(DateUtil.class);
    private static final String formatStr = "yyyy-MM-dd";
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String DATE_STR = "2022-11-01";

    public static String addOneDay(String dateStr) {
        try {
            Date parse = new SimpleDateFormat(formatStr).parse(dateStr);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(parse);
            ((Calendar)calendar).add(5, 1);
            parse = calendar.getTime();
            return new SimpleDateFormat(formatStr).format(parse);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("-1", e.getMessage());
        }
    }

    public static String reduceOneDay(String dateStr) throws ParseException {
        Date parse = new SimpleDateFormat(formatStr).parse(dateStr);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(parse);
        ((Calendar)calendar).add(5, -1);
        parse = calendar.getTime();
        return new SimpleDateFormat(formatStr).format(parse);
    }

    public static String datePlusOne(String data) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        Date parse = dateFormat.parse(data);
        calendar.setTime(parse);
        calendar.add(5, 1);
        return dateFormat.format(calendar.getTime());
    }

    public static String dateMinusOne(String date) throws ParseException {
        long parse = dateFormat.parse(date).getTime() - 86400000L;
        Date date1 = new Date();
        date1.setTime(parse);
        return dateFormat.format(date1);
    }

    public static String getBeforeOneDay() {
        long currTime = System.currentTimeMillis();
        long oneDay = 86400000L;
        long beforeDayTime = currTime - oneDay;
        return cn.hutool.core.date.DateUtil.formatDate((Date)new Date(beforeDayTime));
    }

    public static String getBeforeDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return new SimpleDateFormat("yyyy-MM-dd ").format(cal.getTime());
    }

    public static Date getBeforeOneDate() {
        long currTime = System.currentTimeMillis();
        long oneDay = 86400000L;
        long beforeDayTime = currTime - oneDay;
        return new Date(beforeDayTime);
    }

    public static String getBeforeDayByDay(int day) {
        long currTime = System.currentTimeMillis();
        long nDay = 86400000 * day;
        long beforeDayTime = currTime - nDay;
        return cn.hutool.core.date.DateUtil.formatDate((Date)new Date(beforeDayTime));
    }

    public static Date nextMonth(Long mon, int flag) {
        Date date = mon == null ? new Date() : new Date(mon);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, flag);
        Date time = calendar.getTime();
        return time;
    }

    public static Date stringToDate(String date) throws ParseException {
        return dateFormat.parse(date);
    }

    public static Date toDate(String date) throws ParseException {
        return format.parse(date);
    }

    public static String getDateBefore(Date d, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(5, calendar.get(5) - day);
        return com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static boolean isValidDate(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat(formatStr);
        try {
            Date date = formatter.parse(str);
            return str.equals(formatter.format(date));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean dateCompare(String str) {
        try {
            Date date1 = dateFormat.parse(str);
            Date date2 = dateFormat.parse(DATE_STR);
            if (date1.compareTo(date2) > 0) {
                return true;
            }
            if (date1.compareTo(date2) < 0) {
                return false;
            }
            if (date1.compareTo(date2) == 0) {
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BizException("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
        }
        return false;
    }

    public static boolean timeCompare(String time1, String time2) {
        try {
            Date date1 = format.parse(time1);
            Date date2 = format.parse(time2);
            if (date1.compareTo(date2) > 0) {
                return true;
            }
            if (date1.compareTo(date2) < 0) {
                return false;
            }
            if (date1.compareTo(date2) == 0) {
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new com.dtyunxi.exceptions.BizException("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
        }
        return false;
    }

    public static List<Map<String, Object>> getSplitTimeperiod(int num, String startTime, String endTime) {
        logger.info("\u65f6\u95f4\u6bb5\uff1a\u4ece" + startTime + "\u5230" + endTime);
        ArrayList<Map<String, Object>> cycleTimeList = new ArrayList<Map<String, Object>>();
        try {
            Long startLong;
            Date endParse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTime);
            Long endLong = endParse.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            endTime = sdf.format(new Date(endLong));
            logger.info("\u7ed3\u675f\u65f6\u95f4\uff1a" + endTime);
            int daysBetweenNum = DateUtil.daysBetween(startTime, endTime);
            int cycleForNum = daysBetweenNum % num == 0 ? daysBetweenNum / num : daysBetweenNum / num + 1;
            logger.info("\u4e24\u65e5\u671f\u95f4\u76f8\u9694\u7684\u5929\u6570\u4e3a\uff1a" + daysBetweenNum);
            logger.info("\u5468\u671f\u9009\u62e9\u662f\uff1a" + num + "\u5929\u4e00\u5468\u671f, \u5219\u5207\u5272\u51fa\u6765\u7684\u5468\u671f\u5b58\u5728\u4e2a\u6570\uff1a" + cycleForNum);
            Date startParse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startTime);
            Long calculationLong = startLong = Long.valueOf(startParse.getTime());
            for (int i = 1; i <= cycleForNum; ++i) {
                String startStr = sdf.format(new Date(calculationLong));
                Date startStrParse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startStr);
                Long startStrLong = startStrParse.getTime();
                Long cycleLong = (long)num * 86400000L;
                calculationLong = startStrLong + cycleLong;
                String endStr = endTime;
                if (calculationLong <= endLong) {
                    endStr = sdf.format(new Date(calculationLong));
                }
                logger.info("\u8d77\u59cb:" + startStr + "\u7ed3\u675f\uff1a" + DateUtil.dateMinusOne(endStr) + " 23:59:59");
                HashMap<String, String> stringObjectHashMap = new HashMap<String, String>(16);
                stringObjectHashMap.put("starTtime", startStr);
                stringObjectHashMap.put("endTime", DateUtil.dateMinusOne(endStr) + " 23:59:59");
                cycleTimeList.add(stringObjectHashMap);
            }
            logger.info("\u65f6\u95f4\u5468\u671flist\uff1a" + ((Object)cycleTimeList).toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return cycleTimeList;
    }

    public static int daysBetween(String smdate, String bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(smdate));
        long time1 = cal.getTimeInMillis();
        cal.setTime(sdf.parse(bdate));
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static void main(String[] args) throws Exception {
        String str = "2022-07-29 10:13:59";
        Date date = DateUtil.stringToDate(str);
        System.out.println(DateUtil.getDateBefore(date, 90));
        System.out.println(com.dtyunxi.cube.utils.DateUtil.parseDate((String)"2022-07-29 10:13:19", (String)"yyyy-MM-dd HH:mm:ss"));
        System.out.println(DateUtil.dateCompare("2022-10-17"));
        System.out.println(com.dtyunxi.util.DateUtil.format((Date)new Date(), (String)"HH:mm:ss"));
        System.out.println(DateUtil.getSplitTimeperiod(1, "2022-12-01 00:00:00", "2023-02-28 23:59:59"));
    }
}

