/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.convert.entity.KeepBillReportConverter;
import com.yunxi.dg.base.center.finance.dao.das.IKeepBillReportDas;
import com.yunxi.dg.base.center.finance.dao.mapper.KeepBillReportMapper;
import com.yunxi.dg.base.center.finance.dao.vo.BillKeepAccountReqVo;
import com.yunxi.dg.base.center.finance.dao.vo.GenerateKeepBillReqVo;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepBillReportDomain;
import com.yunxi.dg.base.center.finance.dto.entity.KeepBillReportDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.request.GenerateKeepBillReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepBillReportReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillInfoKeepAccountRespDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepBillReportRespDto;
import com.yunxi.dg.base.center.finance.dto.response.TimeRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepBillReportEo;
import com.yunxi.dg.base.center.finance.service.entity.IKeepBillReportService;
import com.yunxi.dg.base.center.finance.service.utils.DateUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepBillReportServiceImpl
extends BaseServiceImpl<KeepBillReportDto, KeepBillReportEo, IKeepBillReportDomain>
implements IKeepBillReportService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IKeepBillReportDas keepBillReportDas;
    @Resource
    private IKeepBillReportDomain keepBillReportDomain;
    @Resource
    private ILockService lockService;
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    private static final String TABLE_NAME_KEEP_BILL_REPORT = "keep_bill_report";

    public KeepBillReportServiceImpl(IKeepBillReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<KeepBillReportDto, KeepBillReportEo> converter() {
        return KeepBillReportConverter.INSTANCE;
    }

    @Override
    public Long addKeepBillReport(KeepBillReportReqDto addReqDto) {
        KeepBillReportEo keepBillReportEo = new KeepBillReportEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)keepBillReportEo);
        this.keepBillReportDas.insert((BaseEo)keepBillReportEo);
        return keepBillReportEo.getId();
    }

    @Override
    public void modifyKeepBillReport(KeepBillReportReqDto modifyReqDto) {
        KeepBillReportEo keepBillReportEo = new KeepBillReportEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)keepBillReportEo);
        this.keepBillReportDas.updateSelective((BaseEo)keepBillReportEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeKeepBillReport(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.keepBillReportDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public KeepBillReportRespDto queryById(Long id) {
        KeepBillReportEo keepBillReportEo = (KeepBillReportEo)this.keepBillReportDas.selectByPrimaryKey(id);
        KeepBillReportRespDto keepBillReportRespDto = new KeepBillReportRespDto();
        DtoHelper.eo2Dto((BaseEo)keepBillReportEo, (BaseVo)keepBillReportRespDto);
        return keepBillReportRespDto;
    }

    @Override
    public PageInfo<KeepBillReportRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        KeepBillReportReqDto keepBillReportReqDto = (KeepBillReportReqDto)JSON.parseObject((String)filter, KeepBillReportReqDto.class);
        KeepBillReportEo keepBillReportEo = new KeepBillReportEo();
        DtoHelper.dto2Eo((BaseVo)keepBillReportReqDto, (BaseEo)keepBillReportEo);
        PageInfo eoPageInfo = this.keepBillReportDomain.selectPage((BaseEo)keepBillReportEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, KeepBillReportRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void summaryKeepBillReport(GenerateKeepBillReqDto keepBillReqDto) {
        this.logger.info("\u751f\u6210\u8bb0\u8d26\u53d1\u7968\u6838\u5bf9\u6c47\u603b\u62a5\u8868\u8bf7\u6c42\u53c2\u6570\uff1a{]", (Object)JSON.toJSONString((Object)keepBillReqDto));
        String generateDate = keepBillReqDto.getGenerateDate();
        if (Objects.isNull(keepBillReqDto.getGenerateDate())) {
            generateDate = com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd");
        }
        Mutex mutex = null;
        try {
            List keepBillReportAccountVos;
            mutex = this.lockService.lock(TABLE_NAME_KEEP_BILL_REPORT, generateDate, 10, 20, TimeUnit.SECONDS);
            if (null == mutex) {
                throw new BizException("\u91cd\u65b0\u53d1\u7968\u8bb0\u8d26\u6838\u5bf9\u62a5\u8868\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            GenerateKeepBillReqVo keepBillReqVo = new GenerateKeepBillReqVo();
            String keepBillStartDate = keepBillReqDto.getKeepBillStartDate() + " 00:00:00";
            if (StringUtils.isBlank((CharSequence)keepBillReqDto.getKeepBillStartDate())) {
                keepBillStartDate = com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd") + " 00:00:00";
            }
            String keepBillEndDate = keepBillReqDto.getKeepBillEndDate() + " 23:59:59";
            if (StringUtils.isBlank((CharSequence)keepBillReqDto.getKeepBillEndDate())) {
                keepBillEndDate = com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd") + " 23:59:59";
            }
            keepBillReqVo.setKeepBillStartDate(keepBillStartDate);
            keepBillReqVo.setKeepBillEndDate(keepBillEndDate);
            Date keepBillTime = keepBillReqDto.getKeepBillTime();
            if (null == keepBillReqDto.getKeepBillTime()) {
                keepBillTime = DateUtil.toDate(com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(keepBillReportAccountVos = this.keepBillReportDas.summaryKeepBillReport(keepBillReqVo)))) {
                this.keepBillReportDas.updateKeepBillReport(Integer.valueOf(BigDecimal.ONE.intValue()), keepBillReqDto.getUpdatePerson(), generateDate);
                ArrayList keepBillReportEos = Lists.newArrayList();
                String finalGenerateDate = generateDate;
                Date finalKeepBillTime = keepBillTime;
                keepBillReportAccountVos.forEach(v -> {
                    KeepBillReportEo keepBillReportEo = new KeepBillReportEo();
                    keepBillReportEo.setShopCode(v.getShopCode());
                    keepBillReportEo.setShopName(v.getShopName());
                    keepBillReportEo.setCustomerCode(v.getCustomerCode());
                    keepBillReportEo.setCustomerName(v.getCustomerName());
                    keepBillReportEo.setPlatformNo(v.getPlatformNo());
                    keepBillReportEo.setPositiveAmount(v.getPositiveAmount());
                    keepBillReportEo.setReverseAmount(v.getReverseAmount());
                    keepBillReportEo.setTotalAmount(v.getTotalAmount());
                    keepBillReportEo.setEnterprise(v.getEnterprise());
                    keepBillReportEo.setBillAmount(v.getBillAmount());
                    keepBillReportEo.setBalance(v.getBalance());
                    keepBillReportEo.setDivergence(v.getDivergence());
                    keepBillReportEo.setGenerateDate(finalGenerateDate);
                    keepBillReportEo.setUpdatePerson(keepBillReqDto.getUpdatePerson());
                    keepBillReportEo.setKeepBillTime(finalKeepBillTime);
                    keepBillReportEos.add(keepBillReportEo);
                });
                if (CollectionUtils.isNotEmpty((Collection)keepBillReportEos)) {
                    SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
                    KeepBillReportMapper mapper = (KeepBillReportMapper)session.getMapper(KeepBillReportMapper.class);
                    try {
                        int len;
                        int size = 500;
                        int i = 0;
                        for (len = keepBillReportEos.size(); len > size; len -= size) {
                            keepBillReportEos.subList(i, i + size).forEach(v -> mapper.insert(v));
                            i += 500;
                        }
                        if (len > 0) {
                            keepBillReportEos.subList(i, i + len).forEach(v -> mapper.insert(v));
                        }
                        session.commit();
                        session.close();
                        session.clearCache();
                    }
                    finally {
                        session.close();
                    }
                }
            }
            if (mutex == null) return;
        }
        catch (Exception e) {
            try {
                this.logger.error("\u91cd\u65b0\u53d1\u7968\u8bb0\u8d26\u6838\u5bf9\u62a5\u8868\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                throw new BizException("\u91cd\u65b0\u53d1\u7968\u8bb0\u8d26\u6838\u5bf9\u62a5\u8868\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            catch (Throwable throwable) {
                if (mutex == null) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return;
    }

    @Override
    public PageInfo<BillInfoKeepAccountRespDto> keepBillReportPage(BillInfoKeepAccountReqDto billInfoKeepAccountReqDto, Integer pageNum, Integer pageSize) {
        this.logger.info("\u53d1\u7968\u8bb0\u8d26\u62a5\u8868\u8bf7\u6c42\u53c2\u6570\uff1a{},{},{}", new Object[]{JSON.toJSONString((Object)billInfoKeepAccountReqDto), pageNum, pageSize});
        BillKeepAccountReqVo keepAccountReqVo = new BillKeepAccountReqVo();
        keepAccountReqVo.setPlatformOrderNo(billInfoKeepAccountReqDto.getPlatformOrderNo());
        keepAccountReqVo.setShopCodes(billInfoKeepAccountReqDto.getShopCodes());
        if (StringUtils.isNotBlank((CharSequence)billInfoKeepAccountReqDto.getKeepBillStartTime())) {
            keepAccountReqVo.setKeepBillStartTime(billInfoKeepAccountReqDto.getKeepBillStartTime() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoKeepAccountReqDto.getKeepBillEndTime())) {
            keepAccountReqVo.setKeepBillEndTime(billInfoKeepAccountReqDto.getKeepBillEndTime() + " 23:59:59");
        }
        if (Objects.nonNull(billInfoKeepAccountReqDto) && Objects.nonNull(billInfoKeepAccountReqDto.getDivergence())) {
            if (1 == billInfoKeepAccountReqDto.getDivergence()) {
                keepAccountReqVo.setFlag("divergence_yes");
            } else if (0 == billInfoKeepAccountReqDto.getDivergence()) {
                keepAccountReqVo.setFlag("divergence_no");
            }
        }
        PageInfo eoPageInfo = this.keepBillReportDas.keepBillReportPage(keepAccountReqVo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            List dtoList = eoPageInfo.getList().stream().map(v -> {
                BillInfoKeepAccountRespDto respDto = new BillInfoKeepAccountRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)v, (String[])new String[0]);
                return respDto;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(dtoList);
        }
        return dtoPageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handworkKeepBillReport(String startTime, String endTime) {
        this.logger.info("\u751f\u6210\u53d1\u7968\u8bb0\u8d26\u6c47\u603b\u62a5\u8868\u65f6\u95f4\uff1a{},{}", (Object)startTime, (Object)endTime);
        List<Map<String, Object>> timeList = DateUtil.getSplitTimeperiod(1, startTime + " 00:00:00", endTime + " 23:59:59");
        List timeRespDtos = JSONArray.parseArray((String)JSON.toJSONString(timeList), TimeRespDto.class);
        this.logger.info("\u65f6\u95f4\u5468\u671flist\uff1a{}", (Object)JSON.toJSONString((Object)timeRespDtos));
        Mutex mutex = null;
        if (CollectionUtils.isNotEmpty((Collection)timeRespDtos)) {
            for (TimeRespDto v : timeRespDtos) {
                try {
                    mutex = this.lockService.lock(TABLE_NAME_KEEP_BILL_REPORT, v.getStartTime().substring(0, 10), 10, 20, TimeUnit.SECONDS);
                    if (null == mutex) {
                        throw new BizException("\u91cd\u65b0\u53d1\u7968\u8bb0\u8d26\u6838\u5bf9\u62a5\u8868\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    GenerateKeepBillReqVo keepBillReqVo = new GenerateKeepBillReqVo();
                    keepBillReqVo.setKeepBillStartDate(v.getStartTime());
                    keepBillReqVo.setKeepBillEndDate(v.getEndTime());
                    String generateDate = v.getStartTime().substring(0, 10);
                    Date keepBillTime = DateUtil.toDate(v.getStartTime().substring(0, 10) + " " + com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)new Date(), (String)"HH:mm:ss"));
                    List keepBillReportAccountVos = this.keepBillReportDas.summaryKeepBillReport(keepBillReqVo);
                    if (CollectionUtils.isNotEmpty((Collection)keepBillReportAccountVos)) {
                        this.keepBillReportDas.updateKeepBillReport(Integer.valueOf(BigDecimal.ONE.intValue()), "system", generateDate);
                        ArrayList keepBillReportEos = Lists.newArrayList();
                        keepBillReportAccountVos.forEach(i -> {
                            KeepBillReportEo keepBillReportEo = new KeepBillReportEo();
                            keepBillReportEo.setShopCode(i.getShopCode());
                            keepBillReportEo.setShopName(i.getShopName());
                            keepBillReportEo.setCustomerCode(i.getCustomerCode());
                            keepBillReportEo.setCustomerName(i.getCustomerName());
                            keepBillReportEo.setPlatformNo(i.getPlatformNo());
                            keepBillReportEo.setPositiveAmount(i.getPositiveAmount());
                            keepBillReportEo.setReverseAmount(i.getReverseAmount());
                            keepBillReportEo.setTotalAmount(i.getTotalAmount());
                            keepBillReportEo.setEnterprise(i.getEnterprise());
                            keepBillReportEo.setBillAmount(i.getBillAmount());
                            keepBillReportEo.setBalance(i.getBalance());
                            keepBillReportEo.setDivergence(i.getDivergence());
                            keepBillReportEo.setGenerateDate(generateDate);
                            keepBillReportEo.setUpdatePerson("system");
                            keepBillReportEo.setKeepBillTime(keepBillTime);
                            keepBillReportEos.add(keepBillReportEo);
                        });
                        if (CollectionUtils.isNotEmpty((Collection)keepBillReportEos)) {
                            SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
                            KeepBillReportMapper mapper = (KeepBillReportMapper)session.getMapper(KeepBillReportMapper.class);
                            try {
                                int len;
                                int size = 500;
                                int i2 = 0;
                                for (len = keepBillReportEos.size(); len > size; len -= size) {
                                    keepBillReportEos.subList(i2, i2 + size).forEach(j -> mapper.insert(j));
                                    i2 += 500;
                                }
                                if (len > 0) {
                                    keepBillReportEos.subList(i2, i2 + len).forEach(j -> mapper.insert(j));
                                }
                                session.commit();
                                session.close();
                                session.clearCache();
                            }
                            finally {
                                session.close();
                            }
                        }
                    }
                    if (mutex == null) continue;
                }
                catch (Exception e) {
                    try {
                        this.logger.error("\u91cd\u65b0\u53d1\u7968\u8bb0\u8d26\u6838\u5bf9\u62a5\u8868\u5931\u8d25", (Object)e.getMessage(), (Object)e);
                        throw new BizException("\u91cd\u65b0\u53d1\u7968\u8bb0\u8d26\u6838\u5bf9\u62a5\u8868\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    catch (Throwable throwable) {
                        if (mutex != null) {
                            this.lockService.unlock(mutex);
                        }
                        throw throwable;
                    }
                }
                this.lockService.unlock(mutex);
            }
        }
    }
}

