/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.convert.entity.KeepExceptionDetailConverter;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepExceptionDetailDas;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepExceptionDetailDomain;
import com.yunxi.dg.base.center.finance.dto.entity.KeepExceptionDetailDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.KeepExceptionDetailReqDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepExceptionDetailRespDto;
import com.yunxi.dg.base.center.finance.dto.response.SaleOrderItemRespDto;
import com.yunxi.dg.base.center.finance.dto.response.SaleOrderRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.service.entity.IKeepExceptionDetailService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepExceptionDetailServiceImpl
extends BaseServiceImpl<KeepExceptionDetailDto, KeepExceptionDetailEo, IKeepExceptionDetailDomain>
implements IKeepExceptionDetailService {
    @Resource
    private IKeepExceptionDetailDas keepExceptionDetailDas;
    @Resource
    private IKeepExceptionDetailDomain keepExceptionDetailDomain;
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;

    public KeepExceptionDetailServiceImpl(IKeepExceptionDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<KeepExceptionDetailDto, KeepExceptionDetailEo> converter() {
        return KeepExceptionDetailConverter.INSTANCE;
    }

    @Override
    public Long addKeepExceptionDetail(KeepExceptionDetailReqDto addReqDto) {
        KeepExceptionDetailEo keepExceptionDetailEo = new KeepExceptionDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)keepExceptionDetailEo);
        this.keepExceptionDetailDas.insert((BaseEo)keepExceptionDetailEo);
        return keepExceptionDetailEo.getId();
    }

    @Override
    public void modifyKeepExceptionDetail(KeepExceptionDetailReqDto modifyReqDto) {
        KeepExceptionDetailEo keepExceptionDetailEo = new KeepExceptionDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)keepExceptionDetailEo);
        this.keepExceptionDetailDas.updateSelective((BaseEo)keepExceptionDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeKeepExceptionDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.keepExceptionDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public KeepExceptionDetailRespDto queryById(Long id) {
        KeepExceptionDetailEo keepExceptionDetailEo = (KeepExceptionDetailEo)this.keepExceptionDetailDas.selectByPrimaryKey(id);
        KeepExceptionDetailRespDto keepExceptionDetailRespDto = new KeepExceptionDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)keepExceptionDetailEo, (BaseVo)keepExceptionDetailRespDto);
        return keepExceptionDetailRespDto;
    }

    @Override
    public PageInfo<KeepExceptionDetailRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        KeepExceptionDetailReqDto keepExceptionDetailReqDto = (KeepExceptionDetailReqDto)JSON.parseObject((String)filter, KeepExceptionDetailReqDto.class);
        KeepExceptionDetailEo keepExceptionDetailEo = new KeepExceptionDetailEo();
        DtoHelper.dto2Eo((BaseVo)keepExceptionDetailReqDto, (BaseEo)keepExceptionDetailEo);
        PageInfo eoPageInfo = this.keepExceptionDetailDomain.selectPage((BaseEo)keepExceptionDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, KeepExceptionDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchKeepExceptionDetails(List<KeepExceptionDetailReqDto> keepExceptionDetailReqDtos) {
        if (CollectionUtils.isNotEmpty(keepExceptionDetailReqDtos)) {
            ArrayList keepExceptionDetailEos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)keepExceptionDetailEos, keepExceptionDetailReqDtos, KeepExceptionDetailEo.class);
            this.keepExceptionDetailDas.insertBatch((List)keepExceptionDetailEos);
        }
    }

    @Override
    public boolean validateSaleOrder(List<SaleOrderRespDto> saleOrderRespDtos, Map<Long, List<SaleOrderItemRespDto>> saleOrderItemRespDtoListMap, String voucherType, String orderInterface) {
        ListIterator<SaleOrderRespDto> it = saleOrderRespDtos.listIterator();
        while (it.hasNext()) {
            SaleOrderRespDto saleOrderRespDto = (SaleOrderRespDto)it.next();
            String saleOrderNo = saleOrderRespDto.getSaleOrderNo();
            List orderItemIds = saleOrderItemRespDtoListMap.get(saleOrderRespDto.getId()).stream().map(SaleOrderItemRespDto::getId).collect(Collectors.toList());
            VoucherTypeEnum voucherTypeEnum = VoucherTypeEnum.forCode((String)voucherType);
            switch (voucherTypeEnum) {
                case DELIVERY: 
                case INVOICE: {
                    List<Object> keepExceptionDetailReqDtos;
                    List deliveryKeepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().eq((Object)"order_no", (Object)saleOrderNo)).in((Object)"order_item_id", orderItemIds)).eq((Object)"voucher_type", (Object)voucherType)).list();
                    if (CollectionUtils.isNotEmpty((Collection)deliveryKeepAccountsDetailEos)) {
                        keepExceptionDetailReqDtos = Lists.newArrayList();
                        Map<String, List<KeepAccountsDetailEo>> deliveryKeepAccountsDetailEoListMap = deliveryKeepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getOrderNo));
                        deliveryKeepAccountsDetailEoListMap.forEach((k, v) -> {
                            KeepExceptionDetailReqDto exceptionDetailReqDto = new KeepExceptionDetailReqDto();
                            exceptionDetailReqDto.setOrderNo(k);
                            List saleOrderItemIds = v.stream().map(KeepAccountsDetailEo::getOrderItemId).collect(Collectors.toList());
                            String extension = "\u914d\u8d27\u8ba2\u5355\uff1a" + k + " \u5bf9\u5e94\u7684\u5546\u54c1\u884c\uff1a" + JSON.toJSONString(saleOrderItemIds) + " \u5df2\u7ecf\u751f\u6210\u8fc7\u8bb0\u8d26";
                            exceptionDetailReqDto.setExtension(extension);
                            exceptionDetailReqDto.setOrderType(BillTypeEnum.SALE_LIST.getCode());
                            exceptionDetailReqDto.setConditionType(voucherType);
                            keepExceptionDetailReqDtos.add(exceptionDetailReqDto);
                        });
                        this.batchKeepExceptionDetails(keepExceptionDetailReqDtos);
                        it.remove();
                        break;
                    }
                    if (!Objects.equals("KD-OMS-ERP-21", orderInterface) || !CollectionUtils.isNotEmpty((Collection)(keepExceptionDetailReqDtos = this.getKeepExceptionDetailEo(saleOrderRespDto)))) break;
                    this.batchKeepExceptionDetails(keepExceptionDetailReqDtos);
                    it.remove();
                }
            }
        }
        return CollectionUtils.isEmpty(saleOrderRespDtos);
    }

    public List<KeepExceptionDetailReqDto> getKeepExceptionDetailEo(SaleOrderRespDto saleOrderRespDto) {
        ArrayList keepExceptionDetailReqDtos = Lists.newArrayList();
        StringBuffer buffer = new StringBuffer();
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getCargoEscheatageCode())) {
            buffer.append("\u914d\u8d27\u8ba2\u5355\uff1a" + saleOrderRespDto.getSaleOrderNo() + "\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a \n");
        }
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getHsCustomerCode())) {
            buffer.append("\u914d\u8d27\u8ba2\u5355\uff1a" + saleOrderRespDto.getSaleOrderNo() + "\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a \n");
        }
        if (null == saleOrderRespDto.getPlatformCreateTime()) {
            buffer.append("\u914d\u8d27\u8ba2\u5355\uff1a" + saleOrderRespDto.getSaleOrderNo() + "\u9500\u552e\u8ba2\u5355\u7684\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a \n");
        }
        if (StringUtils.isNotBlank((CharSequence)buffer.toString())) {
            KeepExceptionDetailReqDto keepExceptionDetailReqDto = new KeepExceptionDetailReqDto();
            keepExceptionDetailReqDto.setOrderNo(saleOrderRespDto.getSaleOrderNo());
            keepExceptionDetailReqDto.setOrderType(BillTypeEnum.SALE_LIST.getCode());
            keepExceptionDetailReqDto.setExtension(buffer.toString());
            keepExceptionDetailReqDto.setConditionType(VoucherTypeEnum.DELIVERY.getCode());
            keepExceptionDetailReqDtos.add(keepExceptionDetailReqDto);
        }
        return keepExceptionDetailReqDtos;
    }

    @Override
    public List<KeepExceptionDetailDto> queryByOrderCodesNos(List<String> orderNoCodes) {
        List detailEos = ((ExtQueryChainWrapper)this.keepExceptionDetailDas.filter().in((Object)"order_no", orderNoCodes)).list();
        ArrayList<KeepExceptionDetailDto> keepExceptionDetailDtos = new ArrayList<KeepExceptionDetailDto>();
        if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
            CubeBeanUtils.copyCollection(keepExceptionDetailDtos, (Collection)detailEos, KeepExceptionDetailDto.class);
        }
        return keepExceptionDetailDtos;
    }
}

