/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.SaleOrderBillRecordConverter;
import com.yunxi.dg.base.center.finance.dao.das.IPerformOrderInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.ISaleOrderBillRecordDas;
import com.yunxi.dg.base.center.finance.domain.entity.ISaleOrderBillRecordDomain;
import com.yunxi.dg.base.center.finance.dto.entity.QueryUnInvoiceOrderListDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordPageReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderInvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.response.SaleOrderRespDto;
import com.yunxi.dg.base.center.finance.eo.SaleOrderBillRecordEo;
import com.yunxi.dg.base.center.finance.service.entity.ISaleOrderBillRecordService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SaleOrderBillRecordServiceImpl
extends BaseServiceImpl<SaleOrderBillRecordDto, SaleOrderBillRecordEo, ISaleOrderBillRecordDomain>
implements ISaleOrderBillRecordService {
    private static final Logger logger = LoggerFactory.getLogger(SaleOrderBillRecordServiceImpl.class);
    @Resource
    private ISaleOrderBillRecordDas saleOrderBillRecordDas;
    @Resource
    private IPerformOrderInfoDas performOrderInfoDas;

    public SaleOrderBillRecordServiceImpl(ISaleOrderBillRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SaleOrderBillRecordDto, SaleOrderBillRecordEo> converter() {
        return SaleOrderBillRecordConverter.INSTANCE;
    }

    @Override
    public PageInfo<SaleOrderRespDto> queryUnInvoiceOrderList(QueryUnInvoiceOrderListDto queryDto) {
        logger.info("\u67e5\u8be2\u672a\u5f00\u7968\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        if (Objects.isNull(pageNum) || pageNum < 0) {
            throw new BizException("\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        if (Objects.isNull(pageSize) || pageSize < 0) {
            throw new BizException("\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        }
        String startTime = queryDto.getStartTime();
        String endTime = queryDto.getEndTime();
        if (StringUtils.isBlank((CharSequence)startTime) && StringUtils.isBlank((CharSequence)endTime)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            endTime = format.format(date);
            Calendar cale = Calendar.getInstance();
            cale = Calendar.getInstance();
            cale.setTime(date);
            cale.set(5, cale.get(5) - 7);
            startTime = format.format(cale.getTime());
            logger.info("\u5f00\u59cb\u65f6\u95f4\uff1a{}\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)startTime, (Object)endTime);
        } else if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            if (this.timeCompare(startTime, endTime)) {
                throw new BizException("\u5f00\u59cb\u65f6\u95f4\u9700\u8981\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4");
            }
        } else {
            throw new BizException("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u90fd\u9700\u8981\u586b\u5199");
        }
        PageInfo saleOrderInfoVoPageInfo = this.saleOrderBillRecordDas.queryUnInvoiceOrderList(startTime, endTime, pageNum, pageSize, queryDto.getPlatformOrderNos());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)saleOrderInfoVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList saleOrderRespDtoList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)saleOrderInfoVoPageInfo.getList())) {
            CubeBeanUtils.copyCollection(saleOrderRespDtoList, (Collection)saleOrderInfoVoPageInfo.getList(), SaleOrderRespDto.class);
        }
        dtoPageInfo.setList(saleOrderRespDtoList);
        return dtoPageInfo;
    }

    public boolean timeCompare(String time1, String time2) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date1 = format.parse(time1);
            Date date2 = format.parse(time2);
            if (date1.compareTo(date2) > 0) {
                return true;
            }
            if (date1.compareTo(date2) < 0) {
                return false;
            }
            if (date1.compareTo(date2) == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
        }
        return false;
    }

    @Override
    public PageInfo<SaleOrderRespDto> queryApplyUnInvoice(QueryUnInvoiceOrderListDto queryDto) {
        logger.info("\u67e5\u8be2\u672a\u5f00\u7968\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        if (Objects.isNull(pageNum) || pageNum < 0) {
            throw new BizException("\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        if (Objects.isNull(pageSize) || pageSize < 0) {
            throw new BizException("\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        }
        ExtQueryChainWrapper filter = this.saleOrderBillRecordDas.filter();
        filter.eq((Object)"whether_invoice", (Object)SaleOrderInvoiceStateEnum.UNINVOICED.getCode());
        if (StringUtils.isNotBlank((CharSequence)queryDto.getStartTime())) {
            filter.ge((Object)"create_time", (Object)queryDto.getStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getEndTime())) {
            filter.le((Object)"create_time", (Object)queryDto.getEndTime());
        }
        if (CollectionUtil.isNotEmpty((Collection)queryDto.getPlatformOrderNos())) {
            filter.in((Object)"platform_order_no", (Collection)queryDto.getPlatformOrderNos());
        }
        filter.groupBy((Object)"platform_order_no");
        PageInfo dgSaleOrderBillRecordEoPageInfo = filter.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)dgSaleOrderBillRecordEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList saleOrderRespDtoList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)dgSaleOrderBillRecordEoPageInfo.getList())) {
            List saleOrderList = dgSaleOrderBillRecordEoPageInfo.getList().stream().map(SaleOrderBillRecordEo::getSaleOrderNo).distinct().collect(Collectors.toList());
            List performOrderInfoEoList = ((ExtQueryChainWrapper)this.performOrderInfoDas.filter().in((Object)"sale_order_no", saleOrderList)).list();
            CubeBeanUtils.copyCollection(saleOrderRespDtoList, (Collection)performOrderInfoEoList, SaleOrderRespDto.class);
        }
        dtoPageInfo.setList(saleOrderRespDtoList);
        return dtoPageInfo;
    }

    @Override
    public List<SaleOrderBillRecordDto> queryByReqDto(SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto) {
        ExtQueryChainWrapper filter = ((ISaleOrderBillRecordDomain)this.domain).filter();
        if (CollectionUtil.isNotEmpty((Collection)saleOrderBillRecordQueryReqDto.getSaleOrderNoList())) {
            filter.in((Object)"sale_order_no", (Collection)saleOrderBillRecordQueryReqDto.getSaleOrderNoList());
        }
        if (CollectionUtil.isNotEmpty((Collection)saleOrderBillRecordQueryReqDto.getPlatformOrderNoList())) {
            filter.in((Object)"platform_order_no", (Collection)saleOrderBillRecordQueryReqDto.getPlatformOrderNoList());
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderBillRecordQueryReqDto.getWhetherInvoice())) {
            filter.eq((Object)"whether_invoice", (Object)saleOrderBillRecordQueryReqDto.getWhetherInvoice());
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderBillRecordQueryReqDto.getPlatformOrderNo())) {
            filter.eq((Object)"platform_order_no", (Object)saleOrderBillRecordQueryReqDto.getPlatformOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderBillRecordQueryReqDto.getSaleOrderNo())) {
            filter.eq((Object)"sale_order_no", (Object)saleOrderBillRecordQueryReqDto.getSaleOrderNo());
        }
        List list = filter.list();
        ArrayList<SaleOrderBillRecordDto> dtoList = new ArrayList<SaleOrderBillRecordDto>();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, SaleOrderBillRecordDto.class);
        return dtoList;
    }
}

