/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.dao.das.IInventoryPreemptionDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InventoryPreemptionDomainImpl
extends BaseDomainImpl<InventoryUsageRecordEo>
implements IInventoryPreemptionDomain {
    @Autowired
    IInventoryPreemptionDas das;
    @Autowired
    IContext context;

    public ICommonDas<InventoryUsageRecordEo> commonDas() {
        return this.das;
    }

    @Override
    public List<InventoryUsageRecordEo> queryBySourceNo(String sourceNo) {
        if (StrUtil.isBlank((CharSequence)sourceNo)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryUsageRecordEo.class).eq(InventoryUsageRecordEo::getSourceNo, (Object)sourceNo)).eq(InventoryUsageRecordEo::getValid, (Object)ValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public List<InventoryUsageRecordEo> queryBySourceNo(String sourceNo, String usageType, String valid) {
        if (StrUtil.isBlank((CharSequence)sourceNo)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryUsageRecordEo.class).eq(InventoryUsageRecordEo::getSourceNo, (Object)sourceNo)).eq(InventoryUsageRecordEo::getUsageType, (Object)usageType)).eq(InventoryUsageRecordEo::getValid, (Object)valid)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public List<InventoryUsageRecordEo> queryBySourceNos(List<String> sourceNos) {
        if (CollectionUtil.isEmpty(sourceNos)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryUsageRecordEo.class).in(InventoryUsageRecordEo::getSourceNo, sourceNos)).eq(InventoryUsageRecordEo::getValid, (Object)ValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public List<InventoryUsageRecordEo> queryBySourceNo(List<String> sourceNos, String usageType, String valid) {
        if (CollectionUtil.isNotEmpty(sourceNos)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryUsageRecordEo.class).in(InventoryUsageRecordEo::getSourceNo, sourceNos)).eq(InventoryUsageRecordEo::getUsageType, (Object)usageType)).eq(InventoryUsageRecordEo::getValid, (Object)valid)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public void updatePreempt(List<InventoryUsageRecordEo> eoList) {
        if (CollectionUtil.isEmpty(eoList)) {
            return;
        }
        this.das.updatePreempt(eoList);
    }

    @Override
    public void allRelease(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        String updatePerson = StrUtil.isBlank((CharSequence)this.context.userName()) ? "system" : this.context.userName();
        this.das.allRelease(ids, updatePerson);
    }

    @Override
    public List<InventoryUsageRecordEo> queryBySourceNo(String sourceNo, String valid) {
        return this.das.queryBySourceNo(sourceNo, valid);
    }

    @Override
    public Integer searchCountForLessNum(String sourceNo) {
        return this.das.searchCountForLessNum(sourceNo);
    }

    @Override
    public List<InventoryUsageRecordEo> queryByPreItemIds(List<Long> preItemIds) {
        if (CollectionUtil.isEmpty(preItemIds)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryUsageRecordEo.class).in(InventoryUsageRecordEo::getPreOrderItemId, preItemIds)).eq(InventoryUsageRecordEo::getValid, (Object)ValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public InventoryUsageRecordEo queryDto(String warehouseCode, String skuCode, Long preItemId) {
        if (StringUtils.isEmpty((CharSequence)warehouseCode) && StringUtils.isEmpty((CharSequence)skuCode) && preItemId == null) {
            return new InventoryUsageRecordEo();
        }
        return (InventoryUsageRecordEo)this.das.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryUsageRecordEo.class).eq(InventoryUsageRecordEo::getWarehouseCode, (Object)warehouseCode)).eq(InventoryUsageRecordEo::getSkuCode, (Object)skuCode)).eq(InventoryUsageRecordEo::getPreOrderItemId, (Object)preItemId)).eq(InventoryUsageRecordEo::getValid, (Object)ValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }
}

