/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.mqc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderUpdateDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageOrderUpdateDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderAuditReqDto;
import com.yunxi.dg.base.center.inventory.service.business.adjust.IAdjustmentOrderService;
import com.yunxi.dg.base.center.inventory.service.business.other.IInOtherStorageOrderService;
import com.yunxi.dg.base.center.inventory.service.business.transfer.ITransferOrderService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="OA_AUDIT_RESULT_MAPPING", msgType="publish")
public class PushThirdAuditProcess
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(PushThirdAuditProcess.class);
    @Autowired
    private ITransferOrderService transferOrderService;
    @Resource(name="inventoryAdjustmentOrderServiceImpl")
    private IAdjustmentOrderService inventoryAdjustmentOrderServiceImpl;
    @Autowired
    private IInOtherStorageOrderService inOtherStorageOrderService;

    public MessageResponse process(String message) {
        log.info("\u6536\u5230OA\u5ba1\u6838\u63a8\u9001\u56de\u8c03, MQ\u6d88\u606f: {}", (Object)JSON.toJSONString((Object)message));
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)message);
            Integer auditResult = jsonObject.getInteger("auditResult");
            String businessOrderNo = jsonObject.getString("businessOrderNo");
            String orderType = jsonObject.getString("orderType");
            if (auditResult != null && auditResult == 2) {
                return MessageResponse.SUCCESS;
            }
            if ("transfer_order".equals(orderType)) {
                TransferOrderAuditReqDto reqDto = new TransferOrderAuditReqDto();
                reqDto.setAuditResult(auditResult != null && auditResult == 1 ? "audit_pass" : "audit_failed");
                reqDto.setTransferOrderNos((List)Lists.newArrayList((Object[])new String[]{businessOrderNo}));
                this.transferOrderService.audit(reqDto);
            } else if ("INVENTORY_ADJUSTMENT".equals(orderType)) {
                AdjustmentOrderUpdateDto reqDto = new AdjustmentOrderUpdateDto();
                reqDto.setAdjustmentNo(businessOrderNo);
                reqDto.setAuditResult(auditResult);
                this.inventoryAdjustmentOrderServiceImpl.audit(reqDto);
            } else if ("scrap_out".equals(orderType)) {
                InOtherStorageOrderUpdateDto reqDto = new InOtherStorageOrderUpdateDto();
                reqDto.setStorageOrderNo(businessOrderNo);
                reqDto.setAuditResult(String.valueOf(auditResult));
                this.inOtherStorageOrderService.audit(reqDto);
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
    }
}

