/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.rest.calc;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.UpdatePreemptBatchDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryDto;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u57fa\u7ebf-\u5e93\u5b58\u4e2d\u5fc3-\u5e93\u5b58\u8ba1\u7b97\u670d\u52a1"})
@RestController(value="calcInventoryRest")
public class CalcInventoryRest {
    @Resource
    private ICalcInventoryService calcInventoryService;

    @PostMapping(path={"/v1/dg/calcInventory/preempt"})
    @ApiOperation(value="\u9884\u5360\u5e93\u5b58", notes="\u9884\u5360\u5e93\u5b58")
    public RestResponse<Void> preempt(@RequestBody PreemptDto dto) {
        InventoryConfig.lock(() -> this.calcInventoryService.preempt(dto), (String)dto.getSourceNo(), (String)"ORDER_TO_PREEMPT_TAG");
        return RestResponse.VOID;
    }

    @PostMapping(path={"/v1/dg/calcInventory/preemptList"})
    @ApiOperation(value="\u9884\u5360\u5e93\u5b58", notes="\u9884\u5360\u5e93\u5b58")
    public RestResponse<Void> preemptList(@RequestBody List<PreemptDto> preemptDtoList) {
        InventoryConfig.lockList(() -> {
            this.calcInventoryService.preemptList(preemptDtoList);
            return 1;
        }, preemptDtoList.stream().map(CalcDto::getSourceNo).distinct().collect(Collectors.toList()), (String)"ORDER_TO_PREEMPT_TAG_1", (int)60);
        return RestResponse.VOID;
    }

    @PostMapping(path={"/v1/dg/calcInventory/updatePreemptBatch"})
    @ApiOperation(value="\u9884\u5360\u7f6e\u6362", notes="\u9884\u5360\u7f6e\u6362")
    public RestResponse<Void> updatePreemptBatch(@RequestBody UpdatePreemptBatchDto dto) {
        this.calcInventoryService.updatePreemptBatch(dto);
        return RestResponse.VOID;
    }

    @PostMapping(path={"/v1/dg/calcInventory/updatePreempt"})
    @ApiOperation(value="\u66f4\u65b0\u9884\u5360\u5e93\u5b58", notes="\u66f4\u65b0\u9884\u5360\u5e93\u5b58")
    public RestResponse<Void> updatePreempt(@RequestBody PreemptDto dto) {
        this.calcInventoryService.updatePreempt(dto);
        return RestResponse.VOID;
    }

    @PostMapping(path={"/v1/dg/calcInventory/releasePreempt"})
    @ApiOperation(value="\u91ca\u653e\u9884\u5360", notes="\u91ca\u653e\u9884\u5360")
    public RestResponse<Void> releasePreempt(@RequestBody ReleasePreemptDto dto) {
        this.calcInventoryService.releasePreempt(dto);
        return RestResponse.VOID;
    }

    @PostMapping(path={"/v1/dg/calcInventory/syncInventory"})
    @ApiOperation(value="\u91ca\u653e\u9884\u5360", notes="\u91ca\u653e\u9884\u5360")
    public RestResponse<Void> syncInventory(@RequestBody List<LogicInventoryDto> inventoryDtoList) {
        this.calcInventoryService.syncInventory(inventoryDtoList);
        return RestResponse.VOID;
    }
}

