/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.rest.entity;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.api.entity.IInventoryTakeStockOrderApi;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryTakeStockOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryTakeStockOrderPageReqDto;
import com.yunxi.dg.base.center.inventory.service.business.takeStock.IInventoryTakeStockOrderService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import io.swagger.annotations.Api;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u6837\u672c\u4e2d\u5fc3:\u5e93\u5b58\u76d8\u70b9\u5355\u63a5\u53e3\u670d\u52a1"})
public class InventoryTakeStockOrderController
implements IInventoryTakeStockOrderApi {
    @Resource
    private IInventoryTakeStockOrderService service;

    public RestResponse<Long> insert(@RequestBody InventoryTakeStockOrderDto dto) {
        return this.service.save(dto);
    }

    public RestResponse<Integer> insertBatch(@RequestBody List<InventoryTakeStockOrderDto> dto) {
        if (CollectionUtils.isNotEmpty(dto)) {
            for (InventoryTakeStockOrderDto inventoryTakeStockOrderDto : dto) {
                this.service.save(inventoryTakeStockOrderDto);
            }
        }
        return new RestResponse((Object)dto.size());
    }

    public RestResponse update(@RequestBody InventoryTakeStockOrderDto dto) {
        return this.service.updateItemList(dto);
    }

    public RestResponse<InventoryTakeStockOrderDto> get(Long id) {
        return this.service.get(id);
    }

    public RestResponse logicDelete(@PathVariable(name="id", required=true) Long id) {
        return this.service.logicDelete(id);
    }

    public RestResponse<PageInfo<InventoryTakeStockOrderDto>> page(@RequestBody InventoryTakeStockOrderPageReqDto dto) {
        return this.service.page((BaseDto)BeanCopyUtil.copy((Object)dto, InventoryTakeStockOrderDto.class), dto.getPageNum(), dto.getPageSize());
    }

    public RestResponse<PageInfo<InventoryTakeStockOrderDto>> queryByPage(@RequestBody InventoryTakeStockOrderPageReqDto dto) {
        return this.service.queryByPage(dto);
    }

    public RestResponse<PageInfo<InventoryTakeStockOrderDto>> queryByItemPage(@RequestBody InventoryTakeStockOrderPageReqDto dto) {
        return this.service.queryByItemPage(dto);
    }

    public RestResponse<InventoryTakeStockOrderDto> details(@PathVariable(name="orderNo", required=true) String orderNo) {
        return this.service.details(orderNo);
    }

    public RestResponse<Void> cancel(@PathVariable(name="orderNo", required=true) String orderNo) {
        return this.service.cancel(orderNo);
    }

    public RestResponse<Void> cancelByExternal(@PathVariable(name="externalOrderNo", required=true) String externalOrderNo) {
        InventoryTakeStockOrderDto stockOrderDto = this.service.queryByExternalOrderNo(externalOrderNo);
        if (stockOrderDto == null) {
            throw new BizException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        return this.service.cancel(stockOrderDto.getOrderNo());
    }

    public RestResponse<InventoryTakeStockOrderDto> queryByExternalOrderNo(@PathVariable(name="externalOrderNo", required=true) String externalOrderNo) {
        return new RestResponse((Object)this.service.queryByExternalOrderNo(externalOrderNo));
    }

    public RestResponse<Void> completed(@PathVariable(name="orderNo", required=true) String orderNo) {
        return this.service.completed(orderNo);
    }
}

