/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.context;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.ProjectEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IMultipleOutInventoryDomain;
import com.yunxi.dg.base.center.inventory.dto.Schemas.DictExtRespDto;
import com.yunxi.dg.base.center.inventory.dto.Schemas.DictQueryExtReqDto;
import com.yunxi.dg.base.center.inventory.eo.MultipleOutInventoryEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.AbstractPushWmsAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.PushWmsAble;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenBo;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.service.third.DefaultPushSapAble;
import com.yunxi.dg.base.center.inventory.service.third.DefaultPushShareDispatchAble;
import com.yunxi.dg.base.center.inventory.service.third.DefaultPushThirdAuditAble;
import com.yunxi.dg.base.center.inventory.service.third.DefaultTransferOrderPushErpAble;
import com.yunxi.dg.base.center.inventory.service.third.PushSapAble;
import com.yunxi.dg.base.center.inventory.service.third.PushShareDispatchAble;
import com.yunxi.dg.base.center.inventory.service.third.PushThirdAuditAble;
import com.yunxi.dg.base.center.inventory.service.third.TransferOrderPushErpAble;
import com.yunxi.dg.base.center.inventory.service.utils.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.event.TransactionalApplicationListener;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@EnableConfigurationProperties
@ConfigurationProperties(prefix="inventory.dg.config", ignoreInvalidFields=true)
@Configuration
@EnableFeignClients(basePackages={"com.yunxi.dg.base.center.inventory.service.third.api"})
public class InventoryConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(InventoryConfig.class);
    private static IMultipleOutInventoryDomain iMultipleOutInventoryDomain;
    private static ILockService lockService;
    @Resource
    private IPcpDictQueryApiProxy iPcpDictQueryApiProxy;
    public static PlatformTransactionManager platformTransactionManager;
    protected static String projectCode;
    protected static String commonSeparate;
    protected static String defaultBatch;
    protected static boolean noneBatch;
    protected static boolean transferOrderReissue;
    protected static boolean canSmallOut;
    protected static boolean vaildItemExist;
    protected static boolean checkProduceTime;
    protected static boolean enableInspction;
    protected static boolean enableInventoryProperty;
    protected static boolean preemptHiddenBatch;
    protected static boolean multipleOut;
    protected static boolean multipleIn;
    protected static int inventoryPrecision;
    protected static boolean enableUnit;
    protected static boolean enableInOutAutoComplete;
    protected static Map<String, CodeGenEnum> codeGenEnumMap;
    public static Map<String, CodeGenBo> codeGenBoMap;
    protected static PushWmsAble pushWmsAble;
    protected static PushSapAble pushSapAble;
    protected static PushThirdAuditAble pushThirdAuditAble;
    private static PushShareDispatchAble pushShareDispatchAble;
    protected static TransferOrderPushErpAble transferOrderPushErpAble;
    protected static ApplicationEventPublisher applicationEventPublisher;
    protected static GenerateCodeUtil generateCodeUtil;
    protected static boolean logisticsMapping;
    protected static boolean dispatchOrderEnable;
    protected static boolean autoHandleDispatchOrderEnable;
    protected static boolean canSecondLevel;
    protected static boolean canHangUP;
    protected static boolean orderLineCallbackProcess;
    protected static boolean hasThirdClose;
    protected static boolean inventoryInsufficientHangUp;
    protected static boolean canSendLogistics;
    protected static boolean noticeEndStatus;
    protected static boolean canSupplyInventory;
    protected static List<TransactionalApplicationListener> listeners;
    protected static boolean canTakeStockGenAdjustmentOrder;
    protected static boolean dispatchOrderBatch;
    protected static boolean transferInOrderBatch;
    protected static boolean transferInnerAutoCompulete;
    protected static boolean padModule;
    protected static String padModule100Channel;

    @Autowired
    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        InventoryConfig.platformTransactionManager = platformTransactionManager;
    }

    @Autowired
    public void setMultipleOutInventoryDomain(IMultipleOutInventoryDomain iMultipleOutInventoryDomain) {
        InventoryConfig.iMultipleOutInventoryDomain = iMultipleOutInventoryDomain;
    }

    @Autowired
    public void setLockService(ILockService lockService) {
        InventoryConfig.lockService = lockService;
    }

    @Value(value="${inventory.dg.base.project}")
    public void setProjectCode(String projectCode) {
        log.info("\u5f53\u524d\u5de5\u7a0b\uff1a{}", (Object)projectCode);
        InventoryConfig.projectCode = projectCode;
    }

    public void setNoneBatch(boolean noneBatch) {
        InventoryConfig.noneBatch = noneBatch;
        log.info("set\u65e0\u6279\u5f00\u5173\uff1a{}", (Object)noneBatch);
    }

    @Value(value="${yunxi.dg.base.inventory.multipleOut.enable:true}")
    public void setMultipleOut(boolean multipleOut) {
        log.info("\u591a\u6b21\u51fa\u5e93\u5f00\u5173:{}", (Object)multipleOut);
        InventoryConfig.multipleOut = multipleOut;
    }

    @Value(value="${yunxi.dg.base.inventory.multipleIn.enable:true}")
    public void setMultipleIn(boolean multipleIn) {
        log.info("\u591a\u6b21\u5165\u5e93\u5f00\u5173:{}", (Object)multipleIn);
        InventoryConfig.multipleIn = multipleIn;
    }

    public static boolean isEnableInOutAutoComplete() {
        return enableInOutAutoComplete;
    }

    @Value(value="${yunxi.dg.base.inventory.inout.autoComplete.enable:false}")
    public void setEnableInOutAutoComplete(boolean enableInOutAutoComplete) {
        log.info("\u662f\u5426\u542f\u7528\u51fa\u5165\u5e93\u81ea\u52a8\u5b8c\u6210:{}", (Object)enableInOutAutoComplete);
        InventoryConfig.enableInOutAutoComplete = enableInOutAutoComplete;
    }

    public static String getProjectCode() {
        return projectCode;
    }

    public static boolean isNoneBatch() {
        return noneBatch;
    }

    public static boolean isMultipleOut() {
        return multipleOut;
    }

    public static boolean isMultipleOut(String orderType, String businessType) {
        boolean multipleOut = InventoryConfig.isMultipleOut();
        MultipleOutInventoryEo multipleOutInventoryEo = (MultipleOutInventoryEo)Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)iMultipleOutInventoryDomain.filter().eq((Object)"order_type", (Object)orderType)).eq((Object)"business_type", (Object)businessType)).last(" limit 1")).one()).orElse(new MultipleOutInventoryEo());
        if (Objects.equals(1L, multipleOutInventoryEo.getIsMultipleOut())) {
            multipleOut = true;
        } else if (Objects.equals(0L, multipleOutInventoryEo.getIsMultipleOut())) {
            multipleOut = false;
        }
        return multipleOut;
    }

    public static boolean isMultipleIn() {
        return multipleIn;
    }

    public static boolean isMultipleIn(String orderType, String businessType) {
        boolean multipleIn = InventoryConfig.isMultipleIn();
        MultipleOutInventoryEo multipleOutInventoryEo = (MultipleOutInventoryEo)Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)iMultipleOutInventoryDomain.filter().eq((Object)"order_type", (Object)orderType)).eq((Object)"business_type", (Object)businessType)).last(" limit 1")).one()).orElse(new MultipleOutInventoryEo());
        if (Objects.equals(1L, multipleOutInventoryEo.getIsMultipleIn())) {
            multipleIn = true;
        } else if (Objects.equals(0L, multipleOutInventoryEo.getIsMultipleIn())) {
            multipleIn = false;
        }
        return multipleIn;
    }

    @Autowired
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        InventoryConfig.applicationEventPublisher = applicationEventPublisher;
    }

    public static <T extends ApplicationEvent> void pushEvent(T event) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            applicationEventPublisher.publishEvent(event);
        } else {
            listeners.forEach(listener -> listener.onApplicationEvent(event));
        }
        log.info("\u6210\u529f\u53d1\u9001\u4e8b\u4ef6event\uff1a{}", (Object)event.getClass().getName());
    }

    public static CodeGenEnum getCodeGenByCode(String code) {
        return codeGenEnumMap.get(code);
    }

    public static String genCodeGenByType(String code) {
        return generateCodeUtil.generateCode(codeGenEnumMap.get(code));
    }

    public static PushWmsAble getPushWms() {
        return pushWmsAble;
    }

    public static PushSapAble getPushSapAble() {
        return pushSapAble;
    }

    public static boolean isCanSupplyInventory() {
        return canSupplyInventory;
    }

    public static ApplicationEventPublisher getEventPublisher() {
        return applicationEventPublisher;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String property = applicationContext.getEnvironment().getProperty("inventory.dg.base.project");
        Optional.ofNullable(property).map(ProjectEnum::getByCode).ifPresent(byCode -> {
            noneBatch = byCode.getNoneBatch();
            multipleOut = byCode.getMultipleOut();
            multipleIn = byCode.getMultipleIn();
            inventoryPrecision = byCode.getInventoryPrecision();
            projectCode = property;
        });
        Arrays.stream(CodeGenEnum.values()).sorted(Comparator.comparing(o -> Optional.ofNullable(o.getRefProject()).map(List::size).orElse(-1))).forEach(codeGenEnum -> {
            if (codeGenEnum.getRefProject() == null) {
                codeGenEnumMap.put(codeGenEnum.getCode(), (CodeGenEnum)((Object)codeGenEnum));
                codeGenBoMap.put(codeGenEnum.getCode(), (CodeGenBo)BeanUtil.copyProperties((Object)codeGenEnum, CodeGenBo.class, (String[])new String[0]));
            } else {
                boolean hasProjectCodeGen;
                boolean bl = hasProjectCodeGen = codeGenEnumMap.containsKey(codeGenEnum.getCode()) && StringUtils.isNotBlank((CharSequence)property) && codeGenEnum.getRefProject().contains(property);
                if (hasProjectCodeGen) {
                    codeGenEnumMap.put(codeGenEnum.getCode(), (CodeGenEnum)((Object)codeGenEnum));
                    codeGenBoMap.put(codeGenEnum.getCode(), (CodeGenBo)BeanUtil.copyProperties((Object)codeGenEnum, CodeGenBo.class, (String[])new String[0]));
                }
            }
        });
        pushWmsAble = Optional.of(applicationContext.getBeansOfType(PushWmsAble.class).values()).map(set -> set.stream().filter(s -> Objects.equals(s.getType(), projectCode)).findFirst().orElse((PushWmsAble)applicationContext.getBean(AbstractPushWmsAble.class))).orElse((PushWmsAble)applicationContext.getBean(AbstractPushWmsAble.class));
        pushSapAble = Optional.of(applicationContext.getBeansOfType(PushSapAble.class).values()).map(set -> set.stream().filter(s -> Objects.equals(s.getType(), projectCode)).findFirst().orElse((PushSapAble)applicationContext.getBean(DefaultPushSapAble.class))).orElse((PushSapAble)applicationContext.getBean(DefaultPushSapAble.class));
        pushThirdAuditAble = Optional.of(applicationContext.getBeansOfType(PushThirdAuditAble.class).values()).map(set -> set.stream().filter(s -> Objects.equals(s.getType(), projectCode)).findFirst().orElse((PushThirdAuditAble)applicationContext.getBean(DefaultPushThirdAuditAble.class))).orElse((PushThirdAuditAble)applicationContext.getBean(DefaultPushThirdAuditAble.class));
        pushShareDispatchAble = Optional.of(applicationContext.getBeansOfType(PushShareDispatchAble.class).values()).map(set -> set.stream().filter(s -> Objects.equals(s.getType(), projectCode)).findFirst().orElse((PushShareDispatchAble)applicationContext.getBean(DefaultPushShareDispatchAble.class))).orElse((PushShareDispatchAble)applicationContext.getBean(DefaultPushShareDispatchAble.class));
        transferOrderPushErpAble = Optional.of(applicationContext.getBeansOfType(TransferOrderPushErpAble.class).values()).map(set -> set.stream().filter(s -> Objects.equals(s.getType(), projectCode)).findFirst().orElse((TransferOrderPushErpAble)applicationContext.getBean(DefaultTransferOrderPushErpAble.class))).orElse((TransferOrderPushErpAble)applicationContext.getBean(DefaultTransferOrderPushErpAble.class));
        generateCodeUtil = (GenerateCodeUtil)applicationContext.getBean(GenerateCodeUtil.class);
        listeners = applicationContext.getBeansOfType(TransactionalApplicationListener.class).values().stream().collect(Collectors.toList());
    }

    @PostConstruct
    public void loadDictSetting() {
        try {
            DictQueryExtReqDto dictQueryExtReqDto = new DictQueryExtReqDto();
            dictQueryExtReqDto.setCodes(Arrays.asList("DEV_OPS_CONFIG"));
            List dictExtRespDtoList = this.iPcpDictQueryApiProxy.queryByParam(dictQueryExtReqDto);
            log.info("dataDictDtoList:{}", (Object)JSONObject.toJSONString((Object)dictExtRespDtoList));
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)dictExtRespDtoList)) {
                Map<String, Integer> devOpsConfigMap = dictExtRespDtoList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getSubValue()) && null != r.getSubStatus()).collect(Collectors.toMap(DictExtRespDto::getSubValue, DictExtRespDto::getSubStatus, (o, o1) -> o));
                log.info("devOpsConfigMap{}", (Object)JSONObject.toJSONString(devOpsConfigMap));
                noneBatch = !ObjectUtil.equals((Object)devOpsConfigMap.get("BATCH_ENABLE"), (Object)1);
                enableInventoryProperty = ObjectUtil.equals((Object)devOpsConfigMap.get("PROPERTY_ENBALE"), (Object)1);
                enableInspction = ObjectUtil.equals((Object)devOpsConfigMap.get("QUALITY_ENBALE"), (Object)1);
                enableUnit = ObjectUtil.equals((Object)devOpsConfigMap.get("UNIT_ENABLE"), (Object)1);
                log.info("\u5b57\u5178\u65e0\u6279\u5f00\u5173{}", (Object)noneBatch);
                log.info("\u5b57\u5178\u5e93\u5b58\u72b6\u6001\u5f00\u5173{}", (Object)enableInventoryProperty);
                log.info("\u5b57\u5178\u8d28\u68c0\u653e\u884c\u5f00\u5173{}", (Object)enableInspction);
                log.info("\u5b57\u5178\u591a\u5355\u4f4d\u5f00\u5173{}", (Object)enableUnit);
            }
        }
        catch (Exception e) {
            log.error("\u5b57\u5178\u52a0\u8f7d\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    public static GenerateCodeUtil getGenerateCodeUtil() {
        return generateCodeUtil;
    }

    public static boolean isLogisticsMapping() {
        return false;
    }

    @Value(value="${yunxi.dg.base.inventory.logisticsMapping:false}")
    public void setLogisticsMapping(boolean logisticsMapping) {
        log.info("\u7269\u6d41\u5546\u6620\u5c04\u5f00\u5173:{}", (Object)logisticsMapping);
        InventoryConfig.logisticsMapping = logisticsMapping;
    }

    public static boolean isEnableUnit() {
        return enableUnit;
    }

    @Value(value="${yunxi.dg.base.inventory.enableUnit:true}")
    public void setEnableUnit(boolean enableUnit) {
        log.info("\u662f\u5426\u542f\u7528\u5355\u4f4d\u5f00\u5173:{}", (Object)enableUnit);
        InventoryConfig.enableUnit = enableUnit;
        log.info("set\u662f\u5426\u542f\u7528\u5355\u4f4d\u5f00\u5173:{}", (Object)enableUnit);
    }

    public static int getInventoryPrecision() {
        return inventoryPrecision;
    }

    @Value(value="${yunxi.dg.base.inventory.inventoryPrecision:0}")
    public void setInventoryPrecision(Integer inventoryPrecision) {
        InventoryConfig.inventoryPrecision = inventoryPrecision;
    }

    public static boolean isDispatchOrderEnable() {
        return dispatchOrderEnable;
    }

    @Value(value="${yunxi.dg.base.inventory.dispatchOrder.enable:true}")
    public void setDispatchOrderEnable(boolean dispatchOrderEnable) {
        log.info("\u6536\u53d1\u5dee\u5f02\u5355\u5f00\u5173:{}", (Object)dispatchOrderEnable);
        InventoryConfig.dispatchOrderEnable = dispatchOrderEnable;
    }

    public static boolean isDispatchOrderBatch() {
        return dispatchOrderBatch;
    }

    public static boolean isAutoHandleDispatchOrderEnable() {
        return autoHandleDispatchOrderEnable;
    }

    @Value(value="${yunxi.dg.base.inventory.dispatchOrder.auto-handle.enable:false}")
    public void setAutoHandleDispatchOrderEnable(boolean autoHandleDispatchOrderEnable) {
        log.info("\u81ea\u52a8\u5904\u7406\u6536\u53d1\u5dee\u5f02\u5355\u5f00\u5173:{}", (Object)autoHandleDispatchOrderEnable);
        InventoryConfig.autoHandleDispatchOrderEnable = autoHandleDispatchOrderEnable;
    }

    public static boolean isEnableInventoryProperty() {
        return enableInventoryProperty;
    }

    @Value(value="${yunxi.dg.base.inventory.property.enable:true}")
    public void setEnableInventoryProperty(boolean enableInventoryProperty) {
        InventoryConfig.enableInventoryProperty = enableInventoryProperty;
        log.info("set\u5e93\u5b58\u5c5e\u6027\u5f00\u5173:{}", (Object)enableInventoryProperty);
    }

    @Value(value="${yunxi.dg.base.inventory.hidden.batch.enable:false}")
    public void setPreemptHiddenBatch(boolean preemptHiddenBatch) {
        log.info("\u9884\u5360\u9690\u85cf\u6279\u5f00\u5173:{}", (Object)preemptHiddenBatch);
        InventoryConfig.preemptHiddenBatch = preemptHiddenBatch;
    }

    @Value(value="${yunxi.dg.base.inventory.second.level.enable:true}")
    public void setCanSecondLevel(boolean canSecondLevel) {
        log.info("\u4e8c\u7ea7\u5ba1\u6838\u5f00\u5173:{}", (Object)canSecondLevel);
        InventoryConfig.canSecondLevel = canSecondLevel;
    }

    @Value(value="${yunxi.dg.base.inventory.hang.up.enable:true}")
    public void setCanHangUp(boolean canHangUp) {
        log.info("\u662f\u5426\u6302\u8d77:{}", (Object)canHangUp);
        canHangUP = canHangUp;
    }

    public static boolean isCanHangUp() {
        return canHangUP;
    }

    public static boolean isPreemptHiddenBatch() {
        return preemptHiddenBatch;
    }

    public static Map<String, CodeGenEnum> getCodeGenEnumMap() {
        return codeGenEnumMap;
    }

    public static Map<String, CodeGenBo> getCodeGenBoMap() {
        return codeGenBoMap;
    }

    public static PushWmsAble getPushWmsAble() {
        return pushWmsAble;
    }

    public static PushThirdAuditAble getPushThirdAuditAble() {
        return pushThirdAuditAble;
    }

    public static ApplicationEventPublisher getApplicationEventPublisher() {
        return applicationEventPublisher;
    }

    public static boolean isCanSecondLevel() {
        return canSecondLevel;
    }

    public static String getDefaultBatch() {
        return defaultBatch;
    }

    @Value(value="${yunxi.dg.base.inventory.default.batch:A000}")
    public void setDefaultBatch(String defaultBatch) {
        InventoryConfig.defaultBatch = defaultBatch;
    }

    public static boolean isCanSendLogistics() {
        return false;
    }

    @Value(value="${yunxi.dg.base.inventory.send.logistics.enable:true}")
    public void setCanSendLogistics(boolean canSendLogistics) {
        InventoryConfig.canSendLogistics = canSendLogistics;
    }

    @Value(value="${yunxi.dg.base.inventory.supply.inventory.enable:false}")
    public void setCanSupplyInventory(boolean canSupplyInventory) {
        log.info("\u662f\u5426\u9700\u8981\u6821\u9a8c\u4f9b\u8d27\u5e93\u5b58\uff1a{}", (Object)canSupplyInventory);
        InventoryConfig.canSupplyInventory = canSupplyInventory;
    }

    public static boolean isCheckProduceTime() {
        return checkProduceTime;
    }

    public void setCheckProduceTime(boolean checkProduceTime) {
        InventoryConfig.checkProduceTime = checkProduceTime;
    }

    public static String getCommonSeparate() {
        return commonSeparate;
    }

    public static boolean isCanSmallOut() {
        return canSmallOut;
    }

    public void setCanSmallOut(boolean canSmallOut) {
        InventoryConfig.canSmallOut = canSmallOut;
    }

    @Value(value="${yunxi.dg.base.inventory.takeStock.gen.adjustmentOrder.enable:true}")
    public void setcanTakeStockGenAdjustmentOrder(boolean canTakeStockGenAdjustmentOrder) {
        InventoryConfig.canTakeStockGenAdjustmentOrder = canTakeStockGenAdjustmentOrder;
    }

    public static boolean isCanTakeStockGenAdjustmentOrder() {
        return canTakeStockGenAdjustmentOrder;
    }

    @Value(value="${yunxi.dg.base.inventory.insufficient.hang.up.enable:false}")
    public void setInventoryInsufficientHangUp(boolean inventoryInsufficientHangUp) {
        log.info("\u5e93\u5b58\u4e0d\u8db3\u7ed3\u679c\u5355\u662f\u5426\u6302\u8d77 true-\u6302\u8d77\u3001false-\u4e0d\u6302\u8d77\uff0c\u76f4\u63a5\u629b\u51fa\u5f02\u5e38:{}", (Object)inventoryInsufficientHangUp);
        InventoryConfig.inventoryInsufficientHangUp = inventoryInsufficientHangUp;
    }

    public static boolean isInventoryInsufficientHangUp() {
        return inventoryInsufficientHangUp;
    }

    @Value(value="${yunxi.dg.base..dispatchOrderBatch.enable:true}")
    public void setDispatchOrderBatch(boolean dispatchOrderBatch) {
        log.info("\u6536\u53d1\u5dee\u5f02\u6821\u9a8c\u6279\u6b21\u5f00\u5173:{}", (Object)dispatchOrderBatch);
        InventoryConfig.dispatchOrderBatch = dispatchOrderBatch;
    }

    public static boolean isOrderLineCallbackProcess() {
        return orderLineCallbackProcess;
    }

    @Value(value="${yunxi.dg.base.orderLineCallbackProcess.enable:true}")
    public void setOrderLineCallbackProcess(boolean orderLineCallbackProcess) {
        InventoryConfig.orderLineCallbackProcess = orderLineCallbackProcess;
    }

    public static boolean isTransferInOrderBatch() {
        return transferInOrderBatch;
    }

    @Value(value="${yunxi.dg.base.inventory.transferInOrderBatch.enable:true}")
    public static void setTransferInOrderBatch(boolean transferInOrderBatch) {
        log.info("\u8c03\u62e8\u5165\u5e93\u6821\u9a8c\u6279\u6b21\u5f00\u5173:{}", (Object)transferInOrderBatch);
        InventoryConfig.transferInOrderBatch = transferInOrderBatch;
    }

    public static boolean isVaildItemExist() {
        return vaildItemExist;
    }

    public void setVaildItemExist(boolean vaildItemExist) {
        InventoryConfig.vaildItemExist = vaildItemExist;
    }

    public static boolean isHasThirdClose() {
        return hasThirdClose;
    }

    public void setHasThirdClose(boolean hasThirdClose) {
        InventoryConfig.hasThirdClose = hasThirdClose;
    }

    public static boolean isTransferInnerAutoCompulete() {
        return transferInnerAutoCompulete;
    }

    public void setTransferInnerAutoCompulete(boolean transferInnerAutoCompulete) {
        InventoryConfig.transferInnerAutoCompulete = transferInnerAutoCompulete;
    }

    public static boolean isEnableInspction() {
        return enableInspction;
    }

    public void setEnableInspction(boolean enableInspction) {
        InventoryConfig.enableInspction = enableInspction;
        log.info("set\u8d28\u68c0\u653e\u884c\u5f00\u5173:{}", (Object)enableInspction);
    }

    public static PushShareDispatchAble getPushShareDispatchAble() {
        return pushShareDispatchAble;
    }

    public static TransferOrderPushErpAble getTransferOrderPushErpAble() {
        return transferOrderPushErpAble;
    }

    public static void setTransferOrderPushErpAble(TransferOrderPushErpAble transferOrderPushErpAble) {
        InventoryConfig.transferOrderPushErpAble = transferOrderPushErpAble;
    }

    public static void registerSynchronizationAfterCommit(Consumer consumer) {
        InventoryConfig.registerSynchronizationAfterCommit(consumer, Integer.MAX_VALUE);
    }

    public static void registerSynchronizationAfterCommit(final Consumer consumer, final Integer sort) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    consumer.accept();
                }

                public int getOrder() {
                    return sort != Integer.MIN_VALUE ? sort - 1 : sort;
                }
            });
        } else {
            consumer.accept();
        }
    }

    public static void registerSynchronizationBeforeCommit(final Consumer consumer, final Integer sort) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    consumer.accept();
                }

                public int getOrder() {
                    return sort - 1;
                }
            });
        } else {
            consumer.accept();
        }
    }

    public static void registerSynchronizationAfterCompletion(final Consumer consumer) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCompletion(int status) {
                    consumer.accept();
                }
            });
        } else {
            consumer.accept();
        }
    }

    public static String getOrDefaultBatch(String batch) {
        return StringUtils.equalsIgnoreCase((CharSequence)batch, (CharSequence)defaultBatch) ? defaultBatch : batch;
    }

    public void setTransferOrderReissue(boolean transferOrderReissue) {
        InventoryConfig.transferOrderReissue = transferOrderReissue;
    }

    public static boolean isTransferOrderReissue() {
        return transferOrderReissue;
    }

    public static boolean isNoticeEndStatus() {
        return noticeEndStatus;
    }

    @Value(value="${yunxi.dg.base.inventory.notice.end.status.enable:true}")
    public void setNoticeEndStatus(boolean noticeEndStatus) {
        InventoryConfig.noticeEndStatus = noticeEndStatus;
    }

    @Value(value="${yunxi.dg.base.inventory.pda.module:true}")
    public void setPadModule(boolean padModule) {
        log.info("pad\u6a21\u5f0f\u5f00\u5173:{}", (Object)padModule);
        InventoryConfig.padModule = padModule;
    }

    public static String getPadModule100Channel() {
        return padModule100Channel;
    }

    @Value(value="${yunxi.dg.base.inventory.pda.module.channel:}")
    public void setPadModule100Channel(String padModule100Channel) {
        InventoryConfig.padModule100Channel = padModule100Channel;
    }

    public static boolean isPadModule() {
        return padModule;
    }

    public static boolean isPadModule(String channelCode) {
        return padModule || Optional.ofNullable(padModule100Channel).orElse("").contains(StringUtils.defaultString((String)channelCode, (String)""));
    }

    public static <REQ> REQ executorNewTransaction(TransactionCallback<REQ> action) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(platformTransactionManager);
        transactionTemplate.setIsolationLevel(2);
        transactionTemplate.setPropagationBehavior(3);
        return (REQ)transactionTemplate.execute(action);
    }

    public static <REQ> REQ lock(Supplier<REQ> supplier, String orderNo, String business) {
        return InventoryConfig.lock(supplier, orderNo, business, 10);
    }

    public static <REQ> REQ lock(Supplier<REQ> supplier, String orderNo, String business, int waitTime) {
        Mutex lock = lockService.lock(business, orderNo, waitTime, waitTime * 2, TimeUnit.SECONDS);
        try {
            REQ REQ = supplier.get();
            return REQ;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            InventoryConfig.registerSynchronizationAfterCommit(() -> Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)lockService).unlock(arg_0)));
        }
    }

    public static <REQ> REQ lockList(Supplier<REQ> supplier, List<String> orderNoList, String business, int waitTime) {
        HashSet<String> set = new HashSet<String>(orderNoList);
        ArrayList mutexes = new ArrayList();
        try {
            set.forEach(orderNo -> mutexes.add(lockService.lock(business, orderNo, waitTime, waitTime * 2, TimeUnit.SECONDS)));
            REQ REQ = supplier.get();
            return REQ;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            InventoryConfig.registerSynchronizationAfterCompletion(() -> Optional.of(mutexes).filter(CollectionUtils::isNotEmpty).ifPresent(r -> r.forEach(arg_0 -> ((ILockService)lockService).unlock(arg_0))));
        }
    }

    public static void setCheckInventory(boolean checkInventory) {
        ServiceContext.getContext().setAttachment("checkInventory", (Boolean)ObjectUtil.defaultIfNull((Object)checkInventory, (Object)true) != false ? "1" : "0");
    }

    public static boolean isCheckInventory() {
        return ObjectUtil.equals((Object)ServiceContext.getContext().getAttachment("checkInventory"), (Object)"1");
    }

    static {
        commonSeparate = "__";
        defaultBatch = "A000";
        transferOrderReissue = false;
        canSmallOut = true;
        vaildItemExist = true;
        checkProduceTime = false;
        enableInspction = false;
        inventoryPrecision = 0;
        enableUnit = false;
        enableInOutAutoComplete = false;
        codeGenEnumMap = new HashMap<String, CodeGenEnum>(CodeGenEnum.values().length);
        codeGenBoMap = new HashMap<String, CodeGenBo>(CodeGenEnum.values().length);
        orderLineCallbackProcess = true;
        hasThirdClose = false;
    }
}

