/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.abstracts;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.proxy.query.ITransactionCustomerQueryApiProxy;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsOutNoticePushStatusEnum;
import com.yunxi.dg.base.center.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.InOutResultEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.inventory.constants.DocumentTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.LogisticsOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.WarehouseOrderLogisticsTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseOrderLogisticsDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.unit.OrderUnitConverterDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseOrderLogisticsEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.PushWmsAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderDocumentTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.InOutNoticeOrderCompleteEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.PushOrderWmsEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.helper.BaseOrderExtensionHelper;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.logistics.dto.entity.SendOrderDeliveryDetailDto;
import com.yunxi.dg.base.center.logistics.dto.entity.SendOrderDetailDto;
import com.yunxi.dg.base.center.logistics.proxy.send.ISendOrderApiProxy;
import com.yunxi.dg.base.center.message.OrderCancelQimenMessageReqDto;
import com.yunxi.dg.base.center.trade.proxy.order.IPerformOrderQueryApiProxy;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractInOutNoticeOrderAble
implements InOutNoticeOrderAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractInOutNoticeOrderAble.class);
    @Resource
    GenerateCodeUtil generateCodeUtil;
    @Resource
    public IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    public IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    public IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IWarehouseOrderLogisticsDomain iWarehouseOrderLogisticsDomain;
    @Resource
    private ISendOrderApiProxy dgSendOrderApiProxy;
    @Resource
    private IBaseOrderAddressDomain iBaseOrderAddressDomain;
    @Resource
    private IPerformOrderQueryApiProxy iPerformOrderQueryApiProxy;
    @Resource
    private ILogicWarehouseDomain iLogicWarehouseDomain;
    @Resource
    private ITransactionCustomerQueryApiProxy iTransactionCustomerQueryApiProxy;

    protected AbstractInOutNoticeOrderAble() {
    }

    @Override
    public void doGenerate(InOutNoticeOrderContext context) {
        log.info("\u751f\u6210\u5165\u51fa\u5e93\u901a\u77e5\u5355,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)context));
        InOutNoticeOrderEo inOutNoticeOrderEo = this.getInOutNoticeOrderEo(context);
        List<InOutNoticeOrderDetailEo> detailEoList = context.getOrderBasicsDetailReqDtoList().stream().map(d -> this.getInOutNoticeOrderDetailEo(context, inOutNoticeOrderEo, (BaseOrderDetailReqDto)((Object)d))).collect(Collectors.toList());
        WarehouseOrderLogisticsEo warehouseOrderLogisticsEo = this.getWarehouseOrderLogisticsEo(context);
        context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        context.setInOutNoticeOrderDetailEoList(detailEoList);
        this.wrapperGenerate(context);
        context.execBefore();
        if (ObjectUtil.isNotEmpty((Object)warehouseOrderLogisticsEo)) {
            this.iWarehouseOrderLogisticsDomain.insert((BaseEo)warehouseOrderLogisticsEo);
        }
        if (!context.isOnlyGenResult() || !context.getAutoComplete().booleanValue()) {
            this.inOutNoticeOrderDomain.insert((BaseEo)context.getInOutNoticeOrderEo());
            this.inOutNoticeOrderDetailDomain.insertBatch(context.getInOutNoticeOrderDetailEoList());
        }
        this.wrapperGenerateAfter(context);
        context.execAfter();
    }

    protected abstract void wrapperGenerate(InOutNoticeOrderContext var1);

    protected abstract void wrapperGenerateAfter(InOutNoticeOrderContext var1);

    @NotNull
    private WarehouseOrderLogisticsEo getWarehouseOrderLogisticsEo(InOutNoticeOrderContext context) {
        WarehouseOrderLogisticsEo warehouseOrderLogisticsEo = new WarehouseOrderLogisticsEo();
        warehouseOrderLogisticsEo.setOutNoticeOrderNo(context.getDocumentNo());
        warehouseOrderLogisticsEo.setBusinessOrderNo(context.getRelevanceNo());
        warehouseOrderLogisticsEo.setType(WarehouseOrderLogisticsTypeEnum.notice.getCode());
        warehouseOrderLogisticsEo.setShippingNo(context.getShipmentEnterpriseCode());
        warehouseOrderLogisticsEo.setShippingCompanyCode(context.getShipmentEnterpriseCode());
        warehouseOrderLogisticsEo.setShippingCompanyName(context.getShipmentEnterpriseName());
        return warehouseOrderLogisticsEo;
    }

    private InOutNoticeOrderDetailEo getInOutNoticeOrderDetailEo(InOutNoticeOrderContext context, InOutNoticeOrderEo inOutNoticeOrderEo, BaseOrderDetailReqDto d) {
        InOutNoticeOrderDetailEo detailEo = (InOutNoticeOrderDetailEo)BeanUtil.copyProperties((Object)((Object)d), InOutNoticeOrderDetailEo.class, (String[])new String[]{"id"});
        detailEo.setSkuCode(d.getSkuCode());
        detailEo.setSkuName(d.getSkuName());
        detailEo.setBatch(d.getBatch());
        detailEo.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
        detailEo.setPlanQuantity(d.getQuantity());
        detailEo.setCancelQuantity(BigDecimal.ZERO);
        if (context.getAutoComplete().booleanValue()) {
            detailEo.setWaitQuantity(BigDecimal.ZERO);
            detailEo.setDoneQuantity(d.getQuantity());
        } else {
            detailEo.setDoneQuantity(BigDecimal.ZERO);
            detailEo.setWaitQuantity(d.getQuantity());
        }
        detailEo.setExternalOrderNo(context.getExternalOrderNo());
        detailEo.setPreOrderNo(context.getPreOrderNo());
        detailEo.setRelevanceNo(context.getRelevanceNo());
        detailEo.setInitFlag(YesNoEnum.YES.getValue());
        detailEo.setPackType(d.getPackType());
        detailEo.setSkuDisplayName(d.getSkuDisplayName());
        BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)Optional.ofNullable(JSONObject.parseObject((String)d.getExtension(), BasicOrderDtoExtension.class)).orElse(new BasicOrderDtoExtension());
        basicOrderDtoExtension.setVolume(d.getVolume());
        basicOrderDtoExtension.setWeight(d.getWeight());
        basicOrderDtoExtension.setSkuDisplayName(d.getSkuDisplayName());
        detailEo.setExtension(JSONObject.toJSONString((Object)basicOrderDtoExtension));
        detailEo.setPreOrderItemId(d.getPreOrderItemId());
        detailEo.setItemStatus(StringUtils.isNotBlank((CharSequence)d.getItemStatus()) ? d.getItemStatus() : CsPlannedOrderItemStatusEnum.COMMON.getCode());
        return detailEo;
    }

    private InOutNoticeOrderEo getInOutNoticeOrderEo(InOutNoticeOrderContext context) {
        InOutNoticeOrderEo inOutNoticeOrderEo = Optional.ofNullable(context.getInOutNoticeOrderEo()).orElse(new InOutNoticeOrderEo());
        inOutNoticeOrderEo.setId(null);
        context.setDocumentNo(this.getDocumentNo(context));
        BeanUtil.copyProperties((Object)context, (Object)inOutNoticeOrderEo, (CopyOptions)CopyOptions.create().ignoreNullValue().setIgnoreProperties(new String[]{"shipmentEnterpriseCode", "shipmentEnterpriseName"}));
        inOutNoticeOrderEo.setRelevanceTableName(context.getRelevanceTableName().getCode());
        inOutNoticeOrderEo.setPreOrderNo(context.getPreOrderNo());
        inOutNoticeOrderEo.setDocumentType(BaseOrderDocumentTypeEnum.COMMON.getCode());
        inOutNoticeOrderEo.setRelevanceNo(context.getRelevanceNo());
        inOutNoticeOrderEo.setExternalOrderNo(context.getExternalOrderNo());
        inOutNoticeOrderEo.setBusinessType(context.getBusinessType());
        inOutNoticeOrderEo.setOrderStatus(context.getOrderStatus().getCode());
        inOutNoticeOrderEo.setOrderType(context.getOperateTypeEnum().getCode().toLowerCase());
        inOutNoticeOrderEo.setTotalQuantity(context.getTotalQuantity() == null ? BigDecimal.ZERO : context.getTotalQuantity());
        inOutNoticeOrderEo.setRemark(context.getRemark());
        inOutNoticeOrderEo.setExtension(context.getExtension());
        inOutNoticeOrderEo.setNoBatch(context.getNoBatch());
        inOutNoticeOrderEo.setPushStatus(CsOutNoticePushStatusEnum.WITHOUT_PUSH.getCode());
        inOutNoticeOrderEo.setOffsetType(context.getOffsetType());
        BaseOrderExtensionHelper.settingExtensionByContext(context, inOutNoticeOrderEo);
        if (StringUtils.isNotBlank((CharSequence)context.getShipmentEnterpriseCode())) {
            inOutNoticeOrderEo.setShipmentEnterpriseCode(context.getShipmentEnterpriseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)context.getShipmentEnterpriseName())) {
            inOutNoticeOrderEo.setShipmentEnterpriseName(context.getShipmentEnterpriseName());
        }
        if (BaseOrderOperateTypeEnum.OUT.equals((Object)context.getOperateTypeEnum())) {
            inOutNoticeOrderEo.setLogisticsOrderStatus(LogisticsOrderStatusEnum.WAIT_RETRIEVAL_NUMBER.getCode());
        }
        if (CollectionUtils.isNotEmpty(context.getShippingInfoReqDtoList())) {
            Optional.ofNullable(context.getShippingInfoReqDtoList()).filter(CollectionUtils::isNotEmpty).ifPresent(shippingInfoReqDtoList -> {
                CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
                inOutNoticeOrderEo.setShippingCode(csWmsShippingInfoReqDto.getShippingNo());
                if (StringUtils.isBlank((CharSequence)inOutNoticeOrderEo.getShipmentEnterpriseCode())) {
                    inOutNoticeOrderEo.setShipmentEnterpriseCode(csWmsShippingInfoReqDto.getShipmentEnterpriseCode());
                }
                if (StringUtils.isBlank((CharSequence)inOutNoticeOrderEo.getShipmentEnterpriseName())) {
                    inOutNoticeOrderEo.setShipmentEnterpriseName(csWmsShippingInfoReqDto.getShipmentEnterpriseName());
                }
                inOutNoticeOrderEo.setShippingType(csWmsShippingInfoReqDto.getShippingType());
                inOutNoticeOrderEo.setShippingCompany(csWmsShippingInfoReqDto.getShippingCompanyCode());
                inOutNoticeOrderEo.setShippingCompanyName(csWmsShippingInfoReqDto.getShippingCompanyName());
                inOutNoticeOrderEo.setShippingJson(JSON.toJSONString((Object)shippingInfoReqDtoList));
            });
        }
        Optional.ofNullable(context.getExtension()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(o -> {
            JSONObject jsonObject = JSONObject.parseObject((String)o);
            inOutNoticeOrderEo.setPayAmount(jsonObject.getBigDecimal("payAmount"));
        });
        log.info("context\u7684\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606finitInOutNoticeOrderEo\uff1a{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderEo));
        return inOutNoticeOrderEo;
    }

    protected String getDocumentNo(InOutNoticeOrderContext context) {
        if (BaseOrderOperateTypeEnum.OUT.equals((Object)context.getOperateTypeEnum())) {
            return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.OUT_NOTICE_ORDER.getCode()));
        }
        if (BaseOrderOperateTypeEnum.IN_OUT.equals((Object)context.getOperateTypeEnum())) {
            return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.ADJUST_NOTICE_ORDER.getCode()));
        }
        return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.IN_NOTICE_ORDER.getCode()));
    }

    @Override
    public void doClose(InOutNoticeOrderContext context) {
        if (InventoryConfig.isHasThirdClose()) {
            this.closeWms(context);
        } else {
            this.cancelWms(context);
        }
    }

    @Override
    public void doCancel(InOutNoticeOrderContext context) {
        this.cancelWms(context);
    }

    private void cancelWms(InOutNoticeOrderContext context) {
        log.info("\u53d6\u6d88wms\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)context));
        InOutNoticeOrderEo inOutNoticeOrderEo = context.getInOutNoticeOrderEo();
        boolean pushStatus = "success".equals(inOutNoticeOrderEo.getPushStatus());
        if (pushStatus && context.isCancelWms() && InventoryConfig.getPushWms().canPushWms(PushWmsAble.CanPushWmsBo.builder().businessType(context.getInOutNoticeOrderEo().getDisplayBusinessType()).orderType(context.getInOutNoticeOrderEo().getJumpDocumentType()).inOut(context.getOperateTypeEnum().getCode()).logicWarehouseCode(context.getLogicWarehouseCode()).relevanceNo(context.getRelevanceNo()).build())) {
            OrderCancelQimenMessageReqDto reqDto = new OrderCancelQimenMessageReqDto();
            reqDto.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
            reqDto.setOrderType(inOutNoticeOrderEo.getOrderType());
            reqDto.setWarehouseCode(context.getLogicWarehouseCode());
            log.info("\u63a8\u9001\u53d6\u6d88\u903b\u8f91");
            AssertUtil.isTrue((boolean)InventoryConfig.getPushWms().sendOrderCancel(reqDto), (String)"\u53d6\u6d88wms\u5931\u8d25");
        } else {
            log.info("\u6821\u9a8c\u65e0\u9700\u63a8\u9001\u53d6\u6d88");
        }
    }

    private void closeWms(InOutNoticeOrderContext context) {
        log.info("\u5173\u95edwms\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)context));
        InOutNoticeOrderEo inOutNoticeOrderEo = context.getInOutNoticeOrderEo();
        if (StringUtils.equals((CharSequence)TransferOrderTypeEnum.CLOUD_WAREHOUSE_B_C.getCode(), (CharSequence)inOutNoticeOrderEo.getDisplayBusinessType())) {
            log.info("\u4e91\u4ed3BC\u8c03\u62e8\u4e0d\u7528\u63a8wms\u5173\u95ed");
            return;
        }
        boolean pushStatus = "success".equals(inOutNoticeOrderEo.getPushStatus());
        if (pushStatus && context.isCancelWms() && InventoryConfig.getPushWms().canPushWms(PushWmsAble.CanPushWmsBo.builder().businessType(context.getInOutNoticeOrderEo().getDisplayBusinessType()).orderType(context.getInOutNoticeOrderEo().getJumpDocumentType()).relevanceTableNameEnum(context.getRelevanceTableName()).logicWarehouseCode(context.getLogicWarehouseCode()).inOut(context.getOperateTypeEnum().getCode()).relevanceNo(context.getRelevanceNo()).build())) {
            OrderCancelQimenMessageReqDto reqDto = new OrderCancelQimenMessageReqDto();
            reqDto.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
            reqDto.setOrderType(inOutNoticeOrderEo.getOrderType());
            reqDto.setWarehouseCode(context.getLogicWarehouseCode());
            log.info("\u63a8\u9001\u5173\u95ed\u903b\u8f91");
            AssertUtil.isTrue((boolean)InventoryConfig.getPushWms().sendOrderClose(reqDto), (String)"\u5173\u95edwms\u5931\u8d25");
        } else {
            log.info("\u6821\u9a8c\u65e0\u9700\u5173\u95ed\u53d6\u6d88");
        }
    }

    @Override
    public void pushWms(InOutNoticeOrderContext inOutNoticeOrderContext) {
        log.info("\u63a8\u9001wms:{},:{}", (Object)inOutNoticeOrderContext.getDocumentNo(), (Object)JSONObject.toJSONString((Object)inOutNoticeOrderContext));
        if (!inOutNoticeOrderContext.isPushWmsEvent() || !TransactionSynchronizationManager.isActualTransactionActive()) {
            if (Objects.isNull(inOutNoticeOrderContext.getInOutNoticeOrderEo())) {
                return;
            }
            boolean b = InventoryConfig.getPushWmsAble().pushWms(inOutNoticeOrderContext);
            InOutNoticeOrderEo inOutNoticeOrderEo = this.getInOutNoticeOrderEo(inOutNoticeOrderContext, b);
            this.inOutNoticeOrderDomain.updateSelective((BaseEo)inOutNoticeOrderEo);
        } else {
            PushOrderWmsEvent pushOrderWmsEvent = new PushOrderWmsEvent(inOutNoticeOrderContext);
            InventoryConfig.pushEvent(pushOrderWmsEvent);
        }
    }

    @NotNull
    private InOutNoticeOrderEo getInOutNoticeOrderEo(InOutNoticeOrderContext inOutNoticeOrderContext, boolean b) {
        InOutNoticeOrderEo inOutNoticeOrderEo = new InOutNoticeOrderEo();
        inOutNoticeOrderEo.setId(inOutNoticeOrderContext.getInOutNoticeOrderEo().getId());
        inOutNoticeOrderEo.setDocumentNo(inOutNoticeOrderContext.getDocumentNo());
        if (inOutNoticeOrderContext.isAsynchronousWms()) {
            inOutNoticeOrderEo.setPushStatus(b ? CsOutNoticePushStatusEnum.PUSHING.getCode() : CsOutNoticePushStatusEnum.FAIL.getCode());
        } else {
            inOutNoticeOrderEo.setPushStatus(b ? CsOutNoticePushStatusEnum.SUCCESS.getCode() : CsOutNoticePushStatusEnum.FAIL.getCode());
        }
        return inOutNoticeOrderEo;
    }

    @Override
    public void validRepeat(InOutNoticeOrderContext context) {
        ArrayList focusStatusList;
        String logicWarehouseCode;
        String orderType;
        switch (context.getOperateTypeEnum()) {
            case IN: {
                orderType = "in";
                logicWarehouseCode = context.getLogicWarehouseCode();
                focusStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode()});
                if (!context.getMultipleOut().booleanValue()) break;
                return;
            }
            case OUT: {
                orderType = "out";
                logicWarehouseCode = context.getLogicWarehouseCode();
                focusStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_PORTION_OUT.getCode(), BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode()});
                break;
            }
            default: {
                return;
            }
        }
        if (DocumentTypeEnum.TRANSFER_ORDER.getCode().equals(context.getJumpDocumentType())) {
            return;
        }
        AssertUtil.isTrue((((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"order_type", (Object)orderType)).eq((Object)"in_logic_warehouse_code", (Object)logicWarehouseCode)).eq((Object)"relevance_no", (Object)context.getRelevanceNo())).in((Object)"order_status", (Collection)focusStatusList)).count() == 0 ? 1 : 0) != 0, (String)"204", (String)(context.getRelevanceNo() + "\u5355\u636e\u5df2\u751f\u6210\u51fa/\u5165\u5e93\u901a\u77e5\u5355\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c"));
    }

    @Override
    public boolean validCancel(InOutNoticeOrderContext context) {
        this.validHas(context);
        return true;
    }

    @Override
    public boolean validClose(InOutNoticeOrderContext context) {
        this.validHas(context);
        if (BaseOrderStatusEnum.FINISH_OVER.getCode().equals(context.getInOutNoticeOrderEo().getOrderStatus())) {
            log.error("\u5df2\u5b8c\u7ed3\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u5b8c\u7ed3:{}", (Object)context.getDocumentNo());
            return false;
        }
        return true;
    }

    private void validHas(InOutNoticeOrderContext context) {
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)context.getDocumentNo())).last(" limit 1")).one();
        AssertUtil.isTrue((null != inOutNoticeOrderEo ? 1 : 0) != 0, (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        context.setRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        context.setPreOrderNo(inOutNoticeOrderEo.getPreOrderNo());
        context.setExternalOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
        context.setBusinessType(inOutNoticeOrderEo.getBusinessType());
        if ("in".equals(inOutNoticeOrderEo.getOrderType())) {
            context.setLogicWarehouseCode(inOutNoticeOrderEo.getInLogicWarehouseCode());
        } else {
            context.setLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        }
        context.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutNoticeOrderEo.getRelevanceTableName()));
    }

    @Override
    public void complete(InOutNoticeOrderContext inOutNoticeOrderContext) {
        Map<Object, BigDecimal> orderDetailReqDtoMap;
        log.info("\u5b8c\u6210\u66f4\u65b0\u5165\u51fa\u5e93\u901a\u77e5\u5355\u72b6\u6001\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderContext));
        Optional inOutNoticeOrderEoOpt = ((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderContext.getDocumentNo())).oneOpt();
        AssertUtils.isTrue((boolean)inOutNoticeOrderEoOpt.isPresent(), (String)"\u8c03\u7528\u5b8c\u6210\u5355\u636e\u4e0d\u5b58\u5728");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoOpt.get();
        List detailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderContext.getDocumentNo())).list();
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)inOutNoticeOrderContext.getRelevanceTableName()) && "in".equals(inOutNoticeOrderEo.getOrderType()) && !InventoryConfig.isDispatchOrderBatch()) {
            log.info("\u8c03\u62e8\u5355\u5165\u5e93\uff0c\u6536\u53d1\u5dee\u5f02\u4e0d\u6821\u9a8c\u6279\u6b21\u6839\u636eskuCode\u6c47\u603b\u6570\u91cf");
            orderDetailReqDtoMap = inOutNoticeOrderContext.getOrderBasicsDetailReqDtoList().stream().filter(r -> Objects.nonNull(r.getSkuCode())).collect(Collectors.groupingBy(BaseOrderDetailReqDto::getSkuCode, Collectors.mapping(OrderUnitConverterDto::getQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            detailEoList.forEach(detailEo -> Optional.ofNullable(orderDetailReqDtoMap.get(detailEo.getSkuCode())).ifPresent(q -> {
                BigDecimal surplusTotalQuantity = BigDecimalUtils.subtract((BigDecimal)q, (BigDecimal)detailEo.getWaitQuantity());
                BigDecimal quantity = BigDecimalUtils.gtZero((BigDecimal)surplusTotalQuantity) != false ? detailEo.getWaitQuantity() : q;
                detailEo.setDoneQuantity(BigDecimalUtils.add((BigDecimal)detailEo.getDoneQuantity(), (BigDecimal)quantity));
                detailEo.setWaitQuantity(DataExtractUtils.ifLtZeroSetZero((BigDecimal)detailEo.getWaitQuantity().subtract(quantity)));
                orderDetailReqDtoMap.put(detailEo.getSkuCode(), surplusTotalQuantity);
            }));
        } else {
            orderDetailReqDtoMap = inOutNoticeOrderContext.getOrderBasicsDetailReqDtoList().stream().filter(r -> Objects.nonNull(r.getLineNo())).collect(Collectors.groupingBy(BaseOrderDetailReqDto::getLineNo, Collectors.mapping(OrderUnitConverterDto::getQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            detailEoList.forEach(detailEo -> Optional.ofNullable(orderDetailReqDtoMap.get(detailEo.getLineNo())).ifPresent(q -> {
                detailEo.setDoneQuantity(BigDecimalUtils.add((BigDecimal)detailEo.getDoneQuantity(), (BigDecimal)q));
                detailEo.setWaitQuantity(DataExtractUtils.ifLtZeroSetZero((BigDecimal)detailEo.getWaitQuantity().subtract((BigDecimal)q)));
            }));
        }
        AtomicBoolean existBatch = new AtomicBoolean(false);
        detailEoList.forEach(detailEo -> existBatch.set(StringUtils.isNotBlank((CharSequence)detailEo.getBatch())));
        if (!inOutNoticeOrderContext.isNoticeEnd() && this.checkEnd(inOutNoticeOrderContext, detailEoList)) {
            inOutNoticeOrderContext.setNoticeEnd(true);
        }
        if (inOutNoticeOrderContext.isNoticeEndStatus() && this.checkEnd(inOutNoticeOrderContext, detailEoList)) {
            inOutNoticeOrderContext.setNoticeEndStatus(false);
        }
        inOutNoticeOrderEo.setOrderStatus(this.getCompleteStatus(inOutNoticeOrderContext));
        inOutNoticeOrderEo.setInOutResult(InOutResultEnum.NORMAL.getCode());
        inOutNoticeOrderEo.setDeliveryEnterTime(new Date());
        Optional.ofNullable(inOutNoticeOrderContext.getShippingInfoReqDtoList()).filter(CollectionUtils::isNotEmpty).ifPresent(shippingInfoReqDtoList -> {
            CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
            inOutNoticeOrderEo.setShipmentEnterpriseCode(csWmsShippingInfoReqDto.getShipmentEnterpriseCode());
            inOutNoticeOrderEo.setShipmentEnterpriseName(csWmsShippingInfoReqDto.getShipmentEnterpriseName());
            if (StringUtils.isBlank((CharSequence)inOutNoticeOrderEo.getShippingCode())) {
                inOutNoticeOrderEo.setShippingCode(csWmsShippingInfoReqDto.getShippingNo());
            }
        });
        this.inOutNoticeOrderDomain.getMapper().updateById((BaseEo)inOutNoticeOrderEo);
        this.inOutNoticeOrderDetailDomain.getMapper().updateBatchByIds(detailEoList);
        inOutNoticeOrderContext.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        inOutNoticeOrderContext.setInOutNoticeOrderDetailEoList(detailEoList);
        if (inOutNoticeOrderContext.isNoticeEnd()) {
            InventoryConfig.pushEvent(new InOutNoticeOrderCompleteEvent(inOutNoticeOrderContext));
        }
    }

    private List<InOutNoticeOrderDetailEo> getInNoticeOrderDetailEos(InOutNoticeOrderEo inOutNoticeOrderEo) {
        log.info("\u5165\u5e93\u901a\u77e5\u5355\u4e0d\u5b58\u5728\u6279\u6b21\u4e14\u975e\u8c03\u62e8\u5355\u7c7b\u578b\u66f4\u65b0\u4e3a\u5b8c\u6210/\u5df2\u5b8c\u7ed3\u72b6\u6001\uff0c\u6839\u636e\u7ed3\u679c\u5355\u751f\u6210\u901a\u77e5\u5355\u6279\u6b21\u660e\u7ec6\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderEo));
        Map<String, InOutResultOrderDetailEo> map = this.getInOutResultOrderDetailMap(inOutNoticeOrderEo);
        List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEos = map.values().stream().map(e -> {
            InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo = new InOutNoticeOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)inOutNoticeOrderDetailEo, (Object)e, (String[])new String[0]);
            inOutNoticeOrderDetailEo.setPreOrderNo(inOutNoticeOrderEo.getPreOrderNo());
            inOutNoticeOrderDetailEo.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
            inOutNoticeOrderDetailEo.setCreateTime(inOutNoticeOrderEo.getCreateTime());
            inOutNoticeOrderDetailEo.setCreatePerson(inOutNoticeOrderEo.getCreatePerson());
            return inOutNoticeOrderDetailEo;
        }).collect(Collectors.toList());
        if (BaseOrderStatusEnum.INO_TOTAL_IN.getCode().equals(inOutNoticeOrderEo.getOrderStatus())) {
            QueryWrapper inOutNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
            inOutNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo());
            this.inOutNoticeOrderDetailDomain.getMapper().delete((Wrapper)inOutNoticeOrderDetailEoQueryWrapper);
        }
        this.inOutNoticeOrderDetailDomain.insertBatch(inOutNoticeOrderDetailEos);
        return inOutNoticeOrderDetailEos;
    }

    @NotNull
    private Map<String, InOutResultOrderDetailEo> getInOutResultOrderDetailMap(InOutNoticeOrderEo inOutNoticeOrderEo) {
        QueryWrapper inOutResultOrderDetailEoQueryWrapper = new QueryWrapper();
        inOutResultOrderDetailEoQueryWrapper.eq((Object)"pre_order_no", (Object)inOutNoticeOrderEo.getDocumentNo());
        inOutResultOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)0);
        List inOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)inOutResultOrderDetailEoQueryWrapper);
        log.info(String.format("\u6839\u636e\u5165\u5e93\u901a\u77e5\u5355\u53f7\uff1a%s \u67e5\u8be2\u5230\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f\uff1a%s", inOutNoticeOrderEo.getDocumentNo(), JSON.toJSONString((Object)inOutResultOrderDetailEos)));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutResultOrderDetailEos), (String)(inOutNoticeOrderEo.getDocumentNo() + "\u5bf9\u5e94\u7684\u7ed3\u679c\u5355\u660e\u7ec6\u4e0d\u5b58\u5728"));
        HashMap<String, InOutResultOrderDetailEo> map = new HashMap<String, InOutResultOrderDetailEo>(inOutResultOrderDetailEos.size());
        for (InOutResultOrderDetailEo detailEo : inOutResultOrderDetailEos) {
            String key = detailEo.getSkuCode() + " " + detailEo.getBatch();
            InOutResultOrderDetailEo inOutResultOrderDetailEo = (InOutResultOrderDetailEo)map.get(key);
            if (Objects.nonNull(inOutResultOrderDetailEo)) {
                detailEo.setDoneQuantity(detailEo.getDoneQuantity().add(inOutResultOrderDetailEo.getDoneQuantity()));
                detailEo.setWaitQuantity(detailEo.getWaitQuantity().add(inOutResultOrderDetailEo.getWaitQuantity()));
                detailEo.setQuantity(detailEo.getQuantity().add(inOutResultOrderDetailEo.getQuantity()));
                detailEo.setPlanQuantity(detailEo.getPlanQuantity().add(inOutResultOrderDetailEo.getPlanQuantity()));
                detailEo.setCancelQuantity(detailEo.getCancelQuantity().add(inOutResultOrderDetailEo.getCancelQuantity()));
            }
            map.put(key, detailEo);
        }
        log.info("\u6839\u636eskuCode\u3001\u6279\u6b21\u6c47\u603b\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(map));
        return map;
    }

    protected abstract String getCompleteStatus(InOutNoticeOrderContext var1);

    @Override
    public void doSubmit(InOutNoticeOrderContext context) {
        log.info("doSubmit\uff1a{}", (Object)JSON.toJSONString((Object)context));
        String documentNo = context.getInOutNoticeOrderEo().getDocumentNo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"document_no", (Object)documentNo);
        queryWrapper.eq((Object)"dr", (Object)0);
        List eoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
        log.info("eoList:{}", (Object)JSON.toJSONString((Object)eoList));
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)eoList), (String)"\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u5165\u51fa\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)eoList.get(0);
        AssertUtil.isFalse((CsOutNoticePushStatusEnum.SUCCESS.getCode().equals(inOutNoticeOrderEo.getPushStatus()) || CsOutNoticePushStatusEnum.WITHOUT_PUSH.getCode().equals(inOutNoticeOrderEo.getPushStatus()) ? 1 : 0) != 0, (String)String.format("\u5355\u53f7\uff1a%s \u63a8\u9001\u6210\u529f\u548c\u65e0\u9700\u63a8\u9001\u4e0d\u7528\u63a8\u9001\u5230wms", documentNo));
        AssertUtil.isFalse((!BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) && !BaseOrderStatusEnum.INO_WAIT_IN.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) && !BaseOrderStatusEnum.ONO_WAIT_OUT.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) && !BaseOrderStatusEnum.PROCESSING.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) && !BaseOrderStatusEnum.PORTION_PROCESSING.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)String.format("\u5355\u53f7\uff1a%s \u975e\u5f85\u63d0\u4ea4\u6216%s\u72b6\u6001\u4e0d\u80fd\u63a8\u9001\u5230wms", documentNo, "in".equals(inOutNoticeOrderEo.getOrderType()) ? "\u5f85\u5165\u5e93" : "\u5f85\u51fa\u5e93"));
        if (Arrays.asList("in", "in_out").contains(inOutNoticeOrderEo.getOrderType())) {
            return;
        }
        if (!Objects.equals(BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode(), inOutNoticeOrderEo.getOrderStatus())) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"id", new Object[]{inOutNoticeOrderEo.getId()});
        updateWrapper.eq((Object)"dr", (Object)0);
        InOutNoticeOrderEo noticeOrderEo = new InOutNoticeOrderEo();
        noticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_OUT.getCode());
        this.inOutNoticeOrderDomain.getMapper().update((Object)noticeOrderEo, (Wrapper)updateWrapper);
    }

    public void updateStatus(InOutNoticeOrderEo inOutNoticeOrderEo, BaseOrderStatusEnum status) {
        InOutNoticeOrderEo updateEo = new InOutNoticeOrderEo();
        updateEo.setId(inOutNoticeOrderEo.getId());
        updateEo.setOrderStatus(status.getCode());
        this.inOutNoticeOrderDomain.getMapper().updateById((BaseEo)updateEo);
    }

    public void updateDetailQuantity(InOutNoticeOrderContext context) {
        List outNoticeOrderDetailEoList = Optional.ofNullable(context.getInOutNoticeOrderDetailEoList()).filter(CollectionUtils::isNotEmpty).orElseGet(() -> ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)context.getDocumentNo())).list());
        context.setInOutNoticeOrderDetailEoList(outNoticeOrderDetailEoList);
        for (InOutNoticeOrderDetailEo outNoticeOrderDetailEo : outNoticeOrderDetailEoList) {
            outNoticeOrderDetailEo.setCancelQuantity(outNoticeOrderDetailEo.getWaitQuantity());
            outNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
        }
        outNoticeOrderDetailEoList.forEach(out -> {
            InOutNoticeOrderDetailEo outUpdate = new InOutNoticeOrderDetailEo();
            outUpdate.setId(out.getId());
            outUpdate.setCancelQuantity(out.getCancelQuantity());
            outUpdate.setWaitQuantity(out.getWaitQuantity());
            this.inOutNoticeOrderDetailDomain.updateSelective((BaseEo)outUpdate);
        });
    }

    public boolean checkEnd(InOutNoticeOrderContext inOutNoticeOrderContext, List<InOutNoticeOrderDetailEo> detailEoList) {
        return detailEoList.stream().noneMatch(r -> BigDecimalUtils.gtZero((BigDecimal)r.getWaitQuantity())) || inOutNoticeOrderContext.isNoticeEndModule() && detailEoList.stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode, Collectors.mapping(r -> BigDecimalUtils.subtract((BigDecimal)r.getPlanQuantity(), (BigDecimal)r.getDoneQuantity()), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))).values().stream().allMatch(BigDecimalUtils::eqZero);
    }

    @Override
    public void pushLogistics(InOutNoticeOrderContext context) {
        SendOrderDetailDto sendOrderDetailDto = this.getSendOrderDetailDto(context);
        ArrayList sendOrderDeliveryDetailDtoList = Lists.newArrayList();
        List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEoList = context.getInOutNoticeOrderDetailEoList();
        if (CollectionUtils.isNotEmpty(inOutNoticeOrderDetailEoList)) {
            for (InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo : inOutNoticeOrderDetailEoList) {
                SendOrderDeliveryDetailDto sendOrderDeliveryDetailDto = new SendOrderDeliveryDetailDto();
                BeanUtil.copyProperties((Object)inOutNoticeOrderDetailEo, (Object)sendOrderDeliveryDetailDto, (String[])new String[0]);
                sendOrderDeliveryDetailDtoList.add(sendOrderDeliveryDetailDto);
            }
        }
        List<BaseOrderDetailReqDto> orderBasicsDetailReqDtoList = context.getOrderBasicsDetailReqDtoList();
        BigDecimal weight = new BigDecimal("0");
        BigDecimal volume = new BigDecimal("0");
        if (CollectionUtils.isNotEmpty(orderBasicsDetailReqDtoList)) {
            for (BaseOrderDetailReqDto baseOrderDetailReqDto : orderBasicsDetailReqDtoList) {
                weight = weight.add(Optional.ofNullable(baseOrderDetailReqDto.getWeight()).orElse(new BigDecimal("0")));
                volume = volume.add(Optional.ofNullable(baseOrderDetailReqDto.getVolume()).orElse(new BigDecimal("0")));
            }
        }
        sendOrderDetailDto.setTotalVolume(volume);
        sendOrderDetailDto.setTotalWeight(weight);
        sendOrderDetailDto.setSendOrderDeliveryDetailDtoList((List)sendOrderDeliveryDetailDtoList);
        log.info("sendOrderDetailDto:{}", (Object)JSON.toJSONString((Object)sendOrderDetailDto));
        this.dgSendOrderApiProxy.autoSave(sendOrderDetailDto);
    }

    @NotNull
    private SendOrderDetailDto getSendOrderDetailDto(InOutNoticeOrderContext context) {
        SendOrderDetailDto sendOrderDetailDto = new SendOrderDetailDto();
        BeanUtil.copyProperties((Object)context.getInOutNoticeOrderEo(), (Object)sendOrderDetailDto, (String[])new String[0]);
        InOutNoticeOrderEo inOutNoticeOrderEo = context.getInOutNoticeOrderEo();
        sendOrderDetailDto.setOrderType(inOutNoticeOrderEo.getOrderType());
        sendOrderDetailDto.setBusinessNo(inOutNoticeOrderEo.getRelevanceNo());
        sendOrderDetailDto.setBusinessType(inOutNoticeOrderEo.getDisplayBusinessType());
        sendOrderDetailDto.setDeliveryPhysicsWarehouseCode(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
        sendOrderDetailDto.setDeliveryPhysicsWarehouseName(inOutNoticeOrderEo.getOutPhysicsWarehouseName());
        sendOrderDetailDto.setDeliveryLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        sendOrderDetailDto.setDeliveryLogicWarehouseName(inOutNoticeOrderEo.getOutLogicWarehouseName());
        sendOrderDetailDto.setExternalOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
        sendOrderDetailDto.setShippingCompany(inOutNoticeOrderEo.getShipmentEnterpriseCode());
        sendOrderDetailDto.setShippingCompanyName(inOutNoticeOrderEo.getShipmentEnterpriseName());
        sendOrderDetailDto.setRemark(inOutNoticeOrderEo.getRemark());
        sendOrderDetailDto.setNoticeStatus(inOutNoticeOrderEo.getOrderStatus());
        sendOrderDetailDto.setJumpDocumentType(inOutNoticeOrderEo.getJumpDocumentType());
        ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iBaseOrderAddressDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).eq((Object)"contacts_type", (Object)"consignee")).last(" limit 1 ")).oneOpt().ifPresent(baseOrderAddressEo -> {
            sendOrderDetailDto.setHarvestAddress(baseOrderAddressEo.getDetailAddress());
            sendOrderDetailDto.setCityCode(baseOrderAddressEo.getCityCode());
            sendOrderDetailDto.setCity(baseOrderAddressEo.getCity());
            sendOrderDetailDto.setProvinceCode(baseOrderAddressEo.getProvinceCode());
            sendOrderDetailDto.setProvince(baseOrderAddressEo.getProvince());
            sendOrderDetailDto.setCountyCode(baseOrderAddressEo.getDistrictCode());
            sendOrderDetailDto.setCounty(baseOrderAddressEo.getDistrict());
            sendOrderDetailDto.setHarvest(baseOrderAddressEo.getContacts());
            sendOrderDetailDto.setHarvestPhone(baseOrderAddressEo.getPhone());
            sendOrderDetailDto.setCustomerCode(baseOrderAddressEo.getCustomerCode());
            try {
                if (StringUtils.isNotBlank((CharSequence)baseOrderAddressEo.getCustomerCode())) {
                    Optional.ofNullable(this.iTransactionCustomerQueryApiProxy.queryByCode(sendOrderDetailDto.getCustomerCode()).getData()).ifPresent(o -> sendOrderDetailDto.setCustomerAbbreviation(o.getName()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5ba2\u5546\u63a5\u53e3\u62a5\u9519{}", (Object)e.getMessage(), (Object)e);
            }
            sendOrderDetailDto.setCustomerName(baseOrderAddressEo.getCustomerName());
        });
        ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iLogicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inOutNoticeOrderEo.getOutLogicWarehouseCode())).last(" limit 1 ")).oneOpt().ifPresent(warehouse -> {
            sendOrderDetailDto.setOrganizationCode(warehouse.getOrganizationCode());
            sendOrderDetailDto.setOrganizationName(warehouse.getOrganizationName());
        });
        return sendOrderDetailDto;
    }

    @Override
    public boolean filterWms(InOutNoticeOrderContext context) {
        if (context.getRelevanceTableName().equals((Object)CsRelevanceTableNameEnum.CS_TRANSFER_ORDER)) {
            return LogicWarehouseQualityEnum.QUALIFIED.getCode().equals(context.getInOutNoticeOrderEo().getInventoryProperty());
        }
        return true;
    }

    @Override
    public void pushShare(InOutNoticeOrderContext context) {
        InventoryConfig.getPushShareDispatchAble().push(context);
    }
}

