/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.facade.helper.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.enums.AssemblyDisassemblyOrderBizTypeEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.unit.OrderUnitConverterDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.ReceiveDeliveryResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderInHangUpEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutBackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutHangUpEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderWaitConfirmEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.InOutNoticeOrderCompleteEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.AssembleDisassembleOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.helper.AbstractBaseOrderFacadeHelper;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.helper.IInOutBackBaseOrderFacadeHelper;
import com.yunxi.dg.base.center.inventory.service.baseorder.helper.BaseOrderExtensionHelper;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.AdjustNoticeOrderAbleImpl;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.AdjustResultOrderAbleImpl;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.AssemblyDisassemblyResultOrderAbleImpl;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.MergeOutResultOrderAbleImpl;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InOutBackBaseOrderFacadeHelper
extends AbstractBaseOrderFacadeHelper
implements IInOutBackBaseOrderFacadeHelper {
    private static final Logger log = LoggerFactory.getLogger(InOutBackBaseOrderFacadeHelper.class);
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private InOutResultOrderAble outResultOrderAbleImpl;
    @Resource
    private ReceiveDeliveryResultOrderAble deliveryResultOrderAbleImpl;
    @Resource
    private InOutNoticeOrderAble outNoticeOrderAbleImpl;
    @Resource
    private InOutNoticeOrderAble inNoticeOrderAbleImpl;
    @Resource
    private AdjustNoticeOrderAbleImpl adjustNoticeOrderAble;
    @Resource
    private InOutResultOrderAble inResultOrderAbleImpl;
    @Resource
    private ReceiveDeliveryResultOrderAble receiveResultOrderAbleImpl;
    @Resource
    private AdjustResultOrderAbleImpl adjustResultOrderAble;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    protected AssemblyDisassemblyResultOrderAbleImpl assemblyDisassemblyResultOrderAble;
    @Resource
    private MergeOutResultOrderAbleImpl mergeOutResultOrderAble;

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public InOutResultOrderContext outResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        InOutResultOrderContext context = this.getInOutResultOrderContext(facadeBo);
        InOutNoticeOrderEo inOutNoticeOrderEo = facadeBo.getInOutNoticeOrderEo();
        AssertUtil.isTrue((!CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName()) || StringUtils.isNotBlank((CharSequence)facadeBo.getTransferInLogicWarehouseCode()) ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u521b\u5efa\u51fa\u5e93\u5355\u5fc5\u987b\u8bbe\u7f6e\u5165\u5e93\u51fa\u5e93");
        context.setLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        context.setLogicWarehouseName(inOutNoticeOrderEo.getOutLogicWarehouseName());
        context.setPhysicsWarehouseCode(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(inOutNoticeOrderEo.getOutPhysicsWarehouseName());
        this.assignWarehouseResultOrder(facadeBo, context);
        if (CollectionUtils.isNotEmpty(context.getShippingInfoReqDtoList())) {
            for (CsWmsShippingInfoReqDto csWmsShippingInfoReqDto : context.getShippingInfoReqDtoList()) {
                if (StringUtils.isBlank((CharSequence)csWmsShippingInfoReqDto.getShippingType())) {
                    csWmsShippingInfoReqDto.setShippingType(inOutNoticeOrderEo.getShippingType());
                }
                if (!StringUtils.isBlank((CharSequence)csWmsShippingInfoReqDto.getShippingCompanyCode())) continue;
                csWmsShippingInfoReqDto.setShippingCompanyCode(inOutNoticeOrderEo.getShipmentEnterpriseCode());
                csWmsShippingInfoReqDto.setShippingCompanyName(inOutNoticeOrderEo.getShipmentEnterpriseName());
            }
        }
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
        context.setOrderStatus(BaseOrderStatusEnum.ORO_DONE_OUT);
        this.outResultOrderAbleImpl.generate(context);
        if (context.isWaitConfirm()) {
            if (facadeBo.isPushEvent()) {
                InventoryConfig.getEventPublisher().publishEvent((ApplicationEvent)new BaseOrderWaitConfirmEvent(context));
            }
            return context;
        }
        if (context.isHangup()) {
            InventoryConfig.pushEvent(new BaseOrderOutHangUpEvent(context));
            return context;
        }
        InOutResultOrderEo inOutResultOrderEo = context.getInOutResultOrderEo();
        ReceiveDeliveryResultOrderContext resultOrderContext = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)context, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = this.initRdResultByInOutResult(inOutResultOrderEo);
        resultOrderContext.setPreOrderNo(inOutResultOrderEo.getDocumentNo());
        resultOrderContext.setReceiveDeliveryResultOrderEo(receiveDeliveryResultOrderEo);
        this.deliveryResultOrderGen(resultOrderContext);
        if (facadeBo.isPushEvent()) {
            InventoryConfig.pushEvent(new BaseOrderOutBackEvent(resultOrderContext));
        }
        return this.inOutResultOrderComplete(context, inOutNoticeOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public InOutResultOrderContext inResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        InOutResultOrderContext context = this.getInOutResultOrderContext(facadeBo);
        InOutNoticeOrderEo inOutNoticeOrderEo = facadeBo.getInOutNoticeOrderEo();
        BaseOrderExtensionHelper.settingExtensionByContext(context, inOutNoticeOrderEo);
        context.setLogicWarehouseCode(inOutNoticeOrderEo.getInLogicWarehouseCode());
        context.setLogicWarehouseName(inOutNoticeOrderEo.getInLogicWarehouseName());
        context.setPhysicsWarehouseCode(inOutNoticeOrderEo.getInPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(inOutNoticeOrderEo.getInPhysicsWarehouseName());
        BaseOrderExtensionHelper.settingExtensionByContext(context, inOutNoticeOrderEo);
        this.assignWarehouseResultOrder(facadeBo, context);
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN);
        context.setOrderStatus(BaseOrderStatusEnum.IRO_DONE_IN);
        InOutResultOrderEo initOutResultOrderEo = Objects.nonNull(context.getInOutResultOrderEo()) ? context.getInOutResultOrderEo() : new InOutResultOrderEo();
        context.setInOutResultOrderEo(initOutResultOrderEo);
        this.inResultOrderAbleImpl.generate(context);
        if (context.isHangup()) {
            InventoryConfig.pushEvent(new BaseOrderInHangUpEvent(context));
            return context;
        }
        InOutResultOrderEo inOutResultOrderEo = context.getInOutResultOrderEo();
        ReceiveDeliveryResultOrderContext resultOrderContext = (ReceiveDeliveryResultOrderContext)BeanUtil.copyProperties((Object)context, ReceiveDeliveryResultOrderContext.class, (String[])new String[0]);
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = this.initRdResultByInOutResult(inOutResultOrderEo);
        resultOrderContext.setPreOrderNo(inOutResultOrderEo.getDocumentNo());
        resultOrderContext.setReceiveDeliveryResultOrderEo(receiveDeliveryResultOrderEo);
        this.receiveResultOrderGen(resultOrderContext);
        if (facadeBo.isPushEvent()) {
            InventoryConfig.pushEvent(new BaseOrderInBackEvent(resultOrderContext));
        }
        return this.inOutResultOrderComplete(context, inOutNoticeOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public InOutResultOrderContext assembleDisassembleResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        InOutResultOrderContext context = this.getInOutResultOrderContext(facadeBo);
        InOutNoticeOrderEo assemblyDisassemblyNoticeOrderEo = facadeBo.getInOutNoticeOrderEo();
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)assemblyDisassemblyNoticeOrderEo.getRelevanceNo())).notIn((Object)"order_status", new Object[]{BaseOrderStatusEnum.ONO_CANCEL.getCode(), BaseOrderStatusEnum.INO_CANCEL.getCode()})).eq((Object)"order_type", (Object)"out")).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos), (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        this.coverExtension(facadeBo.getOrderBasicsDetailReqDtoList(), facadeBo.getInOutNoticeOrderDetailEos());
        this.cover(facadeBo.getOrderBasicsDetailReqDtoList(), inOutNoticeOrderEo);
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY);
        context.setOrderStatus(BaseOrderStatusEnum.ORO_HANG_UP);
        context.setLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        context.setLogicWarehouseName(inOutNoticeOrderEo.getOutLogicWarehouseName());
        context.setPhysicsWarehouseCode(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(inOutNoticeOrderEo.getOutPhysicsWarehouseName());
        InOutResultOrderEo initOutResultOrderEo = Objects.nonNull(context.getInOutResultOrderEo()) ? context.getInOutResultOrderEo() : new InOutResultOrderEo();
        context.setInOutResultOrderEo(initOutResultOrderEo);
        this.assemblyDisassemblyResultOrderAble.generate(context);
        if (context.isHangup() || context.getAutoComplete().booleanValue()) {
            if (context.isHangup()) {
                InventoryConfig.pushEvent(new BaseOrderOutHangUpEvent(context));
            }
            return context;
        }
        this.assembleDisassembleResultOrderComplete(context, inOutNoticeOrderEo);
        int type = AssemblyDisassemblyOrderBizTypeEnum.getByName((String)inOutNoticeOrderEo.getDisplayBusinessType()).getPackType();
        List<BaseOrderDetailReqDto> orderBasicsDetailReqDtoList = facadeBo.getOrderBasicsDetailReqDtoList();
        List<BaseOrderDetailReqDto> outNoticeOrderDetailEos = orderBasicsDetailReqDtoList.stream().filter(x -> x.getPackType() == type).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(outNoticeOrderDetailEos)) {
            InOutResultOrderFacadeBo inFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)facadeBo, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            inFacadeBo.setPushEvent(true);
            inFacadeBo.setInOutNoticeOrderEo(inOutNoticeOrderEo);
            inFacadeBo.setOrderBasicsDetailReqDtoList(outNoticeOrderDetailEos);
            this.outResultOrderGen(inFacadeBo);
        }
        List<BaseOrderDetailReqDto> detailReqDtos = orderBasicsDetailReqDtoList.stream().filter(x -> x.getPackType() != type).collect(Collectors.toList());
        log.info("\u7ec4\u88c5\u62c6\u5378\u5165\u5e93\u5546\u54c1\u6253\u5370\uff1a{}", (Object)JSONObject.toJSONString(detailReqDtos));
        if (CollectionUtils.isNotEmpty(detailReqDtos)) {
            AssembleDisassembleOrderFacadeBo noticeOrderFacadeBo = (AssembleDisassembleOrderFacadeBo)BeanUtil.copyProperties((Object)facadeBo, AssembleDisassembleOrderFacadeBo.class, (String[])new String[0]);
            noticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(detailReqDtos);
            noticeOrderFacadeBo.setAutoComplete(true);
            noticeOrderFacadeBo.setSendWms(false);
            this.assembleDisassembleReceiveGen(noticeOrderFacadeBo, inOutNoticeOrderEo);
        }
        return context;
    }

    @Override
    public void receiveResultOrderGen(ReceiveDeliveryResultOrderContext context) {
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.RECEIVE);
        context.setOrderStatus(BaseOrderStatusEnum.RRO_RECEIVED);
        this.receiveResultOrderAbleImpl.generate(context);
        this.doDrNoticeOrder(context);
    }

    @Override
    public void deliveryResultOrderGen(ReceiveDeliveryResultOrderContext context) {
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.DELIVERY);
        context.setOrderStatus(BaseOrderStatusEnum.DRO_DELIVERED);
        this.deliveryResultOrderAbleImpl.generate(context);
        this.doDrNoticeOrder(context);
    }

    private InOutResultOrderContext inOutResultOrderComplete(InOutResultOrderContext context, InOutNoticeOrderEo inOutNoticeOrderEo) {
        log.info("inOutResultOrderComplete-InOutResultOrderContext:{}", (Object)JSON.toJSONString((Object)context));
        if (context.getAutoComplete().booleanValue() || !context.isLinkNoticeUpdate()) {
            return context;
        }
        InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)BeanUtil.copyProperties((Object)context, InOutNoticeOrderContext.class, (String[])new String[0]);
        outNoticeOrderContext.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
        if ("in".equals(context.getInOutResultOrderEo().getOrderType())) {
            this.inNoticeOrderAbleImpl.complete(outNoticeOrderContext);
        } else if ("out".equals(context.getInOutResultOrderEo().getOrderType())) {
            this.outNoticeOrderAbleImpl.complete(outNoticeOrderContext);
        } else {
            this.adjustNoticeOrderAble.complete(outNoticeOrderContext);
        }
        context.execComplete(context);
        if (outNoticeOrderContext.isNoticeEnd()) {
            log.info("[inOutResultOrderComplete]\u51fa\u5165\u7ed3\u679c\u5b8c\u6210\u64cd\u4f5c\uff1a{}", (Object)JSONObject.toJSONString((Object)outNoticeOrderContext));
            InventoryConfig.pushEvent(new InOutNoticeOrderCompleteEvent(outNoticeOrderContext));
        }
        return context;
    }

    private InOutResultOrderContext getInOutResultOrderContext(InOutResultOrderFacadeBo facadeBo) {
        AssertUtil.isTrue((facadeBo.getInOutNoticeOrderEo() != null ? 1 : 0) != 0, (String)"\u5173\u8054\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(facadeBo.getInOutNoticeOrderDetailEos()), (String)"\u5173\u8054\u901a\u77e5\u5355\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        InOutResultOrderContext context = (InOutResultOrderContext)BeanUtil.copyProperties((Object)facadeBo, InOutResultOrderContext.class, (String[])new String[0]);
        InOutNoticeOrderEo inOutNoticeOrderEo = facadeBo.getInOutNoticeOrderEo();
        context.setMultipleIn(InventoryConfig.isMultipleIn());
        context.setMultipleOut(InventoryConfig.isMultipleOut());
        context.setPreOrderNo(inOutNoticeOrderEo.getDocumentNo());
        context.setBusinessType(inOutNoticeOrderEo.getBusinessType());
        context.setExternalOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
        context.setRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        context.setDisplayBusinessType(inOutNoticeOrderEo.getDisplayBusinessType());
        context.setDisplayBusinessName(inOutNoticeOrderEo.getDisplayBusinessName());
        context.setJumpDocumentType(inOutNoticeOrderEo.getJumpDocumentType());
        context.setJumpDocumentName(inOutNoticeOrderEo.getJumpDocumentName());
        context.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutNoticeOrderEo.getRelevanceTableName()));
        boolean hasVolume = facadeBo.getOrderBasicsDetailReqDtoList().stream().anyMatch(r -> Objects.nonNull(r.getVolume()));
        if (!hasVolume) {
            this.orderUnitConversionRecordService.baseVolumeAndWeightProcess(facadeBo.getInOutNoticeOrderEo().getRelevanceNo(), facadeBo.getOrderBasicsDetailReqDtoList(), false);
        }
        context.setTotalQuantity(facadeBo.getOrderBasicsDetailReqDtoList().stream().map(OrderUnitConverterDto::getQuantity).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        context.setTotalVolume(facadeBo.getOrderBasicsDetailReqDtoList().stream().peek(r -> r.setVolume((BigDecimal)ObjectUtil.defaultIfNull((Object)r.getVolume(), (Object)BigDecimal.ZERO))).map(BaseOrderDetailReqDto::getVolume).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        context.setTotalWeight(facadeBo.getOrderBasicsDetailReqDtoList().stream().peek(r -> r.setWeight((BigDecimal)ObjectUtil.defaultIfNull((Object)r.getWeight(), (Object)BigDecimal.ZERO))).map(BaseOrderDetailReqDto::getWeight).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        BigDecimal totalQuantity = BigDecimal.ZERO;
        BigDecimal totalVolume = BigDecimal.ZERO;
        BigDecimal totalWeight = BigDecimal.ZERO;
        for (BaseOrderDetailReqDto detail : facadeBo.getOrderBasicsDetailReqDtoList()) {
            totalQuantity = totalQuantity.add(detail.getQuantity() != null ? detail.getQuantity() : BigDecimal.ZERO);
            totalVolume = totalVolume.add(detail.getVolume() != null ? detail.getVolume() : BigDecimal.ZERO);
            totalWeight = totalWeight.add(detail.getWeight() != null ? detail.getWeight() : BigDecimal.ZERO);
        }
        context.setTotalQuantity(totalQuantity);
        context.setTotalVolume(totalVolume);
        context.setTotalWeight(totalWeight);
        InOutResultOrderEo outResultOrderEo = Optional.ofNullable(context.getInOutResultOrderEo()).orElse(new InOutResultOrderEo());
        outResultOrderEo.setExtension(inOutNoticeOrderEo.getExtension());
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutLogicWarehouseCode())) {
            outResultOrderEo.setOutLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutLogicWarehouseName())) {
            outResultOrderEo.setOutLogicWarehouseName(inOutNoticeOrderEo.getOutLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInventoryProperty())) {
            outResultOrderEo.setInventoryProperty(inOutNoticeOrderEo.getInventoryProperty());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutPhysicsWarehouseCode())) {
            outResultOrderEo.setOutPhysicsWarehouseCode(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutPhysicsWarehouseName())) {
            outResultOrderEo.setOutPhysicsWarehouseName(inOutNoticeOrderEo.getOutPhysicsWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInLogicWarehouseCode())) {
            outResultOrderEo.setInLogicWarehouseCode(inOutNoticeOrderEo.getInLogicWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInLogicWarehouseName())) {
            outResultOrderEo.setInLogicWarehouseName(inOutNoticeOrderEo.getInLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInPhysicsWarehouseCode())) {
            outResultOrderEo.setInPhysicsWarehouseCode(inOutNoticeOrderEo.getInPhysicsWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getInPhysicsWarehouseName())) {
            outResultOrderEo.setInPhysicsWarehouseName(inOutNoticeOrderEo.getInPhysicsWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getShopCode())) {
            outResultOrderEo.setShopCode(inOutNoticeOrderEo.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getShopName())) {
            outResultOrderEo.setShopName(inOutNoticeOrderEo.getShopName());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getWmsOrderNo())) {
            outResultOrderEo.setWmsOrderNo(inOutNoticeOrderEo.getWmsOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getTransportStyle())) {
            outResultOrderEo.setTransportStyle(inOutNoticeOrderEo.getTransportStyle());
        }
        if (StringUtils.isNotEmpty((CharSequence)inOutNoticeOrderEo.getLogisticsOrderNo())) {
            outResultOrderEo.setLogisticsOrderNo(inOutNoticeOrderEo.getLogisticsOrderNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)inOutNoticeOrderEo.getOffsetType())) {
            outResultOrderEo.setOffsetType(inOutNoticeOrderEo.getOffsetType());
        }
        context.setInOutResultOrderEo(outResultOrderEo);
        BaseOrderExtensionHelper.loadByExtension(context, inOutNoticeOrderEo);
        context.setExtension(facadeBo.getExtensionExternal());
        return context;
    }

    private void assignWarehouseResultOrder(InOutResultOrderFacadeBo facadeBo, InOutResultOrderContext context) {
        if (facadeBo.isAssignWarehouse() && StringUtils.isNotBlank((CharSequence)facadeBo.getLogicWarehouseCode())) {
            Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)facadeBo.getLogicWarehouseCode())).eq((Object)"warehouse_status", (Object)"enable")).last(" limit 1")).one()).ifPresent(one -> {
                context.setLogicWarehouseCode(facadeBo.getLogicWarehouseCode());
                context.setLogicWarehouseName(one.getWarehouseName());
                context.setPhysicsWarehouseCode(one.getPhysicsWarehouseCode());
                context.setPhysicsWarehouseName(one.getPhysicsWarehouseName());
            });
        }
    }

    @NotNull
    private ReceiveDeliveryResultOrderEo initRdResultByInOutResult(InOutResultOrderEo inOutResultOrderEo) {
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)BeanUtil.copyProperties((Object)inOutResultOrderEo, ReceiveDeliveryResultOrderEo.class, (String[])new String[0]);
        receiveDeliveryResultOrderEo.setDeliveryLogicWarehouseCode(inOutResultOrderEo.getOutLogicWarehouseCode());
        receiveDeliveryResultOrderEo.setDeliveryLogicWarehouseName(inOutResultOrderEo.getOutLogicWarehouseName());
        receiveDeliveryResultOrderEo.setInventoryProperty(inOutResultOrderEo.getInventoryProperty());
        receiveDeliveryResultOrderEo.setDeliveryPhysicsWarehouseCode(inOutResultOrderEo.getOutPhysicsWarehouseCode());
        receiveDeliveryResultOrderEo.setDeliveryPhysicsWarehouseName(inOutResultOrderEo.getOutPhysicsWarehouseName());
        receiveDeliveryResultOrderEo.setReceiveLogicWarehouseCode(inOutResultOrderEo.getInLogicWarehouseCode());
        receiveDeliveryResultOrderEo.setReceiveLogicWarehouseName(inOutResultOrderEo.getInLogicWarehouseName());
        receiveDeliveryResultOrderEo.setReceivePhysicsWarehouseCode(inOutResultOrderEo.getInPhysicsWarehouseCode());
        receiveDeliveryResultOrderEo.setReceivePhysicsWarehouseName(inOutResultOrderEo.getInPhysicsWarehouseName());
        receiveDeliveryResultOrderEo.setShopCode(inOutResultOrderEo.getShopCode());
        receiveDeliveryResultOrderEo.setShopName(inOutResultOrderEo.getShopName());
        receiveDeliveryResultOrderEo.setWmsOrderNo(inOutResultOrderEo.getWmsOrderNo());
        return receiveDeliveryResultOrderEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public InOutResultOrderContext adjustResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        InOutResultOrderContext context = this.getInOutResultOrderContext(facadeBo);
        InOutNoticeOrderEo inOutNoticeOrderEo = facadeBo.getInOutNoticeOrderEo();
        context.setLogicWarehouseCode(inOutNoticeOrderEo.getInLogicWarehouseCode());
        context.setLogicWarehouseName(inOutNoticeOrderEo.getInLogicWarehouseName());
        context.setPhysicsWarehouseCode(inOutNoticeOrderEo.getInPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(inOutNoticeOrderEo.getInPhysicsWarehouseName());
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.IN_OUT);
        context.setOrderStatus(BaseOrderStatusEnum.IRO_DONE_IN);
        InOutResultOrderEo initOutResultOrderEo = Objects.nonNull(context.getInOutResultOrderEo()) ? context.getInOutResultOrderEo() : new InOutResultOrderEo();
        context.setInOutResultOrderEo(initOutResultOrderEo);
        initOutResultOrderEo.setOldInventoryProperty(facadeBo.getInOutNoticeOrderEo().getOldInventoryProperty());
        this.adjustResultOrderAble.generate(context);
        if (context.isHangup() || context.getAutoComplete().booleanValue()) {
            if (context.isHangup()) {
                InventoryConfig.pushEvent(new BaseOrderOutHangUpEvent(context));
                InventoryConfig.pushEvent(new BaseOrderInHangUpEvent(context));
            }
            return context;
        }
        this.inOutResultOrderComplete(context, inOutNoticeOrderEo);
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).notIn((Object)"order_status", new Object[]{BaseOrderStatusEnum.ONO_CANCEL.getCode(), BaseOrderStatusEnum.INO_CANCEL.getCode()})).list();
        Map<String, List<InOutNoticeOrderDetailEo>> inOutMap = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).list().stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getDocumentNo));
        inOutNoticeOrderEos.stream().filter(r -> "in".equals(r.getOrderType())).findFirst().ifPresent(r -> {
            InOutResultOrderFacadeBo inFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)facadeBo, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            inFacadeBo.setPushEvent(true);
            inFacadeBo.setInOutNoticeOrderEo((InOutNoticeOrderEo)r);
            inFacadeBo.setInOutNoticeOrderDetailEos((List)inOutMap.get(r.getDocumentNo()));
            this.inResultOrderGen(inFacadeBo);
        });
        inOutNoticeOrderEos.stream().filter(r -> "out".equals(r.getOrderType())).findFirst().ifPresent(r -> {
            InOutResultOrderFacadeBo inFacadeBo = (InOutResultOrderFacadeBo)BeanUtil.copyProperties((Object)facadeBo, InOutResultOrderFacadeBo.class, (String[])new String[0]);
            inFacadeBo.setPushEvent(true);
            inFacadeBo.setInOutNoticeOrderEo((InOutNoticeOrderEo)r);
            inFacadeBo.setInOutNoticeOrderDetailEos((List)inOutMap.get(r.getDocumentNo()));
            Map noticeOrderDetailEoMap = inFacadeBo.getInOutNoticeOrderDetailEos().stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getLineNo, Function.identity(), (o, o1) -> o));
            inFacadeBo.setOrderBasicsDetailReqDtoList(BeanUtil.copyToList(inFacadeBo.getOrderBasicsDetailReqDtoList(), BaseOrderDetailReqDto.class, (CopyOptions)CopyOptions.create().setIgnoreProperties(new String[]{"id"})).stream().filter(de -> Objects.nonNull(de.getLineNo())).peek(de -> {
                InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)noticeOrderDetailEoMap.get(de.getLineNo());
                de.setBatch(inOutNoticeOrderDetailEo.getBatch());
                de.setInventoryProperty(inOutNoticeOrderDetailEo.getInventoryProperty());
            }).collect(Collectors.toList()));
            this.outResultOrderGen(inFacadeBo);
        });
        return context;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void mergeOutResultOrderGen(InOutResultOrderFacadeBo facadeBo) {
        InOutResultOrderContext context = this.getInOutResultOrderContext(facadeBo);
        InOutNoticeOrderEo inOutNoticeOrderEo = facadeBo.getInOutNoticeOrderEo();
        context.setLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
        context.setLogicWarehouseName(inOutNoticeOrderEo.getOutLogicWarehouseName());
        context.setPhysicsWarehouseCode(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(inOutNoticeOrderEo.getOutPhysicsWarehouseName());
        context.setOperateTypeEnum(BaseOrderOperateTypeEnum.OUT);
        context.setOrderStatus(BaseOrderStatusEnum.ORO_DONE_OUT);
        InOutResultOrderEo initOutResultOrderEo = Objects.nonNull(context.getInOutResultOrderEo()) ? context.getInOutResultOrderEo() : new InOutResultOrderEo();
        context.setInOutResultOrderEo(initOutResultOrderEo);
        initOutResultOrderEo.setOldInventoryProperty(facadeBo.getInOutNoticeOrderEo().getOldInventoryProperty());
        this.mergeOutResultOrderAble.generate(context);
        if (context.isHangup() || context.getAutoComplete().booleanValue()) {
            if (context.isHangup()) {
                InventoryConfig.pushEvent(new BaseOrderOutHangUpEvent(context));
            }
            return;
        }
        this.inOutResultOrderComplete(context, inOutNoticeOrderEo);
        List<BaseOrderDetailReqDto> detailReqDtoList = facadeBo.getOrderBasicsDetailReqDtoList();
        List<Long> longs = detailReqDtoList.stream().map(BaseOrderDetailReqDto::getLineNo).collect(Collectors.toList());
        AbstractBaseOrderFacadeHelper.LoadMergeResult result = this.getLoadMergeResult(longs);
        result.detailMap.forEach((k, v) -> {
            InOutResultOrderFacadeBo inFacadeBo = this.getInOutResultOrderFacadeBo(facadeBo, (String)k, (List<InOutNoticeOrderDetailEo>)v, result.noticeOrderEoMap);
            this.outResultOrderGen(inFacadeBo);
        });
    }
}

