/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryDueInDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchReqDto;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryDueInEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.abstracts.AbstractInOutResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.entity.IInventoryBatchService;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InResultOrderAbleImpl
extends AbstractInOutResultOrderAble {
    private static final Logger log = LoggerFactory.getLogger(InResultOrderAbleImpl.class);
    @Resource
    private ICalcInventoryService calcInventoryService;
    @Resource
    private IInventoryDueInDomain inventoryDueInDomain;
    @Resource
    private IInventoryBatchService inventoryBatchService;
    @Resource
    protected TransactionCallBackService transactionCallBackService;
    @Resource
    private IDispatcherOrderDomain dispatcherOrderDomain;

    @Override
    protected void wrapperGenerateAfter(InOutResultOrderContext context) {
        this.formIn(context);
        this.saveInventoryBatch(context);
    }

    private void saveInventoryBatch(InOutResultOrderContext context) {
        if (InventoryConfig.isNoneBatch()) {
            return;
        }
        this.transactionCallBackService.execute(() -> {
            Map dateMap = context.getInOutResultOrderDetailEoList().stream().collect(Collectors.toMap(r -> r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch(), Function.identity(), (o, o1) -> o));
            this.inventoryBatchService.save(new ArrayList<InventoryBatchReqDto>(dateMap.values().stream().collect(Collectors.toMap(r -> r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch(), r -> (InventoryBatchReqDto)BeanUtil.copyProperties((Object)r, InventoryBatchReqDto.class, (String[])new String[0]), (o, o1) -> o)).values()), false);
        });
    }

    private void formIn(InOutResultOrderContext context) {
        if (!context.getUpdateInventory().booleanValue()) {
            return;
        }
        context.getOrderBasicsDetailReqDtoList().forEach(r -> r.setBatch((String)DataExtractUtils.ifNullElse((Object)r.getBatch(), (Object)InventoryConfig.getDefaultBatch())));
        context.getInOutResultOrderDetailEoList().forEach(r -> r.setBatch((String)DataExtractUtils.ifNullElse((Object)r.getBatch(), (Object)InventoryConfig.getDefaultBatch())));
        if (this.isInTransit(context)) {
            TransferInDto transferInDto = new TransferInDto();
            this.wrapper(context, (CalcDto)transferInDto);
            if (CollectionUtils.isEmpty((Collection)transferInDto.getDetails())) {
                return;
            }
            this.calcInTransit(context, transferInDto);
            transferInDto.setValidNegative(Boolean.FALSE);
            this.calcInventoryService.transferIn(transferInDto);
        } else {
            FormInDto formInDto = new FormInDto();
            this.wrapper(context, (CalcDto)formInDto);
            if (CollectionUtils.isEmpty((Collection)formInDto.getDetails())) {
                return;
            }
            if (!this.canNoticeInventoryProcess(context)) {
                formInDto.setIgnoreFutureIn(Boolean.valueOf(true));
            } else {
                this.calcFutureIn(context, formInDto);
            }
            formInDto.setValidNegative(Boolean.FALSE);
            this.calcInventoryService.formIn(formInDto);
        }
    }

    private void calcFutureIn(InOutResultOrderContext context, FormInDto formInDto) {
        List inventoryOperateLogEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryDueInDomain.filter().eq((Object)"source_no", (Object)context.getRelevanceNo())).isNotNull((Object)"batch")).list();
        this.doCalcIn(context, formInDto, inventoryOperateLogEoList);
        formInDto.setIgnoreFutureIn(Boolean.valueOf(CollectionUtils.isEmpty((Collection)formInDto.getReleaseDetails())));
    }

    @NotNull
    private static String getKey(CalcDetailDto r) {
        return r.getLogicWarehouseCode() + InventoryConfig.getCommonSeparate() + r.getSkuCode();
    }

    private static String getPropertyKey(CalcDetailDto r) {
        return r.getLogicWarehouseCode() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getInventoryProperty();
    }

    private void calcInTransit(InOutResultOrderContext context, TransferInDto transferInDto) {
        String transferOrderNo = null;
        if (CsRelevanceTableNameEnum.IN_DISPATCHER_ORDER.equals((Object)context.getRelevanceTableName())) {
            DispatcherOrderEo dispatcherOrderEo = (DispatcherOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dispatcherOrderDomain.filter().eq((Object)"order_no", (Object)context.getRelevanceNo())).last(" limit 1")).one();
            transferOrderNo = Objects.nonNull(dispatcherOrderEo) ? dispatcherOrderEo.getTransferOrderNo() : null;
            transferInDto.setTransferOrderNo(transferOrderNo);
        }
        List inventoryOperateLogEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryDueInDomain.filter().eq((Object)"source_no", (Object)(StringUtils.isBlank(transferOrderNo) ? context.getRelevanceNo() : transferOrderNo))).isNotNull((Object)"batch")).list();
        log.info("calcInTransit\u6d41\u6c34\u8bb0\u5f55\uff1a{}", (Object)JSONObject.toJSONString((Object)inventoryOperateLogEoList));
        this.doCalcIn(context, transferInDto, inventoryOperateLogEoList);
    }

    private <CALC extends CalcDto> void doCalcIn(InOutResultOrderContext context, CALC transferInDto, List<InventoryDueInEo> inventoryOperateLogEoList) {
        if (context.isNoticeEnd() && !InventoryConfig.isDispatchOrderEnable()) {
            log.info("\u91ca\u653e\u5168\u90e8\u5728\u9014");
            Map<String, BigDecimal> canRelseMap = inventoryOperateLogEoList.stream().collect(Collectors.groupingBy(InResultOrderAbleImpl::getBatchKey, Collectors.mapping(InventoryDueInEo::getRequestNum, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            transferInDto.setReleaseDetails(canRelseMap.entrySet().stream().filter(r -> BigDecimalUtils.gtZero((BigDecimal)((BigDecimal)r.getValue()))).map(entry -> {
                String[] split = ((String)entry.getKey()).split(InventoryConfig.getCommonSeparate());
                CalcDetailDto calcDetailDto = InResultOrderAbleImpl.initCalcDto(entry, split);
                calcDetailDto.setBatch(split[3]);
                return calcDetailDto;
            }).collect(Collectors.toList()));
        } else {
            log.info("\u91ca\u653e\u90e8\u5206\u5728\u9014");
            Map<String, List<InventoryDueInEo>> sourceNumMap = inventoryOperateLogEoList.stream().collect(Collectors.groupingBy(r -> r.getWarehouseCode() + InventoryConfig.getCommonSeparate() + r.getSkuCode()));
            Map<String, List<InventoryDueInEo>> propertySourceNumMap = inventoryOperateLogEoList.stream().collect(Collectors.groupingBy(r -> r.getWarehouseCode() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getInventoryProperty()));
            Map<String, BigDecimal> canRelseMap = inventoryOperateLogEoList.stream().collect(Collectors.groupingBy(InResultOrderAbleImpl::getBatchKey, Collectors.mapping(InventoryDueInEo::getRequestNum, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map<String, BigDecimal> targetNumMap = transferInDto.getDetails().stream().collect(Collectors.groupingBy(InResultOrderAbleImpl::getKey, Collectors.mapping(CalcDetailDto::getNum, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map<String, BigDecimal> targetPropertyNumMap = transferInDto.getDetails().stream().collect(Collectors.groupingBy(InResultOrderAbleImpl::getPropertyKey, Collectors.mapping(CalcDetailDto::getNum, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            transferInDto.setReleaseDetails(transferInDto.getDetails().stream().map(detail -> {
                AtomicReference<BigDecimal> targetNum = new AtomicReference<BigDecimal>(detail.getNum());
                if (BigDecimalUtils.leZero((BigDecimal)targetNum.get()).booleanValue()) {
                    return null;
                }
                String batchKey = InResultOrderAbleImpl.getBatchKey(detail);
                if (!canRelseMap.containsKey(InResultOrderAbleImpl.getBatchKey(detail))) {
                    return null;
                }
                CalcDetailDto calcDetailDto = InResultOrderAbleImpl.getCalcDetailDto(detail);
                calcDetailDto.setBatch(detail.getBatch());
                InResultOrderAbleImpl.updateCalcNum(batchKey, (BigDecimal)canRelseMap.get(batchKey), targetNum, calcDetailDto, canRelseMap);
                targetNumMap.computeIfPresent(InResultOrderAbleImpl.getKey(calcDetailDto), (k, v) -> BigDecimalUtils.subtract((BigDecimal)v, (BigDecimal)calcDetailDto.getNum()));
                targetPropertyNumMap.computeIfPresent(InResultOrderAbleImpl.getPropertyKey(calcDetailDto), (k, v) -> BigDecimalUtils.subtract((BigDecimal)v, (BigDecimal)calcDetailDto.getNum()));
                return calcDetailDto;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
            transferInDto.getReleaseDetails().addAll(targetPropertyNumMap.entrySet().stream().filter(entry -> propertySourceNumMap.containsKey(entry.getKey())).flatMap(entry -> {
                AtomicReference targetNum = new AtomicReference(entry.getValue());
                return canRelseMap.entrySet().stream().filter(e -> ((String)e.getKey()).contains((CharSequence)entry.getKey())).filter(r -> BigDecimalUtils.gtZero((BigDecimal)((BigDecimal)r.getValue()))).map(r -> {
                    if (BigDecimalUtils.leZero((BigDecimal)((BigDecimal)targetNum.get())).booleanValue()) {
                        return null;
                    }
                    CalcDetailDto calcDetailDto = InResultOrderAbleImpl.calcAndInitDetail(entry, r, targetNum, canRelseMap);
                    targetNumMap.computeIfPresent(InResultOrderAbleImpl.getKey(calcDetailDto), (k, v) -> BigDecimalUtils.subtract((BigDecimal)v, (BigDecimal)calcDetailDto.getNum()));
                    return calcDetailDto;
                }).filter(Objects::nonNull);
            }).filter(Objects::nonNull).collect(Collectors.toList()));
            transferInDto.getReleaseDetails().addAll(targetNumMap.entrySet().stream().filter(entry -> sourceNumMap.containsKey(entry.getKey())).flatMap(entry -> {
                AtomicReference targetNum = new AtomicReference(entry.getValue());
                return canRelseMap.entrySet().stream().filter(e -> ((String)e.getKey()).contains((CharSequence)entry.getKey())).filter(r -> BigDecimalUtils.gtZero((BigDecimal)((BigDecimal)r.getValue()))).map(r -> {
                    if (BigDecimalUtils.leZero((BigDecimal)((BigDecimal)targetNum.get())).booleanValue()) {
                        return null;
                    }
                    return InResultOrderAbleImpl.calcAndInitDetail(entry, r, targetNum, canRelseMap);
                }).filter(Objects::nonNull);
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
    }

    @NotNull
    private static CalcDetailDto calcAndInitDetail(Map.Entry<String, BigDecimal> entry, Map.Entry<String, BigDecimal> r, AtomicReference<BigDecimal> targetNum, Map<String, BigDecimal> canRelseMap) {
        String[] split = r.getKey().split(InventoryConfig.getCommonSeparate());
        CalcDetailDto calcDetailDto = InResultOrderAbleImpl.initCalcDto(entry, split);
        calcDetailDto.setBatch(split[3]);
        InResultOrderAbleImpl.updateCalcNum(r.getKey(), r.getValue(), targetNum, calcDetailDto, canRelseMap);
        return calcDetailDto;
    }

    @NotNull
    private static CalcDetailDto getCalcDetailDto(CalcDetailDto detail) {
        CalcDetailDto calcDetailDto = new CalcDetailDto();
        calcDetailDto.setInventoryProperty(detail.getInventoryProperty());
        calcDetailDto.setLogicWarehouseCode(detail.getLogicWarehouseCode());
        calcDetailDto.setSkuCode(detail.getSkuCode());
        return calcDetailDto;
    }

    @NotNull
    public static String getBatchKey(InventoryDueInEo r) {
        return r.getWarehouseCode() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getInventoryProperty() + InventoryConfig.getCommonSeparate() + r.getBatch();
    }

    @NotNull
    private static String getBatchKey(CalcDetailDto r) {
        return r.getLogicWarehouseCode() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getInventoryProperty() + InventoryConfig.getCommonSeparate() + r.getBatch();
    }

    private static void updateCalcNum(String key, BigDecimal value, AtomicReference<BigDecimal> targetNum, CalcDetailDto calcDetailDto, Map<String, BigDecimal> canRelseMap) {
        if (BigDecimalUtils.gt((BigDecimal)value, (BigDecimal)targetNum.get()).booleanValue()) {
            calcDetailDto.setNum(targetNum.get());
            canRelseMap.put(key, BigDecimalUtils.subtract((BigDecimal)value, (BigDecimal)targetNum.get()));
            targetNum.set(BigDecimal.ZERO);
        } else {
            calcDetailDto.setNum(value);
            targetNum.set(BigDecimalUtils.subtract((BigDecimal)targetNum.get(), (BigDecimal)value));
            canRelseMap.put(key, BigDecimal.ZERO);
        }
    }

    @NotNull
    public static CalcDetailDto initCalcDto(Map.Entry<String, BigDecimal> entry, String[] split) {
        CalcDetailDto calcDetailDto = new CalcDetailDto();
        calcDetailDto.setInventoryProperty(split[2]);
        calcDetailDto.setNum(entry.getValue());
        calcDetailDto.setLogicWarehouseCode(split[0]);
        calcDetailDto.setSkuCode(split[1]);
        return calcDetailDto;
    }

    private boolean isInTransit(InOutResultOrderContext context) {
        return (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)context.getRelevanceTableName()) && context.getCanProcessTransit() != false || CsRelevanceTableNameEnum.IN_DISPATCHER_ORDER.equals((Object)context.getRelevanceTableName())) && this.canNoticeInventoryProcess(context);
    }

    @Override
    protected String getCompleteStatus() {
        return BaseOrderStatusEnum.IRO_DONE_IN.getCode();
    }

    @Override
    protected void setUnhookWarehouse(InOutResultOrderContext context) {
        context.setLogicWarehouseCode(context.getInOutResultOrderEo().getInLogicWarehouseCode());
        context.setLogicWarehouseName(context.getInOutResultOrderEo().getInLogicWarehouseName());
        context.setPhysicsWarehouseCode(context.getInOutResultOrderEo().getInPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(context.getInOutResultOrderEo().getInPhysicsWarehouseName());
    }

    @Override
    protected void unhookAfter(InOutResultOrderContext context) {
        context.setLogicWarehouseCode(context.getInOutResultOrderEo().getInLogicWarehouseCode());
        context.setLogicWarehouseName(context.getInOutResultOrderEo().getInLogicWarehouseName());
        context.setPhysicsWarehouseCode(context.getInOutResultOrderEo().getInPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(context.getInOutResultOrderEo().getInPhysicsWarehouseName());
        this.wrapperGenerateAfter(context);
    }

    @Override
    protected void confirmAfter(InOutResultOrderContext inOutResultOrderContext) {
    }

    @Override
    protected String getHangUpStatus() {
        return BaseOrderStatusEnum.IRO_HANG_UP.getCode();
    }

    @Override
    protected String getWaitConfirmStatus() {
        return null;
    }

    @Override
    protected void wrapperGenerate(InOutResultOrderContext context) {
        context.getInOutResultOrderEo().setInLogicWarehouseCode(context.getLogicWarehouseCode());
        context.getInOutResultOrderEo().setInLogicWarehouseName(context.getLogicWarehouseName());
        context.getInOutResultOrderEo().setInPhysicsWarehouseCode(context.getPhysicsWarehouseCode());
        context.getInOutResultOrderEo().setInPhysicsWarehouseName(context.getPhysicsWarehouseName());
    }

    @Override
    public boolean validClose(InOutResultOrderContext context) {
        return false;
    }

    @Override
    public void doClose(InOutResultOrderContext context) {
    }

    @Override
    public boolean validCancel(InOutResultOrderContext context) {
        return super.validCancel(context);
    }

    @Override
    public void doCancel(InOutResultOrderContext context) {
    }
}

