/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.stateMachine.actions;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicLockOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicLockOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseLockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicLockOrderDetailDto;
import com.yunxi.dg.base.center.inventory.eo.LogicLockOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.LogicLockOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.stateMachine.enums.LogicLockOrderContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.stateMachine.enums.LogicLockOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.LogicLockOrder.stateMachine.enums.LogicLockOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class LogicLockOrderExpiredReleaseAction
extends AbstractAction<LogicLockOrderStatusEnum, LogicLockOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(LogicLockOrderExpiredReleaseAction.class);
    @Resource
    private ILogicLockOrderDomain logicLockOrderDomain;
    @Resource
    private ILogicLockOrderDetailDomain logicLockOrderDetailDomain;
    @Resource
    private ICalcInventoryService iCalcInventoryService;

    @Override
    protected void doExecute(StateContext<LogicLockOrderStatusEnum, LogicLockOrderStatusEventEnum> context) {
        log.info("\u8fdb\u5165\u903b\u8f91\u9501\u5e93\u5355\u8fc7\u671f\u91ca\u653e\u52a8\u4f5c");
        StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
        LogicLockOrderEo insertEo = (LogicLockOrderEo)executorBo.getEo();
        List detailDtoList = (List)executorBo.getVariables().get(LogicLockOrderContextEnum.LOGIC_LOCK_ORDER_DETAILDTO.getCode());
        AssertUtil.assertNotEmpty((Collection)detailDtoList, (String)"\u91ca\u653e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String today = DateUtil.today();
        List ids = detailDtoList.stream().map(BaseDto::getId).collect(Collectors.toList());
        if (DateUtil.compare((Date)insertEo.getLockEndDate(), (Date)DateUtil.parseDate((CharSequence)today)) < 0) {
            ReleaseLockDto releaseLockDto = new ReleaseLockDto();
            releaseLockDto.setSourceNo(insertEo.getOrderNo());
            releaseLockDto.setBusinessType(insertEo.getBusinessType());
            releaseLockDto.setSourceType(insertEo.getOrderType());
            releaseLockDto.setExternalOrderNo(insertEo.getExternalOrderNo());
            releaseLockDto.setNoneBatch(Boolean.TRUE);
            releaseLockDto.setNoneLineNo(Boolean.TRUE);
            ArrayList calcDetailDtoList = Lists.newArrayList();
            detailDtoList.forEach(dto -> {
                CalcDetailDto calcDetailDto = new CalcDetailDto();
                calcDetailDto.setSkuCode(dto.getSkuCode());
                calcDetailDto.setBatch(dto.getBatch());
                calcDetailDto.setLogicWarehouseCode(insertEo.getLogicWarehouseCode());
                calcDetailDto.setExpireDate(dto.getExpireTime());
                calcDetailDto.setProduceDate(dto.getProduceTime());
                calcDetailDto.setNum(dto.getQuantity());
                calcDetailDtoList.add(calcDetailDto);
            });
            releaseLockDto.setDetails((List)calcDetailDtoList);
            this.iCalcInventoryService.releaseLock(releaseLockDto);
            List detailEoList = ((ExtQueryChainWrapper)this.logicLockOrderDetailDomain.filter().in((Object)"id", ids)).list();
            ArrayList updateDetailEoList = Lists.newArrayList();
            detailEoList.forEach(o -> {
                LogicLockOrderDetailDto logicLockOrderDetailDto = detailDtoList.stream().filter(dto -> dto.getId().equals(o.getId())).findFirst().orElse(null);
                AssertUtil.isTrue((null != logicLockOrderDetailDto ? 1 : 0) != 0, (String)"\u660e\u7ec6\u4e0d\u5339\u914d");
                LogicLockOrderDetailEo updateEo = new LogicLockOrderDetailEo();
                updateEo.setId(o.getId());
                updateEo.setDoneQuantity(BigDecimalUtils.subtract((BigDecimal)o.getDoneQuantity(), (BigDecimal)logicLockOrderDetailDto.getQuantity()));
                updateDetailEoList.add(updateEo);
            });
            updateDetailEoList.forEach(o -> this.logicLockOrderDetailDomain.updateSelective((BaseEo)o));
        }
    }
}

