/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.action;

import cn.hutool.core.bean.BeanUtil;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentInventoryContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class AdjustmentBatchInventoryTransactionAction
extends AbstractAction<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentBatchInventoryTransactionAction.class);
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;

    @Override
    public void doExecute(StateContext<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> context) {
        StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
        AdjustmentOrderEo adjustmentOrderEo = (AdjustmentOrderEo)executorBo.getEo();
        List adjustmentOrderDetailEos = (List)executorBo.getVariables(AdjustmentInventoryContextEnum.ADJUSTMENT_INVENTORY_ORDER_DETAIL.getCode());
        boolean isProperty = StringUtils.isNotBlank((CharSequence)((AdjustmentOrderDetailEo)adjustmentOrderDetailEos.get(0)).getNewInventoryProperty());
        ReceiveDeliveryNoticeOrderFacadeBo noticeOrderFacadeBo = this.assembleDeLeNoticeOrderParam(adjustmentOrderEo, adjustmentOrderDetailEos);
        noticeOrderFacadeBo.setAutoComplete(true);
        this.baseOrderFacade.deliveryNoticeOrderGen(noticeOrderFacadeBo);
        this.assembleReceNoticeOrderParam(noticeOrderFacadeBo, adjustmentOrderEo, adjustmentOrderDetailEos);
        noticeOrderFacadeBo.setGenAdjustNotice(isProperty);
        this.baseOrderFacade.receiveNoticeOrderGen(noticeOrderFacadeBo);
    }

    private ReceiveDeliveryNoticeOrderFacadeBo assembleDeLeNoticeOrderParam(AdjustmentOrderEo adjustmentOrderEo, List<AdjustmentOrderDetailEo> adjustmentOrderDetailEos) {
        Map<Object, OrderUnitConversionRecordEo> unitConversionRecordDtoMap = this.getUnitConversionRecordDtoMap(adjustmentOrderEo.getAdjustmentNo());
        ReceiveDeliveryNoticeOrderFacadeBo noticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        noticeOrderFacadeBo.setRelevanceNo(adjustmentOrderEo.getAdjustmentNo());
        noticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.IN_ADJUSTMENT_ORDER);
        noticeOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.OUT_TO_ADJUST.getCode());
        noticeOrderFacadeBo.setLogicWarehouseCode(adjustmentOrderEo.getWarehouseCode());
        noticeOrderFacadeBo.setBusinessType(adjustmentOrderEo.getBusinessType());
        noticeOrderFacadeBo.setDisplayBusinessType(adjustmentOrderEo.getBusinessType());
        noticeOrderFacadeBo.setRemark(adjustmentOrderEo.getRemark());
        noticeOrderFacadeBo.setValidNegative(InventoryConfig.isCheckInventory());
        noticeOrderFacadeBo.setSendWms(YesNoEnum.YES.getValue().equals(adjustmentOrderEo.getPushWms()));
        noticeOrderFacadeBo.setBizDate(adjustmentOrderEo.getBizDate());
        noticeOrderFacadeBo.setExternalOrderNo(adjustmentOrderEo.getExternalOrderNo());
        ArrayList<BaseOrderDetailReqDto> orderDetailReqDtos = new ArrayList<BaseOrderDetailReqDto>();
        adjustmentOrderDetailEos.forEach(orderDetailEo -> {
            BaseOrderDetailReqDto baseOrderDetailReqDto = new BaseOrderDetailReqDto();
            OrderUnitConversionRecordEo unitEo = (OrderUnitConversionRecordEo)unitConversionRecordDtoMap.get(this.getKey(orderDetailEo.getSkuCode(), orderDetailEo.getChangeQuantity(), orderDetailEo.getUnit()));
            baseOrderDetailReqDto.setBatch((String)DataExtractUtils.ifNullElse((Object)orderDetailEo.getOrigBatch(), (Object)orderDetailEo.getBatch()));
            baseOrderDetailReqDto.setInventoryProperty(orderDetailEo.getInventoryProperty());
            baseOrderDetailReqDto.setPreOrderItemId(orderDetailEo.getId());
            baseOrderDetailReqDto.setSkuCode(orderDetailEo.getSkuCode());
            baseOrderDetailReqDto.setSkuName(orderDetailEo.getSkuName());
            baseOrderDetailReqDto.setProduceTime(orderDetailEo.getProduceTime());
            baseOrderDetailReqDto.setExpireTime(orderDetailEo.getExpireTime());
            baseOrderDetailReqDto.setQuantity(BeanUtil.isNotEmpty((Object)unitEo, (String[])new String[0]) ? unitEo.getToNum() : orderDetailEo.getChangeQuantity());
            orderDetailReqDtos.add(baseOrderDetailReqDto);
        });
        noticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(orderDetailReqDtos);
        return noticeOrderFacadeBo;
    }

    private void assembleReceNoticeOrderParam(ReceiveDeliveryNoticeOrderFacadeBo noticeOrderFacadeBo, AdjustmentOrderEo adjustmentOrderEo, List<AdjustmentOrderDetailEo> adjustmentOrderDetailEos) {
        Map<Object, OrderUnitConversionRecordEo> unitConversionRecordDtoMap = this.getUnitConversionRecordDtoMap(adjustmentOrderEo.getAdjustmentNo());
        noticeOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.OUT_TO_ADJUST.getCode());
        ArrayList<BaseOrderDetailReqDto> orderDetailReqDtos = new ArrayList<BaseOrderDetailReqDto>();
        adjustmentOrderDetailEos.forEach(orderDetailEo -> {
            OrderUnitConversionRecordEo unitEo = (OrderUnitConversionRecordEo)unitConversionRecordDtoMap.get(this.getKey(orderDetailEo.getSkuCode(), orderDetailEo.getChangeQuantity(), orderDetailEo.getUnit()));
            BaseOrderDetailReqDto baseOrderDetailReqDto = new BaseOrderDetailReqDto();
            baseOrderDetailReqDto.setBatch(orderDetailEo.getBatch());
            baseOrderDetailReqDto.setOldInventoryProperty(orderDetailEo.getInventoryProperty());
            baseOrderDetailReqDto.setInventoryProperty((String)DataExtractUtils.ifNullElse((Object)orderDetailEo.getNewInventoryProperty(), (Object)orderDetailEo.getInventoryProperty()));
            baseOrderDetailReqDto.setPreOrderItemId(orderDetailEo.getId());
            baseOrderDetailReqDto.setSkuCode(orderDetailEo.getSkuCode());
            baseOrderDetailReqDto.setSkuName(orderDetailEo.getSkuName());
            baseOrderDetailReqDto.setProduceTime(orderDetailEo.getProduceTime());
            baseOrderDetailReqDto.setExpireTime(orderDetailEo.getExpireTime());
            baseOrderDetailReqDto.setQuantity(BeanUtil.isNotEmpty((Object)unitEo, (String[])new String[0]) ? unitEo.getToNum() : orderDetailEo.getChangeQuantity());
            orderDetailReqDtos.add(baseOrderDetailReqDto);
        });
        noticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(orderDetailReqDtos);
    }

    private Map<Object, OrderUnitConversionRecordEo> getUnitConversionRecordDtoMap(String adjustmentNo) {
        return this.orderUnitConversionRecordService.getRecordByOrderNo(adjustmentNo).stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), o.getNum(), o.getUnit()), Function.identity(), (k1, k2) -> k1));
    }

    private Object getKey(String skuCode, BigDecimal num, String currentUnit) {
        return skuCode + InventoryConfig.getCommonSeparate() + num.setScale(6) + InventoryConfig.getCommonSeparate() + currentUnit;
    }
}

