/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.assemble.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.convert.entity.AssemblyDisassemblyOrderDetailConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IAssemblyDisassemblyOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AssemblyDisassemblyOrderDetailPageQueryReqDto;
import com.yunxi.dg.base.center.inventory.eo.AssemblyDisassemblyOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.assemble.IAssemblyDisassemblyOrderDetailService;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class AssemblyDisassemblyOrderDetailServiceImpl
extends BaseServiceImpl<AssemblyDisassemblyOrderDetailDto, AssemblyDisassemblyOrderDetailEo, IAssemblyDisassemblyOrderDetailDomain>
implements IAssemblyDisassemblyOrderDetailService {
    @Resource
    protected IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    protected IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;

    public AssemblyDisassemblyOrderDetailServiceImpl(IAssemblyDisassemblyOrderDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<AssemblyDisassemblyOrderDetailDto, AssemblyDisassemblyOrderDetailEo> converter() {
        return AssemblyDisassemblyOrderDetailConverter.INSTANCE;
    }

    @Override
    public PageInfo<AssemblyDisassemblyOrderDetailDto> page(AssemblyDisassemblyOrderDetailPageQueryReqDto dto) {
        AssemblyDisassemblyOrderDetailEo queryDto = (AssemblyDisassemblyOrderDetailEo)BeanCopyUtil.copy((Object)dto, AssemblyDisassemblyOrderDetailEo.class);
        PageInfo pageInfo = ((IAssemblyDisassemblyOrderDetailDomain)this.domain).selectPage((BaseEo)queryDto, dto.getPageNum(), dto.getPageSize());
        PageInfo returnPageInfo = new PageInfo();
        BeanCopyUtil.copyProperties((Object)pageInfo, (Object)returnPageInfo);
        if (pageInfo.getSize() > 0) {
            returnPageInfo.setList(this.converter().toDtoList(pageInfo.getList()));
        }
        this.assemblyRespPageData(dto.getOrderNo(), (PageInfo<AssemblyDisassemblyOrderDetailDto>)returnPageInfo);
        return returnPageInfo;
    }

    public void assemblyRespPageData(String orderNo, PageInfo<AssemblyDisassemblyOrderDetailDto> returnPageInfo) {
        if (returnPageInfo == null || CollectionUtils.isEmpty((Collection)returnPageInfo.getList())) {
            return;
        }
        List<String> skuCodes = returnPageInfo.getList().stream().filter(x -> x.getType() == 0).map(AssemblyDisassemblyOrderDetailDto::getSkuCode).collect(Collectors.toList());
        HashMap<String, Long> skuMap = new HashMap<String, Long>();
        if (CollectionUtil.isNotEmpty(skuCodes)) {
            List dtoList = this.itemDataQueryHelper.getByCodes(skuCodes);
            skuMap.putAll(dtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, ItemSkuDto::getId, (o1, o2) -> o1)));
        }
        HashMap<String, BigDecimal> skuCode2NumMap = new HashMap<String, BigDecimal>();
        List inOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)orderNo)).eq((Object)"order_type", (Object)BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY.getCode().toLowerCase())).list();
        if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEoList)) {
            InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
            skuCode2NumMap.putAll(((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo())).list().stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getSkuCode, InOutNoticeOrderDetailEo::getDoneQuantity)));
        }
        List<String> codes = returnPageInfo.getList().stream().map(AssemblyDisassemblyOrderDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        Map<String, ItemSkuDto> itemSkuDgRespDtoMap = this.getItemSkuDgRespDto(codes);
        for (AssemblyDisassemblyOrderDetailDto detailDto : returnPageInfo.getList()) {
            if (detailDto.getType() == 0) {
                detailDto.setSkuId((Long)skuMap.get(detailDto.getSkuCode()));
            }
            detailDto.setPlanQuantity(detailDto.getQuantity());
            detailDto.setDoneQuantity(Integer.valueOf(skuCode2NumMap.getOrDefault(detailDto.getSkuCode(), BigDecimal.ZERO).intValueExact()));
            detailDto.setDispatcherQuantity(Integer.valueOf(Math.subtractExact(detailDto.getPlanQuantity(), detailDto.getDoneQuantity())));
            if (!itemSkuDgRespDtoMap.containsKey(detailDto.getSkuCode())) continue;
            ItemSkuDto itemSkuDgRespDto = itemSkuDgRespDtoMap.get(detailDto.getSkuCode());
            detailDto.setBarCode(Objects.nonNull(itemSkuDgRespDto) ? itemSkuDgRespDto.getBarCode() : null);
        }
    }

    private Map<String, ItemSkuDto> getItemSkuDgRespDto(List<String> skuCodes) {
        HashMap skuDgRespDtoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skuCodes)) {
            List itemSkuDgRespDtos;
            int length;
            int i = 0;
            for (length = skuCodes.size(); length > 1000; length -= 1000) {
                itemSkuDgRespDtos = this.itemDataQueryHelper.getByCodes(skuCodes.subList(i, i + 1000));
                if (CollectionUtils.isNotEmpty(itemSkuDgRespDtos)) {
                    skuDgRespDtoMap.putAll(itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (k1, k2) -> k2)));
                }
                i += 1000;
            }
            if (length > 0 && CollectionUtils.isNotEmpty(itemSkuDgRespDtos = this.itemDataQueryHelper.getByCodes(skuCodes.subList(i, i + length)))) {
                skuDgRespDtoMap.putAll(itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (k1, k2) -> k2)));
            }
        }
        return skuDgRespDtoMap;
    }
}

