/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.enums;

import com.google.common.collect.Lists;
import java.util.List;

public enum AssemblyDisassemblyOrderStatusEnum {
    WAIT_SUBMIT("wait_submit", "\u5f85\u63d0\u4ea4"),
    WAIT_AUDIT("wait_audit", "\u5f85\u5ba1\u6838"),
    AUDIT_FAIL("audit_fail", "\u5ba1\u6838\u4e0d\u901a\u8fc7"),
    CANCELED("canceled", "\u5df2\u53d6\u6d88"),
    FINISHED("finished", "\u5df2\u5b8c\u6210"),
    COMPLETED("completed", "\u5df2\u5b8c\u7ed3"),
    PROCESSING("processing", "\u52a0\u5de5\u4e2d"),
    PORTION_PROCESSING("portion_processing", "\u90e8\u5206\u52a0\u5de5\u4e2d");

    private String key;
    private String desc;
    private static List<String> code2ProcessList;

    private AssemblyDisassemblyOrderStatusEnum(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public String getKey() {
        return this.key;
    }

    public String getDesc() {
        return this.desc;
    }

    public static AssemblyDisassemblyOrderStatusEnum getByKey(String key) {
        for (AssemblyDisassemblyOrderStatusEnum statusEnum : AssemblyDisassemblyOrderStatusEnum.values()) {
            if (!statusEnum.getKey().equals(key)) continue;
            return statusEnum;
        }
        throw new RuntimeException("enum not exists.");
    }

    public static boolean isProcessing(String key) {
        return PROCESSING.getKey().equalsIgnoreCase(key);
    }

    public static boolean isWaitAudit(String key) {
        return WAIT_AUDIT.getKey().equals(key);
    }

    public static boolean canProcess(String key) {
        return code2ProcessList.contains(key);
    }

    static {
        code2ProcessList = Lists.newArrayList((Object[])new String[]{PROCESSING.getKey(), PORTION_PROCESSING.getKey()});
    }
}

