/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.difforder;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsPcpBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.enums.MergeStrategyConfigStatusEnum;
import com.yunxi.dg.base.center.enums.PcpBasicInventoryBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.TransferOrderEnum;
import com.yunxi.dg.base.center.inventory.constants.SourceSystemEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.OrderUnitConversionRecordConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IAutoTransferConfigDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderStrategyDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.bussiness.CsDisPatcherOrderEnum;
import com.yunxi.dg.base.center.inventory.dto.bussiness.CsTransferDispatcherHandleStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.bussiness.CsTransferDispatcherStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderAuditReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.AutoTransferConfigEo;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderEo;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderStrategyEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.DiffOrderOptContext;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.DispatchOperateBo;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.DispatcherOperateWayEnum;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.IDiffOrderOptAble;
import com.yunxi.dg.base.center.inventory.service.business.transfer.ITransferOrderService;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class DiffOrderOptAbleImpl
implements IDiffOrderOptAble {
    private static final Logger log = LoggerFactory.getLogger(DiffOrderOptAbleImpl.class);
    @Autowired
    public IDispatcherOrderStrategyDomain dispatcherOrderStrategyDomain;
    @Autowired
    public ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    public IRelWarehouseDomain relWarehouseDomain;
    @Autowired
    BaseOrderFacade baseOrderFacade;
    @Autowired
    ITransferOrderService transferOrderService;
    @Autowired
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    private TransactionCallBackService transactionCallBackService;
    @Autowired
    private ICalcInventoryService calcInventoryService;
    @Autowired
    IDispatcherOrderDetailDomain dispatcherOrderDetailDomain;
    @Autowired
    IDispatcherOrderDomain dispatcherOrderDomain;
    @Autowired
    IAutoTransferConfigDomain autoTransferConfigDomain;
    @Autowired
    private ITransferOrderDomain transferOrderDomain;
    @Autowired
    private IBaseOrderAddressDomain baseOrderAddressDomain;
    @Autowired
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Autowired
    public IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    private IContext context;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;

    public DiffOrderOptAbleImpl() {
        log.info("\u521d\u59cb\u5316");
    }

    public DiffOrderOptAbleImpl(IDispatcherOrderStrategyDomain dispatcherOrderStrategyDomain, ILogicWarehouseDomain logicWarehouseDomain, IRelWarehouseDomain relWarehouseDomain, BaseOrderFacade baseOrderFacade, ITransferOrderService transferOrderService, IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain, IInOutNoticeOrderDomain inOutNoticeOrderDomain, TransactionCallBackService transactionCallBackService, ICalcInventoryService calcInventoryService, IDispatcherOrderDetailDomain dispatcherOrderDetailDomain, IDispatcherOrderDomain dispatcherOrderDomain, IAutoTransferConfigDomain autoTransferConfigDomain, ITransferOrderDomain transferOrderDomain, IPhysicsWarehouseDomain physicsWarehouseDomain) {
        this.dispatcherOrderStrategyDomain = dispatcherOrderStrategyDomain;
        this.logicWarehouseDomain = logicWarehouseDomain;
        this.relWarehouseDomain = relWarehouseDomain;
        this.baseOrderFacade = baseOrderFacade;
        this.transferOrderService = transferOrderService;
        this.receiveDeliveryNoticeOrderDomain = receiveDeliveryNoticeOrderDomain;
        this.inOutNoticeOrderDomain = inOutNoticeOrderDomain;
        this.transactionCallBackService = transactionCallBackService;
        this.calcInventoryService = calcInventoryService;
        this.dispatcherOrderDetailDomain = dispatcherOrderDetailDomain;
        this.dispatcherOrderDomain = dispatcherOrderDomain;
        this.autoTransferConfigDomain = autoTransferConfigDomain;
        this.transferOrderDomain = transferOrderDomain;
        this.physicsWarehouseDomain = physicsWarehouseDomain;
    }

    @Override
    public void handle(DispatchOperateBo dispatchOperateBo) {
        log.info("\u5f00\u59cb\u5224\u5b9a\u5e93\u5b58\u81ea\u52a8\u5b8c\u6210\u7684\u914d\u7f6e\u9879dispatchOperateBo:{}", (Object)JSONObject.toJSONString((Object)dispatchOperateBo));
        this.checkConfigStrategy(dispatchOperateBo, dispatchOperateBo.getOriginalTransferOrderEo().getType());
        this.judgeAutoFinish(dispatchOperateBo);
        log.info("\u662f\u5426\u547d\u4e2d\u4e86\u5e93\u5b58\u81ea\u52a8\u5b8c\u6210\u7684\u914d\u7f6e\u9879dispatchOperateBo:{}", (Object)JSONObject.toJSONString((Object)dispatchOperateBo));
        switch (dispatchOperateBo.getDispatcherOperateWayEnum()) {
            case LESS_RETURN_TRANSFER: {
                this.lessReturnTransfer(dispatchOperateBo);
                break;
            }
            case LESS_TRANSFER: {
                dispatchOperateBo.setAutoFinish(Boolean.TRUE);
                this.lessTransfer(dispatchOperateBo);
                break;
            }
            case MORE_TRANSFER: {
                this.moreTransfer(dispatchOperateBo);
                break;
            }
            case LESS_AGAIN_RECEIVE: 
            case LESS_REPAIR_RECEIVE: {
                this.lessInWarehouseAndSendWms(dispatchOperateBo);
                break;
            }
            case MORE_TRANSFER_NONEED_RECEIVE: {
                this.moreInWarehouseSendWms(dispatchOperateBo);
                break;
            }
            case LESS_NOT_REPAIR_RECEIVE: {
                this.lessNotRepairInWarehouse(dispatchOperateBo);
                break;
            }
        }
        if (Objects.nonNull(dispatchOperateBo.getCsTransferOrderRespDto())) {
            String transferOrderNo = dispatchOperateBo.getCsTransferOrderRespDto().getTransferOrderNo();
            DispatcherOrderDetailEo eo = new DispatcherOrderDetailEo();
            eo.setBusinessNo(transferOrderNo);
            List ids = dispatchOperateBo.getDispatcherOrderDetailEos().stream().map(BaseEo::getId).collect(Collectors.toList());
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id", ids);
            this.dispatcherOrderDetailDomain.getMapper().update((Object)eo, (Wrapper)updateWrapper);
            this.dispatcherOrderDetailDomain.updateDispatcherProcessingQuantityByIds(ids);
        }
        DispatcherOrderEo eo = dispatchOperateBo.getEo();
        List dispatcherOrderDetailEos = this.dispatcherOrderDetailDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"order_status", (Object)CsDisPatcherOrderEnum.Status.WAIT.getCode())).eq((Object)"order_no", (Object)dispatchOperateBo.getEo().getOrderNo()));
        BigDecimal reduce = dispatcherOrderDetailEos.stream().map(DispatcherOrderDetailEo::getProcessedQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        TransferOrderEo transferOrder = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)eo.getTransferOrderNo())).one();
        if (dispatchOperateBo.getEo().getTotalQuantity().compareTo(reduce) == 0) {
            eo.setOrderStatus(CsDisPatcherOrderEnum.Status.FINISH.getCode());
            transferOrder.setDispatcherHandleStatus(CsTransferDispatcherHandleStatusEnum.PROCESSED.getCode());
        } else {
            eo.setOrderStatus(CsDisPatcherOrderEnum.Status.PORTION_WAIT.getCode());
            transferOrder.setDispatcherHandleStatus(CsTransferDispatcherHandleStatusEnum.PORTION_PENGDING.getCode());
        }
        String certificate = Objects.nonNull(dispatchOperateBo.getDispatcherOrderReqDto()) && CollectionUtils.isNotEmpty((Collection)dispatchOperateBo.getDispatcherOrderReqDto().getCertificateList()) ? StringUtils.join((Iterable)dispatchOperateBo.getDispatcherOrderReqDto().getCertificateList(), (String)",") : "";
        eo.setCertificate(certificate);
        this.dispatcherOrderDomain.updateSelective((BaseEo)eo);
        List dispatcherOrderEos = ((ExtQueryChainWrapper)this.dispatcherOrderDomain.filter().eq((Object)"transfer_order_no", (Object)eo.getTransferOrderNo())).list();
        if (dispatcherOrderEos.size() > 1) {
            DispatcherOrderEo otherDispatcherOrderEo = (DispatcherOrderEo)dispatcherOrderEos.stream().filter(e -> !e.getOrderNo().equals(eo.getOrderNo())).collect(Collectors.toList()).get(0);
            log.info("otherDispatcherOrderEo:{}", (Object)JSON.toJSONString((Object)otherDispatcherOrderEo));
            if (CsDisPatcherOrderEnum.Status.FINISH.getCode().equals(eo.getOrderStatus()) && !CsDisPatcherOrderEnum.Status.FINISH.getCode().equals(otherDispatcherOrderEo.getOrderStatus()) && !CsDisPatcherOrderEnum.Status.CLOSE.getCode().equals(otherDispatcherOrderEo.getOrderStatus())) {
                transferOrder.setDispatcherHandleStatus(CsTransferDispatcherHandleStatusEnum.PORTION_PENGDING.getCode());
            }
        }
        log.info("\u6536\u53d1\u5dee\u5f02\u56de\u5199\u8c03\u62e8\u5355\u72b6\u6001:dispatcherOrderDetailEos:{}", (Object)JSON.toJSONString((Object)dispatcherOrderDetailEos));
        this.transferOrderDomain.update((BaseEo)transferOrder);
        DiffOrderOptContext.getCurCallBack(InventoryConfig.getProjectCode()).afterCallback(dispatchOperateBo);
    }

    private void checkConfigStrategy(DispatchOperateBo dispatchOperateBo, String type) {
        DispatcherOrderStrategyEo dispatcherOrderStrategyEo = (DispatcherOrderStrategyEo)((ExtQueryChainWrapper)this.dispatcherOrderStrategyDomain.filter().eq((Object)"transfer_order_type", (Object)type)).one();
        AssertUtils.notNull((Object)dispatcherOrderStrategyEo, (String)"\u5f53\u524d\u8c03\u62e8\u7c7b\u578b\u672a\u914d\u7f6e\u5904\u7406\u7b56\u7565");
        dispatchOperateBo.setStrategyEo(dispatcherOrderStrategyEo);
    }

    private void judgeAutoFinish(DispatchOperateBo dispatchOperateBo) {
        if (!dispatchOperateBo.getIsAutoFinish().booleanValue()) {
            String warehouseCode = this.isSetOutWarehouse(dispatchOperateBo.getDispatcherOperateWayEnum()) ? dispatchOperateBo.getEo().getOutPhysicsWarehouseCode() : dispatchOperateBo.getEo().getInPhysicsWarehouseCode();
            List physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(warehouseCode);
            PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)physicsWarehouseEos.get(0);
            dispatchOperateBo.setInterconnectionFlag(physicsWarehouseEo.getInterconnectionFlag());
            if (0 == physicsWarehouseEo.getInterconnectionFlag()) {
                dispatchOperateBo.setAutoFinish(Boolean.TRUE);
                return;
            }
            AutoTransferConfigEo autoTransferConfigEo = new AutoTransferConfigEo();
            autoTransferConfigEo.setWarehouseCode(physicsWarehouseEo.getEntitySystemCode());
            List autoTransferConfigEos = this.autoTransferConfigDomain.selectList((BaseEo)autoTransferConfigEo);
            if (CollectionUtils.isNotEmpty((Collection)autoTransferConfigEos) && MergeStrategyConfigStatusEnum.YES.getCode().equals(((AutoTransferConfigEo)autoTransferConfigEos.get(0)).getStatus())) {
                dispatchOperateBo.setAutoFinish(Boolean.TRUE);
            }
        }
    }

    protected void updateDispatcherProcessingQuantityByIds(DispatchOperateBo dispatchOperateBo) {
        if (!dispatchOperateBo.getIsAutoFinish().booleanValue()) {
            return;
        }
        List ids = dispatchOperateBo.getDispatcherOrderDetailEos().stream().map(BaseEo::getId).collect(Collectors.toList());
        this.dispatcherOrderDetailDomain.updateDispatcherProcessingQuantityByIds(ids);
    }

    @Override
    public void moreInWarehouseSendWms(DispatchOperateBo dispatchOperateBo) {
        this.sendMessageWms(dispatchOperateBo);
        this.updateDispatcherProcessingQuantityByIds(dispatchOperateBo);
    }

    @Override
    public void lessReturnTransfer(DispatchOperateBo dispatchOperateBo) {
        this.sendMessageWms(dispatchOperateBo);
        this.generateDeliveryNoticeOrder(dispatchOperateBo, dispatchOperateBo.getEo(), dispatchOperateBo.getDispatcherOrderDetailEos());
        dispatchOperateBo.setCsTransferOrderRespDto(this.addTransferAndGenerateBaseOrder(dispatchOperateBo, dispatchOperateBo.getStrategyEo().getLessReturnTargetTransferOrderType()));
    }

    @Override
    public void lessTransfer(DispatchOperateBo dispatchOperateBo) {
        this.generateDeliveryNoticeOrder(dispatchOperateBo, dispatchOperateBo.getEo(), dispatchOperateBo.getDispatcherOrderDetailEos());
        dispatchOperateBo.setCsTransferOrderRespDto(this.lessTransferAddTransferAndGenerateBaseOrder(dispatchOperateBo, dispatchOperateBo.getStrategyEo().getLessTargetTransferOrderType()));
    }

    @Override
    public void lessInWarehouse(DispatchOperateBo dispatchOperateBo) {
        dispatchOperateBo.setCsTransferOrderRespDto(this.lessInWarehouseAndSendWms(dispatchOperateBo));
    }

    @Override
    public void moreTransfer(DispatchOperateBo dispatchOperateBo) {
        this.sendMessageWms(dispatchOperateBo);
        dispatchOperateBo.setCsTransferOrderRespDto(this.addTransferAndGenerateBaseOrder(dispatchOperateBo, dispatchOperateBo.getStrategyEo().getMoreTargetTransferOrderType()));
    }

    protected void sendMessageWms(DispatchOperateBo dispatchOperateBo) {
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext;
        log.info("\u53d1\u9001wms\u6d88\u606fdispatchOperateBo\uff1a\u3010{}\u3011", (Object)JSON.toJSONString((Object)dispatchOperateBo));
        if (!dispatchOperateBo.getIsTransferWms().booleanValue() || 0 == dispatchOperateBo.getInterconnectionFlag()) {
            return;
        }
        DispatcherOrderEo eo = dispatchOperateBo.getEo();
        List<DispatcherOrderDetailEo> dispatcherOrderDetailEos = dispatchOperateBo.getDispatcherOrderDetailEos();
        boolean isMore = CsTransferDispatcherStatusEnum.MORE_DISPATCHER.equals((Object)dispatchOperateBo.getDispatcherOperateWayEnum().getType());
        String type = isMore ? PcpBasicInventoryBusinessTypeEnum.EXCHANGE_ORDER_OUT.getCode() : PcpBasicInventoryBusinessTypeEnum.EXCHANGE_ORDER_IN.getCode();
        ReceiveDeliveryNoticeOrderFacadeBo csBasicsOrderReqDto = new ReceiveDeliveryNoticeOrderFacadeBo();
        CubeBeanUtils.copyProperties((Object)csBasicsOrderReqDto, (Object)eo, (String[])new String[]{"id"});
        csBasicsOrderReqDto.setUpdateInventory(false);
        csBasicsOrderReqDto.setPreOrderNo(null);
        csBasicsOrderReqDto.setExternalOrderNo(dispatchOperateBo.getOriginalTransferOrderEo().getPreOrderNo());
        csBasicsOrderReqDto.setDisplayBusinessType(type);
        csBasicsOrderReqDto.setRelevanceNo(eo.getOrderNo());
        csBasicsOrderReqDto.setBusinessType(type);
        csBasicsOrderReqDto.setRemark(this.getRemark(dispatchOperateBo));
        csBasicsOrderReqDto.setRelevanceTableName(CsRelevanceTableNameEnum.IN_DISPATCHER_ORDER);
        if (this.isSetOutWarehouse(dispatchOperateBo.getDispatcherOperateWayEnum())) {
            csBasicsOrderReqDto.setLogicWarehouseCode(eo.getOutLogicWarehouseCode());
            csBasicsOrderReqDto.setLogicWarehouseName(eo.getOutLogicWarehouseName());
            csBasicsOrderReqDto.setPhysicsWarehouseCode(eo.getOutPhysicsWarehouseCode());
            csBasicsOrderReqDto.setPhysicsWarehouseName(eo.getOutPhysicsWarehouseName());
        } else {
            csBasicsOrderReqDto.setLogicWarehouseCode(eo.getInLogicWarehouseCode());
            csBasicsOrderReqDto.setLogicWarehouseName(eo.getInLogicWarehouseName());
            csBasicsOrderReqDto.setPhysicsWarehouseCode(eo.getInPhysicsWarehouseCode());
            csBasicsOrderReqDto.setPhysicsWarehouseName(eo.getInPhysicsWarehouseName());
        }
        csBasicsOrderReqDto.setBaseOrderAddressEoList(((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().eq((Object)"document_no", (Object)dispatchOperateBo.getOriginalTransferOrderEo().getTransferOrderNo())).list());
        csBasicsOrderReqDto.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                context.setSendWms(true);
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
                context.setCallBack(DiffOrderOptAbleImpl.this.getInNoticeCallBack(true));
                context.setTransparentCallback(true);
            }
        });
        csBasicsOrderReqDto.setOrderBasicsDetailReqDtoList(dispatcherOrderDetailEos.stream().map(re -> {
            BaseOrderDetailReqDto basic = (BaseOrderDetailReqDto)((Object)((Object)BeanUtil.copyProperties((Object)re, BaseOrderDetailReqDto.class, (String[])new String[]{"id"})));
            basic.setQuantity(re.getDispatcherQuantity());
            return basic;
        }).collect(Collectors.toList()));
        if (isMore) {
            receiveDeliveryNoticeOrderContext = this.baseOrderFacade.deliveryNoticeOrderGen(csBasicsOrderReqDto);
            if (DispatcherOperateWayEnum.MORE_TRANSFER.equals((Object)dispatchOperateBo.getDispatcherOperateWayEnum())) {
                this.preemptLogicInventory(receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderDetailEoList(), receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo());
            }
        } else {
            receiveDeliveryNoticeOrderContext = this.baseOrderFacade.receiveNoticeOrderGen(csBasicsOrderReqDto);
        }
        String documentNo = receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo().getDocumentNo();
        dispatcherOrderDetailEos.forEach(detail -> {
            detail.setDeliveryNoticeNo(documentNo);
            this.dispatcherOrderDetailDomain.update((BaseEo)detail);
        });
        if (dispatchOperateBo.getAutoFinish().booleanValue()) {
            log.info("\u662f\u5426\u9700\u8981\u7b49wms\u56de\u4f20,isAutoFinish:{}", (Object)dispatchOperateBo.getAutoFinish());
            ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)documentNo)).one();
            deliveryNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.FINISH_OVER.getCode());
            this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)deliveryNoticeOrderEo);
            List inOutNoticeOrderEoList = this.inOutNoticeOrderDomain.queryByPreOrderNo(documentNo);
            InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
            inOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.FINISH_OVER.getCode());
            this.inOutNoticeOrderDomain.updateSelective((BaseEo)inOutNoticeOrderEo);
            List dispatcherOrderDetailEoList = this.dispatcherOrderDetailDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"order_status", (Object)CsDisPatcherOrderEnum.Status.WAIT.getCode())).eq((Object)"delivery_notice_no", (Object)inOutNoticeOrderEo.getPreOrderNo()));
            if (DispatcherOperateWayEnum.MORE_TRANSFER.getCode().equals(((DispatcherOrderDetailEo)dispatcherOrderDetailEoList.get(0)).getOperationWay())) {
                ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
                releasePreemptDto.setSourceNo(deliveryNoticeOrderEo.getDocumentNo());
                releasePreemptDto.setSourceType(deliveryNoticeOrderEo.getRelevanceTableName());
                releasePreemptDto.setBusinessType(deliveryNoticeOrderEo.getBusinessType());
                this.calcInventoryService.releasePreempt(releasePreemptDto);
            }
        }
    }

    private boolean isSetOutWarehouse(DispatcherOperateWayEnum dispatcherOperateWayEnum) {
        switch (dispatcherOperateWayEnum) {
            case LESS_AGAIN_RECEIVE: 
            case LESS_REPAIR_RECEIVE: 
            case MORE_TRANSFER_NONEED_RECEIVE: {
                return false;
            }
        }
        return true;
    }

    public CsTransferOrderRespDto auditTransfer(Long id, String orderNo) {
        TransferOrderAuditReqDto dto = new TransferOrderAuditReqDto();
        dto.setAuditResult("audit_pass");
        dto.setRemark("\u6536\u53d1\u5dee\u5f02\u5904\u7406\u5355\u53f7" + orderNo);
        dto.setTransferOrderNos((List)Lists.newArrayList((Object[])new String[]{orderNo}));
        dto.setVirtualOrderAutoComplete(Boolean.valueOf(true));
        this.transferOrderService.audit(dto);
        if (InventoryConfig.isCanSecondLevel()) {
            this.transferOrderService.audit(dto);
        }
        return (CsTransferOrderRespDto)BeanUtil.copyProperties((Object)this.transferOrderDomain.selectByPrimaryKey(id), CsTransferOrderRespDto.class, (String[])new String[0]);
    }

    private void wrapperTransferOrder(DispatchOperateBo dispatchOperateBo, TransferOrderComboReqDto reqDto, TransferOrderReqDto transferOrderReqDto) {
        transferOrderReqDto.setPlanInTime(new Date());
        transferOrderReqDto.setPlanOutTime(new Date());
        TransferOrderEo originalTransferOrderEo = dispatchOperateBo.getOriginalTransferOrderEo();
        transferOrderReqDto.setSourceSystem(SourceSystemEnum.PCP.getCode());
        transferOrderReqDto.setPreOrderNo(dispatchOperateBo.getEo().getOrderNo());
        transferOrderReqDto.setExternalOrderNo(dispatchOperateBo.getEo().getOrderNo());
        transferOrderReqDto.setBizDate(originalTransferOrderEo.getBizDate());
        transferOrderReqDto.setIsVirtual(Integer.valueOf(1));
        transferOrderReqDto.setRemark("\u6536\u53d1\u5dee\u5f02\u5904\u7406\u5355\u53f7:" + dispatchOperateBo.getEo().getOrderNo());
        transferOrderReqDto.setInOrganizationCode(originalTransferOrderEo.getInOrganizationCode());
        transferOrderReqDto.setOutOrganizationCode(originalTransferOrderEo.getOutOrganizationCode());
        transferOrderReqDto.setOrderType(dispatchOperateBo.getOriginalTransferOrderEo().getOrderType());
        reqDto.setTransferOrderReqDto(transferOrderReqDto);
        this.context.userName(originalTransferOrderEo.getCreatePerson());
        Map map = this.orderUnitConversionRecordService.getRecordByOrderNo(dispatchOperateBo.getEo().getOrderNo()).stream().map(arg_0 -> ((OrderUnitConversionRecordConverter)OrderUnitConversionRecordConverter.INSTANCE).toDto(arg_0)).collect(Collectors.toMap(OrderUnitConversionRecordDto::getSkuCode, Function.identity(), (o, o1) -> o));
        List list = dispatchOperateBo.getDispatcherOrderDetailEos().stream().map(o -> {
            TransferOrderDetailReqDto detailReqDto = new TransferOrderDetailReqDto();
            BeanUtils.copyProperties((Object)o, (Object)detailReqDto, (String[])new String[]{"id"});
            detailReqDto.setSkuCode(o.getSkuCode());
            detailReqDto.setLongCode(o.getSkuCode());
            detailReqDto.setBatch(o.getBatch());
            detailReqDto.setSkuName(o.getSkuName());
            String join = o.getSkuCode();
            if (map.containsKey(join)) {
                OrderUnitConversionRecordDto orderUnitConversionRecordDto = (OrderUnitConversionRecordDto)map.get(join);
                detailReqDto.setQuantity(UnitTransferUtils.pareSaleNum((BigDecimal)o.getDispatcherQuantity(), (OrderUnitConversionRecordDto)orderUnitConversionRecordDto, (boolean)false));
                detailReqDto.setUnit(orderUnitConversionRecordDto.getUnit());
            }
            return detailReqDto;
        }).collect(Collectors.toList());
        reqDto.setDetailList(list);
    }

    protected CsTransferOrderRespDto internalLogicTransfer(DispatchOperateBo dispatchOperateBo) {
        log.info("\u5f00\u59cb\u8fdb\u884c\u5185\u90e8\u79fb\u5e93\uff08\u540c\u4e3b\u4f53\uff09\u5904\u7406");
        TransferOrderComboReqDto reqDto = new TransferOrderComboReqDto();
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setBizDate(dispatchOperateBo.getEo().getBizDate());
        transferOrderReqDto.setType(CsInventorySourceTypeEnum.INTERNAL_LOGIC_TRANSFER.getCode());
        this.setWarehouse(dispatchOperateBo, transferOrderReqDto);
        this.createTransfer(dispatchOperateBo, reqDto, transferOrderReqDto);
        Long aLong = (Long)this.transferOrderService.add(reqDto).getData();
        return this.auditTransfer(aLong, dispatchOperateBo.getEo().getOrderNo());
    }

    protected CsTransferOrderRespDto lessTransferAddTransferAndGenerateBaseOrder(DispatchOperateBo dispatchOperateBo, String type) {
        log.info("\u5c11\u6536\u8d70\u8c03\u62e8\u7406\u8d54\u4ed3\u7c7b\u578b-\u65b0\u589e\u8c03\u62e8\u5355\u5e76\u751f\u6210\u516b\u4e2a\u57fa\u7840\u5355\u636edispatchOperateBo:{},type:{}", (Object)JSON.toJSONString((Object)dispatchOperateBo), (Object)type);
        if (!dispatchOperateBo.getIsAutoFinish().booleanValue()) {
            return null;
        }
        Map<String, List<DispatcherOrderDetailEo>> map = dispatchOperateBo.getDispatcherOrderDetailEos().stream().collect(Collectors.groupingBy(DispatcherOrderDetailEo::getWarehouseCode));
        log.info("\u6839\u636e\u6536\u53d1\u5dee\u5f02\u660e\u7ec6\u7406\u8d54\u4ed3\u5206\u7ec4map\uff1a{}", (Object)JSON.toJSONString(map));
        DispatcherOrderEo eo = dispatchOperateBo.getEo();
        Long aLong = 0L;
        for (Map.Entry<String, List<DispatcherOrderDetailEo>> entry : map.entrySet()) {
            String inWarehouseCode = entry.getKey();
            TransferOrderComboReqDto reqDto = new TransferOrderComboReqDto();
            TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
            transferOrderReqDto.setBizDate(dispatchOperateBo.getEo().getBizDate());
            transferOrderReqDto.setType(type);
            this.setClaimsWarehouse(eo, inWarehouseCode, transferOrderReqDto);
            CsTransferOrderRespDto transferOrderRespDto = this.addTransferAndGenerateBaseOrder(dispatchOperateBo, reqDto, transferOrderReqDto);
            aLong = transferOrderRespDto.getId();
        }
        return (CsTransferOrderRespDto)BeanUtil.copyProperties((Object)this.transferOrderDomain.selectByPrimaryKey(aLong), CsTransferOrderRespDto.class, (String[])new String[0]);
    }

    private void setClaimsWarehouse(DispatcherOrderEo eo, String inWarehouseCode, TransferOrderReqDto transferOrderReqDto) {
        List eos = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inWarehouseCode)).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)eos), (String)"\u627e\u4e0d\u5230\u7406\u8d54\u4ed3\u4fe1\u606f");
        LogicWarehouseEo inLogicWarehouseEo = (LogicWarehouseEo)eos.get(0);
        List relWarehouseEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inWarehouseCode)).eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode())).list();
        transferOrderReqDto.setOutLogicWarehouseCode(eo.getInLogicWarehouseCode());
        transferOrderReqDto.setOutLogicWarehouseName(eo.getInLogicWarehouseName());
        transferOrderReqDto.setOutPhysicsWarehouseCode(eo.getInPhysicsWarehouseCode());
        transferOrderReqDto.setOutOrganizationId(eo.getOutOrganizationId());
        transferOrderReqDto.setOutOrganization(eo.getOutOrganization());
        transferOrderReqDto.setInOrganizationId(eo.getInOrganizationId());
        transferOrderReqDto.setInOrganization(eo.getInOrganization());
        transferOrderReqDto.setInLogicWarehouseCode(inLogicWarehouseEo.getWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(inLogicWarehouseEo.getWarehouseName());
        if (CollectionUtils.isNotEmpty((Collection)relWarehouseEoList)) {
            transferOrderReqDto.setInPhysicsWarehouseCode(((RelWarehouseEo)relWarehouseEoList.get(0)).getRefWarehouseCode());
        }
    }

    protected CsTransferOrderRespDto addTransferAndGenerateBaseOrder(DispatchOperateBo dispatchOperateBo, String type) {
        if (!dispatchOperateBo.getIsAutoFinish().booleanValue()) {
            return null;
        }
        log.info("\u6839\u636e\u7c7b\u578b\u65b0\u589e\u8c03\u62e8\u5355\u5e76\u751f\u6210\u516b\u4e2a\u57fa\u7840\u5355\u636edispatchOperateBo:{},type:{}", (Object)JSON.toJSONString((Object)dispatchOperateBo), (Object)type);
        TransferOrderComboReqDto reqDto = new TransferOrderComboReqDto();
        reqDto.setCommitType("COMMIT");
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setBizDate(dispatchOperateBo.getEo().getBizDate());
        transferOrderReqDto.setType(type);
        if (dispatchOperateBo.getDispatcherOperateWayEnum() == DispatcherOperateWayEnum.MORE_TRANSFER) {
            this.setWarehouse(transferOrderReqDto, dispatchOperateBo.getEo());
        } else {
            this.setWarehouseDefault(transferOrderReqDto, dispatchOperateBo.getEo());
        }
        return this.addTransferAndGenerateBaseOrder(dispatchOperateBo, reqDto, transferOrderReqDto);
    }

    private CsTransferOrderRespDto addTransferAndGenerateBaseOrder(DispatchOperateBo dispatchOperateBo, TransferOrderComboReqDto reqDto, TransferOrderReqDto transferOrderReqDto) {
        this.createTransfer(dispatchOperateBo, reqDto, transferOrderReqDto);
        Long aLong = (Long)this.transferOrderService.add(reqDto).getData();
        TransferOrderEo transferOrderEo = (TransferOrderEo)this.transferOrderDomain.selectByPrimaryKey(aLong);
        this.auditTransfer(aLong, transferOrderEo.getTransferOrderNo());
        this.transferOrderDomain.updateStatusById(aLong, TransferOrderStatus.END.code(), "\u6536\u53d1\u5dee\u5f02\u5904\u7406\u5355\u53f7\uff1a" + dispatchOperateBo.getEo().getOrderNo());
        this.transferOrderDetailDomain.statisticsDispatcherByTransferOrderNo(transferOrderEo.getTransferOrderNo(), true, InventoryConfig.isDispatchOrderBatch());
        return (CsTransferOrderRespDto)BeanUtil.copyProperties((Object)this.transferOrderDomain.selectByPrimaryKey(aLong), CsTransferOrderRespDto.class, (String[])new String[0]);
    }

    @NotNull
    protected InOutNoticeOrderEo generateReceiveNoticeOrderFacadeBo(DispatchOperateBo dispatchOperateBo) {
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        log.info("generateDeliveryNoticeOrder==>\u5c11\u6536\u5e93\u5b58\u91cd\u65b0\u5165\u5e93\uff0c\u6536\u53d1\u5dee\u5f02\u5355\u751f\u6210\u6536\u8d27\u901a\u77e5\u5355,dispatchOperateBo:{}", (Object)JSON.toJSONString((Object)dispatchOperateBo));
        final DispatcherOrderEo eo = dispatchOperateBo.getEo();
        List<DispatcherOrderDetailEo> dispatcherOrderDetailEos = dispatchOperateBo.getDispatcherOrderDetailEos();
        CubeBeanUtils.copyProperties((Object)facadeBo, (Object)eo, (String[])new String[]{"id"});
        String type = PcpBasicInventoryBusinessTypeEnum.EXCHANGE_ORDER_IN.getCode();
        facadeBo.setPreOrderNo(null);
        facadeBo.setExternalOrderNo(eo.getTransferOrderNo());
        facadeBo.setRelevanceNo(eo.getOrderNo());
        facadeBo.setSourceType(CsInventorySourceTypeEnum.IN_OTHER.getCode());
        facadeBo.setBusinessType(type);
        facadeBo.setDisplayBusinessType(type);
        facadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.IN_DISPATCHER_ORDER);
        facadeBo.setRemark(eo.getRemark());
        facadeBo.setLogicWarehouseCode(eo.getInLogicWarehouseCode());
        facadeBo.setLogicWarehouseName(eo.getInLogicWarehouseName());
        facadeBo.setPhysicsWarehouseCode(eo.getInPhysicsWarehouseCode());
        facadeBo.setAutoComplete(true);
        ArrayList<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(dispatcherOrderDetailEos.size());
        for (DispatcherOrderDetailEo detail : dispatcherOrderDetailEos) {
            BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
            CubeBeanUtils.copyProperties((Object)((Object)basic), (Object)detail, (String[])new String[]{"id"});
            basic.setSkuCode(detail.getSkuCode());
            basic.setSkuName(detail.getSkuName());
            basic.setQuantity(detail.getQuantity());
            basic.setBatch(detail.getBatch());
            basic.setVolume(detail.getVolume());
            basic.setPreOrderItemId(detail.getId());
            deliveryDetailList.add(basic);
        }
        facadeBo.setOrderBasicsDetailReqDtoList(deliveryDetailList);
        facadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context1.getReceiveDeliveryNoticeOrderEo();
                receiveDeliveryNoticeOrderEo.setSourceSystem(SourceSystemEnum.PCP.getCode());
                receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseCode(eo.getOutLogicWarehouseCode());
                receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseName(eo.getOutLogicWarehouseName());
                receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseCode(eo.getOutPhysicsWarehouseCode());
                receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseName(eo.getOutPhysicsWarehouseName());
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
                context.setCallBack(DiffOrderOptAbleImpl.this.getInNoticeCallBack(false));
                context.setTransparentCallback(true);
            }
        });
        this.baseOrderFacade.receiveNoticeOrderGen(facadeBo);
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)eo.getOrderNo())).list();
        log.info("\u6839\u636e\u6536\u53d1\u5dee\u5f02\u5355\u53f7\uff1a{}\u67e5\u8be2\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)eo.getOrderNo(), (Object)JSON.toJSONString((Object)inOutNoticeOrderEos));
        return CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos) ? (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0) : null;
    }

    @NotNull
    private ReceiveDeliveryNoticeOrderFacadeBo getReceiveDeliveryNoticeOrderFacadeBo(final TransferOrderEo respDto, List<TransferOrderDetailEo> detailList) {
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        log.info("generateDeliveryNoticeOrder==>\u8c03\u62e8\u5355\u751f\u6210\u6536\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)respDto.getTransferOrderNo());
        CubeBeanUtils.copyProperties((Object)facadeBo, (Object)respDto, (String[])new String[]{"id"});
        facadeBo.setPreOrderNo(respDto.getPreOrderNo());
        String externalOrderNo = CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode().equals(respDto.getType()) || CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode().equals(respDto.getType()) ? respDto.getExternalPurchaseOrderNo() : (StringUtils.isNotBlank((CharSequence)respDto.getExternalSaleOrderNo()) ? respDto.getExternalSaleOrderNo() : respDto.getPreOrderNo());
        facadeBo.setExternalOrderNo(externalOrderNo);
        facadeBo.setRelevanceNo(respDto.getTransferOrderNo());
        facadeBo.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT.getCode());
        facadeBo.setBusinessType(respDto.getType());
        facadeBo.setDisplayBusinessType(respDto.getType());
        facadeBo.setTransferInLogicWarehouseCode(respDto.getInLogicWarehouseCode());
        facadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        facadeBo.setRemark(respDto.getRemark());
        facadeBo.setAutoComplete(true);
        ArrayList<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(detailList.size());
        for (TransferOrderDetailEo detail : detailList) {
            BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
            CubeBeanUtils.copyProperties((Object)((Object)basic), (Object)detail, (String[])new String[]{"id"});
            basic.setSkuCode(detail.getSkuCode());
            basic.setSkuName(detail.getSkuName());
            basic.setQuantity(detail.getQuantity());
            basic.setBatch(detail.getBatch());
            basic.setVolume(detail.getVolume());
            basic.setPreOrderItemId(detail.getId());
            basic.setExpireTime(detail.getExpireTime());
            basic.setProduceTime(detail.getProduceTime());
            deliveryDetailList.add(basic);
        }
        facadeBo.setOrderBasicsDetailReqDtoList(deliveryDetailList);
        facadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context1.getReceiveDeliveryNoticeOrderEo();
                receiveDeliveryNoticeOrderEo.setTotalQuantity(respDto.getTotalQuantity());
                receiveDeliveryNoticeOrderEo.setSourceSystem(SourceSystemEnum.PCP.getCode());
                receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseCode(respDto.getOutLogicWarehouseCode());
                receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseName(respDto.getOutLogicWarehouseName());
                receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(respDto.getOutPhysicsWarehouseCode());
                receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(respDto.getOutPhysicsWarehouseName());
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
                context.setCallBack(DiffOrderOptAbleImpl.this.getInNoticeCallBack(false));
                context.setTransparentCallback(true);
            }
        });
        return facadeBo;
    }

    @NotNull
    private BaseOrderCallBack<BaseOrderBaseContext> getInNoticeCallBack(final boolean sendWms) {
        return new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutNoticeOrderContext) {
                    InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)context;
                    log.info("{}\u662f\u5426\u63a8\u9001wms\uff1a{}", (Object)outNoticeOrderContext.getDocumentNo(), (Object)JSON.toJSONString((Object)sendWms));
                    outNoticeOrderContext.setSendWms(sendWms);
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
                if (!sendWms) {
                    DiffOrderOptAbleImpl.this.transactionCallBackService.execute(() -> log.info("\u63a8\u9001sap:{}", (Object)context.getDocumentNo()));
                }
            }
        };
    }

    protected CsTransferOrderRespDto lessInWarehouseAndSendWms(DispatchOperateBo dispatchOperateBo) {
        this.sendMessageWms(dispatchOperateBo);
        this.generateDeliveryNoticeOrder(dispatchOperateBo, dispatchOperateBo.getEo(), dispatchOperateBo.getDispatcherOrderDetailEos());
        this.updateDispatcherProcessingQuantityByIds(dispatchOperateBo);
        return null;
    }

    protected void lessNotRepairInWarehouse(DispatchOperateBo dispatchOperateBo) {
        this.sendMessageWms(dispatchOperateBo);
        this.generateInDeliveryNoticeOrderSendWms(dispatchOperateBo, dispatchOperateBo.getEo(), dispatchOperateBo.getDispatcherOrderDetailEos(), false);
        this.updateDispatcherProcessingQuantityByIds(dispatchOperateBo);
    }

    protected CsTransferOrderRespDto salesReturnShiftingStepOrg(DispatchOperateBo dispatchOperateBo) {
        log.info("\u5f00\u59cb\u8fdb\u884c\u9500\u552e\u9000\u8d27\u79fb\u5e93\uff08\u8de8\u4e3b\u4f53\uff09\u5904\u7406");
        TransferOrderComboReqDto reqDto = new TransferOrderComboReqDto();
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setBizDate(dispatchOperateBo.getEo().getBizDate());
        transferOrderReqDto.setType(CsInventorySourceTypeEnum.SALES_RETURN_SHIFTING_STEP_ORG.getCode());
        this.setWarehouse(dispatchOperateBo, transferOrderReqDto);
        this.createTransfer(dispatchOperateBo, reqDto, transferOrderReqDto);
        Long aLong = (Long)this.transferOrderService.add(reqDto).getData();
        return this.auditTransfer(aLong, dispatchOperateBo.getEo().getOrderNo());
    }

    protected CsTransferOrderRespDto salesShiftingStepOrg(DispatchOperateBo dispatchOperateBo) {
        log.info("\u5f00\u59cb\u8fdb\u884c\u9500\u552e\u79fb\u5e93\uff08\u8de8\u4e3b\u4f53\uff09\u5904\u7406");
        TransferOrderComboReqDto reqDto = new TransferOrderComboReqDto();
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setBizDate(dispatchOperateBo.getEo().getBizDate());
        transferOrderReqDto.setType(CsInventorySourceTypeEnum.SALES_SHIFTING_STEP_ORG.getCode());
        this.setWarehouse(dispatchOperateBo, transferOrderReqDto);
        this.createTransfer(dispatchOperateBo, reqDto, transferOrderReqDto);
        Long aLong = (Long)this.transferOrderService.add(reqDto).getData();
        return this.auditTransfer(aLong, dispatchOperateBo.getEo().getOrderNo());
    }

    public void createTransfer(DispatchOperateBo dispatchOperateBo, TransferOrderComboReqDto reqDto, TransferOrderReqDto transferOrderReqDto) {
        this.wrapperTransferOrder(dispatchOperateBo, reqDto, transferOrderReqDto);
    }

    protected void setWarehouse(DispatchOperateBo dispatchOperateBo, TransferOrderReqDto transferOrderReqDto) {
        if (dispatchOperateBo.getDispatcherOperateWayEnum() == DispatcherOperateWayEnum.LESS_TRANSFER) {
            this.setWarehouseByLessTransfer(transferOrderReqDto, dispatchOperateBo.getEo(), dispatchOperateBo.getDispatcherOrderDetailEos());
        } else {
            this.setWarehouseDefault(transferOrderReqDto, dispatchOperateBo.getEo());
        }
    }

    protected void setWarehouseByLessTransfer(TransferOrderReqDto transferOrderReqDto, DispatcherOrderEo eo, List<DispatcherOrderDetailEo> dispatcherOrderDetailEos) {
        LogicWarehouseEo csLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(dispatcherOrderDetailEos.get(0).getWarehouseCode());
        AssertUtil.isTrue((null != csLogicWarehouseEo ? 1 : 0) != 0, (String)("\u4e0d\u5b58\u5728\u8be5\u7406\u8d54\u4ed3\u4fe1\u606f:" + dispatcherOrderDetailEos.get(0).getWarehouseCode()));
        transferOrderReqDto.setOutLogicWarehouseCode(eo.getInLogicWarehouseCode());
        transferOrderReqDto.setOutLogicWarehouseName(eo.getInLogicWarehouseName());
        transferOrderReqDto.setInLogicWarehouseCode(csLogicWarehouseEo.getWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(csLogicWarehouseEo.getWarehouseName());
        transferOrderReqDto.setOutOrganizationId(eo.getInOrganizationId());
        transferOrderReqDto.setOutOrganization(eo.getInOrganization());
        transferOrderReqDto.setInOrganizationId(csLogicWarehouseEo.getOrganizationId());
        transferOrderReqDto.setInOrganization(csLogicWarehouseEo.getOrganizationName());
        transferOrderReqDto.setOutPhysicsWarehouseCode(eo.getInPhysicsWarehouseCode());
        transferOrderReqDto.setInPhysicsWarehouseCode(eo.getOutPhysicsWarehouseCode());
    }

    protected void setWarehouseDefault(TransferOrderReqDto transferOrderReqDto, DispatcherOrderEo eo) {
        transferOrderReqDto.setOutLogicWarehouseCode(eo.getInLogicWarehouseCode());
        transferOrderReqDto.setOutLogicWarehouseName(eo.getInLogicWarehouseName());
        transferOrderReqDto.setInLogicWarehouseCode(eo.getOutLogicWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(eo.getOutLogicWarehouseName());
        transferOrderReqDto.setOutOrganizationId(eo.getInOrganizationId());
        transferOrderReqDto.setOutOrganization(eo.getInOrganization());
        transferOrderReqDto.setInOrganizationId(eo.getOutOrganizationId());
        transferOrderReqDto.setInOrganization(eo.getOutOrganization());
        transferOrderReqDto.setOutPhysicsWarehouseCode(eo.getInPhysicsWarehouseCode());
        transferOrderReqDto.setInPhysicsWarehouseCode(eo.getOutPhysicsWarehouseCode());
    }

    protected void setWarehouse(TransferOrderReqDto transferOrderReqDto, DispatcherOrderEo eo) {
        transferOrderReqDto.setOutLogicWarehouseCode(eo.getOutLogicWarehouseCode());
        transferOrderReqDto.setOutLogicWarehouseName(eo.getOutLogicWarehouseName());
        transferOrderReqDto.setInLogicWarehouseCode(eo.getInLogicWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(eo.getInLogicWarehouseName());
        transferOrderReqDto.setOutOrganizationId(eo.getOutOrganizationId());
        transferOrderReqDto.setOutOrganization(eo.getOutOrganization());
        transferOrderReqDto.setInOrganizationId(eo.getInOrganizationId());
        transferOrderReqDto.setInOrganization(eo.getInOrganization());
        transferOrderReqDto.setOutPhysicsWarehouseCode(eo.getOutPhysicsWarehouseCode());
        transferOrderReqDto.setInPhysicsWarehouseCode(eo.getInPhysicsWarehouseCode());
    }

    private String getRemark(DispatchOperateBo dispatchOperateBo) {
        String tableName = TransferOrderEnum.TRANSFER_ORDER.getDesc();
        TransferOrderEo originalTransferOrderEo = dispatchOperateBo.getOriginalTransferOrderEo();
        TransferOrderEnum transferOrderEnum = null;
        if (originalTransferOrderEo != null && Objects.nonNull(transferOrderEnum = TransferOrderEnum.getByCode((String)originalTransferOrderEo.getOrderType()))) {
            tableName = transferOrderEnum.getDesc();
        }
        switch (dispatchOperateBo.getDispatcherOperateWayEnum()) {
            case LESS_AGAIN_RECEIVE: {
                return String.format("%s%s\u6536\u8d27\u4ed3\u672a\u6536\u5b8c\u5c31\u5173\u5355\uff0c\u4ec5\u505a\u865a\u62df\u5165\u5e93\u8c03\u8d26\uff0c\u8bf7WMS\u81ea\u884c\u5904\u7406", tableName, dispatchOperateBo.getEo().getTransferOrderNo());
            }
            case MORE_TRANSFER: {
                return String.format("%s%s\u53d1\u8d27\u4ed3\u591a\u53d1\u5b9e\u7269\uff0c\u4ec5\u505a\u865a\u62df\u51fa\u5e93\u6263\u8d26\uff0c\u8bf7WMS\u81ea\u884c\u5904\u7406", tableName, dispatchOperateBo.getEo().getTransferOrderNo());
            }
            case MORE_TRANSFER_NONEED_RECEIVE: {
                return String.format("%s%s\u6536\u8d27\u4ed3\u5f55\u9519\u591a\u6536\u8d27\uff0c\u4ec5\u505a\u865a\u62df\u51fa\u5e93\u6263\u8d26\uff0c\u8bf7WMS\u81ea\u884c\u5904\u7406", tableName, dispatchOperateBo.getEo().getTransferOrderNo());
            }
        }
        return null;
    }

    protected void generateDeliveryNoticeOrder(DispatchOperateBo dispatchOperateBo, DispatcherOrderEo dispatcherOrderEo, List<DispatcherOrderDetailEo> dispatcherOrderDetailEos) {
        if (!dispatchOperateBo.getIsAutoFinish().booleanValue()) {
            return;
        }
        if (CsPcpBusinessTypeEnum.ALLOT_ONLY_RECORD.getCode().equals(dispatcherOrderEo.getSubType())) {
            return;
        }
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = this.getReceiveDeliveryNoticeOrderFacadeBo(dispatcherOrderEo, dispatcherOrderDetailEos);
        facadeBo.setAutoComplete(Boolean.TRUE);
        facadeBo.setLogicWarehouseCode(dispatcherOrderEo.getInLogicWarehouseCode());
        facadeBo.setLogicWarehouseName(dispatcherOrderEo.getInLogicWarehouseName());
        facadeBo.setPhysicsWarehouseCode(dispatcherOrderEo.getInPhysicsWarehouseCode());
        facadeBo.setPhysicsWarehouseName(dispatcherOrderEo.getInPhysicsWarehouseName());
        facadeBo.setSendWms(false);
        this.baseOrderFacade.receiveNoticeOrderGen(facadeBo);
    }

    protected void generateInDeliveryNoticeOrderSendWms(DispatchOperateBo dispatchOperateBo, DispatcherOrderEo dispatcherOrderEo, List<DispatcherOrderDetailEo> dispatcherOrderDetailEos, boolean ifInWarehouse) {
        log.info("\u5c11\u6536\u751f\u6210\u5165\u5e93\u901a\u77e5\u5355\u5e76\u63a8\u9001wms\u5165\u53c2,dispatchOperateBo\uff1a{}", (Object)JSON.toJSONString((Object)dispatchOperateBo));
        if (!dispatchOperateBo.getIsAutoFinish().booleanValue()) {
            return;
        }
        if (CsPcpBusinessTypeEnum.ALLOT_ONLY_RECORD.getCode().equals(dispatcherOrderEo.getSubType())) {
            return;
        }
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = this.getReceiveDeliveryNoticeOrderFacadeBo(dispatcherOrderEo, dispatcherOrderDetailEos);
        facadeBo.setAutoComplete(Boolean.TRUE);
        facadeBo.setLogicWarehouseCode(ifInWarehouse ? dispatcherOrderEo.getInLogicWarehouseCode() : dispatcherOrderEo.getOutLogicWarehouseCode());
        facadeBo.setLogicWarehouseName(ifInWarehouse ? dispatcherOrderEo.getInLogicWarehouseName() : dispatcherOrderEo.getOutLogicWarehouseName());
        facadeBo.setPhysicsWarehouseCode(ifInWarehouse ? dispatcherOrderEo.getInPhysicsWarehouseCode() : dispatcherOrderEo.getOutPhysicsWarehouseCode());
        facadeBo.setPhysicsWarehouseName(ifInWarehouse ? dispatcherOrderEo.getInPhysicsWarehouseName() : dispatcherOrderEo.getOutPhysicsWarehouseName());
        facadeBo.setSendWms(false);
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = this.baseOrderFacade.receiveNoticeOrderGen(facadeBo);
        String documentNo = receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo().getDocumentNo();
        dispatcherOrderDetailEos.forEach(detail -> {
            detail.setDeliveryNoticeNo(documentNo);
            this.dispatcherOrderDetailDomain.update((BaseEo)detail);
        });
    }

    private ReceiveDeliveryNoticeOrderFacadeBo getReceiveDeliveryNoticeOrderFacadeBo(DispatcherOrderEo dispatcherOrderEo, List<DispatcherOrderDetailEo> dispatcherOrderDetailEos) {
        log.info("generateDeliveryNoticeOrder==>\u6536\u53d1\u5dee\u5f02\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,\u5165\u53c2dispatcherOrderEo\uff1a{}, orderNo:{}", (Object)JSONObject.toJSONString((Object)dispatcherOrderEo), (Object)dispatcherOrderEo.getOrderNo());
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        log.info("generateDeliveryNoticeOrder==>\u8c03\u62e8\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)dispatcherOrderEo.getTransferOrderNo());
        CubeBeanUtils.copyProperties((Object)facadeBo, (Object)dispatcherOrderEo, (String[])new String[0]);
        facadeBo.setPreOrderNo(dispatcherOrderEo.getOrderNo());
        String externalOrderNo = dispatcherOrderEo.getOrderNo();
        facadeBo.setExternalOrderNo(externalOrderNo);
        facadeBo.setRelevanceNo(externalOrderNo);
        facadeBo.setSourceType(CsInventorySourceTypeEnum.IN_ALLOT.getCode());
        facadeBo.setBusinessType(dispatcherOrderEo.getType());
        facadeBo.setDisplayBusinessType(PcpBasicInventoryBusinessTypeEnum.EXCHANGE_ORDER_IN.getCode());
        facadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.IN_DISPATCHER_ORDER);
        facadeBo.setRemark(dispatcherOrderEo.getRemark());
        ArrayList<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(dispatcherOrderDetailEos.size());
        for (DispatcherOrderDetailEo detail : dispatcherOrderDetailEos) {
            BaseOrderDetailReqDto basic = new BaseOrderDetailReqDto();
            CubeBeanUtils.copyProperties((Object)((Object)basic), (Object)detail, (String[])new String[0]);
            basic.setSkuCode(detail.getSkuCode());
            basic.setSkuName(detail.getSkuName());
            basic.setQuantity(detail.getDispatcherQuantity());
            basic.setBatch((String)DataExtractUtils.ifNullElse((Object)detail.getBatch(), (Object)""));
            basic.setVolume(detail.getVolume());
            basic.setPreOrderItemId(detail.getId());
            basic.setExpireTime(detail.getDueDate());
            basic.setProduceTime(detail.getProductDate());
            deliveryDetailList.add(basic);
        }
        facadeBo.setOrderBasicsDetailReqDtoList(deliveryDetailList);
        facadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(true);
                if (context instanceof ReceiveDeliveryResultOrderContext) {
                    ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = (ReceiveDeliveryResultOrderContext)context;
                }
            }
        });
        log.info("generateDeliveryNoticeOrder==>\u6536\u53d1\u5dee\u5f02\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u53c2\u6570facadeBo:{}", (Object)JSONObject.toJSONString((Object)facadeBo));
        return facadeBo;
    }

    private void preemptLogicInventory(List<ReceiveDeliveryNoticeOrderDetailEo> detailEoList, ReceiveDeliveryNoticeOrderEo insertEo) {
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(insertEo.getDocumentNo());
        preemptParam.setSourceType(insertEo.getRelevanceTableName());
        preemptParam.setBusinessType(insertEo.getBusinessType());
        preemptParam.setValidNegative(Boolean.valueOf(true));
        preemptParam.setNoneLineNo(Boolean.valueOf(true));
        ArrayList detailParams = Lists.newArrayList();
        for (ReceiveDeliveryNoticeOrderDetailEo detailEo : detailEoList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal preemptNum = BigDecimalUtils.abs((BigDecimal)detailEo.getPlanQuantity());
            detailParam.setNum(preemptNum);
            detailParam.setSkuCode(detailEo.getSkuCode());
            detailParam.setLogicWarehouseCode("delivery".equals(insertEo.getOrderType()) ? insertEo.getDeliveryLogicWarehouseCode() : insertEo.getReceiveLogicWarehouseCode());
            detailParam.setBatch(detailEo.getBatch());
            detailParams.add(detailParam);
        }
        preemptParam.setDetails((List)detailParams);
        this.calcInventoryService.preempt(preemptParam);
    }
}

