/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.inspection.Impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.InspectionPassRecordConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IInspectionPassRecordDomain;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.InspectionPassRecordAuditDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.InspectionPassRecordDto;
import com.yunxi.dg.base.center.inventory.eo.InspectionPassRecordEo;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IInspectionPassRecordService;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.executor.InspectionPassRecordStatemachineExecutor;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionPassRecordServiceImpl
extends BaseServiceImpl<InspectionPassRecordDto, InspectionPassRecordEo, IInspectionPassRecordDomain>
implements IInspectionPassRecordService {
    private static final Logger log = LoggerFactory.getLogger(InspectionPassRecordServiceImpl.class);
    @Resource
    private InspectionPassRecordStatemachineExecutor inspectionPassRecordStatemachineExecutor;
    @Resource
    private IPcpDictQueryApiProxy pcpDictQueryApiProxy;

    public InspectionPassRecordServiceImpl(IInspectionPassRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InspectionPassRecordDto, InspectionPassRecordEo> converter() {
        return InspectionPassRecordConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void add(InspectionPassRecordEo eo, DgInspectionPassRecordStatusEventEnum eventEnum) {
        this.checkParam(eo);
        eo.setInspectionPassRecordNo(InventoryConfig.getGenerateCodeUtil().generateCode(CodeGenEnum.INSPECTION_PASS_RECORD_ORDER));
        if (StringUtils.isBlank((CharSequence)eo.getPassStatus())) {
            eo.setPassStatus(DgInspectionPassRecordStatusEnum.WAIT_COMMIT.getKey());
        }
        if (Objects.isNull(eo.getRecordTime())) {
            eo.setRecordTime(new Date());
        }
        Optional.ofNullable(this.pcpDictQueryApiProxy.basicDataInfo(eo.getBusinessType())).filter(d -> StringUtils.isNotBlank((CharSequence)d.getGroupCode())).ifPresent(dataDictDto -> eo.setOrderType(dataDictDto.getGroupCode()));
        eo.setCreateTime(null);
        eo.setUpdateTime(null);
        eo.setCreatePerson(null);
        eo.setUpdatePerson(null);
        ((IInspectionPassRecordDomain)this.domain).insert((BaseEo)eo);
        StatemachineExecutorBo<InspectionPassRecordEo> executorBo = new StatemachineExecutorBo<InspectionPassRecordEo>();
        executorBo.setEo(eo);
        this.inspectionPassRecordStatemachineExecutor.execute(eventEnum, executorBo);
        OptUtil.addOptLog((String)OperationLogTypeEnum.CREATED.name(), (String)"EMPTY", (String)eo.getInspectionPassRecordNo(), (String)CodeGenEnum.INSPECTION_PASS_RECORD_ORDER.getCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void audit(InspectionPassRecordAuditDto dto) {
        log.info("\u5ba1\u6838\u653e\u884c\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtil.isTrue(("1".equals(dto.getAuditResult()) || "0".equals(dto.getAuditResult()) ? 1 : 0) != 0, (String)"\u5ba1\u6838\u7ed3\u679c\u6709\u8bef");
        InspectionPassRecordEo inspectionPassRecordEo = (InspectionPassRecordEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInspectionPassRecordDomain)this.domain).filter().eq((Object)"inspection_pass_record_no", (Object)dto.getInspectionPassRecordNo())).last(" limit 1")).one();
        AssertUtil.isTrue((boolean)Objects.nonNull(inspectionPassRecordEo), (String)"\u653e\u884c\u8bb0\u5f55\u4fe1\u606f\u4e0d\u5b58\u5728");
        inspectionPassRecordEo.setAuditRemark(dto.getRemark());
        boolean auditSuccess = "1".equals(dto.getAuditResult());
        inspectionPassRecordEo.setPassStatus(auditSuccess ? DgInspectionPassRecordStatusEnum.PASSING.getKey() : DgInspectionPassRecordStatusEnum.AUDIT_FAILED.getKey());
        inspectionPassRecordEo.setOperatorTime(new Date());
        if (StringUtils.isNotBlank((CharSequence)dto.getOperator())) {
            inspectionPassRecordEo.setOperator(dto.getOperator());
        }
        StatemachineExecutorBo<InspectionPassRecordEo> executorBo = new StatemachineExecutorBo<InspectionPassRecordEo>();
        executorBo.setEo(inspectionPassRecordEo);
        this.inspectionPassRecordStatemachineExecutor.execute(auditSuccess ? DgInspectionPassRecordStatusEventEnum.AUDIT_SUCCESS : DgInspectionPassRecordStatusEventEnum.AUDITFAILED, executorBo);
        String logEvent = auditSuccess ? OperationLogTypeEnum.APPROVED.name() : OperationLogTypeEnum.REJECTED.name();
        String remark = StringUtils.isNotBlank((CharSequence)dto.getRemark()) ? dto.getRemark() : "EMPTY";
        OptUtil.addOptLog((String)logEvent, (String)remark, (String)dto.getInspectionPassRecordNo(), (String)CodeGenEnum.INSPECTION_PASS_RECORD_ORDER.getCode());
    }

    @Override
    public InspectionPassRecordDto queryByInspectionPassRecordNo(String inspectionPassRecordNo) {
        InspectionPassRecordEo eo = (InspectionPassRecordEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInspectionPassRecordDomain)this.domain).filter().eq((Object)"inspection_pass_record_no", (Object)inspectionPassRecordNo)).last(" limit 1")).one();
        return (InspectionPassRecordDto)this.converter().toDto((BaseEo)eo);
    }

    private void checkParam(InspectionPassRecordEo e) {
        AssertUtil.isTrue((boolean)Objects.nonNull(e), (String)"\u653e\u884c\u8bb0\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)Objects.nonNull(e.getQuantity()), (String)"\u8d28\u68c0\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((e.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u653e\u884c\u5e93\u5b58\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)e.getUnit()), (String)"\u653e\u884c\u8bb0\u5f55\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)e.getSkuCode()), (String)"\u653e\u884c\u8bb0\u5f55sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

