/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.inspection.Impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.WaitInspectionRecordConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IInspectionPassRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryBatchDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWaitInspectionPassRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWaitInspectionRecordDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.InspectionPassRecordDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.InspectionPassRecordPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.WaitInspectionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.WaitInspectionRecordPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryBatchEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWaitInspectionPassRecordEo;
import com.yunxi.dg.base.center.inventory.eo.WaitInspectionRecordEo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.IAdjustmentOrderService;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IWaitInspectionRecordService;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WaitInspectionRecordServiceImpl
extends BaseServiceImpl<WaitInspectionRecordDto, WaitInspectionRecordEo, IWaitInspectionRecordDomain>
implements IWaitInspectionRecordService {
    private static final Logger log = LoggerFactory.getLogger(WaitInspectionRecordServiceImpl.class);
    @Resource
    private IInspectionPassRecordDomain inspectionPassRecordDomain;
    @Resource
    private IRelWaitInspectionPassRecordDomain relWaitInspectionPassRecordDomain;
    @Resource(name="inventoryStatusAdjustmentOrderServiceImpl")
    private IAdjustmentOrderService inventoryStatusAdjustmentOrderServiceImpl;
    @Resource
    private IInventoryBatchDomain inventoryBatchDomain;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ILogicInventoryDomain logicInventoryDomain;
    @Resource
    private WaitInspectionRecordServiceImpl waitInspectionRecordServiceImpl;
    @Resource
    private ILockService lockService;

    public WaitInspectionRecordServiceImpl(IWaitInspectionRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<WaitInspectionRecordDto, WaitInspectionRecordEo> converter() {
        return WaitInspectionRecordConverter.INSTANCE;
    }

    @Override
    public PageInfo<WaitInspectionRecordDto> queryByPage(WaitInspectionRecordPageReqDto queryDto) {
        if (Objects.isNull(queryDto)) {
            return null;
        }
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IWaitInspectionRecordDomain)this.domain).filter().in(CollectionUtils.isNotEmpty((Collection)queryDto.getBatchList()), (Object)"batch", (Collection)queryDto.getBatchList())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getSkuCodeList()), (Object)"sku_code", (Collection)queryDto.getSkuCodeList())).in(CollectionUtils.isNotEmpty((Collection)queryDto.getLogicWarehouseCodeList()), (Object)"logic_warehouse_code", (Collection)queryDto.getLogicWarehouseCodeList())).orderByDesc((Object)"id")).list();
        List dtos = this.converter().toDtoList(eos);
        PageInfo pageInfo = new PageInfo(dtos);
        return pageInfo;
    }

    @Override
    public void updateQuantity(String skuCode, String batch) {
        log.info("\u6839\u636e\u653e\u884c\u8bb0\u5f55\u8ddf\u4e0a\u9762\u7684\u4e2d\u95f4\u8bb0\u5f55\u8868\u8fdb\u884c\u5339\u914d\uff0c\u66f4\u65b0\u6570\u91cf\u548c\u65b0\u589e\u5173\u8054\u8868\u3001\u5e93\u5b58\u72b6\u6001\u8c03\u6574\u5355skuCode:{},batch:{}", (Object)skuCode, (Object)batch);
        List recordEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IWaitInspectionRecordDomain)this.domain).filter().gt((Object)"wait_quantity", (Object)0)).eq(StringUtils.isNotBlank((CharSequence)skuCode), (Object)"sku_code", (Object)skuCode)).eq(StringUtils.isNotBlank((CharSequence)batch), (Object)"batch", (Object)batch)).orderByAsc((Object)"id")).list();
        if (CollectionUtils.isEmpty((Collection)recordEos)) {
            return;
        }
        HashSet skuCodeList = new HashSet();
        HashSet batchList = new HashSet();
        HashSet warehouseCodeList = new HashSet();
        recordEos.forEach(e -> {
            skuCodeList.add(e.getSkuCode());
            batchList.add(e.getBatch());
            warehouseCodeList.add(e.getLogicWarehouseCode());
        });
        InspectionPassRecordPageReqDto dto = new InspectionPassRecordPageReqDto();
        dto.setSkuCodeList((List)Lists.newArrayList(skuCodeList));
        dto.setBatchList((List)Lists.newArrayList(batchList));
        dto.setPassStatus(DgInspectionPassRecordStatusEnum.PASS_SUCCESS.getKey());
        dto.setSurplusQuantityGtZero(Boolean.valueOf(true));
        List inspectionPassRecordDtos = this.inspectionPassRecordDomain.querySurplusQuantity(dto);
        if (CollectionUtils.isEmpty((Collection)inspectionPassRecordDtos)) {
            return;
        }
        Map<String, List<InspectionPassRecordDto>> inspectionPassRecordMap = inspectionPassRecordDtos.stream().collect(Collectors.groupingBy(e -> this.getKey(e.getSkuCode(), e.getBatch())));
        Map<String, InventoryBatchEo> inventoryBatchMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryBatchDomain.filter().in((Object)"sku_code", skuCodeList)).in((Object)"batch", batchList)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(e -> this.getKey(e.getSkuCode(), e.getBatch()), Function.identity(), (k1, k2) -> k1));
        Map<String, LogicWarehouseEo> logicWarehouseMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodeList)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(e -> e.getWarehouseCode(), Function.identity(), (k1, k2) -> k1));
        for (WaitInspectionRecordEo recordEo : recordEos) {
            String key = this.getKey(recordEo.getSkuCode(), recordEo.getBatch());
            List<Object> inspectionPassRecordDtoList = inspectionPassRecordMap.get(key);
            if (CollectionUtils.isEmpty(inspectionPassRecordDtoList)) continue;
            inspectionPassRecordDtoList = inspectionPassRecordDtoList.stream().filter(e -> BigDecimalUtils.gtZero((BigDecimal)e.getSurplusQuantity())).collect(Collectors.toList());
            for (InspectionPassRecordDto inspectionPassRecordDto : inspectionPassRecordDtoList) {
                if (BigDecimalUtils.eqZero((BigDecimal)recordEo.getWaitQuantity()).booleanValue() || BigDecimalUtils.eqZero((BigDecimal)inspectionPassRecordDto.getSurplusQuantity()).booleanValue()) continue;
                Mutex wmsOperate = null;
                try {
                    wmsOperate = this.lockService.lock("waitInspectionRecordUpdateQuantity", key, 30, 30, TimeUnit.SECONDS);
                    this.waitInspectionRecordServiceImpl.doExecute(inventoryBatchMap, logicWarehouseMap, recordEo, key, inspectionPassRecordDto);
                }
                catch (Exception e2) {
                    throw e2;
                }
                finally {
                    Optional.ofNullable(wmsOperate).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void doExecute(Map<String, InventoryBatchEo> inventoryBatchMap, Map<String, LogicWarehouseEo> logicWarehouseMap, WaitInspectionRecordEo recordEo, String key, InspectionPassRecordDto inspectionPassRecordDto) {
        log.info("doExecute-recordEo:{}", (Object)JSON.toJSONString((Object)recordEo));
        log.info("doExecute-inspectionPassRecordDto:{}", (Object)JSON.toJSONString((Object)inspectionPassRecordDto));
        BigDecimal totalDoneQuantity = Optional.ofNullable(((ExtQueryChainWrapper)this.relWaitInspectionPassRecordDomain.filter().eq((Object)"inspection_pass_record_id", (Object)inspectionPassRecordDto.getId())).list()).filter(CollectionUtils::isNotEmpty).map(list -> list.stream().map(RelWaitInspectionPassRecordEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
        log.info("\u5173\u8054\u8868\u4e2d\u5df2\u653e\u884c\u7684\u653e\u884c\u8bb0\u5f55\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)totalDoneQuantity));
        BigDecimal surplusQuantity = BigDecimalUtils.subtract((BigDecimal)inspectionPassRecordDto.getSurplusQuantity(), (BigDecimal)totalDoneQuantity);
        if (BigDecimalUtils.leZero((BigDecimal)surplusQuantity).booleanValue()) {
            return;
        }
        RelWaitInspectionPassRecordEo relEo = new RelWaitInspectionPassRecordEo();
        relEo.setSkuCode(recordEo.getSkuCode());
        relEo.setBatch(recordEo.getBatch());
        relEo.setQuantity(recordEo.getQuantity());
        relEo.setWaitInspectionRecordId(recordEo.getId());
        relEo.setInspectionPassRecordId(inspectionPassRecordDto.getId());
        if (BigDecimalUtils.ge((BigDecimal)surplusQuantity, (BigDecimal)recordEo.getWaitQuantity()).booleanValue()) {
            relEo.setDoneQuantity(recordEo.getWaitQuantity());
            recordEo.setDoneQuantity(BigDecimalUtils.add((BigDecimal)recordEo.getDoneQuantity(), (BigDecimal)recordEo.getWaitQuantity()));
            recordEo.setWaitQuantity(BigDecimal.ZERO);
        } else {
            relEo.setDoneQuantity(surplusQuantity);
            recordEo.setDoneQuantity(BigDecimalUtils.add((BigDecimal)recordEo.getDoneQuantity(), (BigDecimal)surplusQuantity));
            recordEo.setWaitQuantity(BigDecimalUtils.subtract((BigDecimal)recordEo.getWaitQuantity(), (BigDecimal)surplusQuantity));
        }
        this.relWaitInspectionPassRecordDomain.insert((BaseEo)relEo);
        this.addAdjustmentOrder(inventoryBatchMap, logicWarehouseMap, recordEo, key, relEo);
        ((IWaitInspectionRecordDomain)this.domain).getMapper().updateById((BaseEo)recordEo);
    }

    private void addAdjustmentOrder(Map<String, InventoryBatchEo> inventoryBatchMap, Map<String, LogicWarehouseEo> logicWarehouseMap, WaitInspectionRecordEo recordEo, String key, RelWaitInspectionPassRecordEo relEo) {
        AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
        ArrayList<AdjustmentOrderDetailDto> adjustmentOrderDetailDtoList = new ArrayList<AdjustmentOrderDetailDto>();
        adjustmentOrderDto.setBusinessType("inventory_status_adjustment");
        adjustmentOrderDto.setBizDate(new Date());
        adjustmentOrderDto.setOrigWarehouseCode(recordEo.getLogicWarehouseCode());
        adjustmentOrderDto.setOrganizationName(recordEo.getLogicWarehouseName());
        adjustmentOrderDto.setWarehouseCode(recordEo.getLogicWarehouseCode());
        adjustmentOrderDto.setWarehouseName(recordEo.getLogicWarehouseName());
        adjustmentOrderDto.setInventoryProperty(LogicWarehouseQualityEnum.WAIT_INSPECTION.getCode());
        adjustmentOrderDto.setNewInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
        adjustmentOrderDto.setRelevanceNo(recordEo.getRelevanceNo());
        adjustmentOrderDto.setExternalOrderNo(relEo.getId().toString());
        adjustmentOrderDto.setPushSap(Integer.valueOf(1));
        adjustmentOrderDto.setPushWms(Integer.valueOf(1));
        adjustmentOrderDto.setRemark("\u5f85\u68c0\u8bb0\u5f55\u4e2d\u95f4\u8868\u5ba1\u6838\u901a\u8fc7");
        adjustmentOrderDto.setOrderType(AdjustmentOrderTypeEnum.BATCH_ADJUSTMENT.getType());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pushFeiShu", "0");
        adjustmentOrderDto.setExtension(JSON.toJSONString(map));
        LogicWarehouseEo logicWarehouseEo = logicWarehouseMap.get(recordEo.getLogicWarehouseCode());
        if (Objects.nonNull(logicWarehouseEo)) {
            adjustmentOrderDto.setPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
            adjustmentOrderDto.setPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
            adjustmentOrderDto.setOrganizationCode(logicWarehouseEo.getOrganizationCode());
            adjustmentOrderDto.setOrganizationName(logicWarehouseEo.getOrganizationName());
        }
        AdjustmentOrderDetailDto adjustmentOrderDetailDto = new AdjustmentOrderDetailDto();
        adjustmentOrderDetailDto.setSkuCode(recordEo.getSkuCode());
        adjustmentOrderDetailDto.setSkuName(recordEo.getSkuName());
        adjustmentOrderDetailDto.setBatch(recordEo.getBatch());
        adjustmentOrderDetailDto.setOrigBatch(recordEo.getBatch());
        adjustmentOrderDetailDto.setInventoryProperty(LogicWarehouseQualityEnum.WAIT_INSPECTION.getCode());
        InventoryBatchEo inventoryBatchEo = inventoryBatchMap.get(key);
        if (Objects.nonNull(inventoryBatchEo)) {
            adjustmentOrderDetailDto.setExpireTime(inventoryBatchEo.getExpireTime());
            adjustmentOrderDetailDto.setProduceTime(inventoryBatchEo.getProduceTime());
            adjustmentOrderDetailDto.setOrigProduceTime(inventoryBatchEo.getExpireTime());
            adjustmentOrderDetailDto.setOrigExpireTime(inventoryBatchEo.getProduceTime());
            adjustmentOrderDetailDto.setSpuCode(inventoryBatchEo.getSpuCode());
            adjustmentOrderDetailDto.setSpuName(inventoryBatchEo.getSpuName());
        }
        LogicInventoryEo logicInventoryEo = (LogicInventoryEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().eq((Object)"sku_code", (Object)recordEo.getSkuCode())).eq((Object)"batch", (Object)recordEo.getBatch())).eq((Object)"warehouse_code", (Object)recordEo.getLogicWarehouseCode())).eq((Object)"inventory_property", (Object)recordEo.getInventoryProperty())).last("limit 1")).one();
        log.info("\u67e5\u8be2\u5e93\u5b58\u53ef\u7528\u5f85\u68c0\u6570:{}", (Object)JSON.toJSONString((Object)logicInventoryEo));
        if (BigDecimalUtils.leZero((BigDecimal)logicInventoryEo.getAvailable()).booleanValue()) {
            return;
        }
        adjustmentOrderDetailDto.setChangeQuantity(BigDecimalUtils.gt((BigDecimal)logicInventoryEo.getAvailable(), (BigDecimal)relEo.getDoneQuantity()) != false ? relEo.getDoneQuantity() : logicInventoryEo.getAvailable());
        adjustmentOrderDetailDto.setUnit(recordEo.getUnit());
        adjustmentOrderDetailDto.setNewInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
        adjustmentOrderDetailDtoList.add(adjustmentOrderDetailDto);
        adjustmentOrderDto.setAdjustmentOrderDetailDtos(adjustmentOrderDetailDtoList);
        adjustmentOrderDto.setAuditRemark("\u5f85\u68c0\u8bb0\u5f55\u4e2d\u95f4\u8868\u5ba1\u6838\u901a\u8fc7");
        adjustmentOrderDto.setEvent(DgAdjustmentInventoryOrderEventEnum.AUDIT_SUCCESS.getKey());
        this.inventoryStatusAdjustmentOrderServiceImpl.addAdjustmentOrder(adjustmentOrderDto);
    }

    @NotNull
    private String getKey(String skuCode, String batch) {
        return skuCode + InventoryConfig.getCommonSeparate() + batch;
    }
}

