/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherStorageOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class InOutStorageFinishAction
extends AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(InOutStorageFinishAction.class);
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain iReceiveDeliveryNoticeOrderDomain;
    @Resource
    private IInOtherStorageOrderDetailDomain inOtherStorageOrderDetailDomain;
    @Resource
    private IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;

    @Override
    public void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
        log.info("\u8fdb\u5165\u5176\u4ed6\u51fa\u5165\u5e93\u5b8c\u6210\u52a8\u4f5c");
        StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
        String storageOrderNo = ((InOtherStorageOrderEo)executorBo.getEo()).getStorageOrderNo();
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iReceiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)storageOrderNo)).eq((Object)"dr", (Object)YesNoEnum.NO)).one()).orElse(new ReceiveDeliveryNoticeOrderEo());
        BaseOrderCommonCancelBo cancelBo = BaseOrderCommonCancelBo.builder().documentNo(deliveryNoticeOrderEo.getDocumentNo()).sourceType(deliveryNoticeOrderEo.getBusinessType()).build();
        if (((InOtherStorageOrderEo)executorBo.getEo()).getType().equals(DgOtherStorageOrderTypeEnum.IN.getCode())) {
            this.baseOrderFacade.receiveNoticeOrderClose(cancelBo);
        } else {
            this.baseOrderFacade.deliveryNoticeOrderClose(cancelBo);
        }
        this.doWriteBack(context);
    }

    public void doWriteBack(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
        log.info("\u51fa\u5165\u5e93\u6279\u6b21\u56de\u5199");
        StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
        InOtherStorageOrderEo eo = (InOtherStorageOrderEo)executorBo.getEo();
        Map idMap = ((ExtQueryChainWrapper)this.inOtherStorageOrderDetailDomain.filter().eq((Object)"storage_order_no", (Object)eo.getStorageOrderNo())).list().stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map<Long, BigDecimal> numMap = idMap.values().stream().collect(Collectors.toMap(BaseEo::getId, InOtherStorageOrderDetailEo::getQuantity));
        List receiveDeliveryResultOrderDetailEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().eq((Object)"relevance_no", (Object)eo.getStorageOrderNo())).list();
        List<OrderUnitConversionRecordEo> orderUnitConversionRecordEos = this.getRecordByCode(eo.getStorageOrderNo());
        Map<String, BigDecimal> ratioMap = orderUnitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum()), (a, a1) -> a));
        Map<String, BigDecimal> toRatioMap = orderUnitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getNum(), (BigDecimal)r.getToNum()), (a, a1) -> a));
        ArrayList<InOtherStorageOrderDetailEo> inOtherStorageOrderDetailEoList = new ArrayList<InOtherStorageOrderDetailEo>();
        if (CollectionUtil.isNotEmpty((Collection)receiveDeliveryResultOrderDetailEos)) {
            Map<Long, List<ReceiveDeliveryResultOrderDetailEo>> idResultDetails = receiveDeliveryResultOrderDetailEos.stream().collect(Collectors.groupingBy(ReceiveDeliveryResultOrderDetailEo::getPreOrderItemId));
            idResultDetails.forEach((k, v) -> {
                ArrayList<List<ReceiveDeliveryResultOrderDetailEo>> arrayList = new ArrayList<List<ReceiveDeliveryResultOrderDetailEo>>(v.stream().collect(Collectors.groupingBy(r -> r.getSkuCode() + r.getBatch() + r.getInventoryProperty())).values());
                arrayList.forEach(eos -> {
                    ReceiveDeliveryResultOrderDetailEo o = (ReceiveDeliveryResultOrderDetailEo)eos.get(0);
                    InOtherStorageOrderDetailEo inOtherStorageOrderDetailEo = (InOtherStorageOrderDetailEo)idMap.get(o.getPreOrderItemId());
                    InOtherStorageOrderDetailEo detailEo = (InOtherStorageOrderDetailEo)BeanUtil.copyProperties((Object)inOtherStorageOrderDetailEo, InOtherStorageOrderDetailEo.class, (String[])new String[0]);
                    detailEo.setId(null);
                    BigDecimal ratio = (BigDecimal)ratioMap.get(o.getSkuCode());
                    BigDecimal toRatio = (BigDecimal)toRatioMap.get(o.getSkuCode());
                    detailEo.setStorageOrderNo(o.getRelevanceNo());
                    detailEo.setSkuCode(o.getSkuCode());
                    detailEo.setSkuName(o.getSkuName());
                    detailEo.setBatch(o.getBatch());
                    BigDecimal decimal = UnitTransferUtils.pareSaleNum((BigDecimal)eos.stream().map(ReceiveDeliveryResultOrderDetailEo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add), (BigDecimal)ratio, (BigDecimal)toRatio);
                    detailEo.setQuantity(decimal);
                    BigDecimal doneQuantity = UnitTransferUtils.pareSaleNum((BigDecimal)eos.stream().map(ReceiveDeliveryResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add), (BigDecimal)ratio, (BigDecimal)toRatio);
                    detailEo.setDoneQuantity(doneQuantity);
                    detailEo.setWaitQuantity(BigDecimal.ZERO);
                    detailEo.setExtension(inOtherStorageOrderDetailEo.getExtension());
                    detailEo.setUnit(inOtherStorageOrderDetailEo.getUnit());
                    detailEo.setLineNo(inOtherStorageOrderDetailEo.getLineNo());
                    detailEo.setInventoryProperty(o.getInventoryProperty());
                    if (arrayList.indexOf(eos) == arrayList.size() - 1) {
                        detailEo.setQuantity((BigDecimal)numMap.get(o.getPreOrderItemId()));
                        detailEo.setId(o.getPreOrderItemId());
                    } else {
                        numMap.compute(o.getPreOrderItemId(), (n, r) -> BigDecimalUtils.subtract((BigDecimal)r, (BigDecimal)detailEo.getQuantity()));
                    }
                    inOtherStorageOrderDetailEoList.add(detailEo);
                });
            });
            if (InventoryConfig.isEnableUnit()) {
                this.orderUnitConversionRecordService.otherOrderVolumeAndWeightProcess(eo.getStorageOrderNo(), inOtherStorageOrderDetailEoList);
            }
            InOtherStorageOrderDetailEo inOtherStorageOrderDetailEo = new InOtherStorageOrderDetailEo();
            inOtherStorageOrderDetailEo.setStorageOrderNo(eo.getStorageOrderNo());
            this.inOtherStorageOrderDetailDomain.delete((BaseEo)inOtherStorageOrderDetailEo);
            this.inOtherStorageOrderDetailDomain.insertBatch(inOtherStorageOrderDetailEoList);
        }
    }

    private List<OrderUnitConversionRecordEo> getRecordByCode(String relevanceNo) {
        return this.orderUnitConversionRecordService.getOrderUnitConversionRecordEos(relevanceNo, (ExtQueryChainWrapper<OrderUnitConversionRecordEo>)this.orderUnitConversionRecordDomain.filter());
    }
}

